/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.mondrian.MondrianDimension;
import com.tonbeller.jpivot.mondrian.MondrianHierarchy;
import com.tonbeller.jpivot.mondrian.MondrianLevel;
import com.tonbeller.jpivot.mondrian.MondrianMember;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianQueryAdapter;
import com.tonbeller.jpivot.mondrian.MondrianSetParameter;
import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.DoubleExpr;
import com.tonbeller.jpivot.olap.model.Expression;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.IntegerExpr;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.impl.DoubleExprImpl;
import com.tonbeller.jpivot.olap.model.impl.IntegerExprImpl;
import com.tonbeller.jpivot.olap.model.impl.StringExprImpl;
import com.tonbeller.jpivot.olap.navi.ExpressionParser;
import com.tonbeller.tbutils.res.Resources;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import mondrian.olap.OlapElement;
import mondrian.olap.Query;
import mondrian.olap.Util;
import org.apache.log4j.Logger;

public class MondrianExpressionParser
extends ExtensionSupport
implements ExpressionParser {
    static NumberFormat nf = NumberFormat.getInstance();
    static Logger logger = Logger.getLogger(MondrianSetParameter.class);
    Resources resources = Resources.instance(MondrianSetParameter.class);

    public MondrianExpressionParser() {
        super.setId("expressionParser");
    }

    public String unparse(Expression expr) {
        if (expr instanceof DoubleExpr) {
            double d = ((DoubleExpr)expr).getValue();
            return nf.format(d);
        }
        if (expr instanceof IntegerExpr) {
            int ii = ((IntegerExpr)expr).getValue();
            return String.valueOf(ii);
        }
        if (expr instanceof MondrianMember) {
            MondrianMember m = (MondrianMember)expr;
            mondrian.olap.Member monMember = m.getMonMember();
            return monMember.getUniqueName();
        }
        if (expr instanceof MondrianLevel) {
            return ((MondrianLevel)expr).getUniqueName();
        }
        if (expr instanceof MondrianHierarchy) {
            return ((MondrianHierarchy)expr).getUniqueName();
        }
        if (expr instanceof MondrianDimension) {
            return ((MondrianDimension)expr).getUniqueName();
        }
        return null;
    }

    public Expression parse(String expr) throws ExpressionParser.InvalidSyntaxException {
        OlapElement element;
        String trimmed = expr.trim();
        int len = trimmed.length();
        if (trimmed.charAt(0) == '\"' && trimmed.charAt(len - 1) == '\"') {
            return new StringExprImpl(trimmed.substring(1, trimmed.length() - 1));
        }
        if (trimmed.charAt(0) == '\'' && trimmed.charAt(len - 1) == '\'') {
            return new StringExprImpl(trimmed.substring(1, trimmed.length() - 1));
        }
        Number number = null;
        try {
            number = nf.parse(trimmed);
        }
        catch (ParseException pex) {
            // empty catch block
        }
        if (number != null) {
            if (number instanceof Double) {
                return new DoubleExprImpl(number.doubleValue());
            }
            return new IntegerExprImpl(number.intValue());
        }
        MondrianModel model = (MondrianModel)this.getModel();
        Query query = ((MondrianQueryAdapter)model.getQueryAdapter()).getMonQuery();
        try {
            element = Util.lookup((Query)query, (List)Util.parseIdentifier((String)trimmed));
        }
        catch (Exception e) {
            logger.info((Object)e);
            throw new ExpressionParser.InvalidSyntaxException(trimmed);
        }
        if (element instanceof mondrian.olap.Member) {
            mondrian.olap.Member monMember = (mondrian.olap.Member)element;
            Member member = model.lookupMemberByUName(monMember.getUniqueName());
            return member;
        }
        if (element instanceof mondrian.olap.Level) {
            mondrian.olap.Level monLevel = (mondrian.olap.Level)element;
            MondrianLevel level = model.lookupLevel(monLevel.getUniqueName());
            return level;
        }
        if (element instanceof mondrian.olap.Hierarchy) {
            mondrian.olap.Hierarchy monHier = (mondrian.olap.Hierarchy)element;
            MondrianHierarchy hier = model.lookupHierarchy(monHier.getUniqueName());
            return hier;
        }
        if (element instanceof mondrian.olap.Dimension) {
            mondrian.olap.Dimension monDim = (mondrian.olap.Dimension)element;
            MondrianDimension dim = model.lookupDimension(monDim.getUniqueName());
            return dim;
        }
        throw new ExpressionParser.InvalidSyntaxException(this.resources.getString("jpivot.MondrianExpressionParser.error.parseError", new Object[]{trimmed}));
    }

    public Member lookupMember(String uniqueName) throws ExpressionParser.InvalidSyntaxException {
        MondrianModel model = (MondrianModel)this.getModel();
        return model.lookupMemberByUName(uniqueName);
    }

    public Level lookupLevel(String uniqueName) throws ExpressionParser.InvalidSyntaxException {
        MondrianModel model = (MondrianModel)this.getModel();
        return model.lookupLevel(uniqueName);
    }

    public Hierarchy lookupHierarchy(String uniqueName) throws ExpressionParser.InvalidSyntaxException {
        MondrianModel model = (MondrianModel)this.getModel();
        return model.lookupHierarchy(uniqueName);
    }

    public Dimension lookupDimension(String uniqueName) throws ExpressionParser.InvalidSyntaxException {
        MondrianModel model = (MondrianModel)this.getModel();
        return model.lookupDimension(uniqueName);
    }
}

