/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.mondrian;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.mondrian.MondrianModel;
import com.tonbeller.jpivot.mondrian.MondrianQueryAdapter;
import com.tonbeller.jpivot.olap.navi.NonEmpty;
import com.tonbeller.tbutils.res.Resources;
import mondrian.olap.Query;
import mondrian.olap.QueryAxis;
import org.apache.log4j.Logger;

public class MondrianNonEmpty
extends ExtensionSupport
implements NonEmpty {
    static Logger logger = Logger.getLogger(MondrianNonEmpty.class);
    Resources resources = Resources.instance();

    public MondrianNonEmpty() {
        super.setId("nonEmpty");
    }

    public boolean isNonEmpty() {
        MondrianModel m = (MondrianModel)this.getModel();
        MondrianQueryAdapter adapter = (MondrianQueryAdapter)m.getQueryAdapter();
        if (adapter == null) {
            return false;
        }
        Query monQuery = adapter.getMonQuery();
        for (int i = 0; i < monQuery.getAxes().length; ++i) {
            QueryAxis qAxis = monQuery.getAxes()[i];
            if (!qAxis.isNonEmpty()) continue;
            return true;
        }
        return false;
    }

    public void setNonEmpty(boolean nonEmpty) {
        MondrianModel m = (MondrianModel)this.getModel();
        MondrianQueryAdapter adapter = (MondrianQueryAdapter)m.getQueryAdapter();
        if (adapter == null) {
            logger.error((Object)this.resources.getString("jpivot.MondrianNonEmpty.error.nullAdapter"));
            return;
        }
        Query monQuery = adapter.getMonQuery();
        boolean bChange = false;
        for (int i = 0; i < monQuery.getAxes().length; ++i) {
            QueryAxis qAxis = monQuery.getAxes()[i];
            if (qAxis.isNonEmpty() == nonEmpty) continue;
            qAxis.setNonEmpty(nonEmpty);
            bChange = true;
        }
        if (bChange && logger.isInfoEnabled()) {
            logger.info((Object)this.resources.getString("jpivot.MondrianNonEmpty.message.nonEmpty", new Object[]{new Boolean(nonEmpty)}));
        }
        if (bChange) {
            ((MondrianModel)this.getModel()).fireModelChanged();
        }
    }
}

