/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.olap.query;

import com.tonbeller.jpivot.core.ExtensionSupport;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.Position;
import com.tonbeller.jpivot.olap.navi.DrillExpandMember;
import com.tonbeller.jpivot.olap.query.MdxOlapModel;
import com.tonbeller.jpivot.olap.query.QueryAdapter;
import java.util.Map;

public class DrillExpandMemberExt
extends ExtensionSupport
implements DrillExpandMember {
    public DrillExpandMemberExt() {
        super.setId("drillExpandMember");
    }

    public boolean canExpand(Member member) {
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        return model.getQueryAdapter().canExpand(member);
    }

    public boolean canExpand(Position position, Member member) {
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        if (model == null) {
            return false;
        }
        Member[] pathMembers = this.memberPath(position, member);
        return model.getQueryAdapter().canExpand(pathMembers);
    }

    public boolean canCollapse(Member member) {
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        return model.getQueryAdapter().canCollapse(member);
    }

    public boolean canCollapse(Position position, Member member) {
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        if (model == null) {
            return false;
        }
        Member[] pathMembers = this.memberPath(position, member);
        return model.getQueryAdapter().canCollapse(pathMembers);
    }

    public void expand(Member member) {
        QueryAdapter.QueryAdapterHolder model = (QueryAdapter.QueryAdapterHolder)((Object)this.getModel());
        if (model == null) {
            return;
        }
        QueryAdapter qa = model.getQueryAdapter();
        if (qa == null) {
            return;
        }
        qa.expand(member);
        this.setDrilling(member, true);
        this.push(new ExtensionSupport.Step("expandMember", member));
        Map drillMap = ((MdxOlapModel)((Object)model)).getDrillMap();
        if (drillMap == null) {
            return;
        }
        drillMap.put(member, null);
    }

    public void collapse(Member member) {
        this.collapseMember(member, false);
    }

    private Member[] memberPath(Position position, Member member) {
        if (position == null) {
            return null;
        }
        Member[] posMembers = position.getMembers();
        if (posMembers == null) {
            return null;
        }
        int pathlen = 0;
        for (int i = 0; i < posMembers.length && posMembers[i] != null; ++i) {
            if (!((Object)posMembers[i]).equals(member)) continue;
            pathlen = i + 1;
            break;
        }
        if (pathlen == 0) {
            return null;
        }
        Member[] pathMembers = new Member[pathlen];
        for (int i = 0; i < pathlen; ++i) {
            pathMembers[i] = posMembers[i];
        }
        return pathMembers;
    }
}

