/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.table.navi;

import com.tonbeller.jpivot.olap.model.Dimension;
import com.tonbeller.jpivot.olap.model.Expression;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.model.OlapModel;
import com.tonbeller.jpivot.olap.navi.ExpressionParser;
import com.tonbeller.jpivot.table.ClickableMember;
import com.tonbeller.jpivot.table.TableComponent;
import com.tonbeller.wcf.controller.RequestContext;
import org.apache.log4j.Logger;

public abstract class AbstractClickableMember
implements ClickableMember {
    private static final Logger logger = Logger.getLogger(AbstractClickableMember.class);
    boolean suppressAllMember = true;
    boolean suppressCalcMember = true;
    boolean suppressMeasures = true;
    private Expression expression;
    protected ExpressionParser parser;
    private String uniqueName;

    protected AbstractClickableMember(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    protected boolean match(Member member) {
        if (this.suppressCalcMember && member.isCalculated()) {
            return false;
        }
        if (this.suppressAllMember && member.isAll()) {
            return false;
        }
        if (this.suppressMeasures && member.getLevel().getHierarchy().getDimension().isMeasure()) {
            return false;
        }
        if (this.empty(this.uniqueName)) {
            return true;
        }
        if (this.parser == null || this.expression == null) {
            return false;
        }
        if (this.expression instanceof Level) {
            return this.expression.equals(member.getLevel());
        }
        if (this.expression instanceof Hierarchy) {
            return this.expression.equals(member.getLevel().getHierarchy());
        }
        if (this.expression instanceof Dimension) {
            return this.expression.equals(member.getLevel().getHierarchy().getDimension());
        }
        throw new IllegalArgumentException("unknown type: " + this.uniqueName);
    }

    private boolean empty(String s) {
        return s == null || s.length() == 0;
    }

    public void startRendering(RequestContext context, TableComponent table) {
        this.expression = null;
        this.parser = null;
        OlapModel model = table.getOlapModel();
        if (this.empty(this.uniqueName)) {
            return;
        }
        this.parser = (ExpressionParser)model.getExtension("expressionParser");
        if (this.parser != null) {
            try {
                this.expression = this.parser.lookupLevel(this.uniqueName);
                if (this.expression == null) {
                    this.expression = this.parser.lookupHierarchy(this.uniqueName);
                }
                if (this.expression == null) {
                    this.expression = this.parser.lookupDimension(this.uniqueName);
                }
            }
            catch (ExpressionParser.InvalidSyntaxException e) {
                logger.warn(null, (Throwable)e);
            }
        }
    }

    public void stopRendering() {
        this.parser = null;
        this.expression = null;
    }

    protected boolean isSuppressAllMember() {
        return this.suppressAllMember;
    }

    protected void setSuppressAllMember(boolean suppressAllMember) {
        this.suppressAllMember = suppressAllMember;
    }

    protected boolean isSuppressCalcMember() {
        return this.suppressCalcMember;
    }

    protected void setSuppressCalcMember(boolean suppressCalcMember) {
        this.suppressCalcMember = suppressCalcMember;
    }

    protected boolean isSuppressMeasures() {
        return this.suppressMeasures;
    }

    protected void setSuppressMeasures(boolean suppressMeasures) {
        this.suppressMeasures = suppressMeasures;
    }
}

