/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.xmla;

import com.tonbeller.jpivot.olap.mdxparse.CompoundId;
import com.tonbeller.jpivot.olap.mdxparse.Exp;
import com.tonbeller.jpivot.olap.mdxparse.ExpVisitor;
import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.OlapException;
import com.tonbeller.jpivot.olap.model.Visitor;
import com.tonbeller.jpivot.olap.query.MDXLevel;
import com.tonbeller.jpivot.util.StringUtil;
import com.tonbeller.jpivot.xmla.XMLA_Hierarchy;
import com.tonbeller.jpivot.xmla.XMLA_Member;
import com.tonbeller.jpivot.xmla.XMLA_MemberProp;
import com.tonbeller.jpivot.xmla.XMLA_Model;
import com.tonbeller.tbutils.res.Resources;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class XMLA_Level
implements Level,
MDXLevel,
Exp {
    private String dimUniqueName;
    private String hierUniqueName;
    private String name;
    private String uniqueName;
    private String caption;
    private int number;
    private int dimType;
    private int cardinality;
    private int type;
    private int customRollupSettings;
    private int uniqueSettings;
    private boolean isVisible;
    private String orderingProperty;
    private int dbType;
    private String nameSqlColumnName;
    private String keySqlColumnName;
    private String uniqueNameSqlColumnName;
    private XMLA_Level childLevel = null;
    private XMLA_Level parentLevel = null;
    private Hierarchy hierarchy = null;
    private List aMembers = null;
    private XMLA_Model model;
    private Map props = new HashMap();
    boolean drilling;
    boolean zooming;

    public XMLA_Level(XMLA_Model model) {
        this.model = model;
    }

    public boolean isEqual(XMLA_Level other) {
        return this.uniqueName.equals(other.getUniqueName());
    }

    public void setMembers(List mList) {
        this.aMembers = mList;
    }

    public void accept(Visitor visitor) {
        visitor.visitLevel(this);
    }

    public Object getRootDecoree() {
        return this;
    }

    public String getLabel() {
        return this.getCaption();
    }

    public String getCaption() {
        return Resources.instance().getOptionalString(this.caption, this.caption);
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public int getCustomRollupSettings() {
        return this.customRollupSettings;
    }

    public int getDbType() {
        return this.dbType;
    }

    public int getDimType() {
        return this.dimType;
    }

    public String getDimUniqueName() {
        return this.dimUniqueName;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public String getHierUniqueName() {
        return this.hierUniqueName;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public String getKeySqlColumnName() {
        return this.keySqlColumnName;
    }

    public String getName() {
        return this.name;
    }

    public String getNameSqlColumnName() {
        return this.nameSqlColumnName;
    }

    public int getDepth() {
        return this.number;
    }

    public String getOrderingProperty() {
        return this.orderingProperty;
    }

    public int getType() {
        return this.type;
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getUniqueNameSqlColumnName() {
        return this.uniqueNameSqlColumnName;
    }

    public int getUniqueSettings() {
        return this.uniqueSettings;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public void setCustomRollupSettings(int customRollupSettings) {
        this.customRollupSettings = customRollupSettings;
    }

    public void setDbType(int dbType) {
        this.dbType = dbType;
    }

    public void setDimType(int dimType) {
        this.dimType = dimType;
    }

    public void setDimUniqueName(String dimUniqueName) {
        this.dimUniqueName = dimUniqueName;
    }

    public void setHierarchy(Hierarchy hier) {
        this.hierarchy = hier;
    }

    public void setHierUniqueName(String hierUniqueName) {
        this.hierUniqueName = hierUniqueName;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }

    public void setKeySqlColumnName(String keySqlColumnName) {
        this.keySqlColumnName = keySqlColumnName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNameSqlColumnName(String nameSqlColumnName) {
        this.nameSqlColumnName = nameSqlColumnName;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public void setOrderingProperty(String orderingProperty) {
        this.orderingProperty = orderingProperty;
    }

    public void setType(int type) {
        this.type = type;
    }

    public void setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
    }

    public void setUniqueNameSqlColumnName(String uniqueNameSqlColumnName) {
        this.uniqueNameSqlColumnName = uniqueNameSqlColumnName;
    }

    public void setUniqueSettings(int uniqueSettings) {
        this.uniqueSettings = uniqueSettings;
    }

    public XMLA_Level getChildLevel() {
        return this.childLevel;
    }

    public XMLA_Level getParentLevel() {
        return this.parentLevel;
    }

    public void setChildLevel(XMLA_Level childLevel) {
        this.childLevel = childLevel;
    }

    public void setParentLevel(XMLA_Level parentLevel) {
        this.parentLevel = parentLevel;
    }

    public XMLA_Member[] getMembers() throws OlapException {
        if (this.aMembers != null) {
            return this.aMembers.toArray(new XMLA_Member[0]);
        }
        this.model.completeLevel(this);
        return this.aMembers.toArray(new XMLA_Member[0]);
    }

    public String toMdx() {
        return this.uniqueName;
    }

    public boolean isAll() {
        if (this.getParentLevel() != null) {
            return false;
        }
        return ((XMLA_Hierarchy)this.getHierarchy()).getAllMember() != null;
    }

    public boolean hasChildLevel() {
        return this.getChildLevel() != null;
    }

    public Object clone() {
        String[] nameParts = StringUtil.splitUniqueName(this.uniqueName);
        CompoundId clone = new CompoundId(nameParts[0], false);
        for (int i = 1; i < nameParts.length; ++i) {
            clone.append(nameParts[i], false);
        }
        return clone;
    }

    public Map getProps() {
        return this.props;
    }

    public void addProp(XMLA_MemberProp prop) {
        if (!this.props.containsKey(prop.getXmlTag())) {
            this.props.put(prop.getXmlTag(), prop);
        }
    }

    public XMLA_MemberProp getProp(String xmlTag) {
        return (XMLA_MemberProp)this.props.get(xmlTag);
    }

    public void accept(ExpVisitor visitor) {
        visitor.visitLevel(this);
    }

    public boolean isDrilling() {
        return this.drilling;
    }

    public void setDrilling(boolean drilling) {
        this.drilling = drilling;
    }

    public boolean isZooming() {
        return this.zooming;
    }

    public void setZooming(boolean zooming) {
        this.zooming = zooming;
    }
}

