/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.teiid.impl;

import com.jaspersoft.jasperserver.api.common.virtualdatasourcequery.teiid.TeiidDataSource;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.teiid.TeiidEmbeddedServer;
import com.jaspersoft.jasperserver.api.engine.common.virtualdatasourcequery.teiid.TranslatorConfig;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.resource.adapter.file.FileManagedConnectionFactory;
import org.teiid.resource.spi.BasicConnectionFactory;
import org.teiid.translator.TranslatorException;

public class FileTeiidDataSourceImpl
implements TeiidDataSource {
    String fileDirectory;
    String fileName;
    String fileSeparator = "/";
    String dataSourceName;
    String tableName;
    String metaDataSyntax;
    String tableExtension = "_info";
    TranslatorConfig translatorConfig;
    private static final Log log = LogFactory.getLog(TeiidEmbeddedServer.class);

    public String getFileDirectory() {
        return this.fileDirectory;
    }

    public void setFileDirectory(String fileDirectory) {
        this.fileDirectory = fileDirectory;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String dataSourceName) {
        this.dataSourceName = dataSourceName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getMetaDataSyntax() {
        return this.metaDataSyntax;
    }

    public void setMetaDataSyntax(String metaDataSyntax) {
        this.metaDataSyntax = metaDataSyntax;
    }

    public TranslatorConfig getTranslatorConfig() {
        return this.translatorConfig;
    }

    public void setTranslatorConfig(TranslatorConfig translatorConfig) {
        this.translatorConfig = translatorConfig;
    }

    public String getConnectorName() {
        return (this.fileDirectory + this.fileSeparator + this.fileName).hashCode() + "";
    }

    public ConnectorManager getConnectorManager() throws Exception {
        FileManagedConnectionFactory fileManagedConnectionFactory = new FileManagedConnectionFactory();
        fileManagedConnectionFactory.setParentDirectory(this.fileDirectory);
        fileManagedConnectionFactory.setAllowParentPaths(Boolean.valueOf(true));
        final BasicConnectionFactory bcf = fileManagedConnectionFactory.createConnectionFactory();
        ConnectorManager cm = new ConnectorManager(this.translatorConfig.getTranslatorName(), this.getConnectorName()){

            public Object getConnectionFactory() throws TranslatorException {
                return bcf;
            }
        };
        this.translatorConfig.setupTranslator();
        cm.setExecutionFactory(this.translatorConfig.getTranslatorFactory());
        return cm;
    }

    public List<ModelMetaData> getModelMetaDataList() {
        ArrayList<ModelMetaData> modelMetaDataList = new ArrayList<ModelMetaData>();
        modelMetaDataList.add(this.getFileModel());
        modelMetaDataList.add(this.getFileViewModel());
        return modelMetaDataList;
    }

    private ModelMetaData getFileModel() {
        String subDataSourceID = this.getConnectorName();
        String modelName = this.dataSourceName + this.tableExtension;
        ModelMetaData model = new ModelMetaData();
        model.setModelType(Model.Type.PHYSICAL);
        model.setName(modelName);
        model.addSourceMapping(subDataSourceID, this.translatorConfig.getTranslatorName(), subDataSourceID);
        return model;
    }

    private ModelMetaData getFileViewModel() {
        String modelName = this.dataSourceName;
        String tableModelName = this.dataSourceName + this.tableExtension;
        String subDataSourceID = this.getConnectorName();
        ModelMetaData model = new ModelMetaData();
        model.setModelType(Model.Type.VIRTUAL);
        model.setSchemaSourceType("ddl");
        model.setName(modelName);
        String schemaText = "create view \"" + this.tableName + "\" OPTIONS (UPDATABLE 'true') as select " + this.tableName + ".* from (call " + tableModelName + ".getTextFiles('" + this.fileName + "')) f, TEXTTABLE(f.file COLUMNS " + this.metaDataSyntax + " HEADER) " + this.tableName;
        log.debug((Object)("FileTeiidDataSourceImpl schema text = " + schemaText));
        model.setSchemaText(schemaText);
        return model;
    }

    public String getFileSeparator() {
        return this.fileSeparator;
    }

    public void setFileSeparator(String fileSeparator) {
        this.fileSeparator = fileSeparator;
    }

    public String getTableExtension() {
        return this.tableExtension;
    }

    public void setTableExtension(String tableExtension) {
        this.tableExtension = tableExtension;
    }
}

