/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.BaseJdbcDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JndiJdbcDataSourceService
extends BaseJdbcDataSource {
    private static final Log log = LogFactory.getLog(JndiJdbcDataSourceService.class);
    private final String jndiName;

    public JndiJdbcDataSourceService(String jndiName) {
        this.jndiName = jndiName;
    }

    @Override
    protected Connection createConnection() {
        try {
            InitialContext ctx = new InitialContext();
            DataSource ds = (DataSource)ctx.lookup("java:comp/env/" + this.jndiName);
            Connection c = ds.getConnection();
            if (log.isDebugEnabled()) {
                log.debug((Object)"CreateConnection successful at com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JndiJdbcDataSourceService.createConnection");
            }
            return c;
        }
        catch (NamingException e) {
            try {
                InitialContext ctx = new InitialContext();
                DataSource ds = (DataSource)ctx.lookup(this.jndiName);
                Connection c = ds.getConnection();
                if (log.isDebugEnabled()) {
                    log.debug((Object)"CreateConnection successful at com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.JndiJdbcDataSourceService.createConnection");
                }
                return c;
            }
            catch (NamingException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e, (Throwable)e);
                }
                throw new JSExceptionWrapper((Exception)e);
            }
            catch (SQLException ex) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)e, (Throwable)e);
                }
                throw new JSExceptionWrapper((Exception)e);
            }
        }
        catch (SQLException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)e, (Throwable)e);
            }
            throw new JSExceptionWrapper((Exception)e);
        }
    }
}

