/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.domain.impl.ReportUnitRequestBase;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataCacheProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.DataSnapshotService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.ReportDataCacheProvider;
import com.jaspersoft.jasperserver.api.engine.jasperreports.service.impl.ReportLoadingService;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.DefaultDataCacheSnapshot;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataCacheSnapshot;
import com.jaspersoft.jasperserver.api.metadata.data.cache.DataSnapshotPersistentMetadata;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import java.util.Date;
import java.util.Map;
import net.sf.jasperreports.data.cache.DataCacheHandler;
import net.sf.jasperreports.data.cache.DataSnapshot;
import net.sf.jasperreports.data.cache.PopulatedSnapshotCacheHandler;
import net.sf.jasperreports.engine.ReportContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StandardDataCacheProvider
implements DataCacheProvider {
    private static final Log log = LogFactory.getLog(StandardDataCacheProvider.class);
    private ReportLoadingService reportLoadingService;
    private DataSnapshotService dataSnapshotService;
    private String dataSnapshotProviderParameter = "com.jaspersoft.jasperserver.data.snapshot.provider";

    @Override
    public DataCacheSnapshot setReportExecutionCache(ExecutionContext context, ReportUnitRequestBase request, ReportUnit reportUnit, Map<String, Object> dataParameters) {
        if (!(request.isUseDataSnapshot() || this.dataSnapshotService.isSnapshotRecordingEnabled() && request.isRecordDataSnapshot())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"no data caching");
            }
            return null;
        }
        ReportContext reportContext = request.getReportContext();
        if (reportContext == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"no report context");
            }
            return null;
        }
        ReportDataCacheProvider cacheProvider = (ReportDataCacheProvider)reportContext.getParameterValue(this.getDataSnapshotProviderParameter());
        if (cacheProvider == null) {
            cacheProvider = this.createReportCacheProvider();
            reportContext.setParameterValue(this.dataSnapshotProviderParameter, (Object)cacheProvider);
        }
        PopulatedSnapshotCacheHandler cacheHandler = null;
        DataCacheSnapshot dataSnapshot = this.loadDataSnapshot(context, request, reportUnit, dataParameters, cacheProvider);
        if (dataSnapshot != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"found data snapshot");
            }
            cacheHandler = new PopulatedSnapshotCacheHandler(dataSnapshot.getSnapshot());
        } else if (this.dataSnapshotService.isSnapshotRecordingEnabled() && request.isRecordDataSnapshot()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"creating recording cache handler");
            }
            cacheHandler = cacheProvider.createRecordHandler(dataParameters);
        }
        if (cacheHandler != null) {
            reportContext.setParameterValue("net.sf.jasperreports.data.cache.handler", (Object)cacheHandler);
        }
        return dataSnapshot;
    }

    @Override
    public void handleInvalidSnapshot(ExecutionContext context, ReportUnitRequestBase request, ReportUnit reportUnit, Map<String, Object> dataParameters) {
        ReportDataCacheProvider cacheProvider;
        ReportContext reportContext = request.getReportContext();
        if (reportContext == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"no report context");
            }
            return;
        }
        DataCacheHandler cacheHandler = (DataCacheHandler)reportContext.getParameterValue("net.sf.jasperreports.data.cache.handler");
        if (cacheHandler != null && cacheHandler.isSnapshotPopulated()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"removing populated data snapshot");
            }
            reportContext.setParameterValue("net.sf.jasperreports.data.cache.handler", null);
        }
        if ((cacheProvider = (ReportDataCacheProvider)reportContext.getParameterValue(this.getDataSnapshotProviderParameter())) != null) {
            DataCacheSnapshot snapshot = cacheProvider.getSnapshot();
            if (snapshot != null && snapshot.isSaved()) {
                cacheProvider.setSnapshot(null);
                cacheProvider.setHadSavedSnapshot(false);
            }
            if (this.dataSnapshotService.isSnapshotRecordingEnabled() && request.isRecordDataSnapshot()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"creating recording cache handler");
                }
                DataCacheHandler recordingHandler = cacheProvider.createRecordHandler(dataParameters);
                reportContext.setParameterValue("net.sf.jasperreports.data.cache.handler", (Object)recordingHandler);
            }
        }
    }

    protected ReportDataCacheProvider createReportCacheProvider() {
        return new ReportDataCacheProvider();
    }

    protected DataCacheSnapshot loadDataSnapshot(ExecutionContext context, ReportUnitRequestBase request, ReportUnit reportUnit, Map<String, Object> dataParameters, ReportDataCacheProvider cacheProvider) {
        if (reportUnit.getDataSnapshotId() != null) {
            cacheProvider.setHadSavedSnapshot(true);
        }
        if (!request.isUseDataSnapshot()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"not using data snapshot");
            }
            return null;
        }
        DataCacheSnapshot dataSnapshot = cacheProvider.getSnapshot();
        if (dataSnapshot != null && !this.parametersMatch(dataParameters, dataSnapshot.getMetadata().getParameters())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"current snapshot doesn't match the parameters");
            }
            cacheProvider.clearSnapshot();
            dataSnapshot = null;
        }
        if (dataSnapshot == null) {
            dataSnapshot = this.useSavedDataSnapshot(context, reportUnit, dataParameters, cacheProvider);
        }
        return dataSnapshot;
    }

    protected DataCacheSnapshot useSavedDataSnapshot(ExecutionContext context, ReportUnit reportUnit, Map<String, Object> dataParameters, ReportDataCacheProvider cacheProvider) {
        DataSnapshot snapshotContents;
        DataSnapshotPersistentMetadata persistentSnapshot = this.loadSavedDataSnapshot(context, reportUnit);
        if (persistentSnapshot == null) {
            cacheProvider.setHadSavedSnapshot(false);
            return null;
        }
        if (!this.parametersMatch(dataParameters, persistentSnapshot.getSnapshotMetadata().getParameters())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("cached data snapshot " + reportUnit.getDataSnapshotId() + " with version " + persistentSnapshot.getVersion() + " doesn't match the parameters"));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("found matching saved data snapshot " + reportUnit.getDataSnapshotId() + " at version " + persistentSnapshot.getVersion()));
        }
        if ((snapshotContents = this.dataSnapshotService.getSnapshotContents(context, persistentSnapshot.getContentsId())) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("data snapshot contents " + persistentSnapshot.getContentsId() + " not found for " + reportUnit.getURIString()));
            }
            return null;
        }
        DefaultDataCacheSnapshot dataSnapshot = new DefaultDataCacheSnapshot(snapshotContents, persistentSnapshot.getSnapshotMetadata());
        cacheProvider.setSavedDataSnapshot(dataSnapshot);
        return dataSnapshot;
    }

    @Override
    public DataSnapshotPersistentMetadata loadSavedDataSnapshot(ExecutionContext context, ReportUnit reportUnit) {
        Date dataSourceTimestamp;
        DataSnapshotPersistentMetadata persistentSnapshot;
        Long snapshotId = reportUnit.getDataSnapshotId();
        if (snapshotId == null) {
            return null;
        }
        if (!this.dataSnapshotService.isSnapshotPersistenceEnabled()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("snapshot persistence is disabled, not using snapshot " + snapshotId + " for report " + reportUnit.getURIString()));
            }
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("loading saved data snapshot " + snapshotId + " for " + reportUnit.getURIString()));
        }
        if ((persistentSnapshot = this.dataSnapshotService.getSnapshotMetadata(context, snapshotId)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("data snapshot " + snapshotId + " not found for " + reportUnit.getURIString()));
            }
            return null;
        }
        Date snapshotDate = persistentSnapshot.getSnapshotMetadata().getSnapshotDate();
        Resource dataSource = this.getReportLoadingService().getFinalResource(context, reportUnit.getDataSource(), Resource.class);
        Date date = dataSourceTimestamp = dataSource == null ? null : dataSource.getUpdateDate();
        if (dataSourceTimestamp != null && !snapshotDate.after(dataSourceTimestamp)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("data snapshot " + snapshotId + " of " + reportUnit.getURIString() + " is older (" + snapshotDate + ") than data source (" + dataSourceTimestamp + ")"));
            }
            return null;
        }
        return persistentSnapshot;
    }

    @Override
    public DataCacheSnapshot getDataSnapshot(ExecutionContext context, ReportContext reportContext) {
        ReportDataCacheProvider cacheProvider = (ReportDataCacheProvider)reportContext.getParameterValue(this.getDataSnapshotProviderParameter());
        if (cacheProvider == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"no cache provider found");
            }
            return null;
        }
        return cacheProvider.getSnapshot();
    }

    @Override
    public boolean parametersMatch(Map<String, Object> dataParameters, Map<String, Object> snapshotParams) {
        boolean match = true;
        for (Map.Entry<String, Object> dataParamsEntry : dataParameters.entrySet()) {
            Object snapshotValue;
            String key = dataParamsEntry.getKey();
            Object value = dataParamsEntry.getValue();
            Object object = snapshotValue = snapshotParams == null ? null : snapshotParams.get(key);
            if (!(value == null ? snapshotValue != null : snapshotValue == null || !value.equals(snapshotValue))) continue;
            match = false;
            break;
        }
        return match;
    }

    @Override
    public void snapshotSaved(ExecutionContext context, ReportContext reportContext, DataCacheSnapshot snapshot, Long savedSnapshotId) {
        ReportDataCacheProvider cacheProvider;
        if (!snapshot.isSaved() && (cacheProvider = (ReportDataCacheProvider)reportContext.getParameterValue(this.getDataSnapshotProviderParameter())) != null) {
            cacheProvider.setSavedDataSnapshot(snapshot);
            cacheProvider.setHadSavedSnapshot(true);
        }
    }

    @Override
    public DataCacheProvider.SnapshotSaveStatus getSnapshotSaveStatus(ReportContext reportContext) {
        DataCacheProvider.SnapshotSaveStatus status;
        ReportDataCacheProvider cacheProvider;
        ReportDataCacheProvider reportDataCacheProvider = cacheProvider = reportContext == null ? null : (ReportDataCacheProvider)reportContext.getParameterValue(this.getDataSnapshotProviderParameter());
        if (cacheProvider == null) {
            status = DataCacheProvider.SnapshotSaveStatus.NO_CHANGE;
        } else {
            DataCacheSnapshot snapshot = cacheProvider.getSnapshot();
            boolean hadSavedSnapshot = cacheProvider.hadSavedSnapshot();
            status = !this.dataSnapshotService.isSnapshotPersistenceEnabled() || snapshot == null || !snapshot.getSnapshot().isPersistable() ? (hadSavedSnapshot ? DataCacheProvider.SnapshotSaveStatus.UPDATED : DataCacheProvider.SnapshotSaveStatus.NO_CHANGE) : (snapshot.isSaved() ? DataCacheProvider.SnapshotSaveStatus.NO_CHANGE : (hadSavedSnapshot ? DataCacheProvider.SnapshotSaveStatus.UPDATED : DataCacheProvider.SnapshotSaveStatus.NEW));
        }
        return status;
    }

    public String getDataSnapshotProviderParameter() {
        return this.dataSnapshotProviderParameter;
    }

    public void setDataSnapshotProviderParameter(String dataSnapshotProviderParameter) {
        this.dataSnapshotProviderParameter = dataSnapshotProviderParameter;
    }

    public ReportLoadingService getReportLoadingService() {
        return this.reportLoadingService;
    }

    public void setReportLoadingService(ReportLoadingService reportLoadingService) {
        this.reportLoadingService = reportLoadingService;
    }

    public DataSnapshotService getDataSnapshotService() {
        return this.dataSnapshotService;
    }

    public void setDataSnapshotService(DataSnapshotService dataSnapshotService) {
        this.dataSnapshotService = dataSnapshotService;
    }
}

