/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.RevokeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.rds.AmazonRDSClient;
import com.amazonaws.services.rds.model.AuthorizeDBSecurityGroupIngressRequest;
import com.amazonaws.services.rds.model.CreateDBSecurityGroupRequest;
import com.amazonaws.services.rds.model.DBInstance;
import com.amazonaws.services.rds.model.DBSecurityGroup;
import com.amazonaws.services.rds.model.DBSecurityGroupMembership;
import com.amazonaws.services.rds.model.DBSecurityGroupNotFoundException;
import com.amazonaws.services.rds.model.DBSubnetGroup;
import com.amazonaws.services.rds.model.DescribeDBInstancesRequest;
import com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import com.amazonaws.services.rds.model.DescribeDBSecurityGroupsRequest;
import com.amazonaws.services.rds.model.DescribeDBSecurityGroupsResult;
import com.amazonaws.services.rds.model.ModifyDBInstanceRequest;
import com.amazonaws.services.rds.model.RevokeDBSecurityGroupIngressRequest;
import com.amazonaws.services.rds.model.VpcSecurityGroupMembership;
import com.amazonaws.services.redshift.AmazonRedshiftClient;
import com.amazonaws.services.redshift.model.AuthorizeClusterSecurityGroupIngressRequest;
import com.amazonaws.services.redshift.model.Cluster;
import com.amazonaws.services.redshift.model.ClusterSecurityGroup;
import com.amazonaws.services.redshift.model.ClusterSecurityGroupMembership;
import com.amazonaws.services.redshift.model.ClusterSecurityGroupNotFoundException;
import com.amazonaws.services.redshift.model.CreateClusterSecurityGroupRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsRequest;
import com.amazonaws.services.redshift.model.DescribeClusterSecurityGroupsResult;
import com.amazonaws.services.redshift.model.DescribeClustersRequest;
import com.amazonaws.services.redshift.model.DescribeClustersResult;
import com.amazonaws.services.redshift.model.IPRange;
import com.amazonaws.services.redshift.model.ModifyClusterRequest;
import com.amazonaws.services.redshift.model.RevokeClusterSecurityGroupIngressRequest;
import com.jaspersoft.jasperserver.api.JSAwsDataSourceRecoveryException;
import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.AwsCredentialUtil;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.AwsEc2MetadataClient;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.AwsProperties;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.AwsReportDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class AwsDataSourceRecovery {
    public static final String RDS = "rds";
    public static final String Redshift = "redshift";
    private List<String> awsRegions;
    private String awsDataSourceActiveStatus;
    private AwsProperties awsProperties;
    private AwsEc2MetadataClient awsEc2MetadataClient;
    public static String DB_VPC_ID = "DB_VPC_ID";
    public static String DB_REGION = "DB_REGION";
    public static String ingressIpPermission = "/32";
    private final Log logger = LogFactory.getLog(AwsDataSourceRecovery.class);
    MessageSource messageSource;

    public void createAwsDSSecurityGroup(AwsReportDataSource awsReportDataSource) {
        if (this.awsProperties.isSecurityGroupChangesEnabled().booleanValue()) {
            this.logger.debug((Object)("Starting Recovery " + awsReportDataSource.getDbService() + " " + awsReportDataSource.getDbInstanceIdentifier() + " instance"));
            try {
                if (awsReportDataSource.getDbService().equals(RDS)) {
                    this.createRDSSecurityGroup(awsReportDataSource);
                } else if (awsReportDataSource.getDbService().equals(Redshift)) {
                    this.createRedshiftSecurityGroup(awsReportDataSource);
                }
            }
            catch (Exception ex) {
                String errorMessage = this.messageSource.getMessage("aws.exception.datasource.recovery.base", (Object[])new String[]{awsReportDataSource.getURIString()}, LocaleContextHolder.getLocale()) + "\n" + ex.getMessage();
                this.logger.error((Object)errorMessage);
                throw new JSAwsDataSourceRecoveryException(errorMessage);
            }
        }
    }

    private void createRDSSecurityGroup(AwsReportDataSource awsReportDataSource) throws Exception {
        DescribeDBInstancesResult describeInstancesResult;
        AWSCredentials awsCredentials = AwsCredentialUtil.getAWSCredentials(awsReportDataSource.getAWSAccessKey(), awsReportDataSource.getAWSSecretKey(), awsReportDataSource.getRoleARN());
        AmazonRDSClient rdsClient = new AmazonRDSClient(awsCredentials);
        DescribeDBInstancesRequest describeDBInstancesRequest = new DescribeDBInstancesRequest().withDBInstanceIdentifier(awsReportDataSource.getDbInstanceIdentifier());
        String endpoint = awsReportDataSource.getAWSRegion();
        if (endpoint != null) {
            rdsClient.setEndpoint("rds." + endpoint);
        }
        if ((describeInstancesResult = rdsClient.describeDBInstances(describeDBInstancesRequest)) != null && describeInstancesResult.getDBInstances() != null && describeInstancesResult.getDBInstances().size() > 0) {
            DBInstance dbInstance = (DBInstance)describeInstancesResult.getDBInstances().get(0);
            if (!dbInstance.getDBInstanceStatus().equals(this.awsDataSourceActiveStatus)) {
                throw new JSException(this.messageSource.getMessage("aws.exception.datasource.recovery.instance.not.active", null, LocaleContextHolder.getLocale()));
            }
            HashMap<String, String> awsDSInstanceDetails = new HashMap<String, String>();
            awsDSInstanceDetails.put(DB_REGION, this.parseRegionFromSubRegion(dbInstance.getAvailabilityZone()));
            DBSubnetGroup dbSubnetGroup = dbInstance.getDBSubnetGroup();
            if (dbSubnetGroup != null) {
                awsDSInstanceDetails.put(DB_VPC_ID, dbSubnetGroup.getVpcId());
            } else {
                awsDSInstanceDetails.put(DB_VPC_ID, null);
            }
            String instanceSourceIp = this.determineSourceIpAddress(awsDSInstanceDetails);
            if (!StringUtils.isNotEmpty((String)instanceSourceIp)) {
                throw new JSException(this.getErrorMessage("aws.exception.datasource.recovery.public.ip.not.determined"));
            }
            String ingressIpMask = instanceSourceIp + ingressIpPermission;
            String vpcSecurityGroupId = null;
            if (awsDSInstanceDetails.get(DB_VPC_ID) != null) {
                vpcSecurityGroupId = this.recoverVpcSecurityGroup(awsReportDataSource, (String)awsDSInstanceDetails.get(DB_VPC_ID), ingressIpMask);
            } else {
                Boolean jsSecurityGroupMembershipFount = true;
                DBSecurityGroup dbSecurityGroup = null;
                try {
                    DescribeDBSecurityGroupsRequest describeDBSecurityGroupsRequest = new DescribeDBSecurityGroupsRequest().withDBSecurityGroupName(this.awsProperties.getSecurityGroupName());
                    DescribeDBSecurityGroupsResult describeDBSecurityGroupsResult = rdsClient.describeDBSecurityGroups(describeDBSecurityGroupsRequest);
                    dbSecurityGroup = (DBSecurityGroup)describeDBSecurityGroupsResult.getDBSecurityGroups().get(0);
                }
                catch (DBSecurityGroupNotFoundException ex) {
                    jsSecurityGroupMembershipFount = false;
                }
                boolean ingressIpMaskExist = false;
                if (jsSecurityGroupMembershipFount.booleanValue()) {
                    List ipRanges = dbSecurityGroup.getIPRanges();
                    for (com.amazonaws.services.rds.model.IPRange ipRange : ipRanges) {
                        if (!ipRange.getCIDRIP().contains(ingressIpMask)) continue;
                        ingressIpMaskExist = true;
                        break;
                    }
                    if (!ingressIpMaskExist) {
                        for (com.amazonaws.services.rds.model.IPRange ipRange : ipRanges) {
                            RevokeDBSecurityGroupIngressRequest revokeDBSecurityGroupIngressRequest = new RevokeDBSecurityGroupIngressRequest().withDBSecurityGroupName(this.awsProperties.getSecurityGroupName()).withCIDRIP(ipRange.getCIDRIP());
                            rdsClient.revokeDBSecurityGroupIngress(revokeDBSecurityGroupIngressRequest);
                        }
                    }
                } else {
                    dbSecurityGroup = rdsClient.createDBSecurityGroup(new CreateDBSecurityGroupRequest().withDBSecurityGroupName(this.awsProperties.getSecurityGroupName()).withDBSecurityGroupDescription(this.awsProperties.getSecurityGroupDescription()));
                }
                if (!ingressIpMaskExist) {
                    rdsClient.authorizeDBSecurityGroupIngress(new AuthorizeDBSecurityGroupIngressRequest().withDBSecurityGroupName(dbSecurityGroup.getDBSecurityGroupName()).withCIDRIP(ingressIpMask));
                }
            }
            if (vpcSecurityGroupId == null) {
                List dbSecurityGroupMemberships = dbInstance.getDBSecurityGroups();
                ArrayList<String> dbSecurityGroupNames = new ArrayList<String>();
                for (DBSecurityGroupMembership dbSecurityGroupMembership : dbSecurityGroupMemberships) {
                    dbSecurityGroupNames.add(dbSecurityGroupMembership.getDBSecurityGroupName());
                }
                if (!dbSecurityGroupNames.contains(this.awsProperties.getSecurityGroupName())) {
                    dbSecurityGroupNames.add(this.awsProperties.getSecurityGroupName());
                    ModifyDBInstanceRequest modifyDBInstanceRequest = new ModifyDBInstanceRequest().withDBSecurityGroups(dbSecurityGroupNames).withDBInstanceIdentifier(dbInstance.getDBInstanceIdentifier());
                    modifyDBInstanceRequest.setApplyImmediately(Boolean.valueOf(true));
                    rdsClient.modifyDBInstance(modifyDBInstanceRequest);
                }
            } else {
                List vpcSecurityGroupMemberships = dbInstance.getVpcSecurityGroups();
                ArrayList<String> vpcSecurityGroupIds = new ArrayList<String>();
                for (VpcSecurityGroupMembership vpcSecurityGroupMembership : vpcSecurityGroupMemberships) {
                    vpcSecurityGroupIds.add(vpcSecurityGroupMembership.getVpcSecurityGroupId());
                }
                if (!vpcSecurityGroupIds.contains(vpcSecurityGroupId)) {
                    vpcSecurityGroupIds.add(vpcSecurityGroupId);
                    ModifyDBInstanceRequest modifyDBInstanceRequest = new ModifyDBInstanceRequest().withVpcSecurityGroupIds(vpcSecurityGroupIds).withDBInstanceIdentifier(dbInstance.getDBInstanceIdentifier());
                    modifyDBInstanceRequest.setApplyImmediately(Boolean.valueOf(true));
                    rdsClient.modifyDBInstance(modifyDBInstanceRequest);
                }
            }
        }
    }

    private void createRedshiftSecurityGroup(AwsReportDataSource awsReportDataSource) throws Exception {
        DescribeClustersResult describeClustersResult;
        AWSCredentials awsCredentials = AwsCredentialUtil.getAWSCredentials(awsReportDataSource.getAWSAccessKey(), awsReportDataSource.getAWSSecretKey(), awsReportDataSource.getRoleARN());
        AmazonRedshiftClient redshiftClient = new AmazonRedshiftClient(awsCredentials);
        DescribeClustersRequest describeClustersRequest = new DescribeClustersRequest().withClusterIdentifier(awsReportDataSource.getDbInstanceIdentifier());
        String endpoint = awsReportDataSource.getAWSRegion();
        if (endpoint != null) {
            redshiftClient.setEndpoint("redshift." + endpoint);
        }
        if ((describeClustersResult = redshiftClient.describeClusters(describeClustersRequest)) != null && describeClustersResult.getClusters() != null && describeClustersResult.getClusters().size() > 0) {
            Cluster cluster = (Cluster)describeClustersResult.getClusters().get(0);
            if (!cluster.getClusterStatus().equals(this.awsDataSourceActiveStatus)) {
                throw new JSException(this.getErrorMessage("aws.exception.datasource.recovery.instance.not.active"));
            }
            HashMap<String, String> awsDSInstanceDetails = new HashMap<String, String>();
            awsDSInstanceDetails.put(DB_REGION, this.parseRegionFromSubRegion(cluster.getAvailabilityZone()));
            String vpcId = cluster.getVpcId();
            if (StringUtils.isNotEmpty((String)vpcId)) {
                awsDSInstanceDetails.put(DB_VPC_ID, vpcId);
            } else {
                awsDSInstanceDetails.put(DB_VPC_ID, null);
            }
            String instanceSourceIp = this.determineSourceIpAddress(awsDSInstanceDetails);
            if (!StringUtils.isNotEmpty((String)instanceSourceIp)) {
                throw new JSException(this.getErrorMessage("aws.exception.datasource.recovery.public.ip.not.determined"));
            }
            String ingressIpMask = instanceSourceIp + ingressIpPermission;
            String vpcSecurityGroupId = null;
            if (awsDSInstanceDetails.get(DB_VPC_ID) != null) {
                vpcSecurityGroupId = this.recoverVpcSecurityGroup(awsReportDataSource, (String)awsDSInstanceDetails.get(DB_VPC_ID), ingressIpMask);
            } else {
                Boolean jsSecurityGroupMembershipFount = true;
                ClusterSecurityGroup clusterSecurityGroup = null;
                try {
                    DescribeClusterSecurityGroupsRequest describeClusterSecurityGroupsRequest = new DescribeClusterSecurityGroupsRequest().withClusterSecurityGroupName(this.awsProperties.getSecurityGroupName());
                    DescribeClusterSecurityGroupsResult describeClusterSecurityGroupsResult = redshiftClient.describeClusterSecurityGroups(describeClusterSecurityGroupsRequest);
                    clusterSecurityGroup = (ClusterSecurityGroup)describeClusterSecurityGroupsResult.getClusterSecurityGroups().get(0);
                }
                catch (ClusterSecurityGroupNotFoundException ex) {
                    jsSecurityGroupMembershipFount = false;
                }
                boolean ingressIpMaskExist = false;
                if (jsSecurityGroupMembershipFount.booleanValue()) {
                    List ipRanges = clusterSecurityGroup.getIPRanges();
                    for (IPRange ipRange : ipRanges) {
                        if (!ipRange.getCIDRIP().contains(ingressIpMask)) continue;
                        ingressIpMaskExist = true;
                        break;
                    }
                    if (!ingressIpMaskExist) {
                        for (IPRange ipRange : ipRanges) {
                            RevokeClusterSecurityGroupIngressRequest revokeClusterSecurityGroupIngressRequest = new RevokeClusterSecurityGroupIngressRequest().withClusterSecurityGroupName(this.awsProperties.getSecurityGroupName()).withCIDRIP(ipRange.getCIDRIP());
                            redshiftClient.revokeClusterSecurityGroupIngress(revokeClusterSecurityGroupIngressRequest);
                        }
                    }
                } else {
                    clusterSecurityGroup = redshiftClient.createClusterSecurityGroup(new CreateClusterSecurityGroupRequest().withClusterSecurityGroupName(this.awsProperties.getSecurityGroupName()).withDescription(this.awsProperties.getSecurityGroupDescription()));
                }
                if (!ingressIpMaskExist) {
                    redshiftClient.authorizeClusterSecurityGroupIngress(new AuthorizeClusterSecurityGroupIngressRequest().withClusterSecurityGroupName(clusterSecurityGroup.getClusterSecurityGroupName()).withCIDRIP(ingressIpMask));
                }
            }
            if (vpcSecurityGroupId == null) {
                List clusterSecurityGroupMemberships = cluster.getClusterSecurityGroups();
                ArrayList<String> clusterSecurityGroupNames = new ArrayList<String>();
                for (ClusterSecurityGroupMembership clusterSecurityGroupMembership : clusterSecurityGroupMemberships) {
                    clusterSecurityGroupNames.add(clusterSecurityGroupMembership.getClusterSecurityGroupName());
                }
                if (!clusterSecurityGroupNames.contains(this.awsProperties.getSecurityGroupName())) {
                    clusterSecurityGroupNames.add(this.awsProperties.getSecurityGroupName());
                    ModifyClusterRequest modifyClusterRequest = new ModifyClusterRequest().withClusterSecurityGroups(clusterSecurityGroupNames).withClusterIdentifier(cluster.getClusterIdentifier());
                    redshiftClient.modifyCluster(modifyClusterRequest);
                }
            } else {
                List vpcSecurityGroupMemberships = cluster.getVpcSecurityGroups();
                ArrayList<String> vpcSecurityGroupIds = new ArrayList<String>();
                for (com.amazonaws.services.redshift.model.VpcSecurityGroupMembership vpcSecurityGroupMembership : vpcSecurityGroupMemberships) {
                    vpcSecurityGroupIds.add(vpcSecurityGroupMembership.getVpcSecurityGroupId());
                }
                if (!vpcSecurityGroupIds.contains(vpcSecurityGroupId)) {
                    vpcSecurityGroupIds.add(vpcSecurityGroupId);
                    ModifyClusterRequest modifyClusterRequest = new ModifyClusterRequest().withVpcSecurityGroupIds(vpcSecurityGroupIds).withClusterIdentifier(cluster.getClusterIdentifier());
                    redshiftClient.modifyCluster(modifyClusterRequest);
                }
            }
        }
    }

    private String determineSourceIpAddress(Map<String, String> awsDSInstanceDetails) throws Exception {
        this.logger.debug((Object)"Determine source Ip address for AWS data source recovery");
        String awsDSInstanceVpcId = awsDSInstanceDetails.get(DB_VPC_ID);
        if (this.awsEc2MetadataClient.isEc2Instance()) {
            String ec2InstanceRegion = this.parseRegionFromSubRegion(this.awsEc2MetadataClient.getEc2InstanceMetadataItem("/latest/meta-data/placement/availability-zone/"));
            String awsDSInstanceRegion = awsDSInstanceDetails.get(DB_REGION);
            if (this.awsEc2MetadataClient.isEc2InstanceInTargetVpc(awsDSInstanceVpcId).booleanValue()) {
                if (ec2InstanceRegion.equals(awsDSInstanceRegion)) {
                    return this.getIpAddress("/latest/meta-data/local-ipv4/");
                }
                return this.getIpAddress("/latest/meta-data/public-ipv4/");
            }
            if (this.awsEc2MetadataClient.isEc2InstanceInVpc().booleanValue() && awsDSInstanceVpcId == null) {
                return this.getIpAddress("/latest/meta-data/public-ipv4/");
            }
            throw new JSException(this.getErrorMessage("aws.exception.datasource.recovery.is.not.possible"));
        }
        if (awsDSInstanceVpcId != null) {
            throw new JSException(this.getErrorMessage("aws.exception.datasource.recovery.is.not.possible"));
        }
        return this.getIpAddress(null);
    }

    private String getIpAddress(String source) {
        if (!StringUtils.isEmpty((String)this.awsProperties.getSecurityGroupIngressPublicIp())) {
            return this.awsProperties.getSecurityGroupIngressPublicIp();
        }
        if (StringUtils.isNotEmpty((String)source)) {
            return this.awsEc2MetadataClient.getEc2InstanceMetadataItem(source);
        }
        throw new JSException(this.getErrorMessage("aws.exception.datasource.recovery.public.ip.not.provided"));
    }

    private String recoverVpcSecurityGroup(AwsReportDataSource awsReportDataSource, String vpcId, String ingressPublicIp) {
        String vpcSecurityGroupId;
        SecurityGroup vpcSecurityGroup;
        AmazonEC2Client amazonEc2Client;
        block9: {
            AWSCredentials awsCredentials = AwsCredentialUtil.getAWSCredentials(awsReportDataSource.getAWSAccessKey(), awsReportDataSource.getAWSSecretKey(), awsReportDataSource.getRoleARN());
            amazonEc2Client = new AmazonEC2Client(awsCredentials);
            vpcSecurityGroup = null;
            try {
                DescribeSecurityGroupsResult describeSecurityGroupsResult = amazonEc2Client.describeSecurityGroups();
                if (describeSecurityGroupsResult == null || describeSecurityGroupsResult.getSecurityGroups() == null || describeSecurityGroupsResult.getSecurityGroups().size() <= 0) break block9;
                for (SecurityGroup securityGroup : describeSecurityGroupsResult.getSecurityGroups()) {
                    if (securityGroup.getVpcId() == null || !securityGroup.getVpcId().equals(vpcId) || !securityGroup.getGroupName().equals(this.awsProperties.getSecurityGroupName())) continue;
                    vpcSecurityGroup = securityGroup;
                    break;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        boolean ingressIpMaskExist = false;
        if (vpcSecurityGroup != null) {
            vpcSecurityGroupId = vpcSecurityGroup.getGroupId();
            List ipPermissions = vpcSecurityGroup.getIpPermissions();
            if (ipPermissions != null && ipPermissions.size() > 0) {
                for (IpPermission ipPermission : ipPermissions) {
                    if (ipPermission.getIpRanges() == null || ipPermission.getIpRanges().size() <= 0 || !ipPermission.getIpRanges().contains(ingressPublicIp)) continue;
                    ingressIpMaskExist = true;
                }
            }
            if (!ingressIpMaskExist && ipPermissions != null && ipPermissions.size() > 0) {
                RevokeSecurityGroupIngressRequest revokeSecurityGroupIngressRequest = new RevokeSecurityGroupIngressRequest().withGroupId(vpcSecurityGroup.getGroupId()).withIpPermissions(new IpPermission[0]).withIpPermissions((Collection)vpcSecurityGroup.getIpPermissions());
                amazonEc2Client.revokeSecurityGroupIngress(revokeSecurityGroupIngressRequest);
            }
        } else {
            vpcSecurityGroupId = amazonEc2Client.createSecurityGroup(new CreateSecurityGroupRequest().withGroupName(this.awsProperties.getSecurityGroupName()).withVpcId(vpcId).withDescription(this.awsProperties.getSecurityGroupDescription())).getGroupId();
        }
        if (!ingressIpMaskExist) {
            IpPermission ipPermission = new IpPermission().withIpProtocol("tcp").withIpRanges(new String[]{ingressPublicIp}).withFromPort(Integer.valueOf(0)).withToPort(Integer.valueOf(65535));
            ArrayList<IpPermission> ipPermissions = new ArrayList<IpPermission>();
            ipPermissions.add(ipPermission);
            AuthorizeSecurityGroupIngressRequest authorizeRequest = new AuthorizeSecurityGroupIngressRequest().withIpPermissions(ipPermissions).withGroupId(vpcSecurityGroupId);
            amazonEc2Client.authorizeSecurityGroupIngress(authorizeRequest);
        }
        return vpcSecurityGroupId;
    }

    private String getErrorMessage(String errorCode) {
        return this.messageSource.getMessage(errorCode, null, LocaleContextHolder.getLocale());
    }

    private String parseRegionFromSubRegion(String region) {
        String regionPrefix = ".amazonaws.com";
        if (region != null) {
            for (String awsRegion : this.awsRegions) {
                String[] parse = awsRegion.split(regionPrefix);
                if (!region.contains(parse[0])) continue;
                return awsRegion;
            }
        }
        return null;
    }

    public void setAwsRegions(List<String> awsRegions) {
        this.awsRegions = awsRegions;
    }

    public void setAwsDataSourceActiveStatus(String awsDataSourceActiveStatus) {
        this.awsDataSourceActiveStatus = awsDataSourceActiveStatus;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messageSource = messageSource;
    }

    public void setAwsEc2MetadataClient(AwsEc2MetadataClient awsEc2MetadataClient) {
        this.awsEc2MetadataClient = awsEc2MetadataClient;
    }

    public MessageSource getMessageSource() {
        return this.messageSource;
    }

    public void setAwsProperties(AwsProperties awsProperties) {
        this.awsProperties = awsProperties;
    }
}

