/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.common.service.impl.BeanForInterfaceImplementationFactoryImpl;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.DataSourceServiceDefinition;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.DataSourceServiceFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class DataSourceServiceFactoryImpl
extends BeanForInterfaceImplementationFactoryImpl
implements DataSourceServiceFactory,
InitializingBean {
    private static final Log log = LogFactory.getLog(DataSourceServiceFactoryImpl.class);
    @Autowired
    private List<DataSourceServiceDefinition> serviceDefinitionList;
    private Map<String, DataSourceServiceDefinition> serviceDefinitionMap;
    private Set<Class<?>> universalTypes;
    private Map languageTypes;

    public void afterPropertiesSet() {
        this.serviceDefinitionMap = new LinkedHashMap<String, DataSourceServiceDefinition>();
        for (DataSourceServiceDefinition dssd : this.serviceDefinitionList) {
            this.serviceDefinitionMap.put(dssd.getDataSourceInterface(), dssd);
        }
        this.setBeanInterfaceMappings();
        this.collectLanguageTypes();
    }

    protected void setBeanInterfaceMappings() {
        HashMap<String, String> beanItfMap = new HashMap<String, String>();
        for (Map.Entry<String, DataSourceServiceDefinition> entry : this.serviceDefinitionMap.entrySet()) {
            String itf = entry.getKey();
            DataSourceServiceDefinition serviceDef = entry.getValue();
            beanItfMap.put(itf, serviceDef.getServiceBeanName());
        }
        this.setBeanForInterfaceMappings(beanItfMap);
    }

    protected void collectLanguageTypes() {
        this.languageTypes = new HashMap();
        this.universalTypes = new HashSet();
        for (Map.Entry<String, DataSourceServiceDefinition> entry : this.serviceDefinitionMap.entrySet()) {
            String itf = entry.getKey();
            DataSourceServiceDefinition serviceDef = entry.getValue();
            if (serviceDef.isAnyLanguage()) {
                this.universalTypes.add(this.resolveType(itf));
            }
            this.collectTypes(itf, serviceDef);
        }
    }

    protected void collectTypes(String itf, DataSourceServiceDefinition serviceDef) {
        Set languages = serviceDef.getSupportedQueryLanguages();
        if (languages != null) {
            for (String language : languages) {
                HashSet langTypes = (HashSet)this.languageTypes.get(language);
                if (langTypes == null) {
                    langTypes = new HashSet();
                    this.languageTypes.put(language, langTypes);
                }
                langTypes.add(this.resolveType(itf));
            }
        }
    }

    protected Class<?> resolveType(String itf) {
        try {
            return Class.forName(itf, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e, (Throwable)e);
            throw new JSExceptionWrapper((Exception)e);
        }
    }

    @Override
    public Set getSupportingDataSourceTypes(String queryLanguage) {
        HashSet types = new HashSet();
        Set langTypes = (Set)this.languageTypes.get(queryLanguage);
        if (langTypes != null) {
            types.addAll(langTypes);
        }
        types.addAll(this.universalTypes);
        return types;
    }

    public Map getServiceDefinitionMap() {
        return this.serviceDefinitionMap;
    }

    public List<DataSourceServiceDefinition> getServiceDefinitionList() {
        return this.serviceDefinitionList;
    }

    public void setServiceDefinitionList(List<DataSourceServiceDefinition> serviceDefinitionList) {
        this.serviceDefinitionList = serviceDefinitionList;
    }
}

