/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.AwsEc2MetadataClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class InstanceProductTypeResolver {
    protected boolean isEC2;
    protected AwsEc2MetadataClient awsEc2MetadataClient = new AwsEc2MetadataClient();
    protected boolean hasMarketplaceCodes = false;
    protected boolean overriding = false;
    protected String productTypeName = "";
    protected static final String OVERRIDE_PRODUCT_TYPE_NONE = "";
    public static String MARKETPLACE_PREFIX = "MP_";
    public static String NOT_EC2 = "NOT_EC2";
    public static String EC2 = "EC2";
    public static String CONFIG_FILE_NAME = "product_type.properties";
    public static String PROPERTY_NAME_OVERRIDE = "overrideProductType";
    private static InstanceProductTypeResolver instance;
    private String overrideProductType = "";
    public static String MarketplaceCeProductType;
    private static String MarketplaceCeProductCode;
    protected static Map<String, String> mpProductCodes;

    public static synchronized InstanceProductTypeResolver getInstance() {
        if (instance == null) {
            instance = new InstanceProductTypeResolver();
        }
        return instance;
    }

    protected InstanceProductTypeResolver() {
        this.init();
    }

    protected void init() {
        if (!this.readAndSetOverride()) {
            this.isEC2 = this.awsEc2MetadataClient.isEc2Instance();
            if (this.isEC2) {
                this.productTypeName = EC2;
                for (String product : mpProductCodes.keySet()) {
                    if (!this.awsEc2MetadataClient.hasAwsProductCode(mpProductCodes.get(product)).booleanValue()) continue;
                    this.hasMarketplaceCodes = true;
                    this.productTypeName = product;
                    break;
                }
            }
        }
    }

    public boolean isEC2() {
        return this.isEC2;
    }

    public boolean isJrsAmi() {
        return this.isMpAmi();
    }

    public boolean isMpAmi() {
        return this.hasMarketplaceCodes;
    }

    public String getProductTypeName() {
        return this.productTypeName;
    }

    public String getProductPrefix() {
        return MARKETPLACE_PREFIX;
    }

    public boolean isOverriding() {
        return this.overriding;
    }

    public String getAwsProductNameForHeartBeat() {
        if (this.isEC2) {
            if (this.isMpAmi()) {
                return this.getProductPrefix() + this.getProductTypeName();
            }
            return EC2;
        }
        return NOT_EC2;
    }

    protected void setOverrideProductType(String overrideProductType) {
        this.overrideProductType = overrideProductType;
        this.overriding = true;
        if (!overrideProductType.equals(OVERRIDE_PRODUCT_TYPE_NONE)) {
            this.hasMarketplaceCodes = mpProductCodes.containsKey(overrideProductType);
            this.isEC2 = this.hasMarketplaceCodes ? true : overrideProductType.equals(EC2);
            this.productTypeName = overrideProductType;
        }
    }

    protected boolean readAndSetOverride() {
        Properties prop = new Properties();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream stream = loader.getResourceAsStream(CONFIG_FILE_NAME);
        if (stream == null) {
            return false;
        }
        try {
            prop.load(stream);
            String overrideProperty = prop.getProperty(PROPERTY_NAME_OVERRIDE);
            if (overrideProperty == null) {
                return false;
            }
            this.setOverrideProductType(overrideProperty);
        }
        catch (IOException ignored) {
            return false;
        }
        return true;
    }

    static {
        MarketplaceCeProductType = "CE";
        MarketplaceCeProductCode = "9xda1pooiqrx1xrl6127ygztq";
        mpProductCodes = new HashMap<String, String>(){
            {
                this.put(MarketplaceCeProductType, MarketplaceCeProductCode);
            }
        };
    }
}

