/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.DataConverterFactory;
import java.util.Date;
import java.util.TimeZone;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.quartz.DateBuilder;

public class JRTimezoneResultSetDataSource
implements JRDataSource {
    private TimeZone timezone;
    private JRDataSource dataSource;

    public JRTimezoneResultSetDataSource(JRDataSource dataSource, TimeZone timezone) {
        this.dataSource = dataSource;
        this.timezone = timezone;
    }

    public boolean next() throws JRException {
        boolean hasNext = false;
        if (this.dataSource != null) {
            try {
                hasNext = this.dataSource.next();
            }
            catch (JRException e) {
                throw new JRException("Unable to get next record.", (Throwable)e);
            }
        }
        return hasNext;
    }

    public Object getFieldValue(JRField field) throws JRException {
        Object value = null;
        if (field != null && this.dataSource != null) {
            block8: {
                try {
                    value = this.dataSource.getFieldValue(field);
                }
                catch (JRException ex) {
                    if (ex.getMessage().indexOf("Unable to get value for field") <= 0 || ex.getMessage().indexOf("of class") <= 0 || !(field instanceof JRDesignField)) break block8;
                    try {
                        String originalType = field.getValueClassName();
                        String newType = DataConverterFactory.getPumpUpType(originalType);
                        if (newType == null) {
                            throw ex;
                        }
                        ((JRDesignField)field).setValueClassName(newType);
                        value = this.dataSource.getFieldValue(field);
                        ((JRDesignField)field).setValueClassName(originalType);
                        DataConverterFactory.DataConverter dataConverter = DataConverterFactory.createConverter(originalType);
                        if (dataConverter == null) {
                            throw ex;
                        }
                        value = dataConverter.convert(value);
                    }
                    catch (Exception ex2) {
                        throw ex;
                    }
                }
            }
            if (value instanceof Date && this.timezone != null) {
                Date initialDate = (Date)value;
                Date date = DateBuilder.translateTime((Date)initialDate, (TimeZone)TimeZone.getDefault(), (TimeZone)this.timezone);
                initialDate.setTime(date.getTime());
                return initialDate;
            }
            return value;
        }
        return value;
    }
}

