/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.engine.jasperreports.util.repo;

import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryContext;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.RepositoryUtil;
import com.jaspersoft.jasperserver.api.engine.jasperreports.util.repo.RepositoryConnection;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public class Handler
extends URLStreamHandler {
    public static final String REPOSITORY_PROTOCOL = "repo";
    public static final String URL_PROTOCOL_PREFIX = "repo:";
    private final RepositoryContext repositoryContext;

    public Handler() {
        this.repositoryContext = null;
    }

    public Handler(RepositoryContext repositoryContext) {
        this.repositoryContext = repositoryContext;
    }

    @Override
    protected void parseURL(URL u, String spec, int start, int limit) {
        String path;
        spec = spec.trim();
        String protocol = null;
        if (spec.startsWith(URL_PROTOCOL_PREFIX)) {
            protocol = REPOSITORY_PROTOCOL;
            path = spec.substring(URL_PROTOCOL_PREFIX.length());
        } else {
            path = spec;
        }
        this.setURL(u, protocol, null, -1, null, null, path, null, null);
    }

    @Override
    protected URLConnection openConnection(URL url) throws IOException {
        RepositoryContext context = this.repositoryContext;
        if (context == null) {
            context = RepositoryUtil.getThreadRepositoryContext();
        }
        return new RepositoryConnection(context, url);
    }
}

