/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InterruptedIOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.Version;
import org.jgroups.View;
import org.jgroups.annotations.Experimental;
import org.jgroups.annotations.LocalAddress;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.LazyRemovalCache;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.logging.Log;
import org.jgroups.logging.LogFactory;
import org.jgroups.protocols.TpHeader;
import org.jgroups.stack.DiagnosticsHandler;
import org.jgroups.stack.Protocol;
import org.jgroups.util.AgeOutCache;
import org.jgroups.util.Buffer;
import org.jgroups.util.DefaultSocketFactory;
import org.jgroups.util.DefaultThreadFactory;
import org.jgroups.util.DefaultTimeScheduler;
import org.jgroups.util.DirectExecutor;
import org.jgroups.util.ExposedByteArrayOutputStream;
import org.jgroups.util.ExposedDataOutputStream;
import org.jgroups.util.HashedTimingWheel;
import org.jgroups.util.LazyThreadFactory;
import org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.jgroups.util.SingletonAddress;
import org.jgroups.util.SocketFactory;
import org.jgroups.util.ThreadFactory;
import org.jgroups.util.ThreadManagerThreadPoolExecutor;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.TimeScheduler2;
import org.jgroups.util.Tuple;
import org.jgroups.util.UUID;
import org.jgroups.util.Util;

@MBean(description="Transport protocol")
public abstract class TP
extends Protocol {
    protected static final byte LIST = 1;
    protected static final byte MULTICAST = 2;
    protected static final byte OOB = 4;
    protected static final boolean can_bind_to_mcast_addr = Util.checkForLinux() || Util.checkForSolaris() || Util.checkForHp();
    protected static NumberFormat f = NumberFormat.getNumberInstance();
    @LocalAddress
    @Property(name="bind_addr", description="The bind address which should be used by this transport. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL and NON_LOOPBACK", defaultValueIPv4="NON_LOOPBACK_ADDRESS", defaultValueIPv6="NON_LOOPBACK_ADDRESS", systemProperty={"jgroups.bind_addr"}, writable=false)
    protected InetAddress bind_addr = null;
    @Property(description="Use \"external_addr\" if you have hosts on different networks, behind firewalls. On each firewall, set up a port forwarding rule (sometimes called \"virtual server\") to the local IP (e.g. 192.168.1.100) of the host then on each host, set \"external_addr\" TCP transport parameter to the external (public IP) address of the firewall.", systemProperty={"jgroups.external_addr"}, writable=false)
    protected InetAddress external_addr = null;
    @Property(name="bind_interface", converter=PropertyConverters.BindInterface.class, description="The interface (NIC) which should be used by this transport", dependsUpon="bind_addr", exposeAsManagedAttribute=false)
    protected String bind_interface_str = null;
    @Property(description="If true, the transport should use all available interfaces to receive multicast messages")
    protected boolean receive_on_all_interfaces = false;
    @Property(converter=PropertyConverters.NetworkInterfaceList.class, description="Comma delimited list of interfaces (IP addresses or interface names) to receive multicasts on")
    protected List<NetworkInterface> receive_interfaces = null;
    @Property(description="Max number of elements in the logical address cache before eviction starts")
    protected int logical_addr_cache_max_size = 500;
    @Property(description="Time (in ms) after which entries in the logical address cache marked as removable are removed")
    protected long logical_addr_cache_expiration = 120000L;
    @Property(description="The port to which the transport binds. Default of 0 binds to any (ephemeral) port", writable=false)
    protected int bind_port = 0;
    @Property(description="The range of valid ports, from bind_port to end_port. 0 only binds to bind_port and fails if taken")
    protected int port_range = 50;
    @Property(description="Messages to self are looped back immediately if true")
    protected boolean loopback = true;
    @Property(description="Discard packets with a different version if true. Default is false")
    protected boolean discard_incompatible_packets = false;
    @Property(description="Thread naming pattern for threads in this channel. Default is cl")
    protected String thread_naming_pattern = "cl";
    @Property(name="oob_thread_pool.enabled", description="Switch for enabling thread pool for OOB messages. Default=true", writable=false)
    protected boolean oob_thread_pool_enabled = true;
    protected int oob_thread_pool_min_threads = 2;
    protected int oob_thread_pool_max_threads = 10;
    protected long oob_thread_pool_keep_alive_time = 30000L;
    @Property(name="oob_thread_pool.queue_enabled", description="Use queue to enqueue incoming OOB messages")
    protected boolean oob_thread_pool_queue_enabled = true;
    @Property(name="oob_thread_pool.queue_max_size", description="Maximum queue size for incoming OOB messages. Default is 500")
    protected int oob_thread_pool_queue_max_size = 500;
    @Property(name="oob_thread_pool.rejection_policy", description="Thread rejection policy. Possible values are Abort, Discard, DiscardOldest and Run. Default is Discard")
    String oob_thread_pool_rejection_policy = "discard";
    protected int thread_pool_min_threads = 2;
    protected int thread_pool_max_threads = 10;
    protected long thread_pool_keep_alive_time = 30000L;
    @Property(name="thread_pool.enabled", description="Switch for enabling thread pool for regular messages. Default true")
    protected boolean thread_pool_enabled = true;
    @Property(name="thread_pool.queue_enabled", description="Use queue to enqueue incoming regular messages. Default is true")
    protected boolean thread_pool_queue_enabled = true;
    @Property(name="thread_pool.queue_max_size", description="Maximum queue size for incoming OOB messages. Default is 500")
    protected int thread_pool_queue_max_size = 500;
    @Property(name="thread_pool.rejection_policy", description="Thread rejection policy. Possible values are Abort, Discard, DiscardOldest and Run")
    protected String thread_pool_rejection_policy = "Discard";
    @Property(description="Type of timer to be used. Valid values are \"old\" (DefaultTimeScheduler, used up to 2.10), \"new\" (TimeScheduler2) and \"wheel\". Note that this property might disappear in future releases, if one of the 3 timers is chosen as default timer")
    protected String timer_type = "new";
    protected int timer_min_threads = 4;
    protected int timer_max_threads = 10;
    protected long timer_keep_alive_time = 5000L;
    @Property(name="timer.queue_max_size", description="Max number of elements on a timer queue")
    protected int timer_queue_max_size = 500;
    @Property(name="timer.rejection_policy", description="Timer rejection policy. Possible values are Abort, Discard, DiscardOldest and Run")
    protected String timer_rejection_policy = "run";
    @Property(name="timer.wheel_size", description="Number of ticks in the HashedTimingWheel timer. Only applicable if timer_type is \"wheel\"")
    protected int wheel_size = 200;
    @Property(name="timer.tick_time", description="Tick duration in the HashedTimingWheel timer. Only applicable if timer_type is \"wheel\"")
    protected long tick_time = 50L;
    @Property(description="Enable bundling of smaller messages into bigger ones. Default is true")
    protected boolean enable_bundling = true;
    @Property(description="Enable bundling of smaller messages into bigger ones for unicast messages. Default is false")
    protected boolean enable_unicast_bundling = false;
    @Property(description="Switch to enable diagnostic probing. Default is true")
    protected boolean enable_diagnostics = true;
    @Property(description="Address for diagnostic probing. Default is 224.0.75.75", defaultValueIPv4="224.0.75.75", defaultValueIPv6="ff0e::0:75:75")
    protected InetAddress diagnostics_addr = null;
    @Property(description="Port for diagnostic probing. Default is 7500")
    protected int diagnostics_port = 7500;
    @Property(description="If assigned enable this transport to be a singleton (shared) transport")
    protected String singleton_name = null;
    @Property(description="whether or not warnings about messages from different groups are logged")
    protected boolean log_discard_msgs = true;
    protected int max_bundle_size = 64000;
    protected long max_bundle_timeout = 20L;
    @Property(description="The type of bundler used. Has to be \"old\" (default) or \"new\"")
    protected String bundler_type = "new";
    @Experimental
    @Property(description="The max number of elements in a bundler if the bundler supports size limitations")
    protected int bundler_capacity = 200000;
    @ManagedAttribute(description="Number of messages sent")
    protected long num_msgs_sent = 0L;
    @ManagedAttribute(description="Number of messages received")
    protected long num_msgs_received = 0L;
    @ManagedAttribute(description="Number of bytes sent")
    protected long num_bytes_sent = 0L;
    @ManagedAttribute(description="Number of bytes received")
    protected long num_bytes_received = 0L;
    @ManagedAttribute(description="Channel (cluster) name")
    protected String channel_name = null;
    @ManagedAttribute(description="Number of OOB messages received")
    protected long num_oob_msgs_received = 0L;
    @ManagedAttribute(description="Number of regular messages received")
    protected long num_incoming_msgs_received = 0L;
    protected Address local_addr = null;
    protected final Set<Address> members = new CopyOnWriteArraySet<Address>();
    protected ThreadGroup pool_thread_group = new ThreadGroup(Util.getGlobalThreadGroup(), "Thread Pools");
    protected int connect_count = 0;
    protected final ReentrantLock connectLock = new ReentrantLock();
    protected Executor oob_thread_pool;
    protected ThreadFactory oob_thread_factory = null;
    protected BlockingQueue<Runnable> oob_thread_pool_queue = null;
    protected Executor thread_pool;
    protected ThreadFactory default_thread_factory = null;
    protected BlockingQueue<Runnable> thread_pool_queue = null;
    protected TimeScheduler timer = null;
    protected ThreadFactory timer_thread_factory;
    protected ThreadFactory global_thread_factory = null;
    protected SocketFactory socket_factory = new DefaultSocketFactory();
    protected Bundler bundler = null;
    protected DiagnosticsHandler diag_handler = null;
    protected final List<DiagnosticsHandler.ProbeHandler> preregistered_probe_handlers = new LinkedList<DiagnosticsHandler.ProbeHandler>();
    protected final ConcurrentMap<String, Protocol> up_prots = Util.createConcurrentMap(16, 0.75f, 16);
    protected TpHeader header;
    protected LazyRemovalCache<Address, PhysicalAddress> logical_addr_cache;
    protected long last_discovery_request = 0L;
    Future<?> logical_addr_cache_reaper = null;
    protected static final LazyRemovalCache.Printable<Address, PhysicalAddress> print_function;
    protected AgeOutCache<Address> who_has_cache;

    @Property(name="max_bundle_size", description="Maximum number of bytes for messages to be queued until they are sent")
    public void setMaxBundleSize(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("max_bundle_size (" + size + ") is <= 0");
        }
        this.max_bundle_size = size;
    }

    public long getMaxBundleTimeout() {
        return this.max_bundle_timeout;
    }

    @Property(name="max_bundle_timeout", description="Max number of milliseconds until queued messages are sent")
    public void setMaxBundleTimeout(long timeout) {
        if (timeout <= 0L) {
            throw new IllegalArgumentException("max_bundle_timeout of " + timeout + " is invalid");
        }
        this.max_bundle_timeout = timeout;
    }

    public int getMaxBundleSize() {
        return this.max_bundle_size;
    }

    @ManagedAttribute
    public int getBundlerBufferSize() {
        if (this.bundler instanceof TransferQueueBundler) {
            return ((TransferQueueBundler)this.bundler).getBufferSize();
        }
        return 0;
    }

    @Property(name="oob_thread_pool.keep_alive_time", description="Timeout in ms to remove idle threads from the OOB pool")
    public void setOOBThreadPoolKeepAliveTime(long time) {
        this.oob_thread_pool_keep_alive_time = time;
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setKeepAliveTime(time, TimeUnit.MILLISECONDS);
        }
    }

    public long getOOBThreadPoolKeepAliveTime() {
        return this.oob_thread_pool_keep_alive_time;
    }

    @Property(name="oob_thread_pool.min_threads", description="Minimum thread pool size for the OOB thread pool")
    public void setOOBThreadPoolMinThreads(int size) {
        this.oob_thread_pool_min_threads = size;
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setCorePoolSize(size);
        }
    }

    public int getOOBThreadPoolMinThreads() {
        return this.oob_thread_pool_min_threads;
    }

    @Property(name="oob_thread_pool.max_threads", description="Max thread pool size for the OOB thread pool")
    public void setOOBThreadPoolMaxThreads(int size) {
        this.oob_thread_pool_max_threads = size;
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setMaximumPoolSize(size);
        }
    }

    public int getOOBThreadPoolMaxThreads() {
        return this.oob_thread_pool_max_threads;
    }

    @Property(name="thread_pool.min_threads", description="Minimum thread pool size for the regular thread pool")
    public void setThreadPoolMinThreads(int size) {
        this.thread_pool_min_threads = size;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setCorePoolSize(size);
        }
    }

    public int getThreadPoolMinThreads() {
        return this.thread_pool_min_threads;
    }

    @Property(name="thread_pool.max_threads", description="Maximum thread pool size for the regular thread pool")
    public void setThreadPoolMaxThreads(int size) {
        this.thread_pool_max_threads = size;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setMaximumPoolSize(size);
        }
    }

    public int getThreadPoolMaxThreads() {
        return this.thread_pool_max_threads;
    }

    @Property(name="thread_pool.keep_alive_time", description="Timeout in milliseconds to remove idle thread from regular pool")
    public void setThreadPoolKeepAliveTime(long time) {
        this.thread_pool_keep_alive_time = time;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setKeepAliveTime(time, TimeUnit.MILLISECONDS);
        }
    }

    public long getThreadPoolKeepAliveTime() {
        return this.thread_pool_keep_alive_time;
    }

    @Property(name="timer.min_threads", description="Minimum thread pool size for the timer thread pool")
    public void setTimerMinThreads(int size) {
        this.timer_min_threads = size;
        if (this.timer != null) {
            this.timer.setMinThreads(size);
        }
    }

    public int getTimerMinThreads() {
        return this.timer_min_threads;
    }

    @Property(name="timer.max_threads", description="Max thread pool size for the timer thread pool")
    public void setTimerMaxThreads(int size) {
        this.timer_max_threads = size;
        if (this.timer != null) {
            this.timer.setMaxThreads(size);
        }
    }

    public int getTimerMaxThreads() {
        return this.timer_max_threads;
    }

    @Property(name="timer.keep_alive_time", description="Timeout in ms to remove idle threads from the timer pool")
    public void setTimerKeepAliveTime(long time) {
        this.timer_keep_alive_time = time;
        if (this.timer != null) {
            this.timer.setKeepAliveTime(time);
        }
    }

    public long getTimerKeepAliveTime() {
        return this.timer_keep_alive_time;
    }

    @ManagedAttribute
    public int getTimerQueueSize() {
        if (this.timer instanceof TimeScheduler2) {
            return ((TimeScheduler2)this.timer).getQueueSize();
        }
        return 0;
    }

    @ManagedAttribute(description="Class of the timer implementation")
    public String getTimerClass() {
        return this.timer != null ? this.timer.getClass().getSimpleName() : "null";
    }

    protected TP() {
    }

    public abstract boolean supportsMulticasting();

    public boolean isMulticastCapable() {
        return this.supportsMulticasting();
    }

    public String toString() {
        if (!this.isSingleton()) {
            return this.local_addr != null ? this.name + "(local address: " + this.local_addr + ')' : this.name;
        }
        return this.name + " (singleton=" + this.singleton_name + ")";
    }

    @Override
    public void resetStats() {
        this.num_bytes_received = 0L;
        this.num_bytes_sent = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
        this.num_incoming_msgs_received = 0L;
        this.num_oob_msgs_received = 0L;
    }

    public void registerProbeHandler(DiagnosticsHandler.ProbeHandler handler) {
        if (this.diag_handler != null) {
            this.diag_handler.registerProbeHandler(handler);
        } else {
            this.preregistered_probe_handlers.add(handler);
        }
    }

    public void unregisterProbeHandler(DiagnosticsHandler.ProbeHandler handler) {
        if (this.diag_handler != null) {
            this.diag_handler.unregisterProbeHandler(handler);
        }
    }

    public void setDiagnosticsHandler(DiagnosticsHandler handler) {
        if (this.diag_handler != null) {
            this.diag_handler.stop();
        }
        this.diag_handler = handler;
    }

    public ThreadGroup getPoolThreadGroup() {
        return this.pool_thread_group;
    }

    public void setThreadPoolQueueEnabled(boolean flag) {
        this.thread_pool_queue_enabled = flag;
    }

    public Executor getDefaultThreadPool() {
        return this.thread_pool;
    }

    public void setDefaultThreadPool(Executor thread_pool) {
        if (this.thread_pool != null) {
            TP.shutdownThreadPool(this.thread_pool);
        }
        this.thread_pool = thread_pool;
    }

    public ThreadFactory getDefaultThreadPoolThreadFactory() {
        return this.default_thread_factory;
    }

    public void setDefaultThreadPoolThreadFactory(ThreadFactory factory) {
        this.default_thread_factory = factory;
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setThreadFactory(factory);
        }
    }

    public Executor getOOBThreadPool() {
        return this.oob_thread_pool;
    }

    public void setOOBThreadPool(Executor oob_thread_pool) {
        if (this.oob_thread_pool != null) {
            TP.shutdownThreadPool(this.oob_thread_pool);
        }
        this.oob_thread_pool = oob_thread_pool;
    }

    public ThreadFactory getOOBThreadPoolThreadFactory() {
        return this.oob_thread_factory;
    }

    public void setOOBThreadPoolThreadFactory(ThreadFactory factory) {
        this.oob_thread_factory = factory;
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setThreadFactory(factory);
        }
    }

    public ThreadFactory getTimerThreadFactory() {
        return this.timer_thread_factory;
    }

    public void setTimerThreadFactory(ThreadFactory factory) {
        this.timer_thread_factory = factory;
        this.timer.setThreadFactory(factory);
    }

    public TimeScheduler getTimer() {
        return this.timer;
    }

    public void setTimer(TimeScheduler timer) {
        this.timer = timer;
    }

    @Override
    public ThreadFactory getThreadFactory() {
        return this.global_thread_factory;
    }

    public void setThreadFactory(ThreadFactory factory) {
        this.global_thread_factory = factory;
    }

    @Override
    public SocketFactory getSocketFactory() {
        return this.socket_factory;
    }

    @Override
    public void setSocketFactory(SocketFactory factory) {
        if (factory != null) {
            this.socket_factory = factory;
        }
    }

    public String getThreadNamingPattern() {
        return this.thread_naming_pattern;
    }

    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    public long getNumBytesSent() {
        return this.num_bytes_sent;
    }

    public long getNumBytesReceived() {
        return this.num_bytes_received;
    }

    public InetAddress getBindAddress() {
        return this.bind_addr;
    }

    public void setBindAddress(InetAddress bind_addr) {
        this.bind_addr = bind_addr;
    }

    public int getBindPort() {
        return this.bind_port;
    }

    public void setBindPort(int port) {
        this.bind_port = port;
    }

    public void setBindToAllInterfaces(boolean flag) {
        this.receive_on_all_interfaces = flag;
    }

    public boolean isReceiveOnAllInterfaces() {
        return this.receive_on_all_interfaces;
    }

    public List<NetworkInterface> getReceiveInterfaces() {
        return this.receive_interfaces;
    }

    public boolean isDiscardIncompatiblePackets() {
        return this.discard_incompatible_packets;
    }

    public void setDiscardIncompatiblePackets(boolean flag) {
        this.discard_incompatible_packets = flag;
    }

    public boolean isEnableBundling() {
        return this.enable_bundling;
    }

    public void setEnableBundling(boolean flag) {
        this.enable_bundling = flag;
    }

    public boolean isEnableUnicastBundling() {
        return this.enable_unicast_bundling;
    }

    public void setEnableUnicastBundling(boolean enable_unicast_bundling) {
        this.enable_unicast_bundling = enable_unicast_bundling;
    }

    public void setPortRange(int range) {
        this.port_range = range;
    }

    public int getPortRange() {
        return this.port_range;
    }

    public boolean isOOBThreadPoolEnabled() {
        return this.oob_thread_pool_enabled;
    }

    public boolean isDefaulThreadPoolEnabled() {
        return this.thread_pool_enabled;
    }

    public boolean isLoopback() {
        return this.loopback;
    }

    public void setLoopback(boolean b) {
        this.loopback = b;
    }

    public ConcurrentMap<String, Protocol> getUpProtocols() {
        return this.up_prots;
    }

    @ManagedAttribute(description="Current number of threads in the OOB thread pool")
    public int getOOBPoolSize() {
        return this.oob_thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.oob_thread_pool).getPoolSize() : 0;
    }

    public long getOOBMessages() {
        return this.num_oob_msgs_received;
    }

    @ManagedAttribute(description="Number of messages in the OOB thread pool's queue")
    public int getOOBQueueSize() {
        return this.oob_thread_pool_queue != null ? this.oob_thread_pool_queue.size() : 0;
    }

    public int getOOBMaxQueueSize() {
        return this.oob_thread_pool_queue_max_size;
    }

    public void setOOBRejectionPolicy(String rejection_policy) {
        RejectedExecutionHandler handler = Util.parseRejectionPolicy(rejection_policy);
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.oob_thread_pool).setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(handler));
        }
    }

    @ManagedAttribute(description="Current number of threads in the default thread pool")
    public int getRegularPoolSize() {
        return this.thread_pool instanceof ThreadPoolExecutor ? ((ThreadPoolExecutor)this.thread_pool).getPoolSize() : 0;
    }

    public long getRegularMessages() {
        return this.num_incoming_msgs_received;
    }

    @ManagedAttribute(description="Number of messages in the default thread pool's queue")
    public int getRegularQueueSize() {
        return this.thread_pool_queue != null ? this.thread_pool_queue.size() : 0;
    }

    public int getRegularMaxQueueSize() {
        return this.thread_pool_queue_max_size;
    }

    @ManagedAttribute(name="TimerTasks", description="Number of timer tasks queued up for execution")
    public int getNumTimerTasks() {
        return this.timer != null ? this.timer.size() : -1;
    }

    @ManagedOperation
    public String dumpTimerTasks() {
        return this.timer.dumpTimerTasks();
    }

    @ManagedAttribute(description="Number of threads currently in the pool")
    public int getTimerThreads() {
        return this.timer.getCurrentThreads();
    }

    @ManagedAttribute(description="Returns the number of live threads in the JVM")
    public static int getNumThreads() {
        return ManagementFactory.getThreadMXBean().getThreadCount();
    }

    public void setRegularRejectionPolicy(String rejection_policy) {
        RejectedExecutionHandler handler = Util.parseRejectionPolicy(rejection_policy);
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            ((ThreadPoolExecutor)this.thread_pool).setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(handler));
        }
    }

    public void setLogDiscardMessages(boolean flag) {
        this.log_discard_msgs = flag;
    }

    public boolean getLogDiscardMessages() {
        return this.log_discard_msgs;
    }

    @ManagedOperation(description="Dumps the contents of the logical address cache")
    public String printLogicalAddressCache() {
        return this.logical_addr_cache.printCache(print_function);
    }

    @ManagedOperation(description="Evicts elements in the logical address cache which have expired")
    public void evictLogicalAddressCache() {
        this.logical_addr_cache.removeMarkedElements();
        this.fetchLocalAddresses();
    }

    public abstract void sendMulticast(byte[] var1, int var2, int var3) throws Exception;

    public abstract void sendUnicast(PhysicalAddress var1, byte[] var2, int var3, int var4) throws Exception;

    public abstract String getInfo();

    @Override
    public void init() throws Exception {
        super.init();
        if (this.global_thread_factory == null) {
            this.global_thread_factory = new DefaultThreadFactory(Util.getGlobalThreadGroup(), "", false);
        }
        if (this.timer_thread_factory == null) {
            this.timer_thread_factory = new LazyThreadFactory(Util.getGlobalThreadGroup(), "Timer", true, true);
        }
        if (this.isSingleton()) {
            this.timer_thread_factory.setIncludeClusterName(false);
        }
        if (this.default_thread_factory == null) {
            this.default_thread_factory = new DefaultThreadFactory(this.pool_thread_group, "Incoming", false, true);
        }
        if (this.oob_thread_factory == null) {
            this.oob_thread_factory = new DefaultThreadFactory(this.pool_thread_group, "OOB", false, true);
        }
        this.setInAllThreadFactories(this.channel_name, this.local_addr, this.thread_naming_pattern);
        if (this.timer == null) {
            if (this.timer_type.equalsIgnoreCase("old")) {
                if (this.timer_min_threads < 2) {
                    this.log.warn("timer.min_threads should not be less than 2 for timer_type=\"old\"; setting value to 2 (from " + this.timer_min_threads + ")");
                    this.timer_min_threads = 2;
                }
                this.timer = new DefaultTimeScheduler(this.timer_thread_factory, this.timer_min_threads);
            } else if (this.timer_type.equalsIgnoreCase("new")) {
                this.timer = new TimeScheduler2(this.timer_thread_factory, this.timer_min_threads, this.timer_max_threads, this.timer_keep_alive_time, this.timer_queue_max_size, this.timer_rejection_policy);
            } else if (this.timer_type.equalsIgnoreCase("wheel")) {
                this.timer = new HashedTimingWheel(this.timer_thread_factory, this.timer_min_threads, this.timer_max_threads, this.timer_keep_alive_time, this.timer_queue_max_size, this.wheel_size, this.tick_time);
            } else {
                throw new Exception("timer_type has to be either \"old\", \"new\" or \"wheel\"");
            }
        }
        this.who_has_cache = new AgeOutCache(this.timer, 2000L);
        Util.verifyRejectionPolicy(this.oob_thread_pool_rejection_policy);
        Util.verifyRejectionPolicy(this.thread_pool_rejection_policy);
        if (this.oob_thread_pool == null) {
            if (this.oob_thread_pool_enabled) {
                this.oob_thread_pool_queue = this.oob_thread_pool_queue_enabled ? new LinkedBlockingQueue<Runnable>(this.oob_thread_pool_queue_max_size) : new SynchronousQueue<Runnable>();
                this.oob_thread_pool = TP.createThreadPool(this.oob_thread_pool_min_threads, this.oob_thread_pool_max_threads, this.oob_thread_pool_keep_alive_time, this.oob_thread_pool_rejection_policy, this.oob_thread_pool_queue, this.oob_thread_factory);
            } else {
                this.oob_thread_pool = new DirectExecutor();
            }
        }
        if (this.thread_pool == null) {
            if (this.thread_pool_enabled) {
                this.thread_pool_queue = this.thread_pool_queue_enabled ? new LinkedBlockingQueue<Runnable>(this.thread_pool_queue_max_size) : new SynchronousQueue<Runnable>();
                this.thread_pool = TP.createThreadPool(this.thread_pool_min_threads, this.thread_pool_max_threads, this.thread_pool_keep_alive_time, this.thread_pool_rejection_policy, this.thread_pool_queue, this.default_thread_factory);
            } else {
                this.thread_pool = new DirectExecutor();
            }
        }
        HashMap<String, InetAddress> m = new HashMap<String, InetAddress>(2);
        if (this.bind_addr != null) {
            m.put("bind_addr", this.bind_addr);
        }
        if (this.external_addr != null) {
            m.put("external_addr", this.external_addr);
        }
        if (!m.isEmpty()) {
            this.up(new Event(56, m));
        }
        this.logical_addr_cache = new LazyRemovalCache(this.logical_addr_cache_max_size, this.logical_addr_cache_expiration);
        if (this.logical_addr_cache_reaper == null || this.logical_addr_cache_reaper.isDone()) {
            if (this.logical_addr_cache_expiration <= 0L) {
                throw new IllegalArgumentException("logical_addr_cache_expiration has to be > 0");
            }
            this.logical_addr_cache_reaper = this.timer.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    TP.this.logical_addr_cache.removeMarkedElements();
                    TP.this.fetchLocalAddresses();
                }

                public String toString() {
                    return "TP.LogicalAddressCacheReaper (interval=" + TP.this.logical_addr_cache_expiration + " ms)";
                }
            }, this.logical_addr_cache_expiration, this.logical_addr_cache_expiration, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.logical_addr_cache_reaper != null) {
            this.logical_addr_cache_reaper.cancel(false);
            this.logical_addr_cache_reaper = null;
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        if (this.oob_thread_pool instanceof ThreadPoolExecutor) {
            TP.shutdownThreadPool(this.oob_thread_pool);
        }
        if (this.thread_pool instanceof ThreadPoolExecutor) {
            TP.shutdownThreadPool(this.thread_pool);
        }
    }

    @Override
    public void start() throws Exception {
        this.fetchLocalAddresses();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (this.enable_diagnostics) {
            boolean diag_handler_created;
            boolean bl = diag_handler_created = this.diag_handler == null;
            if (this.diag_handler == null) {
                this.diag_handler = new DiagnosticsHandler(this.diagnostics_addr, this.diagnostics_port, this.log, this.getSocketFactory(), this.getThreadFactory());
            }
            this.diag_handler.registerProbeHandler(new DiagnosticsHandler.ProbeHandler(){

                @Override
                public Map<String, String> handleProbe(String ... keys) {
                    HashMap<String, String> retval = new HashMap<String, String>(2);
                    for (String key : keys) {
                        if (key.equals("dump")) {
                            retval.put("dump", Util.dumpThreads());
                            continue;
                        }
                        if (key.equals("uuids")) {
                            retval.put("uuids", TP.this.printLogicalAddressCache());
                            if (TP.this.isSingleton() || retval.containsKey("local_addr")) continue;
                            retval.put("local_addr", TP.this.local_addr != null ? TP.this.local_addr.toString() : null);
                            continue;
                        }
                        if (key.equals("keys")) {
                            StringBuilder sb = new StringBuilder();
                            for (DiagnosticsHandler.ProbeHandler handler : TP.this.diag_handler.getProbeHandlers()) {
                                String[] tmp = handler.supportedKeys();
                                if (tmp == null || tmp.length <= 0) continue;
                                for (String s : tmp) {
                                    sb.append(s).append(" ");
                                }
                            }
                            retval.put("keys", sb.toString());
                        }
                        if (!key.equals("info") || TP.this.singleton_name == null || TP.this.singleton_name.length() <= 0) continue;
                        retval.put("singleton_name", TP.this.singleton_name);
                    }
                    return retval;
                }

                @Override
                public String[] supportedKeys() {
                    return new String[]{"dump", "keys", "uuids", "info"};
                }
            });
            if (diag_handler_created) {
                this.diag_handler.start();
            }
            for (DiagnosticsHandler.ProbeHandler handler : this.preregistered_probe_handlers) {
                this.diag_handler.registerProbeHandler(handler);
            }
            this.preregistered_probe_handlers.clear();
        }
        if (this.enable_bundling) {
            if (this.bundler_type.equals("new")) {
                this.bundler = new TransferQueueBundler(this.bundler_capacity);
            } else if (this.bundler_type.equals("old")) {
                this.bundler = new DefaultBundler();
            } else {
                this.log.warn("bundler_type \"" + this.bundler_type + "\" not known; using default bundler");
            }
            if (this.bundler == null) {
                this.bundler = new DefaultBundler();
            }
            this.bundler.start();
        }
        this.setInAllThreadFactories(this.channel_name, this.local_addr, this.thread_naming_pattern);
    }

    @Override
    public void stop() {
        if (this.diag_handler != null) {
            this.diag_handler.stop();
            this.diag_handler = null;
        }
        this.preregistered_probe_handlers.clear();
        if (this.bundler != null) {
            this.bundler.stop();
        }
    }

    protected void handleConnect() throws Exception {
        ++this.connect_count;
    }

    protected void handleDisconnect() {
        this.connect_count = Math.max(0, this.connect_count - 1);
    }

    public String getSingletonName() {
        return this.singleton_name;
    }

    public boolean isSingleton() {
        return this.singleton_name != null;
    }

    @Override
    public Object up(Event evt) {
        if (this.isSingleton()) {
            this.passToAllUpProtocols(evt);
            return null;
        }
        return this.up_prot.up(evt);
    }

    @Override
    public Object down(Event evt) {
        block12: {
            boolean multicast;
            Address dest;
            if (evt.getType() != 1) {
                return this.handleDownEvent(evt);
            }
            Message msg = (Message)evt.getArg();
            if (this.header != null) {
                msg.putHeaderIfAbsent(this.id, this.header);
            }
            if (!this.isSingleton()) {
                this.setSourceAddress(msg);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("sending msg to " + msg.getDest() + ", src=" + msg.getSrc() + ", headers are " + msg.printHeaders());
            }
            if ((dest = msg.getDest()) instanceof PhysicalAddress) {
                msg.setDest(null);
            }
            boolean bl = multicast = dest == null;
            if (this.loopback && (multicast || dest.equals(msg.getSrc()) && dest.equals(this.local_addr))) {
                final Message copy = msg.copy();
                if (this.log.isTraceEnabled()) {
                    this.log.trace(new StringBuilder("looping back message ").append(copy));
                }
                Executor pool = msg.isFlagSet(Message.OOB) ? this.oob_thread_pool : this.thread_pool;
                pool.execute(new Runnable(){

                    @Override
                    public void run() {
                        TP.this.passMessageUp(copy, false, multicast, false);
                    }
                });
                if (!multicast) {
                    return null;
                }
            }
            try {
                this.send(msg, dest, multicast);
            }
            catch (InterruptedIOException iex) {
            }
            catch (InterruptedException interruptedEx) {
                Thread.currentThread().interrupt();
            }
            catch (Throwable e) {
                if (!this.log.isErrorEnabled()) break block12;
                this.log.error("failed sending message to " + (dest == null ? "cluster" : dest) + " (" + msg.size() + " bytes): " + e + ", cause: " + e.getCause());
            }
        }
        return null;
    }

    protected void setSourceAddress(Message msg) {
        if (msg.getSrc() == null && this.local_addr != null) {
            msg.setSrc(this.local_addr);
        }
    }

    protected void passMessageUp(Message msg, boolean perform_cluster_name_matching, boolean multicast, boolean discard_own_mcast) {
        Protocol tmp_prot;
        TpHeader hdr = (TpHeader)msg.getHeader(this.id);
        if (hdr == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error("message does not have a transport header, msg is " + msg + ", headers are " + msg.printHeaders() + ", will be discarded");
            }
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder("received ").append(msg).append(", headers are ").append(msg.printHeaders()));
        }
        String ch_name = hdr.channel_name;
        Protocol protocol = tmp_prot = this.isSingleton() ? (Protocol)this.up_prots.get(ch_name) : this.up_prot;
        if (tmp_prot != null) {
            boolean is_protocol_adapter = tmp_prot instanceof ProtocolAdapter;
            if (!is_protocol_adapter && perform_cluster_name_matching && this.channel_name != null && !this.channel_name.equals(ch_name)) {
                if (this.log.isWarnEnabled() && this.log_discard_msgs) {
                    this.log.warn("discarded message from different cluster \"" + ch_name + "\" (our cluster is \"" + this.channel_name + "\"). Sender was " + msg.getSrc());
                }
                return;
            }
            if (this.loopback && multicast && discard_own_mcast) {
                Address local;
                Address address = local = is_protocol_adapter ? ((ProtocolAdapter)tmp_prot).getAddress() : this.local_addr;
                if (local != null && local.equals(msg.getSrc())) {
                    return;
                }
            }
            tmp_prot.up(new Event(1, msg));
        }
    }

    protected void receive(Address sender, byte[] data, int offset, int length) {
        block5: {
            if (data == null) {
                return;
            }
            try {
                byte oob_flag = data[2];
                if ((oob_flag & 4) == 4) {
                    ++this.num_oob_msgs_received;
                    this.dispatchToThreadPool(this.oob_thread_pool, sender, data, offset, length);
                } else {
                    ++this.num_incoming_msgs_received;
                    this.dispatchToThreadPool(this.thread_pool, sender, data, offset, length);
                }
            }
            catch (Throwable t) {
                if (!this.log.isErrorEnabled()) break block5;
                this.log.error("failed handling data from " + sender, t);
            }
        }
    }

    protected void dispatchToThreadPool(Executor pool, Address sender, byte[] data, int offset, int length) {
        if (pool instanceof DirectExecutor) {
            pool.execute(new IncomingPacket(sender, data, offset, length));
        } else {
            byte[] tmp = new byte[length];
            System.arraycopy(data, offset, tmp, 0, length);
            pool.execute(new IncomingPacket(sender, tmp, 0, length));
        }
    }

    protected void send(Message msg, Address dest, boolean multicast) throws Exception {
        if (this.enable_bundling && !msg.isFlagSet(Message.OOB) && !msg.isFlagSet(Message.DONT_BUNDLE) && (this.enable_unicast_bundling || multicast)) {
            this.bundler.send(msg);
            return;
        }
        ExposedByteArrayOutputStream out_stream = new ExposedByteArrayOutputStream((int)(msg.size() + 50L));
        ExposedDataOutputStream dos = new ExposedDataOutputStream(out_stream);
        TP.writeMessage(msg, dos, multicast);
        Buffer buf = new Buffer(out_stream.getRawBuffer(), 0, out_stream.size());
        this.doSend(buf, dest, multicast);
    }

    protected void doSend(Buffer buf, Address dest, boolean multicast) throws Exception {
        if (this.stats) {
            ++this.num_msgs_sent;
            this.num_bytes_sent += (long)buf.getLength();
        }
        if (multicast) {
            this.sendMulticast(buf.getBuf(), buf.getOffset(), buf.getLength());
        } else {
            this.sendToSingleMember(dest, buf.getBuf(), buf.getOffset(), buf.getLength());
        }
    }

    protected void sendToSingleMember(Address dest, byte[] buf, int offset, int length) throws Exception {
        if (dest instanceof PhysicalAddress) {
            this.sendUnicast((PhysicalAddress)dest, buf, offset, length);
            return;
        }
        PhysicalAddress physical_dest = null;
        int cnt = 1;
        long sleep_time = 20L;
        while ((physical_dest = this.getPhysicalAddressFromCache(dest)) == null && cnt++ <= 10) {
            if (!this.who_has_cache.contains(dest)) {
                this.who_has_cache.add(dest);
                Util.sleepRandom(1L, 500L);
                physical_dest = this.getPhysicalAddressFromCache(dest);
                if (physical_dest != null) break;
                this.up(new Event(87, dest));
            }
            Util.sleep(sleep_time);
            sleep_time = Math.min(1000L, sleep_time * 2L);
        }
        if (physical_dest != null) {
            this.sendUnicast(physical_dest, buf, offset, length);
        } else if (this.log.isWarnEnabled()) {
            this.log.warn(this.local_addr + ": no physical address for " + dest + ", dropping message");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendToAllPhysicalAddresses(byte[] buf, int offset, int length) throws Exception {
        HashSet<PhysicalAddress> dests = new HashSet<PhysicalAddress>(this.logical_addr_cache.nonRemovedValues());
        if (!this.logical_addr_cache.containsKeys(this.members)) {
            long current_time = 0L;
            TP tP = this;
            synchronized (tP) {
                if (this.last_discovery_request == 0L || (current_time = System.currentTimeMillis()) - this.last_discovery_request >= 10000L) {
                    long l = this.last_discovery_request = current_time == 0L ? System.currentTimeMillis() : current_time;
                    if (this.log.isWarnEnabled()) {
                        this.log.warn("logical address cache didn't contain all physical address, sending up a discovery request");
                    }
                    this.up_prot.up(new Event(12));
                }
            }
        }
        for (PhysicalAddress dest : dests) {
            try {
                this.sendUnicast(dest, buf, offset, length);
            }
            catch (Throwable t) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error("failure sending message to " + dest + ": " + t);
            }
        }
    }

    protected static void writeMessage(Message msg, DataOutputStream dos, boolean multicast) throws Exception {
        int flags = 0;
        dos.writeShort(Version.version);
        if (multicast) {
            flags = (byte)(flags + 2);
        }
        if (msg.isFlagSet(Message.OOB)) {
            flags = (byte)(flags + 4);
        }
        dos.writeByte(flags);
        msg.writeTo(dos);
    }

    protected static Message readMessage(DataInputStream instream) throws Exception {
        Message msg = new Message(false);
        msg.readFrom(instream);
        return msg;
    }

    protected static void writeMessageList(Address dest, Address src, List<Message> msgs, DataOutputStream dos, boolean multicast) throws Exception {
        dos.writeShort(Version.version);
        int flags = 1;
        if (multicast) {
            flags = (byte)(flags + 2);
        }
        dos.writeByte(flags);
        Util.writeAddress(dest, dos);
        Util.writeAddress(src, dos);
        if (msgs != null) {
            for (Message msg : msgs) {
                dos.writeBoolean(true);
                msg.writeToNoAddrs(src, dos);
            }
        }
        dos.writeBoolean(false);
    }

    protected static List<Message> readMessageList(DataInputStream in) throws Exception {
        LinkedList<Message> list = new LinkedList<Message>();
        Address dest = Util.readAddress(in);
        Address src = Util.readAddress(in);
        while (in.readBoolean()) {
            Message msg = new Message(false);
            msg.readFrom(in);
            msg.setDest(dest);
            if (msg.getSrc() == null) {
                msg.setSrc(src);
            }
            list.add(msg);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object handleDownEvent(Event evt) {
        switch (evt.getType()) {
            case 6: 
            case 15: {
                Set<Address> set = this.members;
                synchronized (set) {
                    View view = (View)evt.getArg();
                    this.members.clear();
                    if (!this.isSingleton()) {
                        List<Address> tmpvec = view.getMembers();
                        this.members.addAll(tmpvec);
                    } else {
                        for (Protocol prot : this.up_prots.values()) {
                            if (!(prot instanceof ProtocolAdapter)) continue;
                            ProtocolAdapter ad = (ProtocolAdapter)prot;
                            Set<Address> tmp = ad.getMembers();
                            this.members.addAll(tmp);
                        }
                    }
                    this.logical_addr_cache.retainAll(this.members);
                    this.fetchLocalAddresses();
                    UUID.retainAll(this.members);
                    break;
                }
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.channel_name = (String)evt.getArg();
                this.header = new TpHeader(this.channel_name);
                this.setInAllThreadFactories(this.channel_name, this.local_addr, this.thread_naming_pattern);
                this.setThreadNames();
                this.connectLock.lock();
                try {
                    this.handleConnect();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.connectLock.unlock();
                }
                return null;
            }
            case 4: {
                this.unsetThreadNames();
                this.connectLock.lock();
                try {
                    this.handleDisconnect();
                    break;
                }
                finally {
                    this.connectLock.unlock();
                }
            }
            case 87: {
                return this.getPhysicalAddressFromCache((Address)evt.getArg());
            }
            case 88: {
                return this.logical_addr_cache.contents();
            }
            case 89: {
                Tuple tuple = (Tuple)evt.getArg();
                this.addPhysicalAddressToCache((Address)tuple.getVal1(), (PhysicalAddress)tuple.getVal2());
                break;
            }
            case 90: {
                this.removeLogicalAddressFromCache((Address)evt.getArg());
                break;
            }
            case 8: {
                if (!this.isSingleton()) {
                    this.local_addr = (Address)evt.getArg();
                }
                this.registerLocalAddress((Address)evt.getArg());
            }
        }
        return null;
    }

    protected void registerLocalAddress(Address addr) {
        PhysicalAddress physical_addr = this.getPhysicalAddress();
        if (physical_addr != null && addr != null) {
            this.addPhysicalAddressToCache(addr, physical_addr);
        }
    }

    protected void fetchLocalAddresses() {
        if (!this.isSingleton()) {
            if (this.local_addr != null) {
                this.registerLocalAddress(this.local_addr);
            } else {
                Address addr;
                this.local_addr = addr = (Address)this.up_prot.up(new Event(91));
                this.registerLocalAddress(addr);
            }
        } else {
            for (Protocol prot : this.up_prots.values()) {
                Address addr = (Address)prot.up(new Event(91));
                this.registerLocalAddress(addr);
            }
        }
    }

    protected void setThreadNames() {
        if (this.diag_handler != null) {
            this.global_thread_factory.renameThread("DiagnosticsHandler", this.diag_handler.getThread());
        }
        if (this.bundler instanceof TransferQueueBundler) {
            this.global_thread_factory.renameThread("TransferQueueBundler", ((TransferQueueBundler)this.bundler).getThread());
        }
    }

    protected void unsetThreadNames() {
        Thread thread;
        if (this.diag_handler != null && this.diag_handler.getThread() != null) {
            this.diag_handler.getThread().setName("DiagnosticsHandler");
        }
        if (this.bundler instanceof TransferQueueBundler && (thread = ((TransferQueueBundler)this.bundler).getThread()) != null) {
            this.global_thread_factory.renameThread("TransferQueueBundler", thread);
        }
    }

    protected void setInAllThreadFactories(String cluster_name, Address local_address, String pattern) {
        ThreadFactory[] factories = new ThreadFactory[]{this.timer_thread_factory, this.default_thread_factory, this.oob_thread_factory, this.global_thread_factory};
        boolean is_shared_transport = this.isSingleton();
        for (ThreadFactory factory : factories) {
            if (pattern != null) {
                factory.setPattern(pattern);
                if (is_shared_transport) {
                    factory.setIncludeClusterName(false);
                }
            }
            if (cluster_name != null && !is_shared_transport) {
                factory.setClusterName(cluster_name);
            }
            if (local_address == null) continue;
            factory.setAddress(local_address.toString());
        }
    }

    protected static ExecutorService createThreadPool(int min_threads, int max_threads, long keep_alive_time, String rejection_policy, BlockingQueue<Runnable> queue, ThreadFactory factory) {
        ThreadManagerThreadPoolExecutor pool = new ThreadManagerThreadPoolExecutor(min_threads, max_threads, keep_alive_time, TimeUnit.MILLISECONDS, queue);
        pool.setThreadFactory(factory);
        RejectedExecutionHandler handler = Util.parseRejectionPolicy(rejection_policy);
        pool.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(handler));
        return pool;
    }

    protected static void shutdownThreadPool(Executor thread_pool) {
        if (thread_pool instanceof ExecutorService) {
            ExecutorService service = (ExecutorService)thread_pool;
            service.shutdownNow();
            try {
                service.awaitTermination(3000L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void passToAllUpProtocols(Event evt) {
        for (Protocol prot : this.up_prots.values()) {
            try {
                prot.up(evt);
            }
            catch (Exception e) {
                if (!this.log.isErrorEnabled()) continue;
                this.log.error("failed passing up event " + evt, e);
            }
        }
    }

    protected void addPhysicalAddressToCache(Address logical_addr, PhysicalAddress physical_addr) {
        if (logical_addr != null && physical_addr != null) {
            this.logical_addr_cache.add(logical_addr, physical_addr);
        }
    }

    protected PhysicalAddress getPhysicalAddressFromCache(Address logical_addr) {
        return logical_addr != null ? this.logical_addr_cache.get(logical_addr) : null;
    }

    protected void removeLogicalAddressFromCache(Address logical_addr) {
        if (logical_addr != null) {
            this.logical_addr_cache.remove(logical_addr);
            this.fetchLocalAddresses();
        }
    }

    public void clearLogicalAddressCache() {
        this.logical_addr_cache.clear(true);
        this.fetchLocalAddresses();
    }

    protected abstract PhysicalAddress getPhysicalAddress();

    static /* synthetic */ Log access$200(TP x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$300(TP x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$400(TP x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$500(TP x0) {
        return x0.log;
    }

    static /* synthetic */ Log access$600(TP x0) {
        return x0.log;
    }

    static {
        f.setGroupingUsed(false);
        f.setMaximumFractionDigits(2);
        print_function = new LazyRemovalCache.Printable<Address, PhysicalAddress>(){

            @Override
            public String print(Address logical_addr, PhysicalAddress physical_addr) {
                StringBuilder sb = new StringBuilder();
                String tmp_logical_name = UUID.get(logical_addr);
                if (tmp_logical_name != null) {
                    sb.append(tmp_logical_name).append(": ");
                }
                if (logical_addr instanceof UUID) {
                    sb.append(((UUID)logical_addr).toStringLong());
                } else {
                    sb.append(logical_addr);
                }
                sb.append(": ").append(physical_addr).append("\n");
                return sb.toString();
            }
        };
    }

    public static class ProtocolAdapter
    extends Protocol
    implements DiagnosticsHandler.ProbeHandler {
        String cluster_name;
        final short transport_id;
        TpHeader header;
        final Set<Address> members = new CopyOnWriteArraySet<Address>();
        final ThreadFactory factory;
        protected SocketFactory socket_factory = new DefaultSocketFactory();
        Address local_addr;
        static final ThreadLocal<ProtocolAdapter> thread_local = new ThreadLocal();

        public ProtocolAdapter(String cluster_name, Address local_addr, short transport_id, Protocol up2, Protocol down2, String pattern) {
            this.cluster_name = cluster_name;
            this.local_addr = local_addr;
            this.transport_id = transport_id;
            this.up_prot = up2;
            this.down_prot = down2;
            this.header = new TpHeader(cluster_name);
            this.factory = new DefaultThreadFactory(Util.getGlobalThreadGroup(), "", false);
            this.factory.setPattern(pattern);
            if (local_addr != null) {
                this.factory.setAddress(local_addr.toString());
            }
            if (cluster_name != null) {
                this.factory.setClusterName(cluster_name);
            }
        }

        @ManagedAttribute(description="Name of the cluster to which this adapter proxies")
        public String getClusterName() {
            return this.cluster_name;
        }

        public Address getAddress() {
            return this.local_addr;
        }

        @ManagedAttribute(name="Address", description="local address")
        public String getAddressAsString() {
            return this.local_addr != null ? this.local_addr.toString() : null;
        }

        @ManagedAttribute(name="AddressUUID", description="local address")
        public String getAddressAsUUID() {
            return this.local_addr instanceof UUID ? ((UUID)this.local_addr).toStringLong() : null;
        }

        @ManagedAttribute(description="ID of the transport")
        public short getTransportName() {
            return this.transport_id;
        }

        public Set<Address> getMembers() {
            return Collections.unmodifiableSet(this.members);
        }

        @Override
        public ThreadFactory getThreadFactory() {
            return this.factory;
        }

        @Override
        public SocketFactory getSocketFactory() {
            return this.socket_factory;
        }

        @Override
        public void setSocketFactory(SocketFactory factory) {
            if (factory != null) {
                this.socket_factory = factory;
            }
        }

        @Override
        public void start() throws Exception {
            TP tp = this.getTransport();
            if (tp != null) {
                tp.registerProbeHandler(this);
            }
        }

        @Override
        public void stop() {
            TP tp = this.getTransport();
            if (tp != null) {
                tp.unregisterProbeHandler(this);
            }
        }

        @Override
        public Object down(Event evt) {
            switch (evt.getType()) {
                case 1: {
                    Message msg = (Message)evt.getArg();
                    msg.putHeader(this.transport_id, this.header);
                    if (msg.getSrc() != null) break;
                    msg.setSrc(this.local_addr);
                    break;
                }
                case 6: {
                    View view = (View)evt.getArg();
                    List<Address> tmp = view.getMembers();
                    this.members.clear();
                    this.members.addAll(tmp);
                    break;
                }
                case 4: {
                    thread_local.set(this);
                    break;
                }
                case 2: 
                case 80: 
                case 92: 
                case 93: {
                    thread_local.set(this);
                    this.cluster_name = (String)evt.getArg();
                    this.factory.setClusterName(this.cluster_name);
                    this.header = new TpHeader(this.cluster_name);
                    break;
                }
                case 8: {
                    Address addr = (Address)evt.getArg();
                    if (addr == null) break;
                    this.local_addr = addr;
                    this.factory.setAddress(addr.toString());
                }
            }
            return this.down_prot.down(evt);
        }

        @Override
        public String getName() {
            return "TP.ProtocolAdapter";
        }

        public String toString() {
            return this.cluster_name + " (" + this.transport_id + ")";
        }

        @Override
        public Map<String, String> handleProbe(String ... keys) {
            HashMap<String, String> retval = new HashMap<String, String>();
            retval.put("cluster", this.cluster_name);
            retval.put("local_addr", this.local_addr != null ? this.local_addr.toString() : null);
            retval.put("local_addr (UUID)", this.local_addr instanceof UUID ? ((UUID)this.local_addr).toStringLong() : null);
            retval.put("transport_id", Short.toString(this.transport_id));
            return retval;
        }

        @Override
        public String[] supportedKeys() {
            return null;
        }
    }

    private class TransferQueueBundler
    implements Bundler,
    Runnable {
        final int threshold;
        final BlockingQueue<Message> buffer;
        volatile Thread bundler_thread;
        final Log log = LogFactory.getLog(this.getClass());
        final Map<SingletonAddress, List<Message>> msgs = new HashMap<SingletonAddress, List<Message>>(36);
        long count = 0L;
        int num_msgs = 0;
        long next_bundle_time;
        volatile boolean running = true;
        public static final String THREAD_NAME = "TransferQueueBundler";

        private TransferQueueBundler(int capacity) {
            if (capacity <= 0) {
                throw new IllegalArgumentException("Bundler capacity cannot be " + capacity);
            }
            this.buffer = new LinkedBlockingQueue<Message>(capacity);
            this.threshold = (int)((double)capacity * 0.9);
        }

        @Override
        public void start() {
            if (this.bundler_thread == null || !this.bundler_thread.isAlive()) {
                this.bundler_thread = TP.this.getThreadFactory().newThread(this, THREAD_NAME);
                this.running = true;
                this.bundler_thread.start();
            }
        }

        public Thread getThread() {
            return this.bundler_thread;
        }

        @Override
        public void stop() {
            this.running = false;
            if (this.bundler_thread != null) {
                this.bundler_thread.interrupt();
            }
        }

        @Override
        public void send(Message msg) throws Exception {
            long length = msg.size();
            this.checkLength(length);
            this.buffer.put(msg);
        }

        public int getBufferSize() {
            return this.buffer.size();
        }

        @Override
        public void run() {
            this.next_bundle_time = System.currentTimeMillis() + TP.this.max_bundle_timeout;
            while (this.running) {
                Message msg = null;
                long sleep_time = this.next_bundle_time - System.currentTimeMillis();
                try {
                    boolean send_msgs;
                    msg = this.count == 0L ? this.buffer.take() : this.buffer.poll(sleep_time, TimeUnit.MILLISECONDS);
                    long size = msg != null ? msg.size() : 0L;
                    boolean bl = send_msgs = msg != null && this.count + size >= (long)TP.this.max_bundle_size || this.buffer.size() >= this.threshold || System.currentTimeMillis() >= this.next_bundle_time;
                    if (send_msgs) {
                        this.next_bundle_time = System.currentTimeMillis() + TP.this.max_bundle_timeout;
                        try {
                            if (!this.msgs.isEmpty()) {
                                this.sendBundledMessages(this.msgs);
                                this.msgs.clear();
                            }
                            this.count = 0L;
                        }
                        catch (Exception e) {
                            this.log.error("failed sending bundled messages: " + e.getMessage());
                        }
                    }
                    if (msg == null) continue;
                    this.count += size;
                    this.addMessage(msg);
                }
                catch (Throwable t) {}
            }
        }

        private void checkLength(long len) throws Exception {
            if (len > (long)TP.this.max_bundle_size) {
                throw new Exception("message size (" + len + ") is greater than max bundling size (" + TP.this.max_bundle_size + "). Set the fragmentation/bundle size in FRAG and TP correctly");
            }
        }

        private void addMessage(Message msg) {
            String cluster_name;
            Address dst = msg.getDest();
            if (!TP.this.isSingleton()) {
                cluster_name = TP.this.channel_name;
            } else {
                TpHeader hdr = (TpHeader)msg.getHeader(TP.this.id);
                cluster_name = hdr.channel_name;
            }
            SingletonAddress dest = new SingletonAddress(cluster_name, dst);
            List<Message> tmp = this.msgs.get(dest);
            if (tmp == null) {
                tmp = new LinkedList<Message>();
                this.msgs.put(dest, tmp);
            }
            tmp.add(msg);
            ++this.num_msgs;
        }

        private void sendBundledMessages(Map<SingletonAddress, List<Message>> msgs) {
            if (this.log.isTraceEnabled()) {
                double percentage = 100.0 / (double)TP.this.max_bundle_size * (double)this.count;
                StringBuilder sb = new StringBuilder("sending ").append(this.num_msgs).append(" msgs (");
                sb.append(this.count).append(" bytes (" + f.format(percentage) + "% of max_bundle_size)");
                sb.append(" to ").append(msgs.size()).append(" destination(s)");
                if (msgs.size() > 1) {
                    sb.append(" (dests=").append(msgs.keySet()).append(")");
                }
                this.log.trace(sb);
                this.num_msgs = 0;
            }
            ExposedByteArrayOutputStream bundler_out_stream = new ExposedByteArrayOutputStream((int)(this.count + 50L));
            ExposedDataOutputStream bundler_dos = new ExposedDataOutputStream(bundler_out_stream);
            for (Map.Entry<SingletonAddress, List<Message>> entry : msgs.entrySet()) {
                List<Message> list = entry.getValue();
                if (list.isEmpty()) continue;
                SingletonAddress dst = entry.getKey();
                Address dest = dst.getAddress();
                Address src_addr = list.get(0).getSrc();
                boolean multicast = dest == null;
                try {
                    bundler_out_stream.reset();
                    bundler_dos.reset();
                    TP.writeMessageList(dest, src_addr, list, bundler_dos, multicast);
                    Buffer buf = new Buffer(bundler_out_stream.getRawBuffer(), 0, bundler_out_stream.size());
                    TP.this.doSend(buf, dest, multicast);
                }
                catch (Throwable e) {
                    if (!this.log.isErrorEnabled()) continue;
                    this.log.error("exception sending bundled msgs: " + e + ":, cause: " + e.getCause());
                }
            }
        }
    }

    private class DefaultBundler
    implements Bundler {
        static final int MIN_NUMBER_OF_BUNDLING_TASKS = 2;
        final Map<SingletonAddress, List<Message>> msgs = new HashMap<SingletonAddress, List<Message>>(36);
        long count = 0L;
        int num_msgs = 0;
        int num_bundling_tasks = 0;
        long last_bundle_time;
        final ReentrantLock lock = new ReentrantLock();
        final Log log = LogFactory.getLog(this.getClass());

        private DefaultBundler() {
        }

        @Override
        public void start() {
        }

        @Override
        public void stop() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void send(Message msg) throws Exception {
            long length = msg.size();
            boolean do_schedule = false;
            this.checkLength(length);
            this.lock.lock();
            try {
                if (this.count + length >= (long)TP.this.max_bundle_size) {
                    this.sendBundledMessages(this.msgs);
                }
                this.addMessage(msg);
                this.count += length;
                if (this.num_bundling_tasks < 2) {
                    ++this.num_bundling_tasks;
                    do_schedule = true;
                }
            }
            finally {
                this.lock.unlock();
            }
            if (do_schedule) {
                TP.this.timer.schedule(new BundlingTimer(), TP.this.max_bundle_timeout, TimeUnit.MILLISECONDS);
            }
        }

        private void addMessage(Message msg) {
            List<Message> tmp;
            String cluster_name;
            Address dst = msg.getDest();
            if (!TP.this.isSingleton()) {
                cluster_name = TP.this.channel_name;
            } else {
                TpHeader hdr = (TpHeader)msg.getHeader(TP.this.id);
                cluster_name = hdr.channel_name;
            }
            SingletonAddress dest = new SingletonAddress(cluster_name, dst);
            if (this.msgs.isEmpty()) {
                this.last_bundle_time = System.currentTimeMillis();
            }
            if ((tmp = this.msgs.get(dest)) == null) {
                tmp = new LinkedList<Message>();
                this.msgs.put(dest, tmp);
            }
            tmp.add(msg);
            ++this.num_msgs;
        }

        private void sendBundledMessages(Map<SingletonAddress, List<Message>> msgs) {
            if (this.log.isTraceEnabled()) {
                long stop = System.currentTimeMillis();
                double percentage = 100.0 / (double)TP.this.max_bundle_size * (double)this.count;
                StringBuilder sb = new StringBuilder("sending ").append(this.num_msgs).append(" msgs (");
                this.num_msgs = 0;
                sb.append(this.count).append(" bytes (" + f.format(percentage) + "% of max_bundle_size)");
                if (this.last_bundle_time > 0L) {
                    sb.append(", collected in ").append(stop - this.last_bundle_time).append("ms) ");
                }
                sb.append(" to ").append(msgs.size()).append(" destination(s)");
                if (msgs.size() > 1) {
                    sb.append(" (dests=").append(msgs.keySet()).append(")");
                }
                this.log.trace(sb);
            }
            ExposedByteArrayOutputStream bundler_out_stream = new ExposedByteArrayOutputStream((int)(this.count + 50L));
            ExposedDataOutputStream bundler_dos = new ExposedDataOutputStream(bundler_out_stream);
            for (Map.Entry<SingletonAddress, List<Message>> entry : msgs.entrySet()) {
                List<Message> list = entry.getValue();
                if (list.isEmpty()) continue;
                SingletonAddress dst = entry.getKey();
                Address dest = dst.getAddress();
                Address src_addr = list.get(0).getSrc();
                boolean multicast = dest == null;
                try {
                    bundler_out_stream.reset();
                    bundler_dos.reset();
                    TP.writeMessageList(dest, src_addr, list, bundler_dos, multicast);
                    Buffer buffer = new Buffer(bundler_out_stream.getRawBuffer(), 0, bundler_out_stream.size());
                    TP.this.doSend(buffer, dest, multicast);
                }
                catch (Throwable e) {
                    if (!this.log.isErrorEnabled()) continue;
                    this.log.error("exception sending bundled msgs", e);
                }
            }
            msgs.clear();
            this.count = 0L;
        }

        private void checkLength(long len) throws Exception {
            if (len > (long)TP.this.max_bundle_size) {
                throw new Exception("message size (" + len + ") is greater than max bundling size (" + TP.this.max_bundle_size + "). Set the fragmentation/bundle size in FRAG and TP correctly");
            }
        }

        private class BundlingTimer
        implements Runnable {
            private BundlingTimer() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DefaultBundler.this.lock.lock();
                try {
                    if (!DefaultBundler.this.msgs.isEmpty()) {
                        try {
                            DefaultBundler.this.sendBundledMessages(DefaultBundler.this.msgs);
                        }
                        catch (Exception e) {
                            DefaultBundler.this.log.error("failed sending bundled messages", e);
                        }
                    }
                }
                finally {
                    --DefaultBundler.this.num_bundling_tasks;
                    DefaultBundler.this.lock.unlock();
                }
            }

            public String toString() {
                return this.getClass().getSimpleName();
            }
        }
    }

    protected static interface Bundler {
        public void start();

        public void stop();

        public void send(Message var1) throws Exception;
    }

    class IncomingPacket
    implements Runnable {
        final Address sender;
        final byte[] buf;
        final int offset;
        final int length;

        IncomingPacket(Address sender, byte[] buf, int offset, int length) {
            this.sender = sender;
            this.buf = buf;
            this.offset = offset;
            this.length = length;
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK], 0[TRYBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void handleMyMessage(Message msg, boolean multicast) {
            if (TP.this.stats) {
                ++TP.this.num_msgs_received;
                TP.this.num_bytes_received += (long)msg.getLength();
            }
            TP.this.passMessageUp(msg, true, multicast, true);
        }
    }
}

