/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols.pbcast;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Digest;
import org.jgroups.util.ShutdownRejectedExecutionHandler;
import org.jgroups.util.StateTransferResult;
import org.jgroups.util.Util;

@MBean(description="Streaming state transfer protocol base class")
public abstract class StreamingStateTransfer
extends Protocol {
    @Property(description="Size (in bytes) of the state transfer buffer")
    protected int buffer_size = 8192;
    @Property(description="Maximum number of pool threads serving state requests")
    protected int max_pool = 5;
    @Property(description="Keep alive for pool threads serving state requests")
    protected long pool_thread_keep_alive = 20000L;
    protected final AtomicInteger num_state_reqs = new AtomicInteger(0);
    protected final AtomicLong num_bytes_sent = new AtomicLong(0L);
    protected double avg_state_size = 0.0;
    protected Address local_addr = null;
    protected volatile Address state_provider = null;
    protected final List<Address> members = new ArrayList<Address>();
    protected volatile boolean flushProtocolInStack = false;
    @ManagedAttribute(description="whether or not the barrier is closed")
    protected AtomicBoolean barrier_closed = new AtomicBoolean(false);
    protected ThreadPoolExecutor thread_pool;
    protected final Map<Address, OutputStream> pending_state_transfers = new HashMap<Address, OutputStream>();
    protected final Lock state_lock = new ReentrantLock();

    @ManagedAttribute
    public int getNumberOfStateRequests() {
        return this.num_state_reqs.get();
    }

    @ManagedAttribute
    public long getNumberOfStateBytesSent() {
        return this.num_bytes_sent.get();
    }

    @ManagedAttribute
    public double getAverageStateSize() {
        return this.avg_state_size;
    }

    @ManagedAttribute
    public int getThreadPoolSize() {
        return this.thread_pool.getPoolSize();
    }

    @ManagedAttribute
    public long getThreadPoolCompletedTasks() {
        return this.thread_pool.getCompletedTaskCount();
    }

    @Override
    public List<Integer> requiredDownServices() {
        ArrayList<Integer> retval = new ArrayList<Integer>(2);
        retval.add(39);
        retval.add(42);
        return retval;
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_state_reqs.set(0);
        this.num_bytes_sent.set(0L);
        this.avg_state_size = 0.0;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.thread_pool = this.createThreadPool();
    }

    @Override
    public void destroy() {
        this.thread_pool.shutdown();
        super.destroy();
    }

    @Override
    public void start() throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("state_transfer", true);
        map.put("protocol_class", this.getClass().getName());
        this.up_prot.up(new Event(56, map));
        if (this.buffer_size <= 0) {
            throw new IllegalArgumentException("buffer_size has to be > 0");
        }
    }

    @Override
    public void stop() {
        super.stop();
        this.barrier_closed.set(false);
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 6: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 19: {
                Address target;
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                if (info.target == null) {
                    target = this.determineCoordinator();
                } else {
                    target = info.target;
                    if (target.equals(this.local_addr)) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error("cannot fetch state from myself !");
                        }
                        target = null;
                    }
                }
                if (target == null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("first member (no state)");
                    }
                    this.up_prot.up(new Event(73, new StateTransferResult()));
                } else {
                    this.state_provider = target;
                    Message state_req = new Message(target, null, null);
                    state_req.putHeader(this.id, new StateHeader(1));
                    if (this.log.isDebugEnabled()) {
                        this.log.debug(this.local_addr + ": asking " + target + " for state");
                    }
                    this.down_prot.down(new Event(1, state_req));
                }
                return null;
            }
            case 56: {
                this.handleConfig((Map)evt.getArg());
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Message msg = (Message)evt.getArg();
                StateHeader hdr = (StateHeader)msg.getHeader(this.id);
                if (hdr == null) break;
                Address sender = msg.getSrc();
                switch (hdr.type) {
                    case 1: {
                        this.handleStateReq(sender);
                        break;
                    }
                    case 2: {
                        this.handleStateRsp(sender, hdr);
                        break;
                    }
                    case 3: {
                        this.handleStateChunk(sender, msg.getRawBuffer(), msg.getOffset(), msg.getLength());
                        break;
                    }
                    case 4: {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.local_addr + " <-- EOF <-- " + sender);
                        }
                        this.handleEOF(sender);
                        break;
                    }
                    case 5: {
                        this.handleException((Throwable)msg.getObject());
                        break;
                    }
                    default: {
                        if (!this.log.isErrorEnabled()) break;
                        this.log.error("type " + hdr.type + " not known in StateHeader");
                    }
                }
                return null;
            }
            case 6: 
            case 15: {
                this.handleViewChange((View)evt.getArg());
                break;
            }
            case 56: {
                this.handleConfig((Map)evt.getArg());
            }
        }
        return this.up_prot.up(evt);
    }

    protected boolean isDigestNeeded() {
        return !this.flushProtocolInStack;
    }

    protected void handleConfig(Map<String, Object> config) {
        if (config != null && config.containsKey("flush_supported")) {
            this.flushProtocolInStack = true;
        }
        if (config != null && config.containsKey("state_transfer")) {
            throw new IllegalArgumentException("Protocol stack must have only one state transfer protocol");
        }
    }

    protected void handleStateChunk(Address sender, byte[] buffer, int offset, int length) {
    }

    protected void handleEOF(Address sender) {
        this.state_provider = null;
    }

    protected void handleException(Throwable exception) {
        this.state_provider = null;
        this.openBarrierAndResumeStable();
        this.up_prot.up(new Event(73, new StateTransferResult(exception)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getStateFromApplication(Address requester, OutputStream out, boolean use_separate_thread) {
        if (out == null || requester == null) {
            throw new IllegalArgumentException("output stream and requester's address have to be non-null");
        }
        boolean close_barrier = false;
        this.state_lock.lock();
        try {
            if (this.pending_state_transfers.containsKey(requester)) {
                throw new IllegalStateException("requester " + requester + " has a pending state transfer; concurrent " + "state transfers from the same member are not supported");
            }
            close_barrier = this.pending_state_transfers.isEmpty();
            if (close_barrier) {
                this.closeBarrierAndSuspendStable();
            }
            this.pending_state_transfers.put(requester, out);
            StateGetter state_getter = new StateGetter(requester, out);
            if (use_separate_thread) {
                this.thread_pool.execute(state_getter);
            } else {
                state_getter.run();
            }
        }
        catch (Throwable t) {
            if (close_barrier) {
                this.openBarrierAndResumeStable();
            }
            this.sendException(requester, t);
            this.pending_state_transfers.remove(requester);
        }
        finally {
            this.state_lock.unlock();
        }
    }

    protected void removeRequester(Address requester) {
        if (requester == null) {
            return;
        }
        OutputStream out = this.pending_state_transfers.remove(requester);
        Util.close(out);
        if (out != null && this.pending_state_transfers.isEmpty()) {
            this.openBarrierAndResumeStable();
        }
    }

    protected void setStateInApplication(Address provider, InputStream in, Digest digest) {
        this.closeBarrierAndSuspendStable();
        try {
            if (digest != null) {
                this.down_prot.down(new Event(42, digest));
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + ": setting the state in the aplication");
            }
            this.up_prot.up(new Event(71, in));
            this.openBarrierAndResumeStable();
            this.up_prot.up(new Event(73, new StateTransferResult()));
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    @ManagedOperation(description="Closes BARRIER and suspends STABLE")
    public void closeBarrierAndSuspendStable() {
        if (!this.isDigestNeeded() || !this.barrier_closed.compareAndSet(false, true)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": sending down CLOSE_BARRIER and SUSPEND_STABLE");
        }
        this.down_prot.down(new Event(76));
        this.down_prot.down(new Event(65));
    }

    @ManagedOperation(description="Opens BARRIER and resumes STABLE")
    public void openBarrierAndResumeStable() {
        if (!this.isDigestNeeded() || !this.barrier_closed.compareAndSet(true, false)) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": sending down OPEN_BARRIER and RESUME_STABLE");
        }
        this.down_prot.down(new Event(77));
        this.down_prot.down(new Event(66));
    }

    protected void sendEof(Address requester) {
        try {
            Message eof_msg = new Message(requester);
            eof_msg.putHeader(this.getId(), new StateHeader(4));
            if (this.log.isTraceEnabled()) {
                this.log.trace(this.local_addr + " --> EOF --> " + requester);
            }
            this.down(new Event(1, eof_msg));
        }
        catch (Throwable t) {
            this.log.error(this.local_addr + ": failed sending EOF to " + requester);
        }
    }

    protected void sendException(Address requester, Throwable exception) {
        try {
            Message ex_msg = new Message(requester, null, exception);
            ex_msg.putHeader(this.getId(), new StateHeader(5));
            this.down(new Event(1, ex_msg));
        }
        catch (Throwable t) {
            this.log.error(this.local_addr + ": failed sending exception " + exception.toString() + " to " + requester);
        }
    }

    protected ThreadPoolExecutor createThreadPool() {
        ThreadPoolExecutor threadPool = new ThreadPoolExecutor(0, this.max_pool, this.pool_thread_keep_alive, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>());
        ThreadFactory factory = new ThreadFactory(){
            private final AtomicInteger thread_id = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable command) {
                return StreamingStateTransfer.this.getThreadFactory().newThread(command, "StreamingStateTransfer-sender-" + this.thread_id.getAndIncrement());
            }
        };
        threadPool.setRejectedExecutionHandler(new ShutdownRejectedExecutionHandler(threadPool.getRejectedExecutionHandler()));
        threadPool.setThreadFactory(factory);
        return threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Address determineCoordinator() {
        List<Address> list = this.members;
        synchronized (list) {
            for (Address member : this.members) {
                if (this.local_addr.equals(member)) continue;
                return member;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleViewChange(View v) {
        List<Address> new_members = v.getMembers();
        List<Address> list = this.members;
        synchronized (list) {
            this.members.clear();
            this.members.addAll(new_members);
        }
        this.state_lock.lock();
        try {
            HashSet<Address> keys = new HashSet<Address>(this.pending_state_transfers.keySet());
            for (Address key : keys) {
                if (new_members.contains(key)) continue;
                this.removeRequester(key);
            }
        }
        finally {
            this.state_lock.unlock();
        }
    }

    protected void handleStateReq(Address requester) {
        if (requester == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(this.local_addr + ": sender of STATE_REQ is null; ignoring state transfer request");
            }
            return;
        }
        Message state_rsp = new Message(requester);
        Digest digest = this.isDigestNeeded() ? (Digest)this.down_prot.down(Event.GET_DIGEST_EVT) : null;
        StateHeader hdr = new StateHeader(2, null, digest);
        this.modifyStateResponseHeader(hdr);
        state_rsp.putHeader(this.id, hdr);
        if (this.log.isDebugEnabled()) {
            this.log.debug(this.local_addr + ": responding to state requester " + requester);
        }
        this.down_prot.down(new Event(1, state_rsp));
        if (this.stats) {
            this.num_state_reqs.incrementAndGet();
        }
        try {
            this.createStreamToRequester(requester);
        }
        catch (Throwable t) {
            this.sendException(requester, t);
        }
    }

    protected abstract void createStreamToRequester(Address var1);

    protected abstract void createStreamToProvider(Address var1, StateHeader var2);

    protected void modifyStateResponseHeader(StateHeader hdr) {
    }

    void handleStateRsp(Address sender, StateHeader hdr) {
        this.createStreamToProvider(sender, hdr);
    }

    protected class StateGetter
    implements Runnable {
        protected final Address requester;
        protected final OutputStream output;

        public StateGetter(Address requester, OutputStream output) {
            this.requester = requester;
            this.output = output;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (StreamingStateTransfer.this.log.isTraceEnabled()) {
                    StreamingStateTransfer.this.log.trace(StreamingStateTransfer.this.local_addr + ": getting the state from the application");
                }
                StreamingStateTransfer.this.up_prot.up(new Event(72, this.output));
                this.output.flush();
                StreamingStateTransfer.this.sendEof(this.requester);
            }
            catch (Throwable e) {
                if (StreamingStateTransfer.this.log.isWarnEnabled()) {
                    StreamingStateTransfer.this.log.warn(StreamingStateTransfer.this.local_addr + ": failed getting the state from the application", e);
                }
                StreamingStateTransfer.this.sendException(this.requester, e);
            }
            finally {
                StreamingStateTransfer.this.state_lock.lock();
                try {
                    StreamingStateTransfer.this.removeRequester(this.requester);
                }
                finally {
                    StreamingStateTransfer.this.state_lock.unlock();
                }
            }
        }
    }

    public static class StateHeader
    extends Header {
        public static final byte STATE_REQ = 1;
        public static final byte STATE_RSP = 2;
        public static final byte STATE_PART = 3;
        public static final byte STATE_EOF = 4;
        public static final byte STATE_EX = 5;
        protected byte type = 0;
        protected Digest my_digest = null;
        protected IpAddress bind_addr = null;

        public StateHeader() {
        }

        public StateHeader(byte type) {
            this.type = type;
        }

        public StateHeader(byte type, Digest digest) {
            this.type = type;
            this.my_digest = digest;
        }

        public StateHeader(byte type, IpAddress bind_addr, Digest digest) {
            this.type = type;
            this.my_digest = digest;
            this.bind_addr = bind_addr;
        }

        public int getType() {
            return this.type;
        }

        public Digest getDigest() {
            return this.my_digest;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("type=").append(StateHeader.type2Str(this.type));
            if (this.my_digest != null) {
                sb.append(", digest=").append(this.my_digest);
            }
            if (this.bind_addr != null) {
                sb.append(", bind_addr=" + this.bind_addr);
            }
            return sb.toString();
        }

        static String type2Str(int t) {
            switch (t) {
                case 1: {
                    return "STATE_REQ";
                }
                case 2: {
                    return "STATE_RSP";
                }
                case 3: {
                    return "STATE_PART";
                }
                case 4: {
                    return "STATE_EOF";
                }
                case 5: {
                    return "STATE_EX";
                }
            }
            return "<unknown>";
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            Util.writeStreamable(this.my_digest, out);
            Util.writeStreamable(this.bind_addr, out);
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            this.my_digest = (Digest)Util.readStreamable(Digest.class, in);
            this.bind_addr = (IpAddress)Util.readStreamable(IpAddress.class, in);
        }

        @Override
        public int size() {
            int retval = 1;
            ++retval;
            if (this.my_digest != null) {
                retval = (int)((long)retval + this.my_digest.serializedSize());
            }
            return retval += Util.size(this.bind_addr);
        }
    }
}

