/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.logging.filter;

import com.jaspersoft.jasperserver.api.logging.context.LoggingContextProvider;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

public abstract class BasicLoggingFilter
implements Filter {
    private LoggingContextProvider loggingContextProvider;
    private Exception originalException = null;

    public void setLoggingContextProvider(LoggingContextProvider loggingContextProvider) {
        this.loggingContextProvider = loggingContextProvider;
    }

    protected abstract void beforeChain(ServletRequest var1) throws ServletException;

    protected abstract void logException(ServletRequest var1, Exception var2) throws ServletException;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            this.beforeChain(request);
            chain.doFilter(request, response);
        }
        catch (IOException e) {
            this.originalException = e;
            throw e;
        }
        catch (ServletException e) {
            this.originalException = e;
            throw e;
        }
        catch (RuntimeException e) {
            this.originalException = e;
            throw e;
        }
        finally {
            this.logException(request, this.originalException);
            this.originalException = null;
            this.loggingContextProvider.flushContext();
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

