/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl;

import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class Cipherer
implements InitializingBean {
    private static Log log = LogFactory.getLog(Cipherer.class);
    private static final byte[] DEFAULT_KEY_BYTES = new byte[]{-56, 67, 41, 73, -82, 37, 47, -95, -63, -14, -56, -39, 49, 1, 44, 82, 84, 11, 94, -22, -98, 55, -88, 97};
    private static final byte[] INIT_VECTOR_8 = new byte[]{-114, 18, 57, -100, 7, 114, 111, 90};
    private static final byte[] INIT_VECTOR_16 = new byte[]{-117, 72, 16, 3, 93, -33, -7, -84, 23, -14, -67, 100, -73, 81, -64, 41};
    private Cipher E_CIPHER = null;
    private Cipher D_CIPHER = null;
    private static final String DEFAULT_CIPHER_TRANSFORMATION = "DESede/CBC/PKCS5Padding";
    private static final String DEFAULT_KEY_ALGORITHM = "DESede";
    private byte[] keyBytes = DEFAULT_KEY_BYTES;
    private String cipherTransformation = "DESede/CBC/PKCS5Padding";
    private String keyAlgorithm = "DESede";
    private static final char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void init(String inCipherTransformation, String inKeyAlgorithm, String inKeyBytes, boolean isPlainText) {
        this.cipherTransformation = inCipherTransformation;
        this.keyAlgorithm = inKeyAlgorithm;
        this.setKeyBytes(inKeyBytes, isPlainText);
        this.init();
    }

    public void init() {
        try {
            IvParameterSpec paramSpec = this.cipherTransformation.toUpperCase().startsWith("AES") ? new IvParameterSpec(INIT_VECTOR_16) : new IvParameterSpec(INIT_VECTOR_8);
            this.E_CIPHER = Cipher.getInstance(this.cipherTransformation);
            this.D_CIPHER = Cipher.getInstance(this.cipherTransformation);
            SecretKeySpec spec = new SecretKeySpec(this.keyBytes, this.keyAlgorithm);
            this.E_CIPHER.init(1, (Key)spec, paramSpec);
            this.D_CIPHER.init(2, (Key)spec, paramSpec);
        }
        catch (Exception e) {
            log.error((Object)"Cipher init failed", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public String encode(String content) {
        try {
            if (content == null) {
                return null;
            }
            return Cipherer.hexify(this.encode(content.getBytes("UTF-8")));
        }
        catch (Exception ex) {
            log.warn((Object)"Unsuccessfull password encryption", (Throwable)ex);
            return Cipherer.hexify(this.encode(content.getBytes()));
        }
    }

    public byte[] encode(byte[] content) {
        try {
            return this.E_CIPHER.doFinal(content);
        }
        catch (Exception ex) {
            log.warn((Object)"Unsuccessfull password decryption", (Throwable)ex);
            return content;
        }
    }

    public String decode(String content) {
        try {
            if (content == null) {
                return null;
            }
            return new String(this.decode(Cipherer.dehexify(content)), "UTF-8");
        }
        catch (Exception ex) {
            log.warn((Object)"Password decrypted unsuccesfully.", (Throwable)ex);
            return new String(this.decode(Cipherer.dehexify(content)));
        }
    }

    public byte[] decode(byte[] content) {
        try {
            return this.D_CIPHER.doFinal(content);
        }
        catch (Exception ex) {
            log.warn((Object)"Unsuccessfull password decryption", (Throwable)ex);
            return content;
        }
    }

    public String decode(String content, Object booleanValue) {
        if (booleanValue == null || !(booleanValue instanceof String) || content == null) {
            return content;
        }
        boolean isEncrypted = new Boolean((String)booleanValue);
        if (isEncrypted) {
            return this.decode(content);
        }
        return content;
    }

    public static String hexify(byte[] data) {
        StringBuffer hex = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int highBits = (data[i] & 0xF0) >> 4;
            int lowBits = data[i] & 0xF;
            hex.append(hexChars[highBits]).append(hexChars[lowBits]);
        }
        return hex.toString();
    }

    public static byte[] dehexify(String data) {
        byte[] bytes = new byte[data.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)Integer.parseInt(data.substring(2 * i, 2 * i + 2), 16);
        }
        return bytes;
    }

    public void setKeyBytes(String inKeyBytes, boolean isPlainText) {
        if (isPlainText) {
            this.keyBytes = inKeyBytes.getBytes();
        } else {
            this.setKeyBytes(inKeyBytes);
        }
    }

    public void setKeyBytes(String inKeyBytes) {
        String[] keyStringArr = inKeyBytes.split("\\s+");
        this.keyBytes = new byte[keyStringArr.length];
        for (int i = 0; i < keyStringArr.length; ++i) {
            this.keyBytes[i] = Integer.decode(keyStringArr[i]).byteValue();
        }
    }

    public void setCipherTransformation(String cipherTransformation) {
        this.cipherTransformation = cipherTransformation;
    }

    public void setKeyAlgorithm(String keyAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
    }

    public static void test(String[] args) {
        String password = "Hello Dolly";
        byte[] passwd = null;
        Cipherer cip = new Cipherer();
        cip.setKeyBytes("this is my key bytes arg", true);
        cip.init();
        try {
            passwd = password.getBytes("UTF-8");
            System.out.println("passwd = " + new String(passwd) + " " + new String(passwd, "UTF-8"));
            byte[] encoded = cip.encode(passwd);
            System.out.println("Encoded = " + new String(encoded));
            String hex = Cipherer.hexify(encoded);
            System.out.println("Hexified bytes= " + hex);
            byte[] dehex = Cipherer.dehexify(hex);
            System.out.println("Dehexify = " + new String(dehex));
            System.out.println("valid = " + new String(encoded).equals(new String(dehex)));
            byte[] decoded = cip.decode(dehex);
            System.out.println("Decoded = " + new String(decoded));
            System.out.println("valid decode = " + new String(decoded).equals(password));
            String en = cip.encode(password);
            System.out.println("String encoded: " + en);
            String de = cip.decode(en);
            System.out.println("String decoded: " + de);
            System.out.println("string decoded = " + new String(de).equals(password));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) {
        String usage = "Usage: java com.panscopic.util.CipherUtils {options} <password>\nOptions:  \n-d      decrypts password\n-e      encrypts password";
        if (args.length < 2 || args[0] == null || args[1] == null) {
            System.out.println(usage);
            return;
        }
        Cipherer cip = new Cipherer();
        cip.setKeyBytes("this is my key bytes arg", true);
        cip.init();
        String option = args[0];
        String password = args[1];
        if (option.equals("-d")) {
            String de = cip.decode(password);
            System.out.println("The decoded password for <" + password + "> is <" + de + ">");
            System.out.println("The re-encoded password for <" + password + "> is <" + cip.encode(de) + ">");
        } else if (option.equals("-e")) {
            String en = cip.encode(password);
            System.out.println("The encoded password for <" + password + "> is <" + en + ">");
            System.out.println("The re-decoded password for <" + password + "> is <" + cip.decode(en) + ">");
        } else {
            System.out.println("Unknown option: <" + option + ">");
            System.out.println(usage);
            return;
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.keyBytes, (String)("keyBytes has not been set in " + Cipherer.class));
        Assert.notNull((Object)this.keyAlgorithm, (String)("keyAlgorithm has not been set in " + Cipherer.class));
        Assert.notNull((Object)this.cipherTransformation, (String)("cipherTransformation has not been set in " + Cipherer.class));
        this.init();
    }
}

