/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.JSExceptionWrapper;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import java.sql.Blob;
import java.sql.SQLException;
import net.sf.cglib.transform.impl.InterceptFieldCallback;
import net.sf.cglib.transform.impl.InterceptFieldEnabled;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Hibernate;

public class RepoFileResource
extends RepoResource
implements InterceptFieldEnabled {
    private transient InterceptFieldCallback $CGLIB_READ_WRITE_CALLBACK;
    private static final Log log;
    private String fileType;
    private Blob data;
    private RepoFileResource reference;

    @Override
    public InterceptFieldCallback getInterceptFieldCallback() {
        return this.$CGLIB_READ_WRITE_CALLBACK;
    }

    @Override
    public void setInterceptFieldCallback(InterceptFieldCallback interceptFieldCallback) {
        this.$CGLIB_READ_WRITE_CALLBACK = interceptFieldCallback;
    }

    public String $cglib_read_fileType() {
        String string = this.fileType;
        if (this.getInterceptFieldCallback() == null) {
            return string;
        }
        String string2 = string;
        return (String)this.getInterceptFieldCallback().readObject((Object)this, "fileType", (Object)string2);
    }

    public void $cglib_write_fileType(String string) {
        this.fileType = this.getInterceptFieldCallback() != null ? (String)this.getInterceptFieldCallback().writeObject((Object)this, "fileType", (Object)this.fileType, (Object)string) : string;
    }

    public Blob $cglib_read_data() {
        Blob blob = this.data;
        if (this.getInterceptFieldCallback() == null) {
            return blob;
        }
        Blob blob2 = blob;
        return (Blob)this.getInterceptFieldCallback().readObject((Object)this, "data", (Object)blob2);
    }

    public void $cglib_write_data(Blob blob) {
        this.data = this.getInterceptFieldCallback() != null ? (Blob)this.getInterceptFieldCallback().writeObject((Object)this, "data", (Object)this.data, (Object)blob) : blob;
    }

    public RepoFileResource $cglib_read_reference() {
        RepoFileResource repoFileResource = this.reference;
        if (this.getInterceptFieldCallback() == null) {
            return repoFileResource;
        }
        RepoFileResource repoFileResource2 = repoFileResource;
        return (RepoFileResource)this.getInterceptFieldCallback().readObject((Object)this, "reference", (Object)repoFileResource2);
    }

    public void $cglib_write_reference(RepoFileResource repoFileResource) {
        this.reference = this.getInterceptFieldCallback() != null ? (RepoFileResource)this.getInterceptFieldCallback().writeObject((Object)this, "reference", (Object)this.reference, (Object)repoFileResource) : repoFileResource;
    }

    public Blob getData() {
        return this.$cglib_read_data();
    }

    public void setData(Blob blob) {
        this.$cglib_write_data(blob);
    }

    public String getFileType() {
        return this.$cglib_read_fileType();
    }

    public void setFileType(String string) {
        this.$cglib_write_fileType(string);
    }

    public String getFinalFileType() {
        RepoFileResource repoFileResource = this;
        while (repoFileResource.isFileReference()) {
            repoFileResource = repoFileResource.getReference();
        }
        return repoFileResource.getFileType();
    }

    public boolean isFileReference() {
        return this.getReference() != null;
    }

    public RepoFileResource getReference() {
        return this.$cglib_read_reference();
    }

    public void setReference(RepoFileResource repoFileResource) {
        this.$cglib_write_reference(repoFileResource);
    }

    @Override
    protected Class getClientItf() {
        return FileResource.class;
    }

    @Override
    protected void copyTo(Resource resource, ResourceFactory resourceFactory) {
        super.copyTo(resource, resourceFactory);
        FileResource fileResource = (FileResource)resource;
        if (this.isFileReference()) {
            RepoFileResource repoFileResource = this.getReference();
            fileResource.setFileType(null);
            fileResource.setData(null);
            fileResource.setReferenceURI(repoFileResource.getResourceURI());
        } else {
            fileResource.setFileType(this.getFileType());
            if (this.hasClientOption("fullData")) {
                this.copyDataTo(fileResource);
            } else {
                fileResource.setData(null);
            }
            fileResource.setReferenceURI(null);
        }
    }

    protected void copyDataTo(FileResource fileResource) {
        Blob blob = this.getData();
        if (blob == null) {
            fileResource.setData(null);
        } else {
            try {
                fileResource.readData(blob.getBinaryStream());
            }
            catch (SQLException sQLException) {
                log.error((Object)("Error while reading data blob of \"" + this.getResourceURI() + "\""), (Throwable)sQLException);
                throw new JSExceptionWrapper((Exception)sQLException);
            }
        }
    }

    public FileResourceData copyData() {
        try {
            if (this.isFileReference()) {
                String string = "\"" + this.getResourceURI() + "\"";
                throw new JSException("jsexception.file.resource.is.reference", new Object[]{string});
            }
            Blob blob = this.getData();
            FileResourceData fileResourceData = blob == null ? new FileResourceData((byte[])null) : new FileResourceData(blob.getBinaryStream());
            return fileResourceData;
        }
        catch (SQLException sQLException) {
            log.error((Object)("Error while reading data blob of \"" + this.getResourceURI() + "\""), (Throwable)sQLException);
            throw new JSExceptionWrapper((Exception)sQLException);
        }
    }

    protected void copyDataFrom(FileResource fileResource) {
        if (fileResource.isReference()) {
            this.setData(null);
        } else if (fileResource.hasData()) {
            byte[] byArray = fileResource.getData();
            Blob blob = Hibernate.createBlob((byte[])byArray);
            this.setData(blob);
        }
    }

    @Override
    protected void copyFrom(Resource resource, ReferenceResolver referenceResolver) {
        super.copyFrom(resource, referenceResolver);
        FileResource fileResource = (FileResource)resource;
        if (fileResource.isReference()) {
            this.setFileType(null);
            this.setData(null);
            RepoFileResource repoFileResource = (RepoFileResource)referenceResolver.getExternalReference(fileResource.getReferenceURI(), RepoFileResource.class);
            if (fileResource.getFileType() != null && !fileResource.getFileType().equals(repoFileResource.getFinalFileType())) {
                throw new JSException("jsexception.file.resource.no.match.type", new Object[]{fileResource.getFileType(), repoFileResource.getFileType()});
            }
            this.setReference(repoFileResource);
        } else {
            this.setFileType(fileResource.getFileType());
            this.copyDataFrom(fileResource);
            this.setReference(null);
        }
    }

    static {
        RepoFileResource.CGLIB$STATICHOOK2();
        log = LogFactory.getLog(RepoFileResource.class);
    }

    static void CGLIB$STATICHOOK2() {
    }
}

