/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.datasource;

import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.service.ResourceFactory;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.ReferenceResolver;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoDataSource;
import com.jaspersoft.jasperserver.api.metadata.common.service.impl.hibernate.persistent.RepoResource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.VirtualReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.impl.datasource.RepoReportDataSource;
import java.util.HashMap;
import java.util.Map;

public class RepoVirtualDataSource
extends RepoDataSource
implements RepoReportDataSource {
    private String timezone;
    private Map<String, RepoResource> dataSourceUriMap;

    public Map<String, RepoResource> getDataSourceUriMap() {
        return this.dataSourceUriMap;
    }

    public void setDataSourceUriMap(Map<String, RepoResource> dataSourceUriMap) {
        this.dataSourceUriMap = dataSourceUriMap;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    @Override
    protected Class getClientItf() {
        return VirtualReportDataSource.class;
    }

    @Override
    protected void copyTo(Resource clientRes, ResourceFactory resourceFactory) {
        super.copyTo(clientRes, resourceFactory);
        VirtualReportDataSource ds = (VirtualReportDataSource)clientRes;
        if (this.dataSourceUriMap != null) {
            HashMap<String, ResourceReference> clientDataSourceUriMap = new HashMap<String, ResourceReference>();
            for (Map.Entry<String, RepoResource> entry : this.dataSourceUriMap.entrySet()) {
                ResourceReference resourceReference = this.getClientReference(entry.getValue(), resourceFactory);
                clientDataSourceUriMap.put(entry.getKey(), resourceReference);
            }
            ds.setDataSourceUriMap(clientDataSourceUriMap);
        }
        ds.setTimezone(this.getTimezone());
    }

    @Override
    protected void copyFrom(Resource clientRes, ReferenceResolver referenceResolver) {
        super.copyFrom(clientRes, referenceResolver);
        VirtualReportDataSource ds = (VirtualReportDataSource)clientRes;
        if (ds.getDataSourceUriMap() == null) {
            this.setDataSourceUriMap(null);
        } else {
            HashMap<String, RepoResource> repoDataSourceUriMap = new HashMap<String, RepoResource>();
            for (Map.Entry entry : ds.getDataSourceUriMap().entrySet()) {
                RepoResource repoResource = this.getReference((ResourceReference)entry.getValue(), RepoResource.class, referenceResolver);
                repoDataSourceUriMap.put((String)entry.getKey(), repoResource);
            }
            this.setDataSourceUriMap(repoDataSourceUriMap);
        }
        this.setTimezone(ds.getTimezone());
    }
}

