/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.security;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.metadata.user.domain.ObjectPermission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.security.AccessDeniedException;
import org.springframework.security.Authentication;
import org.springframework.security.ConfigAttribute;
import org.springframework.security.ConfigAttributeDefinition;
import org.springframework.security.afterinvocation.AfterInvocationProvider;
import org.springframework.security.vote.AccessDecisionVoter;

public abstract class BasicObjectPermissionArgumentVoter
implements AccessDecisionVoter,
AfterInvocationProvider {
    public boolean supports(Class clazz) {
        return MethodInvocation.class.isAssignableFrom(clazz) || ObjectPermission.class.isAssignableFrom(clazz) || Collection.class.isAssignableFrom(clazz);
    }

    public int vote(Authentication authentication, Object object, ConfigAttributeDefinition config) {
        int result = 0;
        if (this.supports(object, config)) {
            if (this.isPrivileged(object)) {
                result = 1;
            } else {
                Collection<ObjectPermission> permissions = this.getObjectPermissions(object);
                if (permissions != null && !permissions.isEmpty()) {
                    result = 1;
                    for (ObjectPermission permission : permissions) {
                        if (this.isPermitted(authentication, permission, object)) continue;
                        result = -1;
                        break;
                    }
                }
            }
        }
        return result;
    }

    public Object decide(Authentication authentication, Object object, ConfigAttributeDefinition config, Object returnedObject) throws AccessDeniedException {
        if (this.supports(object, config)) {
            if (returnedObject instanceof Collection) {
                Collection<ObjectPermission> returned = this.getObjectPermissions(returnedObject);
                LinkedList<ObjectPermission> res = new LinkedList<ObjectPermission>();
                for (ObjectPermission permission : returned) {
                    if (!this.isPermitted(authentication, permission, object)) continue;
                    res.add(permission);
                }
                returnedObject = res;
            } else if (returnedObject instanceof ObjectPermission && !this.isPermitted(authentication, (ObjectPermission)returnedObject, object)) {
                returnedObject = null;
            }
        }
        return returnedObject;
    }

    protected boolean supports(Object object, ConfigAttributeDefinition config) {
        boolean supports = false;
        if (object != null && this.supports(object.getClass()) && config != null && config.getConfigAttributes() != null) {
            Collection configAttributes = config.getConfigAttributes();
            for (ConfigAttribute configAttribute : configAttributes) {
                if (!this.supports(configAttribute)) continue;
                supports = true;
                break;
            }
        }
        return supports;
    }

    protected Collection<ObjectPermission> getObjectPermissions(Object object) {
        Object[] arguments;
        ArrayList<ObjectPermission> permissions = new ArrayList<ObjectPermission>();
        if (object instanceof ObjectPermission) {
            permissions.add((ObjectPermission)object);
        } else if (object instanceof Collection) {
            Collection collection = (Collection)object;
            if (!collection.isEmpty() && collection.iterator().next() instanceof ObjectPermission) {
                permissions.addAll(collection);
            }
        } else if (object instanceof MethodInvocation && (arguments = ((MethodInvocation)object).getArguments()) != null) {
            for (Object argument : arguments) {
                permissions.addAll(this.getObjectPermissions(argument));
            }
        }
        return permissions;
    }

    protected abstract boolean isPermitted(Authentication var1, ObjectPermission var2, Object var3);

    private boolean isPrivileged(Object object) {
        Object[] arguments;
        if (object instanceof MethodInvocation && (arguments = ((MethodInvocation)object).getArguments()) != null) {
            for (Object argument : arguments) {
                if (!(argument instanceof ExecutionContext) || !((ExecutionContext)argument).getAttributes().contains("PRIVILEGED_OPERATION")) continue;
                return true;
            }
        }
        return false;
    }
}

