/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.internalAuth;

import com.jaspersoft.jasperserver.api.metadata.user.domain.impl.client.MetadataUserDetails;
import com.jaspersoft.jasperserver.api.metadata.user.service.impl.UserIsNotInternalException;
import com.jaspersoft.jasperserver.api.security.internalAuth.InternalAuthenticationTokenImpl;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.providers.UsernamePasswordAuthenticationToken;
import org.springframework.security.providers.dao.DaoAuthenticationProvider;
import org.springframework.security.userdetails.UserDetails;

public class InternalDaoAuthenticationProvider
extends DaoAuthenticationProvider {
    protected void additionalAuthenticationChecks(UserDetails userDetails, UsernamePasswordAuthenticationToken authentication) throws AuthenticationException {
        if (!(userDetails instanceof MetadataUserDetails) || ((MetadataUserDetails)userDetails).isExternallyDefined()) {
            throw new UserIsNotInternalException("User needs to be internal to be authenticated by " + ((Object)((Object)this)).getClass());
        }
        super.additionalAuthenticationChecks(userDetails, authentication);
    }

    protected Authentication createSuccessAuthentication(Object principal, Authentication authentication, UserDetails user) {
        InternalAuthenticationTokenImpl result = new InternalAuthenticationTokenImpl(principal, authentication.getCredentials(), user.getAuthorities());
        result.setDetails(authentication.getDetails());
        return result;
    }
}

