/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.security.validators;

import com.jaspersoft.jasperserver.api.JSSecurityException;
import com.jaspersoft.jasperserver.api.security.SecurityConfiguration;
import com.jaspersoft.jasperserver.api.security.validators.ValidatorRule;
import com.jaspersoft.jasperserver.api.security.validators.ValidatorRuleImpl;
import com.jaspersoft.jasperserver.core.util.JSONUtil;
import com.jaspersoft.jasperserver.core.util.StringUtil;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.StringUtilities;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public class Validator {
    private static final Logger log = Logger.getLogger(Validator.class);
    private static final String RULES_LOCATION = "esapi/security.properties";
    public static final String SQL_QUERY_EXECUTOR_RULE_KEY = "sqlQueryExecutor";
    private static final String MSG_VALIDATION_SQL = "message.validation.sql";
    private static final String ERR_MSG_SQL_VALIDATION = "An error has occurred. Please contact your system administrator. (56632)";
    private static final String LOG_SECURITY_FAILURE_CONTEXT = "[SECURITY FAILURE context=";
    private static final String LOG_SECURITY_FAILURE_KEY = ", key=";
    private static final String LOG_SECURITY_FAILURE_TYPE = ", type(";
    private static final String LOG_SECURITY_FAILURE_PATTERN = ")=";
    private static final String LOG_SECURITY_FAILURE_INPUT = ", input=";
    private static final String LOG_SECURITY_FAILURE_MAXLENGTH = ", maxLength=";
    private static final String LOG_SECURITY_FAILURE_BLACKLIST = ", isBlacklist=";
    private static final String END_BRACKET = "]";
    private static final String UNKNOWN_KEY_OR_VALUE = "unknown";
    private static MessageSource messages;
    private static Map<String, ValidatorRule> validationRules;
    private static final ValidatorRule DEFAULT_VALIDATION_RULE;

    private Validator() {
    }

    private static void loadInputValidationConfig() {
        if (validationRules != null) {
            return;
        }
        Properties validationConfig = new Properties();
        try {
            InputStream is = Validator.class.getClassLoader().getResourceAsStream(RULES_LOCATION);
            validationConfig.load(is);
            is.close();
        }
        catch (Exception e) {
            throw new JSSecurityException("Input validation configuration cannot be loaded.", (Throwable)e);
        }
        Validator.resolveValidationProperties(validationConfig);
        validationRules = Validator.resolveInputValidationRules(validationConfig);
    }

    private static void resolveValidationProperties(Properties validationConfig) {
        Set<String> configPropertyNames = validationConfig.stringPropertyNames();
        for (Props prop : Props.values()) {
            if (!configPropertyNames.contains(prop.toString())) continue;
            prop.set(validationConfig.getProperty(prop.toString()));
        }
    }

    private static Map<String, ValidatorRule> resolveInputValidationRules(Properties validationConfig) {
        HashMap<String, ValidatorRule> validationRules = new HashMap<String, ValidatorRule>();
        try {
            for (String propName : validationConfig.stringPropertyNames()) {
                if (Props.getStringList().contains(propName)) continue;
                String[] propValues = validationConfig.getProperty(propName).split("\\" + (String)Props.DEFAULT_DELIMITER.get());
                validationRules.put(propName, new ValidatorRuleImpl(propValues[0], propValues[1], Integer.parseInt(propValues[2]), Boolean.parseBoolean(propValues[3]), propValues[4]));
            }
        }
        catch (Exception e) {
            throw new JSSecurityException("Input validation configuration cannot be resolved.", (Throwable)e);
        }
        return validationRules;
    }

    private static void setESAPISecurityConf() {
        ESAPI.initialize((String)"com.jaspersoft.jasperserver.api.security.JSESAPISecurityConfiguration");
    }

    public static boolean validateRequestParams(HttpServletRequest request) {
        if (!SecurityConfiguration.isInputValidationOn()) {
            return true;
        }
        Map requestParamMap = StringUtil.getDecodedMap((Map)request.getParameterMap(), (String)((String)Props.DEFAULT_ENCODING.get()), (String)((String)Props.DEFAULT_MESSAGE_ENCODING_ERROR.get()));
        if (requestParamMap.size() == 0) {
            return true;
        }
        for (Map.Entry reqNameValuePair : requestParamMap.entrySet()) {
            final String reqParamKey = (String)reqNameValuePair.getKey();
            List reqParamAttribValueList = (List)request.getAttribute("DECRYPTED." + reqParamKey);
            Object[] reqParamValueArr = reqParamAttribValueList != null ? reqParamAttribValueList.toArray() : (Object[])reqNameValuePair.getValue();
            List<ValidatorRule> validationRuleList = Validator.getRulesForParameter(reqParamKey);
            if (validationRuleList == null || validationRuleList.size() == 0) {
                validationRuleList = Arrays.asList(DEFAULT_VALIDATION_RULE);
            }
            boolean allRulesFailed = true;
            for (ValidatorRule paramRule : validationRuleList) {
                final boolean[] allParamValuesValid = new boolean[]{true};
                for (Object reqParamValue : reqParamValueArr) {
                    JSONObject reqJsonObj = JSONUtil.getJSONObject((String)reqParamValue.toString());
                    JSONArray reqJsonArr = JSONUtil.getJSONArray((String)reqParamValue.toString());
                    if (reqJsonObj != null || reqJsonArr != null && reqJsonArr.length() != 0) {
                        JSONUtil.applyFunctorToJson((Object)(reqJsonObj != null ? reqJsonObj : reqJsonArr), (JSONUtil.Functor)new JSONUtil.Functor(){

                            public String call(String jsonKey, String jsonValue) {
                                List<ValidatorRule> validJsonRuleList;
                                if (jsonKey == null) {
                                    jsonKey = reqParamKey;
                                }
                                if ((validJsonRuleList = Validator.getRulesForParameter(jsonKey)) == null || validJsonRuleList.size() == 0) {
                                    validJsonRuleList = Arrays.asList(DEFAULT_VALIDATION_RULE);
                                }
                                for (ValidatorRule rule : validJsonRuleList) {
                                    if (Validator.isParamValueValid(reqParamKey + "-" + jsonKey, jsonValue, rule)) continue;
                                    allParamValuesValid[0] = false;
                                    return null;
                                }
                                return jsonValue;
                            }
                        });
                    }
                    if (allParamValuesValid[0] && Validator.isParamValueValid(reqParamKey, reqParamValue.toString(), paramRule)) continue;
                    allParamValuesValid[0] = false;
                    break;
                }
                if (!allParamValuesValid[0]) continue;
                allRulesFailed = false;
                break;
            }
            if (!allRulesFailed) continue;
            return false;
        }
        return true;
    }

    public static boolean isParamValueValid(String paramName, String paramValue, ValidatorRule rule) {
        boolean doesInputSatisfyValidationRule;
        if (!SecurityConfiguration.isInputValidationOn()) {
            return true;
        }
        if (rule == null) {
            throw new IllegalArgumentException("Missing validation rule.");
        }
        if (StringUtilities.isEmpty((String)paramValue)) {
            return rule.isAllowNull();
        }
        if (((Boolean)Props.DEFAULT_CANONICALIZE.get()).booleanValue()) {
            paramValue = ESAPI.encoder().canonicalize(paramValue);
        }
        if ((doesInputSatisfyValidationRule = ESAPI.validator().isValidInput(rule.getContext(), paramValue, rule.getValueValidationKey(), rule.getMaxLength(), rule.isAllowNull(), false)) && rule.isBlacklistRule() || !doesInputSatisfyValidationRule && !rule.isBlacklistRule()) {
            Validator.logSecurityFailure(paramName, paramValue, rule);
            return false;
        }
        return true;
    }

    private static void logSecurityFailure(String key, String value, ValidatorRule rule) {
        key = key == null ? UNKNOWN_KEY_OR_VALUE : key;
        value = value == null ? UNKNOWN_KEY_OR_VALUE : value;
        StringBuilder errMsg = new StringBuilder();
        errMsg.append(LOG_SECURITY_FAILURE_CONTEXT).append(rule.getContext());
        errMsg.append(LOG_SECURITY_FAILURE_KEY).append(key);
        errMsg.append(LOG_SECURITY_FAILURE_TYPE).append(rule.getValueValidationKey());
        errMsg.append(LOG_SECURITY_FAILURE_PATTERN).append(ESAPI.securityConfiguration().getValidationPattern(rule.getValueValidationKey()));
        errMsg.append(LOG_SECURITY_FAILURE_INPUT).append(value);
        if (rule != null) {
            errMsg.append(LOG_SECURITY_FAILURE_MAXLENGTH).append(rule.getMaxLength()).append(LOG_SECURITY_FAILURE_BLACKLIST).append(rule.isBlacklistRule()).append(END_BRACKET);
        } else {
            errMsg.append(LOG_SECURITY_FAILURE_MAXLENGTH).append(UNKNOWN_KEY_OR_VALUE).append(LOG_SECURITY_FAILURE_BLACKLIST).append(UNKNOWN_KEY_OR_VALUE).append(END_BRACKET);
        }
        log.error((Object)errMsg.toString());
    }

    public static boolean isParamValueValid(String paramName, String paramValue, String valueValidationExpression) {
        ValidatorRuleImpl rule = new ValidatorRuleImpl(DEFAULT_VALIDATION_RULE.getParamValidationKey(), valueValidationExpression, DEFAULT_VALIDATION_RULE.getMaxLength(), DEFAULT_VALIDATION_RULE.isAllowNull(), DEFAULT_VALIDATION_RULE.getContext());
        return Validator.isParamValueValid(paramName, paramValue, rule);
    }

    public static boolean isValueValid(String value, String validatorRuleName) {
        ValidatorRuleImpl rule = new ValidatorRuleImpl(DEFAULT_VALIDATION_RULE.getParamValidationKey(), validatorRuleName, DEFAULT_VALIDATION_RULE.getMaxLength(), DEFAULT_VALIDATION_RULE.isAllowNull(), DEFAULT_VALIDATION_RULE.getContext());
        return Validator.isParamValueValid("genericKey", value, rule);
    }

    @Deprecated
    public static boolean isParamNameValid(String paramName, ValidatorRule rule) {
        if (!SecurityConfiguration.isInputValidationOn()) {
            return true;
        }
        if (rule == null) {
            throw new IllegalArgumentException("Missing validation rule.");
        }
        if (((Boolean)Props.DEFAULT_CANONICALIZE.get()).booleanValue()) {
            paramName = ESAPI.encoder().canonicalize(paramName);
        }
        return ESAPI.validator().isValidInput(rule.getContext(), paramName, rule.getParamValidationKey(), rule.getMaxLength(), rule.isAllowNull(), false);
    }

    public static boolean validateSQL(String queryOrParamString) {
        if (!SecurityConfiguration.isSQLValidationOn() || queryOrParamString == null) {
            return true;
        }
        queryOrParamString = queryOrParamString.trim().replaceAll("[;]+$", "");
        List<ValidatorRule> validationRuleList = Validator.getRulesForParameter(SQL_QUERY_EXECUTOR_RULE_KEY);
        if (validationRuleList != null) {
            for (ValidatorRule rule : validationRuleList) {
                boolean isSQLValid;
                boolean isInputNonEmptyStrings = StringUtil.checkAllInputStringsNonEmpty((String[])new String[]{queryOrParamString, rule.getContext(), rule.getValueValidationKey()});
                if (!isInputNonEmptyStrings || rule.getMaxLength() <= 0) continue;
                String sqlCommentsRegexp = SecurityConfiguration.getProperty("security.validation.sql.comments.regexp");
                if (sqlCommentsRegexp != null && !sqlCommentsRegexp.isEmpty()) {
                    Pattern regex = Pattern.compile(sqlCommentsRegexp, 40);
                    queryOrParamString = regex.matcher(queryOrParamString).replaceAll("");
                }
                if (isSQLValid = ESAPI.validator().isValidInput(rule.getContext(), queryOrParamString, rule.getValueValidationKey(), rule.getMaxLength(), false)) continue;
                String errMsg = messages == null ? ERR_MSG_SQL_VALIDATION : messages.getMessage(MSG_VALIDATION_SQL, new Object[0], LocaleContextHolder.getLocale());
                log.error((Object)("Invalid SQL:" + errMsg + ", SQL: " + queryOrParamString));
                throw new JSSecurityException(errMsg);
            }
        }
        return true;
    }

    private static List<ValidatorRule> getRulesForParameter(String paramName) {
        ArrayList<ValidatorRule> paramRules = new ArrayList<ValidatorRule>();
        if (!validationRules.containsKey(paramName)) {
            return paramRules;
        }
        paramRules.add(validationRules.get(paramName));
        int count = 2;
        while (validationRules.containsKey(paramName + count)) {
            paramRules.add(validationRules.get(paramName + count));
            ++count;
        }
        return paramRules;
    }

    public static String getDefaultEncoding() {
        return (String)Props.DEFAULT_ENCODING.get();
    }

    public static String getDefaultEncodingErrorMessage() {
        return (String)Props.DEFAULT_MESSAGE_ENCODING_ERROR.get();
    }

    public void setMessages(MessageSource messages) {
        Validator.messages = messages;
    }

    public MessageSource getMessages() {
        return messages;
    }

    static {
        Validator.setESAPISecurityConf();
        Validator.loadInputValidationConfig();
        List<ValidatorRule> defRules = Validator.getRulesForParameter((String)Props.DEFAULT_RULE_NAME.get());
        DEFAULT_VALIDATION_RULE = defRules.isEmpty() ? new ValidatorRuleImpl((String)Props.DEFAULT_PARAM_NAME_VALIDATION_KEY.get(), (String)Props.DEFAULT_VALUE_VALIDATION_KEY.get(), (Integer)Props.DEFAULT_MAX_LENGTH.get(), (Boolean)Props.DEFAULT_ALLOW_NULL.get(), (String)Props.DEFAULT_VALUE_VALIDATION_CONTEXT.get()) : defRules.get(0);
    }

    static enum Props {
        DEFAULT_PARAM_NAME_VALIDATION_KEY(String.class, "Alpha"),
        DEFAULT_VALUE_VALIDATION_CONTEXT(String.class, "DEFAULT"),
        DEFAULT_VALUE_VALIDATION_KEY(String.class, "AlphaNumPunctuationBrackets"),
        DEFAULT_MAX_LENGTH(Integer.class, "200000"),
        DEFAULT_ALLOW_NULL(Boolean.class, "true"),
        DEFAULT_RULE_NAME(String.class, "DEFAULT"),
        DEFAULT_DELIMITER(String.class, ","),
        DEFAULT_ENCODING(String.class, "UTF-8"),
        DEFAULT_CANONICALIZE(Boolean.class, "true"),
        DEFAULT_MESSAGE_MISSING_RULE(String.class, "No rule for parameter [%s]. Using default validation on input=[%s]."),
        DEFAULT_MESSAGE_ENCODING_ERROR(String.class, "Please make sure your web application server is set to URIEncoding=UTF-8.");

        private Class clazz;
        private Object value;

        private Props(Class clazz, String defaultValue) {
            this.clazz = clazz;
            this.set(defaultValue);
        }

        public void set(String value) {
            this.value = this.clazz.equals(Integer.class) ? Integer.valueOf(Integer.parseInt(value)) : (this.clazz.equals(Boolean.class) ? Boolean.valueOf(Boolean.parseBoolean(value)) : value);
        }

        public <T> T get() {
            return (T)this.value;
        }

        public static Set<String> getStringList() {
            HashSet<String> stringSet = new HashSet<String>();
            for (Props prop : Props.values()) {
                stringSet.add(prop.toString());
            }
            return stringSet;
        }
    }
}

