/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.types.basic;

import org.teiid.core.BundleUtil;
import org.teiid.core.CorePlugin;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Transform;
import org.teiid.core.types.TransformationException;

public class ObjectToAnyTransform
extends Transform {
    private Class targetClass;

    public ObjectToAnyTransform(Class targetClass) {
        this.targetClass = targetClass;
    }

    public Class getSourceType() {
        return DataTypeManager.DefaultDataClasses.OBJECT;
    }

    public Class getTargetType() {
        return this.targetClass;
    }

    @Override
    public Object transformDirect(Object value) throws TransformationException {
        if (this.targetClass.isAssignableFrom(value.getClass())) {
            return value;
        }
        Transform transform = DataTypeManager.getTransform(value.getClass(), this.getTargetType());
        if (transform == null || transform instanceof ObjectToAnyTransform) {
            Object[] params = new Object[]{this.getSourceType(), this.targetClass, value};
            throw new TransformationException((BundleUtil.Event)CorePlugin.Event.TEIID10076, CorePlugin.Util.gs(CorePlugin.Event.TEIID10076, params));
        }
        try {
            return transform.transform(value);
        }
        catch (TransformationException e) {
            Object[] params = new Object[]{this.getSourceType(), this.targetClass, value};
            throw new TransformationException(CorePlugin.Event.TEIID10076, e, CorePlugin.Util.gs(CorePlugin.Event.TEIID10076, params));
        }
    }

    @Override
    public boolean isExplicit() {
        return true;
    }
}

