/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.client;

import com.jaspersoft.jasperserver.api.common.domain.ValidationResult;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.InputControl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceReference;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ResourceImpl;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportDataSource;
import com.jaspersoft.jasperserver.api.metadata.jasperreports.domain.ReportUnit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ReportUnitImpl
extends ResourceImpl
implements ReportUnit,
Serializable {
    private ResourceReference dataSource = null;
    private ResourceReference query = null;
    private List inputControls;
    private ResourceReference mainReport = null;
    private List resources = new ArrayList();
    private String inputControlRenderingView;
    private String reportRenderingView;
    private boolean alwaysPromptControls;
    private byte controlsLayout = 1;
    private Long dataSnapshotId;

    public ReportUnitImpl() {
        this.inputControls = new ArrayList();
    }

    @Override
    public ResourceReference getDataSource() {
        return this.dataSource;
    }

    @Override
    public void setDataSource(ResourceReference dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public void setDataSource(ReportDataSource dataSource) {
        this.setDataSource(new ResourceReference(dataSource));
    }

    @Override
    public void setDataSourceReference(String referenceURI) {
        this.setDataSource(new ResourceReference(referenceURI));
    }

    @Override
    public ResourceReference getQuery() {
        return this.query;
    }

    @Override
    public void setQuery(ResourceReference query) {
        this.query = query;
    }

    public List getInputControls() {
        return this.inputControls;
    }

    @Override
    public ResourceReference getMainReport() {
        return this.mainReport;
    }

    @Override
    public InputControl getInputControl(String name) {
        ListIterator it = this.inputControlsLocalNameLocator(name).positionBefore();
        InputControl inputControl = it.hasNext() ? (InputControl)((ResourceReference)it.next()).getLocalResource() : null;
        return inputControl;
    }

    @Override
    public void setMainReport(ResourceReference mainReport) {
        this.mainReport = mainReport;
    }

    @Override
    public void setMainReport(FileResource report) {
        this.setMainReport(new ResourceReference(report));
    }

    @Override
    public void setMainReportReference(String referenceURI) {
        this.setMainReport(new ResourceReference(referenceURI));
    }

    @Override
    public List getResources() {
        return this.resources;
    }

    public FileResource getResource(String name) {
        FileResource resource = null;
        if (this.resources != null && !this.resources.isEmpty()) {
            for (FileResource res : this.resources) {
                if (!res.getName().equals(name)) continue;
                resource = res;
                break;
            }
        }
        return resource;
    }

    @Override
    public void setResources(List resources) {
        this.resources = resources;
    }

    @Override
    public String getInputControlRenderingView() {
        return this.inputControlRenderingView;
    }

    @Override
    public String getReportRenderingView() {
        return this.reportRenderingView;
    }

    @Override
    public void setInputControlRenderingView(String viewName) {
        this.inputControlRenderingView = viewName;
    }

    @Override
    public void setReportRenderingView(String viewName) {
        this.reportRenderingView = viewName;
    }

    @Override
    public boolean isAlwaysPromptControls() {
        return this.alwaysPromptControls;
    }

    @Override
    public void setAlwaysPromptControls(boolean alwaysPromptControls) {
        this.alwaysPromptControls = alwaysPromptControls;
    }

    @Override
    public byte getControlsLayout() {
        return this.controlsLayout;
    }

    @Override
    public void setControlsLayout(byte controlsLayout) {
        this.controlsLayout = controlsLayout;
    }

    @Override
    public void addResource(ResourceReference resourceReference) {
        this.resources.add(resourceReference);
    }

    @Override
    public void addResourceReference(String referenceURI) {
        this.addResource(new ResourceReference(referenceURI));
    }

    @Override
    public void addResource(FileResource resource) {
        this.addResource(new ResourceReference(resource));
    }

    @Override
    public ResourceReference removeResource(int index) {
        return (ResourceReference)this.resources.remove(index);
    }

    @Override
    public FileResource removeResourceLocal(String name) {
        FileResource removed = null;
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            FileResource resource;
            ResourceReference resourceRef = (ResourceReference)it.next();
            if (!resourceRef.isLocal() || !(resource = (FileResource)resourceRef.getLocalResource()).getName().equals(name)) continue;
            it.remove();
            removed = resource;
            break;
        }
        return removed;
    }

    @Override
    public boolean removeResourceReference(String referenceURI) {
        boolean removed = false;
        Iterator it = this.resources.iterator();
        while (it.hasNext()) {
            ResourceReference resourceRef = (ResourceReference)it.next();
            if (resourceRef.isLocal() || !resourceRef.getReferenceURI().equals(referenceURI)) continue;
            it.remove();
            removed = true;
            break;
        }
        return removed;
    }

    @Override
    public ValidationResult validate() {
        return null;
    }

    @Override
    public void addInputControl(ResourceReference inputControlReference) {
        this.inputControls.add(inputControlReference);
    }

    @Override
    public void addInputControlReference(String referenceURI) {
        this.addInputControl(new ResourceReference(referenceURI));
    }

    public void setInputControls(List inputControls) {
        this.inputControls = inputControls;
    }

    @Override
    public void addInputControl(InputControl inputControl) {
        this.addInputControl(new ResourceReference(inputControl));
    }

    @Override
    public ResourceReference removeInputControl(int index) {
        return (ResourceReference)this.inputControls.remove(index);
    }

    @Override
    public InputControl removeInputControlLocal(String name) {
        InputControl removed;
        ListIterator it = this.inputControlsLocalNameLocator(name).positionBefore();
        if (it.hasNext()) {
            removed = (InputControl)((ResourceReference)it.next()).getLocalResource();
            it.remove();
        } else {
            removed = null;
        }
        return removed;
    }

    @Override
    public boolean removeInputControlReference(String referenceURI) {
        ListIterator it = this.inputControlsReferenceLocator(referenceURI).positionBefore();
        boolean remove = it.hasNext();
        if (remove) {
            it.remove();
        }
        return remove;
    }

    protected ResourceListLocalNameLocator inputControlsLocalNameLocator(String name) {
        return new ResourceListLocalNameLocator(this.inputControls, name);
    }

    protected ResourceListReferenceLocator inputControlsReferenceLocator(String referenceURI) {
        return new ResourceListReferenceLocator(this.inputControls, referenceURI);
    }

    @Override
    public void replaceInputControlLocal(String name, ResourceReference inputControlReference) {
        this.replaceInputControl(this.inputControlsLocalNameLocator(name), inputControlReference);
    }

    @Override
    public void replaceInputControlReference(String referenceURI, ResourceReference inputControlReference) {
        this.replaceInputControl(this.inputControlsReferenceLocator(referenceURI), inputControlReference);
    }

    @Override
    public void replaceInputControlLocal(String name, String newReferenceURI) {
        this.replaceInputControl(this.inputControlsLocalNameLocator(name), new ResourceReference(newReferenceURI));
    }

    @Override
    public void replaceInputControlLocal(String name, InputControl inputControl) {
        this.replaceInputControl(this.inputControlsLocalNameLocator(name), new ResourceReference(inputControl));
    }

    @Override
    public void replaceInputControlReference(String referenceURI, String newReferenceURI) {
        this.replaceInputControl(this.inputControlsReferenceLocator(referenceURI), new ResourceReference(newReferenceURI));
    }

    @Override
    public void replaceInputControlReference(String referenceURI, InputControl inputControl) {
        this.replaceInputControl(this.inputControlsReferenceLocator(referenceURI), new ResourceReference(inputControl));
    }

    protected void replaceInputControl(ResourceListLocator locator, ResourceReference inputControlRef) {
        ListIterator it = locator.positionBefore();
        if (it.hasNext()) {
            it.next();
            it.set(inputControlRef);
        } else {
            it.add(inputControlRef);
        }
    }

    @Override
    public FileResource getResourceLocal(String name) {
        FileResource resource = null;
        if (this.resources != null && !this.resources.isEmpty()) {
            for (ResourceReference resourceRef : this.resources) {
                FileResource res;
                if (!resourceRef.isLocal() || !(res = (FileResource)resourceRef.getLocalResource()).getName().equals(name)) continue;
                resource = res;
                break;
            }
        }
        return resource;
    }

    @Override
    protected Class getImplementingItf() {
        return ReportUnit.class;
    }

    @Override
    public Long getDataSnapshotId() {
        return this.dataSnapshotId;
    }

    @Override
    public void setDataSnapshotId(Long dataSnapshotId) {
        this.dataSnapshotId = dataSnapshotId;
    }

    protected static class ResourceListLocalNameLocator
    extends ResourceListLocator {
        private final String localName;

        public ResourceListLocalNameLocator(List resources, String localName) {
            super(resources);
            this.localName = localName;
        }

        @Override
        protected boolean matches(ResourceReference ref) {
            return ref.isLocal() && ref.getLocalResource().getName().equals(this.localName);
        }
    }

    protected static class ResourceListReferenceLocator
    extends ResourceListLocator {
        private final String referenceURI;

        public ResourceListReferenceLocator(List resources, String referenceURI) {
            super(resources);
            this.referenceURI = referenceURI;
        }

        @Override
        protected boolean matches(ResourceReference ref) {
            return !ref.isLocal() && ref.getReferenceURI().equals(this.referenceURI);
        }
    }

    protected static abstract class ResourceListLocator {
        private final List resources;

        public ResourceListLocator(List resources) {
            this.resources = resources;
        }

        public ListIterator positionBefore() {
            ListIterator it = this.resources.listIterator();
            while (it.hasNext()) {
                ResourceReference ref = (ResourceReference)it.next();
                if (!this.matches(ref)) continue;
                it.previous();
                break;
            }
            return it;
        }

        protected abstract boolean matches(ResourceReference var1);
    }
}

