/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.metadata.common.domain;

import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import java.io.IOException;
import java.io.InputStream;

public class SelfCleaningFileResourceDataWrapper
extends FileResourceData {
    public SelfCleaningFileResourceDataWrapper(FileResourceData object) {
        super(object);
    }

    @Override
    public InputStream getDataStream() {
        return new SelfCleaningStreamWrapper(super.getDataStream());
    }

    private class SelfCleaningStreamWrapper
    extends InputStream {
        InputStream stream;

        SelfCleaningStreamWrapper(InputStream stream) {
            this.stream = stream;
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            int read = this.stream.read(b);
            if (read == -1) {
                SelfCleaningFileResourceDataWrapper.this.dispose();
            }
            return read;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int read = this.stream.read(b, off, len);
            if (read == -1) {
                SelfCleaningFileResourceDataWrapper.this.dispose();
            }
            return read;
        }

        @Override
        public long skip(long n) throws IOException {
            return this.stream.skip(n);
        }

        @Override
        public int available() throws IOException {
            return this.stream.available();
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }

        @Override
        public void mark(int readlimit) {
            this.stream.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }
    }
}

