/*
 * Decompiled with CFR 0.152.
 */
package mondrian.calc.impl;

import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.TupleCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.calc.impl.MemberValueCalc;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.fun.TupleFunDef;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

public class TupleValueCalc
extends GenericCalc {
    private final TupleCalc tupleCalc;

    public TupleValueCalc(Exp exp, TupleCalc tupleCalc) {
        super(exp);
        this.tupleCalc = tupleCalc;
    }

    public Object evaluate(Evaluator evaluator) {
        Member[] members = this.tupleCalc.evaluateTuple(evaluator);
        if (members == null) {
            return null;
        }
        boolean needToReturnNull = evaluator.needToReturnNullForUnrelatedDimension(members);
        if (needToReturnNull) {
            return null;
        }
        Member[] savedMembers = new Member[members.length];
        for (int i = 0; i < members.length; ++i) {
            savedMembers[i] = evaluator.setContext(members[i]);
        }
        Object result = evaluator.evaluateCurrent();
        evaluator.setContext(savedMembers);
        return result;
    }

    public Calc[] getCalcs() {
        return new Calc[]{this.tupleCalc};
    }

    public boolean dependsOn(Hierarchy hierarchy) {
        if (super.dependsOn(hierarchy)) {
            return true;
        }
        for (Type type : ((TupleType)this.tupleCalc.getType()).elementTypes) {
            if (!type.usesHierarchy(hierarchy, true)) continue;
            return false;
        }
        return true;
    }

    public Calc optimize() {
        if (this.tupleCalc instanceof TupleFunDef.CalcImpl) {
            TupleFunDef.CalcImpl calc = (TupleFunDef.CalcImpl)this.tupleCalc;
            return new MemberValueCalc((Exp)new DummyExp(this.type), calc.getMemberCalcs());
        }
        return this;
    }
}

