/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import mondrian.olap.DimensionType;
import mondrian.olap.Util;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.Dialect;
import org.eigenbase.xom.DOMElementParser;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.NodeDef;
import org.eigenbase.xom.XMLAttrVector;
import org.eigenbase.xom.XMLOutput;
import org.eigenbase.xom.XOMException;

public class MondrianDef {
    public static String[] _elements = new String[]{"Schema", "CubeDimension", "Cube", "VirtualCube", "CubeUsages", "CubeUsage", "VirtualCubeDimension", "VirtualCubeMeasure", "DimensionUsage", "Dimension", "Hierarchy", "Level", "Closure", "Property", "Measure", "CalculatedMember", "CalculatedMemberProperty", "NamedSet", "Formula", "MemberReaderParameter", "RelationOrJoin", "Relation", "View", "SQL", "Join", "Table", "Hint", "InlineTable", "ColumnDefs", "ColumnDef", "Rows", "Row", "Value", "AggTable", "AggName", "AggPattern", "AggExclude", "AggColumnName", "AggFactCount", "AggIgnoreColumn", "AggForeignKey", "AggLevel", "AggMeasure", "Expression", "Column", "ExpressionView", "KeyExpression", "ParentExpression", "OrdinalExpression", "NameExpression", "CaptionExpression", "MeasureExpression", "Role", "Grant", "SchemaGrant", "CubeGrant", "DimensionGrant", "HierarchyGrant", "MemberGrant", "Union", "RoleUsage", "UserDefinedFunction", "Parameter", "Annotations", "Annotation"};

    public static Class getXMLDefClass() {
        return MondrianDef.class;
    }

    public static class Annotation
    extends ElementDef {
        public String name;
        public String cdata;

        public Annotation() {
        }

        public Annotation(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.cdata = _parser.getText();
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Annotation";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Annotation.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Annotation.displayString((PrintWriter)_out, (String)"cdata", (String)this.cdata, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Annotation", new XMLAttrVector().add("name", (Object)this.name));
            _out.cdata(this.cdata);
            _out.endTag("Annotation");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Annotation _cother = (Annotation)_other;
            boolean _diff = Annotation.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Annotation.displayStringDiff((String)"cdata", (String)this.cdata, (String)_cother.cdata, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Annotations
    extends ElementDef {
        public Annotation[] array;

        public Annotations() {
        }

        public Annotations(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Annotation.class, 0, 0);
                this.array = new Annotation[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Annotation)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Annotations";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Annotations.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Annotations", new XMLAttrVector());
            Annotations.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Annotations");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Annotations _cother = (Annotations)_other;
            boolean _diff = Annotations.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Parameter
    extends ElementDef {
        public String name;
        public String description;
        public static final String[] _type_values = new String[]{"String", "Numeric", "Integer", "Boolean", "Date", "Time", "Timestamp", "Member"};
        public String type;
        public Boolean modifiable;
        public String defaultValue;

        public Parameter() {
        }

        public Parameter(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.type = (String)_parser.getAttribute("type", "String", "String", _type_values, true);
                this.modifiable = (Boolean)_parser.getAttribute("modifiable", "Boolean", "true", null, false);
                this.defaultValue = (String)_parser.getAttribute("defaultValue", "String", null, null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Parameter";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Parameter.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Parameter.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Parameter.displayAttribute((PrintWriter)_out, (String)"type", (Object)this.type, (int)(_indent + 1));
            Parameter.displayAttribute((PrintWriter)_out, (String)"modifiable", (Object)this.modifiable, (int)(_indent + 1));
            Parameter.displayAttribute((PrintWriter)_out, (String)"defaultValue", (Object)this.defaultValue, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Parameter", new XMLAttrVector().add("name", (Object)this.name).add("description", (Object)this.description).add("type", (Object)this.type).add("modifiable", (Object)this.modifiable).add("defaultValue", (Object)this.defaultValue));
            _out.endTag("Parameter");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Parameter _cother = (Parameter)_other;
            boolean _diff = Parameter.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Parameter.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Parameter.displayAttributeDiff((String)"type", (Object)this.type, (Object)_cother.type, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Parameter.displayAttributeDiff((String)"modifiable", (Object)this.modifiable, (Object)_cother.modifiable, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Parameter.displayAttributeDiff((String)"defaultValue", (Object)this.defaultValue, (Object)_cother.defaultValue, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class UserDefinedFunction
    extends ElementDef {
        public String name;
        public String className;

        public UserDefinedFunction() {
        }

        public UserDefinedFunction(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.className = (String)_parser.getAttribute("className", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "UserDefinedFunction";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            UserDefinedFunction.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            UserDefinedFunction.displayAttribute((PrintWriter)_out, (String)"className", (Object)this.className, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("UserDefinedFunction", new XMLAttrVector().add("name", (Object)this.name).add("className", (Object)this.className));
            _out.endTag("UserDefinedFunction");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            UserDefinedFunction _cother = (UserDefinedFunction)_other;
            boolean _diff = UserDefinedFunction.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && UserDefinedFunction.displayAttributeDiff((String)"className", (Object)this.className, (Object)_cother.className, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class RoleUsage
    extends ElementDef {
        public String roleName;

        public RoleUsage() {
        }

        public RoleUsage(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.roleName = (String)_parser.getAttribute("roleName", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "RoleUsage";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            RoleUsage.displayAttribute((PrintWriter)_out, (String)"roleName", (Object)this.roleName, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("RoleUsage", new XMLAttrVector().add("roleName", (Object)this.roleName));
            _out.endTag("RoleUsage");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            RoleUsage _cother = (RoleUsage)_other;
            boolean _diff = RoleUsage.displayAttributeDiff((String)"roleName", (Object)this.roleName, (Object)_cother.roleName, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Union
    extends ElementDef {
        public RoleUsage[] roleUsages;

        public Union() {
        }

        public Union(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(RoleUsage.class, 0, 0);
                this.roleUsages = new RoleUsage[_tempArray.length];
                for (int _i = 0; _i < this.roleUsages.length; ++_i) {
                    this.roleUsages[_i] = (RoleUsage)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Union";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Union.displayElementArray((PrintWriter)_out, (String)"roleUsages", (NodeDef[])this.roleUsages, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Union", new XMLAttrVector());
            Union.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.roleUsages);
            _out.endTag("Union");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Union _cother = (Union)_other;
            boolean _diff = Union.displayElementArrayDiff((String)"roleUsages", (NodeDef[])this.roleUsages, (NodeDef[])_cother.roleUsages, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class MemberGrant
    extends ElementDef {
        public String member;
        public static final String[] _access_values = new String[]{"all", "none"};
        public String access;

        public MemberGrant() {
        }

        public MemberGrant(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.member = (String)_parser.getAttribute("member", "String", null, null, true);
                this.access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "MemberGrant";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            MemberGrant.displayAttribute((PrintWriter)_out, (String)"member", (Object)this.member, (int)(_indent + 1));
            MemberGrant.displayAttribute((PrintWriter)_out, (String)"access", (Object)this.access, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("MemberGrant", new XMLAttrVector().add("member", (Object)this.member).add("access", (Object)this.access));
            _out.endTag("MemberGrant");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            MemberGrant _cother = (MemberGrant)_other;
            boolean _diff = MemberGrant.displayAttributeDiff((String)"member", (Object)this.member, (Object)_cother.member, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && MemberGrant.displayAttributeDiff((String)"access", (Object)this.access, (Object)_cother.access, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class HierarchyGrant
    extends Grant {
        public String hierarchy;
        public String topLevel;
        public String bottomLevel;
        public String rollupPolicy;
        public MemberGrant[] memberGrants;

        public HierarchyGrant() {
        }

        public HierarchyGrant(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.hierarchy = (String)_parser.getAttribute("hierarchy", "String", null, null, true);
                this.topLevel = (String)_parser.getAttribute("topLevel", "String", null, null, false);
                this.bottomLevel = (String)_parser.getAttribute("bottomLevel", "String", null, null, false);
                this.rollupPolicy = (String)_parser.getAttribute("rollupPolicy", "String", null, null, false);
                this.access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
                NodeDef[] _tempArray = _parser.getArray(MemberGrant.class, 0, 0);
                this.memberGrants = new MemberGrant[_tempArray.length];
                for (int _i = 0; _i < this.memberGrants.length; ++_i) {
                    this.memberGrants[_i] = (MemberGrant)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "HierarchyGrant";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            HierarchyGrant.displayAttribute((PrintWriter)_out, (String)"hierarchy", (Object)this.hierarchy, (int)(_indent + 1));
            HierarchyGrant.displayAttribute((PrintWriter)_out, (String)"topLevel", (Object)this.topLevel, (int)(_indent + 1));
            HierarchyGrant.displayAttribute((PrintWriter)_out, (String)"bottomLevel", (Object)this.bottomLevel, (int)(_indent + 1));
            HierarchyGrant.displayAttribute((PrintWriter)_out, (String)"rollupPolicy", (Object)this.rollupPolicy, (int)(_indent + 1));
            HierarchyGrant.displayAttribute((PrintWriter)_out, (String)"access", (Object)this.access, (int)(_indent + 1));
            HierarchyGrant.displayElementArray((PrintWriter)_out, (String)"memberGrants", (NodeDef[])this.memberGrants, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("HierarchyGrant", new XMLAttrVector().add("hierarchy", (Object)this.hierarchy).add("topLevel", (Object)this.topLevel).add("bottomLevel", (Object)this.bottomLevel).add("rollupPolicy", (Object)this.rollupPolicy).add("access", (Object)this.access));
            HierarchyGrant.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.memberGrants);
            _out.endTag("HierarchyGrant");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            HierarchyGrant _cother = (HierarchyGrant)_other;
            boolean _diff = HierarchyGrant.displayAttributeDiff((String)"hierarchy", (Object)this.hierarchy, (Object)_cother.hierarchy, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && HierarchyGrant.displayAttributeDiff((String)"topLevel", (Object)this.topLevel, (Object)_cother.topLevel, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && HierarchyGrant.displayAttributeDiff((String)"bottomLevel", (Object)this.bottomLevel, (Object)_cother.bottomLevel, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && HierarchyGrant.displayAttributeDiff((String)"rollupPolicy", (Object)this.rollupPolicy, (Object)_cother.rollupPolicy, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && HierarchyGrant.displayElementArrayDiff((String)"memberGrants", (NodeDef[])this.memberGrants, (NodeDef[])_cother.memberGrants, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class DimensionGrant
    extends Grant {
        public String dimension;

        public DimensionGrant() {
        }

        public DimensionGrant(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.dimension = (String)_parser.getAttribute("dimension", "String", null, null, true);
                this.access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "DimensionGrant";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            DimensionGrant.displayAttribute((PrintWriter)_out, (String)"dimension", (Object)this.dimension, (int)(_indent + 1));
            DimensionGrant.displayAttribute((PrintWriter)_out, (String)"access", (Object)this.access, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("DimensionGrant", new XMLAttrVector().add("dimension", (Object)this.dimension).add("access", (Object)this.access));
            _out.endTag("DimensionGrant");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            DimensionGrant _cother = (DimensionGrant)_other;
            boolean _diff = DimensionGrant.displayAttributeDiff((String)"dimension", (Object)this.dimension, (Object)_cother.dimension, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class CubeGrant
    extends Grant {
        public String cube;
        public DimensionGrant[] dimensionGrants;
        public HierarchyGrant[] hierarchyGrants;

        public CubeGrant() {
        }

        public CubeGrant(DOMWrapper _def) throws XOMException {
            try {
                int _i;
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.cube = (String)_parser.getAttribute("cube", "String", null, null, true);
                this.access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
                NodeDef[] _tempArray = _parser.getArray(DimensionGrant.class, 0, 0);
                this.dimensionGrants = new DimensionGrant[_tempArray.length];
                for (_i = 0; _i < this.dimensionGrants.length; ++_i) {
                    this.dimensionGrants[_i] = (DimensionGrant)_tempArray[_i];
                }
                _tempArray = _parser.getArray(HierarchyGrant.class, 0, 0);
                this.hierarchyGrants = new HierarchyGrant[_tempArray.length];
                for (_i = 0; _i < this.hierarchyGrants.length; ++_i) {
                    this.hierarchyGrants[_i] = (HierarchyGrant)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "CubeGrant";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            CubeGrant.displayAttribute((PrintWriter)_out, (String)"cube", (Object)this.cube, (int)(_indent + 1));
            CubeGrant.displayAttribute((PrintWriter)_out, (String)"access", (Object)this.access, (int)(_indent + 1));
            CubeGrant.displayElementArray((PrintWriter)_out, (String)"dimensionGrants", (NodeDef[])this.dimensionGrants, (int)(_indent + 1));
            CubeGrant.displayElementArray((PrintWriter)_out, (String)"hierarchyGrants", (NodeDef[])this.hierarchyGrants, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("CubeGrant", new XMLAttrVector().add("cube", (Object)this.cube).add("access", (Object)this.access));
            CubeGrant.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.dimensionGrants);
            CubeGrant.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.hierarchyGrants);
            _out.endTag("CubeGrant");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            CubeGrant _cother = (CubeGrant)_other;
            boolean _diff = CubeGrant.displayAttributeDiff((String)"cube", (Object)this.cube, (Object)_cother.cube, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CubeGrant.displayElementArrayDiff((String)"dimensionGrants", (NodeDef[])this.dimensionGrants, (NodeDef[])_cother.dimensionGrants, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CubeGrant.displayElementArrayDiff((String)"hierarchyGrants", (NodeDef[])this.hierarchyGrants, (NodeDef[])_cother.hierarchyGrants, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class SchemaGrant
    extends Grant {
        public CubeGrant[] cubeGrants;

        public SchemaGrant() {
        }

        public SchemaGrant(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
                NodeDef[] _tempArray = _parser.getArray(CubeGrant.class, 0, 0);
                this.cubeGrants = new CubeGrant[_tempArray.length];
                for (int _i = 0; _i < this.cubeGrants.length; ++_i) {
                    this.cubeGrants[_i] = (CubeGrant)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "SchemaGrant";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            SchemaGrant.displayAttribute((PrintWriter)_out, (String)"access", (Object)this.access, (int)(_indent + 1));
            SchemaGrant.displayElementArray((PrintWriter)_out, (String)"cubeGrants", (NodeDef[])this.cubeGrants, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("SchemaGrant", new XMLAttrVector().add("access", (Object)this.access));
            SchemaGrant.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.cubeGrants);
            _out.endTag("SchemaGrant");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            SchemaGrant _cother = (SchemaGrant)_other;
            boolean _diff = SchemaGrant.displayElementArrayDiff((String)"cubeGrants", (NodeDef[])this.cubeGrants, (NodeDef[])_cother.cubeGrants, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static abstract class Grant
    extends ElementDef {
        public static final String[] _access_values = new String[]{"all", "custom", "none", "all_dimensions"};
        public String access;

        public Grant() {
        }

        public Grant(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.access = (String)_parser.getAttribute("access", "String", null, _access_values, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Grant";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Grant.displayAttribute((PrintWriter)_out, (String)"access", (Object)this.access, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("(%Grant;)", new XMLAttrVector().add("access", (Object)this.access));
            _out.endTag("(%Grant;)");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Grant _cother = (Grant)_other;
            boolean _diff = Grant.displayAttributeDiff((String)"access", (Object)this.access, (Object)_cother.access, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Role
    extends ElementDef {
        public String name;
        public Annotations annotations;
        public SchemaGrant[] schemaGrants;
        public Union union;

        public Role() {
        }

        public Role(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.annotations = (Annotations)_parser.getElement(Annotations.class, false);
                NodeDef[] _tempArray = _parser.getArray(SchemaGrant.class, 0, 0);
                this.schemaGrants = new SchemaGrant[_tempArray.length];
                for (int _i = 0; _i < this.schemaGrants.length; ++_i) {
                    this.schemaGrants[_i] = (SchemaGrant)_tempArray[_i];
                }
                this.union = (Union)_parser.getElement(Union.class, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Role";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Role.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Role.displayElement((PrintWriter)_out, (String)"annotations", (ElementDef)this.annotations, (int)(_indent + 1));
            Role.displayElementArray((PrintWriter)_out, (String)"schemaGrants", (NodeDef[])this.schemaGrants, (int)(_indent + 1));
            Role.displayElement((PrintWriter)_out, (String)"union", (ElementDef)this.union, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Role", new XMLAttrVector().add("name", (Object)this.name));
            Role.displayXMLElement((XMLOutput)_out, (ElementDef)this.annotations);
            Role.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.schemaGrants);
            Role.displayXMLElement((XMLOutput)_out, (ElementDef)this.union);
            _out.endTag("Role");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Role _cother = (Role)_other;
            boolean _diff = Role.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Role.displayElementDiff((String)"annotations", (NodeDef)this.annotations, (NodeDef)_cother.annotations, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Role.displayElementArrayDiff((String)"schemaGrants", (NodeDef[])this.schemaGrants, (NodeDef[])_cother.schemaGrants, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Role.displayElementDiff((String)"union", (NodeDef)this.union, (NodeDef)_cother.union, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class MeasureExpression
    extends ExpressionView {
        public MeasureExpression() {
        }

        public MeasureExpression(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(SQL.class, 1, 0);
                this.expressions = new SQL[_tempArray.length];
                for (int _i = 0; _i < this.expressions.length; ++_i) {
                    this.expressions[_i] = (SQL)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "MeasureExpression";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            MeasureExpression.displayElementArray((PrintWriter)_out, (String)"expressions", (NodeDef[])this.expressions, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("MeasureExpression", new XMLAttrVector());
            MeasureExpression.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.expressions);
            _out.endTag("MeasureExpression");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            MeasureExpression _cother = (MeasureExpression)_other;
            boolean _diff = MeasureExpression.displayElementArrayDiff((String)"expressions", (NodeDef[])this.expressions, (NodeDef[])_cother.expressions, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class CaptionExpression
    extends ExpressionView {
        public CaptionExpression() {
        }

        public CaptionExpression(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(SQL.class, 1, 0);
                this.expressions = new SQL[_tempArray.length];
                for (int _i = 0; _i < this.expressions.length; ++_i) {
                    this.expressions[_i] = (SQL)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "CaptionExpression";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            CaptionExpression.displayElementArray((PrintWriter)_out, (String)"expressions", (NodeDef[])this.expressions, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("CaptionExpression", new XMLAttrVector());
            CaptionExpression.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.expressions);
            _out.endTag("CaptionExpression");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            CaptionExpression _cother = (CaptionExpression)_other;
            boolean _diff = CaptionExpression.displayElementArrayDiff((String)"expressions", (NodeDef[])this.expressions, (NodeDef[])_cother.expressions, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class NameExpression
    extends ExpressionView {
        public NameExpression() {
        }

        public NameExpression(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(SQL.class, 1, 0);
                this.expressions = new SQL[_tempArray.length];
                for (int _i = 0; _i < this.expressions.length; ++_i) {
                    this.expressions[_i] = (SQL)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "NameExpression";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            NameExpression.displayElementArray((PrintWriter)_out, (String)"expressions", (NodeDef[])this.expressions, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("NameExpression", new XMLAttrVector());
            NameExpression.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.expressions);
            _out.endTag("NameExpression");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            NameExpression _cother = (NameExpression)_other;
            boolean _diff = NameExpression.displayElementArrayDiff((String)"expressions", (NodeDef[])this.expressions, (NodeDef[])_cother.expressions, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class OrdinalExpression
    extends ExpressionView {
        public OrdinalExpression() {
        }

        public OrdinalExpression(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(SQL.class, 1, 0);
                this.expressions = new SQL[_tempArray.length];
                for (int _i = 0; _i < this.expressions.length; ++_i) {
                    this.expressions[_i] = (SQL)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "OrdinalExpression";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            OrdinalExpression.displayElementArray((PrintWriter)_out, (String)"expressions", (NodeDef[])this.expressions, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("OrdinalExpression", new XMLAttrVector());
            OrdinalExpression.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.expressions);
            _out.endTag("OrdinalExpression");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            OrdinalExpression _cother = (OrdinalExpression)_other;
            boolean _diff = OrdinalExpression.displayElementArrayDiff((String)"expressions", (NodeDef[])this.expressions, (NodeDef[])_cother.expressions, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class ParentExpression
    extends ExpressionView {
        public ParentExpression() {
        }

        public ParentExpression(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(SQL.class, 1, 0);
                this.expressions = new SQL[_tempArray.length];
                for (int _i = 0; _i < this.expressions.length; ++_i) {
                    this.expressions[_i] = (SQL)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "ParentExpression";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            ParentExpression.displayElementArray((PrintWriter)_out, (String)"expressions", (NodeDef[])this.expressions, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("ParentExpression", new XMLAttrVector());
            ParentExpression.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.expressions);
            _out.endTag("ParentExpression");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            ParentExpression _cother = (ParentExpression)_other;
            boolean _diff = ParentExpression.displayElementArrayDiff((String)"expressions", (NodeDef[])this.expressions, (NodeDef[])_cother.expressions, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class KeyExpression
    extends ExpressionView {
        public KeyExpression() {
        }

        public KeyExpression(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(SQL.class, 1, 0);
                this.expressions = new SQL[_tempArray.length];
                for (int _i = 0; _i < this.expressions.length; ++_i) {
                    this.expressions[_i] = (SQL)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "KeyExpression";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            KeyExpression.displayElementArray((PrintWriter)_out, (String)"expressions", (NodeDef[])this.expressions, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("KeyExpression", new XMLAttrVector());
            KeyExpression.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.expressions);
            _out.endTag("KeyExpression");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            KeyExpression _cother = (KeyExpression)_other;
            boolean _diff = KeyExpression.displayElementArrayDiff((String)"expressions", (NodeDef[])this.expressions, (NodeDef[])_cother.expressions, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static abstract class ExpressionView
    extends Expression {
        public SQL[] expressions;

        public ExpressionView() {
        }

        public ExpressionView(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(SQL.class, 1, 0);
                this.expressions = new SQL[_tempArray.length];
                for (int _i = 0; _i < this.expressions.length; ++_i) {
                    this.expressions[_i] = (SQL)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "ExpressionView";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            ExpressionView.displayElementArray((PrintWriter)_out, (String)"expressions", (NodeDef[])this.expressions, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("(%ExpressionView;)", new XMLAttrVector());
            ExpressionView.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.expressions);
            _out.endTag("(%ExpressionView;)");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            ExpressionView _cother = (ExpressionView)_other;
            boolean _diff = ExpressionView.displayElementArrayDiff((String)"expressions", (NodeDef[])this.expressions, (NodeDef[])_cother.expressions, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String toString() {
            return this.expressions[0].cdata;
        }

        public String getExpression(SqlQuery query) {
            return SQL.toCodeSet(this.expressions).chooseQuery(query.getDialect());
        }

        public String getGenericExpression() {
            for (int i = 0; i < this.expressions.length; ++i) {
                if (!this.expressions[i].dialect.equals("generic")) continue;
                return this.expressions[i].cdata;
            }
            return this.expressions[0].cdata;
        }

        public String getTableAlias() {
            return null;
        }

        public int hashCode() {
            int h = 17;
            for (int i = 0; i < this.expressions.length; ++i) {
                h = 37 * h + this.expressions[i].hashCode();
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ExpressionView)) {
                return false;
            }
            ExpressionView that = (ExpressionView)((Object)obj);
            if (this.expressions.length != that.expressions.length) {
                return false;
            }
            for (int i = 0; i < this.expressions.length; ++i) {
                if (this.expressions[i].equals((Object)that.expressions[i])) continue;
                return false;
            }
            return true;
        }
    }

    public static class Column
    extends Expression {
        public String table;
        public String name;

        public Column() {
        }

        public Column(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.table = (String)_parser.getAttribute("table", "String", null, null, false);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Column";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Column.displayAttribute((PrintWriter)_out, (String)"table", (Object)this.table, (int)(_indent + 1));
            Column.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Column", new XMLAttrVector().add("table", (Object)this.table).add("name", (Object)this.name));
            _out.endTag("Column");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Column _cother = (Column)_other;
            boolean _diff = Column.displayAttributeDiff((String)"table", (Object)this.table, (Object)_cother.table, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Column.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public Column(String table, String name) {
            this();
            Util.assertTrue(name != null);
            this.table = table;
            this.name = name;
        }

        public String getExpression(SqlQuery query) {
            return query.getDialect().quoteIdentifier(this.table, this.name);
        }

        public String getGenericExpression() {
            if (this.table == null) {
                return this.name;
            }
            return this.table + "." + this.name;
        }

        public String getColumnName() {
            return this.name;
        }

        public String getTableAlias() {
            return this.table;
        }

        public int hashCode() {
            return this.name.hashCode() ^ (this.table == null ? 0 : this.table.hashCode());
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Column)) {
                return false;
            }
            Column that = (Column)((Object)obj);
            return this.name.equals(that.name) && Util.equals(this.table, that.table);
        }
    }

    public static abstract class Expression
    extends ElementDef {
        public Expression() {
        }

        public Expression(DOMWrapper _def) throws XOMException {
        }

        public String getName() {
            return "Expression";
        }

        public void display(PrintWriter _out, int _indent) {
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("(%Expression;)", new XMLAttrVector());
            _out.endTag("(%Expression;)");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            return true;
        }

        public abstract String getExpression(SqlQuery var1);

        public abstract String getGenericExpression();

        public abstract String getTableAlias();
    }

    public static class AggMeasure
    extends ElementDef {
        public String column;
        public String name;

        public AggMeasure() {
        }

        public AggMeasure(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.column = (String)_parser.getAttribute("column", "String", null, null, true);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggMeasure";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggMeasure.displayAttribute((PrintWriter)_out, (String)"column", (Object)this.column, (int)(_indent + 1));
            AggMeasure.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggMeasure", new XMLAttrVector().add("column", (Object)this.column).add("name", (Object)this.name));
            _out.endTag("AggMeasure");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggMeasure _cother = (AggMeasure)_other;
            boolean _diff = AggMeasure.displayAttributeDiff((String)"column", (Object)this.column, (Object)_cother.column, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggMeasure.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getNameAttribute() {
            return this.name;
        }

        public String getColumn() {
            return this.column;
        }
    }

    public static class AggLevel
    extends ElementDef {
        public String column;
        public String name;

        public AggLevel() {
        }

        public AggLevel(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.column = (String)_parser.getAttribute("column", "String", null, null, true);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggLevel";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggLevel.displayAttribute((PrintWriter)_out, (String)"column", (Object)this.column, (int)(_indent + 1));
            AggLevel.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggLevel", new XMLAttrVector().add("column", (Object)this.column).add("name", (Object)this.name));
            _out.endTag("AggLevel");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggLevel _cother = (AggLevel)_other;
            boolean _diff = AggLevel.displayAttributeDiff((String)"column", (Object)this.column, (Object)_cother.column, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggLevel.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getNameAttribute() {
            return this.name;
        }

        public String getColumnName() {
            return this.column;
        }
    }

    public static class AggForeignKey
    extends ElementDef {
        public String factColumn;
        public String aggColumn;

        public AggForeignKey() {
        }

        public AggForeignKey(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.factColumn = (String)_parser.getAttribute("factColumn", "String", null, null, true);
                this.aggColumn = (String)_parser.getAttribute("aggColumn", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggForeignKey";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggForeignKey.displayAttribute((PrintWriter)_out, (String)"factColumn", (Object)this.factColumn, (int)(_indent + 1));
            AggForeignKey.displayAttribute((PrintWriter)_out, (String)"aggColumn", (Object)this.aggColumn, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggForeignKey", new XMLAttrVector().add("factColumn", (Object)this.factColumn).add("aggColumn", (Object)this.aggColumn));
            _out.endTag("AggForeignKey");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggForeignKey _cother = (AggForeignKey)_other;
            boolean _diff = AggForeignKey.displayAttributeDiff((String)"factColumn", (Object)this.factColumn, (Object)_cother.factColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggForeignKey.displayAttributeDiff((String)"aggColumn", (Object)this.aggColumn, (Object)_cother.aggColumn, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getFactFKColumnName() {
            return this.factColumn;
        }

        public String getAggregateFKColumnName() {
            return this.aggColumn;
        }
    }

    public static class AggIgnoreColumn
    extends AggColumnName {
        public AggIgnoreColumn() {
        }

        public AggIgnoreColumn(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.column = (String)_parser.getAttribute("column", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggIgnoreColumn";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggIgnoreColumn.displayAttribute((PrintWriter)_out, (String)"column", (Object)this.column, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggIgnoreColumn", new XMLAttrVector().add("column", (Object)this.column));
            _out.endTag("AggIgnoreColumn");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggIgnoreColumn _cother = (AggIgnoreColumn)_other;
            return true;
        }
    }

    public static class AggFactCount
    extends AggColumnName {
        public AggFactCount() {
        }

        public AggFactCount(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.column = (String)_parser.getAttribute("column", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggFactCount";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggFactCount.displayAttribute((PrintWriter)_out, (String)"column", (Object)this.column, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggFactCount", new XMLAttrVector().add("column", (Object)this.column));
            _out.endTag("AggFactCount");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggFactCount _cother = (AggFactCount)_other;
            return true;
        }
    }

    public static abstract class AggColumnName
    extends ElementDef {
        public String column;

        public AggColumnName() {
        }

        public AggColumnName(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.column = (String)_parser.getAttribute("column", "String", null, null, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggColumnName";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggColumnName.displayAttribute((PrintWriter)_out, (String)"column", (Object)this.column, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("(%AggColumnName;)", new XMLAttrVector().add("column", (Object)this.column));
            _out.endTag("(%AggColumnName;)");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggColumnName _cother = (AggColumnName)_other;
            boolean _diff = AggColumnName.displayAttributeDiff((String)"column", (Object)this.column, (Object)_cother.column, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getColumnName() {
            return this.column;
        }
    }

    public static class AggExclude
    extends ElementDef {
        public String pattern;
        public String name;
        public Boolean ignorecase;

        public AggExclude() {
        }

        public AggExclude(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.pattern = (String)_parser.getAttribute("pattern", "String", null, null, false);
                this.name = (String)_parser.getAttribute("name", "String", null, null, false);
                this.ignorecase = (Boolean)_parser.getAttribute("ignorecase", "Boolean", "true", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggExclude";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggExclude.displayAttribute((PrintWriter)_out, (String)"pattern", (Object)this.pattern, (int)(_indent + 1));
            AggExclude.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            AggExclude.displayAttribute((PrintWriter)_out, (String)"ignorecase", (Object)this.ignorecase, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggExclude", new XMLAttrVector().add("pattern", (Object)this.pattern).add("name", (Object)this.name).add("ignorecase", (Object)this.ignorecase));
            _out.endTag("AggExclude");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggExclude _cother = (AggExclude)_other;
            boolean _diff = AggExclude.displayAttributeDiff((String)"pattern", (Object)this.pattern, (Object)_cother.pattern, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggExclude.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggExclude.displayAttributeDiff((String)"ignorecase", (Object)this.ignorecase, (Object)_cother.ignorecase, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getNameAttribute() {
            return this.name;
        }

        public String getPattern() {
            return this.pattern;
        }

        public boolean isIgnoreCase() {
            return this.ignorecase;
        }
    }

    public static class AggPattern
    extends AggTable {
        public String pattern;
        public AggExclude[] excludes;

        public AggPattern() {
        }

        public AggPattern(DOMWrapper _def) throws XOMException {
            try {
                int _i;
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.pattern = (String)_parser.getAttribute("pattern", "String", null, null, true);
                this.ignorecase = (Boolean)_parser.getAttribute("ignorecase", "Boolean", "true", null, false);
                this.factcount = (AggFactCount)_parser.getElement(AggFactCount.class, true);
                NodeDef[] _tempArray = _parser.getArray(AggIgnoreColumn.class, 0, 0);
                this.ignoreColumns = new AggIgnoreColumn[_tempArray.length];
                for (_i = 0; _i < this.ignoreColumns.length; ++_i) {
                    this.ignoreColumns[_i] = (AggIgnoreColumn)_tempArray[_i];
                }
                _tempArray = _parser.getArray(AggForeignKey.class, 0, 0);
                this.foreignKeys = new AggForeignKey[_tempArray.length];
                for (_i = 0; _i < this.foreignKeys.length; ++_i) {
                    this.foreignKeys[_i] = (AggForeignKey)_tempArray[_i];
                }
                _tempArray = _parser.getArray(AggMeasure.class, 0, 0);
                this.measures = new AggMeasure[_tempArray.length];
                for (_i = 0; _i < this.measures.length; ++_i) {
                    this.measures[_i] = (AggMeasure)_tempArray[_i];
                }
                _tempArray = _parser.getArray(AggLevel.class, 0, 0);
                this.levels = new AggLevel[_tempArray.length];
                for (_i = 0; _i < this.levels.length; ++_i) {
                    this.levels[_i] = (AggLevel)_tempArray[_i];
                }
                _tempArray = _parser.getArray(AggExclude.class, 0, 0);
                this.excludes = new AggExclude[_tempArray.length];
                for (_i = 0; _i < this.excludes.length; ++_i) {
                    this.excludes[_i] = (AggExclude)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggPattern";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggPattern.displayAttribute((PrintWriter)_out, (String)"pattern", (Object)this.pattern, (int)(_indent + 1));
            AggPattern.displayAttribute((PrintWriter)_out, (String)"ignorecase", (Object)this.ignorecase, (int)(_indent + 1));
            AggPattern.displayElement((PrintWriter)_out, (String)"factcount", (ElementDef)this.factcount, (int)(_indent + 1));
            AggPattern.displayElementArray((PrintWriter)_out, (String)"ignoreColumns", (NodeDef[])this.ignoreColumns, (int)(_indent + 1));
            AggPattern.displayElementArray((PrintWriter)_out, (String)"foreignKeys", (NodeDef[])this.foreignKeys, (int)(_indent + 1));
            AggPattern.displayElementArray((PrintWriter)_out, (String)"measures", (NodeDef[])this.measures, (int)(_indent + 1));
            AggPattern.displayElementArray((PrintWriter)_out, (String)"levels", (NodeDef[])this.levels, (int)(_indent + 1));
            AggPattern.displayElementArray((PrintWriter)_out, (String)"excludes", (NodeDef[])this.excludes, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggPattern", new XMLAttrVector().add("pattern", (Object)this.pattern).add("ignorecase", (Object)this.ignorecase));
            AggPattern.displayXMLElement((XMLOutput)_out, (ElementDef)this.factcount);
            AggPattern.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.ignoreColumns);
            AggPattern.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.foreignKeys);
            AggPattern.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.measures);
            AggPattern.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.levels);
            AggPattern.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.excludes);
            _out.endTag("AggPattern");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggPattern _cother = (AggPattern)_other;
            boolean _diff = AggPattern.displayAttributeDiff((String)"pattern", (Object)this.pattern, (Object)_cother.pattern, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggPattern.displayElementDiff((String)"factcount", (NodeDef)this.factcount, (NodeDef)_cother.factcount, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggPattern.displayElementArrayDiff((String)"ignoreColumns", (NodeDef[])this.ignoreColumns, (NodeDef[])_cother.ignoreColumns, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggPattern.displayElementArrayDiff((String)"foreignKeys", (NodeDef[])this.foreignKeys, (NodeDef[])_cother.foreignKeys, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggPattern.displayElementArrayDiff((String)"measures", (NodeDef[])this.measures, (NodeDef[])_cother.measures, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggPattern.displayElementArrayDiff((String)"levels", (NodeDef[])this.levels, (NodeDef[])_cother.levels, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggPattern.displayElementArrayDiff((String)"excludes", (NodeDef[])this.excludes, (NodeDef[])_cother.excludes, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getPattern() {
            return this.pattern;
        }

        public AggExclude[] getAggExcludes() {
            return this.excludes;
        }
    }

    public static class AggName
    extends AggTable {
        public String name;

        public AggName() {
        }

        public AggName(DOMWrapper _def) throws XOMException {
            try {
                int _i;
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.ignorecase = (Boolean)_parser.getAttribute("ignorecase", "Boolean", "true", null, false);
                this.factcount = (AggFactCount)_parser.getElement(AggFactCount.class, true);
                NodeDef[] _tempArray = _parser.getArray(AggIgnoreColumn.class, 0, 0);
                this.ignoreColumns = new AggIgnoreColumn[_tempArray.length];
                for (_i = 0; _i < this.ignoreColumns.length; ++_i) {
                    this.ignoreColumns[_i] = (AggIgnoreColumn)_tempArray[_i];
                }
                _tempArray = _parser.getArray(AggForeignKey.class, 0, 0);
                this.foreignKeys = new AggForeignKey[_tempArray.length];
                for (_i = 0; _i < this.foreignKeys.length; ++_i) {
                    this.foreignKeys[_i] = (AggForeignKey)_tempArray[_i];
                }
                _tempArray = _parser.getArray(AggMeasure.class, 0, 0);
                this.measures = new AggMeasure[_tempArray.length];
                for (_i = 0; _i < this.measures.length; ++_i) {
                    this.measures[_i] = (AggMeasure)_tempArray[_i];
                }
                _tempArray = _parser.getArray(AggLevel.class, 0, 0);
                this.levels = new AggLevel[_tempArray.length];
                for (_i = 0; _i < this.levels.length; ++_i) {
                    this.levels[_i] = (AggLevel)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggName";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggName.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            AggName.displayAttribute((PrintWriter)_out, (String)"ignorecase", (Object)this.ignorecase, (int)(_indent + 1));
            AggName.displayElement((PrintWriter)_out, (String)"factcount", (ElementDef)this.factcount, (int)(_indent + 1));
            AggName.displayElementArray((PrintWriter)_out, (String)"ignoreColumns", (NodeDef[])this.ignoreColumns, (int)(_indent + 1));
            AggName.displayElementArray((PrintWriter)_out, (String)"foreignKeys", (NodeDef[])this.foreignKeys, (int)(_indent + 1));
            AggName.displayElementArray((PrintWriter)_out, (String)"measures", (NodeDef[])this.measures, (int)(_indent + 1));
            AggName.displayElementArray((PrintWriter)_out, (String)"levels", (NodeDef[])this.levels, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("AggName", new XMLAttrVector().add("name", (Object)this.name).add("ignorecase", (Object)this.ignorecase));
            AggName.displayXMLElement((XMLOutput)_out, (ElementDef)this.factcount);
            AggName.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.ignoreColumns);
            AggName.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.foreignKeys);
            AggName.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.measures);
            AggName.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.levels);
            _out.endTag("AggName");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggName _cother = (AggName)_other;
            boolean _diff = AggName.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggName.displayElementDiff((String)"factcount", (NodeDef)this.factcount, (NodeDef)_cother.factcount, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggName.displayElementArrayDiff((String)"ignoreColumns", (NodeDef[])this.ignoreColumns, (NodeDef[])_cother.ignoreColumns, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggName.displayElementArrayDiff((String)"foreignKeys", (NodeDef[])this.foreignKeys, (NodeDef[])_cother.foreignKeys, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggName.displayElementArrayDiff((String)"measures", (NodeDef[])this.measures, (NodeDef[])_cother.measures, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggName.displayElementArrayDiff((String)"levels", (NodeDef[])this.levels, (NodeDef[])_cother.levels, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getNameAttribute() {
            return this.name;
        }
    }

    public static abstract class AggTable
    extends ElementDef {
        public Boolean ignorecase;
        public AggFactCount factcount;
        public AggIgnoreColumn[] ignoreColumns;
        public AggForeignKey[] foreignKeys;
        public AggMeasure[] measures;
        public AggLevel[] levels;

        public AggTable() {
        }

        public AggTable(DOMWrapper _def) throws XOMException {
            try {
                int _i;
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.ignorecase = (Boolean)_parser.getAttribute("ignorecase", "Boolean", "true", null, false);
                this.factcount = (AggFactCount)_parser.getElement(AggFactCount.class, true);
                NodeDef[] _tempArray = _parser.getArray(AggIgnoreColumn.class, 0, 0);
                this.ignoreColumns = new AggIgnoreColumn[_tempArray.length];
                for (_i = 0; _i < this.ignoreColumns.length; ++_i) {
                    this.ignoreColumns[_i] = (AggIgnoreColumn)_tempArray[_i];
                }
                _tempArray = _parser.getArray(AggForeignKey.class, 0, 0);
                this.foreignKeys = new AggForeignKey[_tempArray.length];
                for (_i = 0; _i < this.foreignKeys.length; ++_i) {
                    this.foreignKeys[_i] = (AggForeignKey)_tempArray[_i];
                }
                _tempArray = _parser.getArray(AggMeasure.class, 0, 0);
                this.measures = new AggMeasure[_tempArray.length];
                for (_i = 0; _i < this.measures.length; ++_i) {
                    this.measures[_i] = (AggMeasure)_tempArray[_i];
                }
                _tempArray = _parser.getArray(AggLevel.class, 0, 0);
                this.levels = new AggLevel[_tempArray.length];
                for (_i = 0; _i < this.levels.length; ++_i) {
                    this.levels[_i] = (AggLevel)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "AggTable";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            AggTable.displayAttribute((PrintWriter)_out, (String)"ignorecase", (Object)this.ignorecase, (int)(_indent + 1));
            AggTable.displayElement((PrintWriter)_out, (String)"factcount", (ElementDef)this.factcount, (int)(_indent + 1));
            AggTable.displayElementArray((PrintWriter)_out, (String)"ignoreColumns", (NodeDef[])this.ignoreColumns, (int)(_indent + 1));
            AggTable.displayElementArray((PrintWriter)_out, (String)"foreignKeys", (NodeDef[])this.foreignKeys, (int)(_indent + 1));
            AggTable.displayElementArray((PrintWriter)_out, (String)"measures", (NodeDef[])this.measures, (int)(_indent + 1));
            AggTable.displayElementArray((PrintWriter)_out, (String)"levels", (NodeDef[])this.levels, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("(%AggTable;)", new XMLAttrVector().add("ignorecase", (Object)this.ignorecase));
            AggTable.displayXMLElement((XMLOutput)_out, (ElementDef)this.factcount);
            AggTable.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.ignoreColumns);
            AggTable.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.foreignKeys);
            AggTable.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.measures);
            AggTable.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.levels);
            _out.endTag("(%AggTable;)");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            AggTable _cother = (AggTable)_other;
            boolean _diff = AggTable.displayAttributeDiff((String)"ignorecase", (Object)this.ignorecase, (Object)_cother.ignorecase, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggTable.displayElementDiff((String)"factcount", (NodeDef)this.factcount, (NodeDef)_cother.factcount, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggTable.displayElementArrayDiff((String)"ignoreColumns", (NodeDef[])this.ignoreColumns, (NodeDef[])_cother.ignoreColumns, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggTable.displayElementArrayDiff((String)"foreignKeys", (NodeDef[])this.foreignKeys, (NodeDef[])_cother.foreignKeys, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggTable.displayElementArrayDiff((String)"measures", (NodeDef[])this.measures, (NodeDef[])_cother.measures, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && AggTable.displayElementArrayDiff((String)"levels", (NodeDef[])this.levels, (NodeDef[])_cother.levels, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public boolean isIgnoreCase() {
            return this.ignorecase;
        }

        public AggFactCount getAggFactCount() {
            return this.factcount;
        }

        public AggIgnoreColumn[] getAggIgnoreColumns() {
            return this.ignoreColumns;
        }

        public AggForeignKey[] getAggForeignKeys() {
            return this.foreignKeys;
        }

        public AggMeasure[] getAggMeasures() {
            return this.measures;
        }

        public AggLevel[] getAggLevels() {
            return this.levels;
        }
    }

    public static class Value
    extends ElementDef {
        public String column;
        public String cdata;

        public Value() {
        }

        public Value(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.column = (String)_parser.getAttribute("column", "String", null, null, true);
                this.cdata = _parser.getText();
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Value";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Value.displayAttribute((PrintWriter)_out, (String)"column", (Object)this.column, (int)(_indent + 1));
            Value.displayString((PrintWriter)_out, (String)"cdata", (String)this.cdata, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Value", new XMLAttrVector().add("column", (Object)this.column));
            _out.cdata(this.cdata);
            _out.endTag("Value");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Value _cother = (Value)_other;
            boolean _diff = Value.displayAttributeDiff((String)"column", (Object)this.column, (Object)_cother.column, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Value.displayStringDiff((String)"cdata", (String)this.cdata, (String)_cother.cdata, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Row
    extends ElementDef {
        public Value[] values;

        public Row() {
        }

        public Row(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Value.class, 0, 0);
                this.values = new Value[_tempArray.length];
                for (int _i = 0; _i < this.values.length; ++_i) {
                    this.values[_i] = (Value)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Row";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Row.displayElementArray((PrintWriter)_out, (String)"values", (NodeDef[])this.values, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Row", new XMLAttrVector());
            Row.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.values);
            _out.endTag("Row");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Row _cother = (Row)_other;
            boolean _diff = Row.displayElementArrayDiff((String)"values", (NodeDef[])this.values, (NodeDef[])_cother.values, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Rows
    extends ElementDef {
        public Row[] array;

        public Rows() {
        }

        public Rows(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(Row.class, 0, 0);
                this.array = new Row[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (Row)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Rows";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Rows.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Rows", new XMLAttrVector());
            Rows.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("Rows");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Rows _cother = (Rows)_other;
            boolean _diff = Rows.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class ColumnDef
    extends ElementDef {
        public String name;
        public static final String[] _type_values = new String[]{"String", "Numeric", "Integer", "Boolean", "Date", "Time", "Timestamp"};
        public String type;

        public ColumnDef() {
        }

        public ColumnDef(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.type = (String)_parser.getAttribute("type", "String", null, _type_values, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "ColumnDef";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            ColumnDef.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            ColumnDef.displayAttribute((PrintWriter)_out, (String)"type", (Object)this.type, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("ColumnDef", new XMLAttrVector().add("name", (Object)this.name).add("type", (Object)this.type));
            _out.endTag("ColumnDef");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            ColumnDef _cother = (ColumnDef)_other;
            boolean _diff = ColumnDef.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && ColumnDef.displayAttributeDiff((String)"type", (Object)this.type, (Object)_cother.type, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class ColumnDefs
    extends ElementDef {
        public ColumnDef[] array;

        public ColumnDefs() {
        }

        public ColumnDefs(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(ColumnDef.class, 0, 0);
                this.array = new ColumnDef[_tempArray.length];
                for (int _i = 0; _i < this.array.length; ++_i) {
                    this.array[_i] = (ColumnDef)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "ColumnDefs";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            ColumnDefs.displayElementArray((PrintWriter)_out, (String)"array", (NodeDef[])this.array, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("ColumnDefs", new XMLAttrVector());
            ColumnDefs.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.array);
            _out.endTag("ColumnDefs");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            ColumnDefs _cother = (ColumnDefs)_other;
            boolean _diff = ColumnDefs.displayElementArrayDiff((String)"array", (NodeDef[])this.array, (NodeDef[])_cother.array, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class InlineTable
    extends Relation {
        public String alias;
        public ColumnDefs columnDefs;
        public Rows rows;

        public InlineTable() {
        }

        public InlineTable(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.alias = (String)_parser.getAttribute("alias", "String", null, null, false);
                this.columnDefs = (ColumnDefs)_parser.getElement(ColumnDefs.class, true);
                this.rows = (Rows)_parser.getElement(Rows.class, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "InlineTable";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            InlineTable.displayAttribute((PrintWriter)_out, (String)"alias", (Object)this.alias, (int)(_indent + 1));
            InlineTable.displayElement((PrintWriter)_out, (String)"columnDefs", (ElementDef)this.columnDefs, (int)(_indent + 1));
            InlineTable.displayElement((PrintWriter)_out, (String)"rows", (ElementDef)this.rows, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("InlineTable", new XMLAttrVector().add("alias", (Object)this.alias));
            InlineTable.displayXMLElement((XMLOutput)_out, (ElementDef)this.columnDefs);
            InlineTable.displayXMLElement((XMLOutput)_out, (ElementDef)this.rows);
            _out.endTag("InlineTable");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            InlineTable _cother = (InlineTable)_other;
            boolean _diff = InlineTable.displayAttributeDiff((String)"alias", (Object)this.alias, (Object)_cother.alias, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && InlineTable.displayElementDiff((String)"columnDefs", (NodeDef)this.columnDefs, (NodeDef)_cother.columnDefs, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && InlineTable.displayElementDiff((String)"rows", (NodeDef)this.rows, (NodeDef)_cother.rows, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public InlineTable(InlineTable inlineTable) {
            this.alias = inlineTable.alias;
            this.columnDefs = new ColumnDefs();
            this.columnDefs.array = (ColumnDef[])inlineTable.columnDefs.array.clone();
            this.rows = new Rows();
            this.rows.array = (Row[])inlineTable.rows.array.clone();
        }

        public String getAlias() {
            return this.alias;
        }

        public String toString() {
            return "<inline data>";
        }

        public InlineTable find(String seekAlias) {
            return seekAlias.equals(this.alias) ? this : null;
        }

        public boolean equals(Object o) {
            if (o instanceof InlineTable) {
                InlineTable that = (InlineTable)((Object)o);
                return this.alias.equals(that.alias);
            }
            return false;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }

    public static class Hint
    extends ElementDef {
        public String type;
        public String cdata;

        public Hint() {
        }

        public Hint(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.type = (String)_parser.getAttribute("type", "String", null, null, true);
                this.cdata = _parser.getText();
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Hint";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Hint.displayAttribute((PrintWriter)_out, (String)"type", (Object)this.type, (int)(_indent + 1));
            Hint.displayString((PrintWriter)_out, (String)"cdata", (String)this.cdata, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Hint", new XMLAttrVector().add("type", (Object)this.type));
            _out.cdata(this.cdata);
            _out.endTag("Hint");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Hint _cother = (Hint)_other;
            boolean _diff = Hint.displayAttributeDiff((String)"type", (Object)this.type, (Object)_cother.type, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hint.displayStringDiff((String)"cdata", (String)this.cdata, (String)_cother.cdata, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Table
    extends Relation {
        public String name;
        public String schema;
        public String alias;
        public SQL filter;
        public AggExclude[] aggExcludes;
        public AggTable[] aggTables;
        public Hint[] tableHints;
        private Map<String, String> hintMap;

        public Table() {
        }

        public Table(DOMWrapper _def) throws XOMException {
            try {
                int _i;
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.schema = (String)_parser.getAttribute("schema", "String", null, null, false);
                this.alias = (String)_parser.getAttribute("alias", "String", null, null, false);
                this.filter = (SQL)_parser.getElement(SQL.class, false);
                NodeDef[] _tempArray = _parser.getArray(AggExclude.class, 0, 0);
                this.aggExcludes = new AggExclude[_tempArray.length];
                for (_i = 0; _i < this.aggExcludes.length; ++_i) {
                    this.aggExcludes[_i] = (AggExclude)_tempArray[_i];
                }
                _tempArray = _parser.getArray(AggTable.class, 0, 0);
                this.aggTables = new AggTable[_tempArray.length];
                for (_i = 0; _i < this.aggTables.length; ++_i) {
                    this.aggTables[_i] = (AggTable)_tempArray[_i];
                }
                _tempArray = _parser.getArray(Hint.class, 0, 0);
                this.tableHints = new Hint[_tempArray.length];
                for (_i = 0; _i < this.tableHints.length; ++_i) {
                    this.tableHints[_i] = (Hint)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        @Override
        public String getName() {
            return "Table";
        }

        @Override
        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Table.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Table.displayAttribute((PrintWriter)_out, (String)"schema", (Object)this.schema, (int)(_indent + 1));
            Table.displayAttribute((PrintWriter)_out, (String)"alias", (Object)this.alias, (int)(_indent + 1));
            Table.displayElement((PrintWriter)_out, (String)"filter", (ElementDef)this.filter, (int)(_indent + 1));
            Table.displayElementArray((PrintWriter)_out, (String)"aggExcludes", (NodeDef[])this.aggExcludes, (int)(_indent + 1));
            Table.displayElementArray((PrintWriter)_out, (String)"aggTables", (NodeDef[])this.aggTables, (int)(_indent + 1));
            Table.displayElementArray((PrintWriter)_out, (String)"tableHints", (NodeDef[])this.tableHints, (int)(_indent + 1));
        }

        @Override
        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Table", new XMLAttrVector().add("name", (Object)this.name).add("schema", (Object)this.schema).add("alias", (Object)this.alias));
            Table.displayXMLElement((XMLOutput)_out, (ElementDef)this.filter);
            Table.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.aggExcludes);
            Table.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.aggTables);
            Table.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.tableHints);
            _out.endTag("Table");
        }

        @Override
        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Table _cother = (Table)_other;
            boolean _diff = Table.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Table.displayAttributeDiff((String)"schema", (Object)this.schema, (Object)_cother.schema, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Table.displayAttributeDiff((String)"alias", (Object)this.alias, (Object)_cother.alias, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Table.displayElementDiff((String)"filter", (NodeDef)this.filter, (NodeDef)_cother.filter, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Table.displayElementArrayDiff((String)"aggExcludes", (NodeDef[])this.aggExcludes, (NodeDef[])_cother.aggExcludes, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Table.displayElementArrayDiff((String)"aggTables", (NodeDef[])this.aggTables, (NodeDef[])_cother.aggTables, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Table.displayElementArrayDiff((String)"tableHints", (NodeDef[])this.tableHints, (NodeDef[])_cother.tableHints, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public Table(Table table) {
            this(table.schema, table.name, table.alias, table.tableHints);
        }

        public Table(String schema, String name, String alias, Hint[] tablehints) {
            this();
            this.schema = schema;
            this.name = name;
            this.alias = alias;
            this.hintMap = this.buildHintMap(tablehints);
        }

        private Map<String, String> buildHintMap(Hint[] th) {
            HashMap<String, String> h = new HashMap<String, String>();
            if (th != null) {
                for (int i = 0; i < th.length; ++i) {
                    h.put(th[i].type, th[i].cdata);
                }
            }
            return h;
        }

        @Override
        public String getAlias() {
            return this.alias != null ? this.alias : this.name;
        }

        public String toString() {
            return this.schema == null ? this.name : this.schema + "." + this.name;
        }

        @Override
        public Table find(String seekAlias) {
            return seekAlias.equals(this.name) ? this : (this.alias != null && seekAlias.equals(this.alias) ? this : null);
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Table) {
                Table that = (Table)((Object)o);
                return this.name.equals(that.name) && Util.equals(this.alias, that.alias) && Util.equals(this.schema, that.schema);
            }
            return false;
        }

        @Override
        public int hashCode() {
            return this.toString().hashCode();
        }

        public String getFilter() {
            return this.filter == null ? null : this.filter.cdata;
        }

        public AggExclude[] getAggExcludes() {
            return this.aggExcludes;
        }

        public AggTable[] getAggTables() {
            return this.aggTables;
        }

        public Map<String, String> getHintMap() {
            if (this.hintMap == null) {
                this.hintMap = this.buildHintMap(this.tableHints);
            }
            return this.hintMap;
        }
    }

    public static class Join
    extends RelationOrJoin {
        public String leftAlias;
        public String leftKey;
        public String rightAlias;
        public String rightKey;
        public RelationOrJoin left;
        public RelationOrJoin right;

        public Join() {
        }

        public Join(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.leftAlias = (String)_parser.getAttribute("leftAlias", "String", null, null, false);
                this.leftKey = (String)_parser.getAttribute("leftKey", "String", null, null, true);
                this.rightAlias = (String)_parser.getAttribute("rightAlias", "String", null, null, false);
                this.rightKey = (String)_parser.getAttribute("rightKey", "String", null, null, true);
                this.left = (RelationOrJoin)_parser.getElement(RelationOrJoin.class, true);
                this.right = (RelationOrJoin)_parser.getElement(RelationOrJoin.class, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Join";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Join.displayAttribute((PrintWriter)_out, (String)"leftAlias", (Object)this.leftAlias, (int)(_indent + 1));
            Join.displayAttribute((PrintWriter)_out, (String)"leftKey", (Object)this.leftKey, (int)(_indent + 1));
            Join.displayAttribute((PrintWriter)_out, (String)"rightAlias", (Object)this.rightAlias, (int)(_indent + 1));
            Join.displayAttribute((PrintWriter)_out, (String)"rightKey", (Object)this.rightKey, (int)(_indent + 1));
            Join.displayElement((PrintWriter)_out, (String)"left", (ElementDef)this.left, (int)(_indent + 1));
            Join.displayElement((PrintWriter)_out, (String)"right", (ElementDef)this.right, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Join", new XMLAttrVector().add("leftAlias", (Object)this.leftAlias).add("leftKey", (Object)this.leftKey).add("rightAlias", (Object)this.rightAlias).add("rightKey", (Object)this.rightKey));
            Join.displayXMLElement((XMLOutput)_out, (ElementDef)this.left);
            Join.displayXMLElement((XMLOutput)_out, (ElementDef)this.right);
            _out.endTag("Join");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Join _cother = (Join)_other;
            boolean _diff = Join.displayAttributeDiff((String)"leftAlias", (Object)this.leftAlias, (Object)_cother.leftAlias, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Join.displayAttributeDiff((String)"leftKey", (Object)this.leftKey, (Object)_cother.leftKey, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Join.displayAttributeDiff((String)"rightAlias", (Object)this.rightAlias, (Object)_cother.rightAlias, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Join.displayAttributeDiff((String)"rightKey", (Object)this.rightKey, (Object)_cother.rightKey, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Join.displayElementDiff((String)"left", (NodeDef)this.left, (NodeDef)_cother.left, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Join.displayElementDiff((String)"right", (NodeDef)this.right, (NodeDef)_cother.right, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public Join(String leftAlias, String leftKey, RelationOrJoin left, String rightAlias, String rightKey, RelationOrJoin right) {
            this.leftAlias = leftAlias;
            this.leftKey = leftKey;
            this.left = left;
            this.rightAlias = rightAlias;
            this.rightKey = rightKey;
            this.right = right;
        }

        public String getLeftAlias() {
            if (this.leftAlias != null) {
                return this.leftAlias;
            }
            if (this.left instanceof Relation) {
                return ((Relation)this.left).getAlias();
            }
            throw Util.newInternal("alias is required because " + (Object)((Object)this.left) + " is not a table");
        }

        public String getRightAlias() {
            if (this.rightAlias != null) {
                return this.rightAlias;
            }
            if (this.right instanceof Relation) {
                return ((Relation)this.right).getAlias();
            }
            if (this.right instanceof Join) {
                return ((Join)this.right).getLeftAlias();
            }
            throw Util.newInternal("alias is required because " + (Object)((Object)this.right) + " is not a table");
        }

        public String toString() {
            return "(" + (Object)((Object)this.left) + ") join (" + (Object)((Object)this.right) + ") on " + this.leftAlias + "." + this.leftKey + " = " + this.rightAlias + "." + this.rightKey;
        }

        public Relation find(String seekAlias) {
            Relation relation = this.left.find(seekAlias);
            if (relation == null) {
                relation = this.right.find(seekAlias);
            }
            return relation;
        }
    }

    public static class SQL
    extends ElementDef {
        public String dialect;
        public String cdata;

        public SQL() {
        }

        public SQL(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.dialect = (String)_parser.getAttribute("dialect", "String", "generic", null, true);
                this.cdata = _parser.getText();
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "SQL";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            SQL.displayAttribute((PrintWriter)_out, (String)"dialect", (Object)this.dialect, (int)(_indent + 1));
            SQL.displayString((PrintWriter)_out, (String)"cdata", (String)this.cdata, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("SQL", new XMLAttrVector().add("dialect", (Object)this.dialect));
            _out.cdata(this.cdata);
            _out.endTag("SQL");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            SQL _cother = (SQL)_other;
            boolean _diff = SQL.displayAttributeDiff((String)"dialect", (Object)this.dialect, (Object)_cother.dialect, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && SQL.displayStringDiff((String)"cdata", (String)this.cdata, (String)_cother.cdata, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public int hashCode() {
            return this.dialect.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SQL)) {
                return false;
            }
            SQL that = (SQL)((Object)obj);
            return this.dialect.equals(that.dialect) && Util.equals(this.cdata, that.cdata);
        }

        public static SqlQuery.CodeSet toCodeSet(SQL[] sqls) {
            SqlQuery.CodeSet codeSet = new SqlQuery.CodeSet();
            for (SQL sql : sqls) {
                codeSet.put(sql.dialect, sql.cdata);
            }
            return codeSet;
        }
    }

    public static class View
    extends Relation {
        public String alias;
        public SQL[] selects;

        public View() {
        }

        public View(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.alias = (String)_parser.getAttribute("alias", "String", null, null, true);
                NodeDef[] _tempArray = _parser.getArray(SQL.class, 1, 0);
                this.selects = new SQL[_tempArray.length];
                for (int _i = 0; _i < this.selects.length; ++_i) {
                    this.selects[_i] = (SQL)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "View";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            View.displayAttribute((PrintWriter)_out, (String)"alias", (Object)this.alias, (int)(_indent + 1));
            View.displayElementArray((PrintWriter)_out, (String)"selects", (NodeDef[])this.selects, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("View", new XMLAttrVector().add("alias", (Object)this.alias));
            View.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.selects);
            _out.endTag("View");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            View _cother = (View)_other;
            boolean _diff = View.displayAttributeDiff((String)"alias", (Object)this.alias, (Object)_cother.alias, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && View.displayElementArrayDiff((String)"selects", (NodeDef[])this.selects, (NodeDef[])_cother.selects, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public View(View view) {
            this.alias = view.alias;
            this.selects = (SQL[])view.selects.clone();
        }

        public String toString() {
            return this.selects[0].cdata;
        }

        public View find(String seekAlias) {
            if (seekAlias.equals(this.alias)) {
                return this;
            }
            return null;
        }

        public String getAlias() {
            return this.alias;
        }

        public SqlQuery.CodeSet getCodeSet() {
            return SQL.toCodeSet(this.selects);
        }

        public void addCode(String dialect, String code) {
            if (this.selects == null) {
                this.selects = new SQL[1];
            } else {
                SQL[] olds = this.selects;
                this.selects = new SQL[olds.length + 1];
                System.arraycopy(olds, 0, this.selects, 0, olds.length);
            }
            SQL sql = new SQL();
            sql.dialect = dialect;
            sql.cdata = code;
            this.selects[this.selects.length - 1] = sql;
        }
    }

    public static abstract class Relation
    extends RelationOrJoin {
        public Relation() {
        }

        public Relation(DOMWrapper _def) throws XOMException {
        }

        public String getName() {
            return "Relation";
        }

        public void display(PrintWriter _out, int _indent) {
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("(%Relation;)", new XMLAttrVector());
            _out.endTag("(%Relation;)");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            return true;
        }

        public abstract String getAlias();
    }

    public static abstract class RelationOrJoin
    extends ElementDef {
        public RelationOrJoin() {
        }

        public RelationOrJoin(DOMWrapper _def) throws XOMException {
        }

        public String getName() {
            return "RelationOrJoin";
        }

        public void display(PrintWriter _out, int _indent) {
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("(%RelationOrJoin;)", new XMLAttrVector());
            _out.endTag("(%RelationOrJoin;)");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            return true;
        }

        public abstract Relation find(String var1);

        public boolean equals(Object o) {
            return this == o;
        }

        public int hashCode() {
            return System.identityHashCode((Object)this);
        }
    }

    public static class MemberReaderParameter
    extends ElementDef {
        public String name;
        public String value;

        public MemberReaderParameter() {
        }

        public MemberReaderParameter(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, false);
                this.value = (String)_parser.getAttribute("value", "String", null, null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "MemberReaderParameter";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            MemberReaderParameter.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            MemberReaderParameter.displayAttribute((PrintWriter)_out, (String)"value", (Object)this.value, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("MemberReaderParameter", new XMLAttrVector().add("name", (Object)this.name).add("value", (Object)this.value));
            _out.endTag("MemberReaderParameter");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            MemberReaderParameter _cother = (MemberReaderParameter)_other;
            boolean _diff = MemberReaderParameter.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && MemberReaderParameter.displayAttributeDiff((String)"value", (Object)this.value, (Object)_cother.value, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Formula
    extends ElementDef {
        public String cdata;

        public Formula() {
        }

        public Formula(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.cdata = _parser.getText();
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Formula";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Formula.displayString((PrintWriter)_out, (String)"cdata", (String)this.cdata, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Formula", new XMLAttrVector());
            _out.cdata(this.cdata);
            _out.endTag("Formula");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Formula _cother = (Formula)_other;
            boolean _diff = Formula.displayStringDiff((String)"cdata", (String)this.cdata, (String)_cother.cdata, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class NamedSet
    extends ElementDef {
        public String name;
        public String caption;
        public String description;
        public String formula;
        public Annotations annotations;
        public Formula formulaElement;

        public NamedSet() {
        }

        public NamedSet(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.formula = (String)_parser.getAttribute("formula", "String", null, null, false);
                this.annotations = (Annotations)_parser.getElement(Annotations.class, false);
                this.formulaElement = (Formula)_parser.getElement(Formula.class, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "NamedSet";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            NamedSet.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            NamedSet.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            NamedSet.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            NamedSet.displayAttribute((PrintWriter)_out, (String)"formula", (Object)this.formula, (int)(_indent + 1));
            NamedSet.displayElement((PrintWriter)_out, (String)"annotations", (ElementDef)this.annotations, (int)(_indent + 1));
            NamedSet.displayElement((PrintWriter)_out, (String)"formulaElement", (ElementDef)this.formulaElement, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("NamedSet", new XMLAttrVector().add("name", (Object)this.name).add("caption", (Object)this.caption).add("description", (Object)this.description).add("formula", (Object)this.formula));
            NamedSet.displayXMLElement((XMLOutput)_out, (ElementDef)this.annotations);
            NamedSet.displayXMLElement((XMLOutput)_out, (ElementDef)this.formulaElement);
            _out.endTag("NamedSet");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            NamedSet _cother = (NamedSet)_other;
            boolean _diff = NamedSet.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && NamedSet.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && NamedSet.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && NamedSet.displayAttributeDiff((String)"formula", (Object)this.formula, (Object)_cother.formula, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && NamedSet.displayElementDiff((String)"annotations", (NodeDef)this.annotations, (NodeDef)_cother.annotations, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && NamedSet.displayElementDiff((String)"formulaElement", (NodeDef)this.formulaElement, (NodeDef)_cother.formulaElement, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getFormula() {
            if (this.formulaElement != null) {
                return this.formulaElement.cdata;
            }
            return this.formula;
        }
    }

    public static class CalculatedMemberProperty
    extends ElementDef {
        public String name;
        public String caption;
        public String description;
        public String expression;
        public String value;

        public CalculatedMemberProperty() {
        }

        public CalculatedMemberProperty(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.expression = (String)_parser.getAttribute("expression", "String", null, null, false);
                this.value = (String)_parser.getAttribute("value", "String", null, null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "CalculatedMemberProperty";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            CalculatedMemberProperty.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            CalculatedMemberProperty.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            CalculatedMemberProperty.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            CalculatedMemberProperty.displayAttribute((PrintWriter)_out, (String)"expression", (Object)this.expression, (int)(_indent + 1));
            CalculatedMemberProperty.displayAttribute((PrintWriter)_out, (String)"value", (Object)this.value, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("CalculatedMemberProperty", new XMLAttrVector().add("name", (Object)this.name).add("caption", (Object)this.caption).add("description", (Object)this.description).add("expression", (Object)this.expression).add("value", (Object)this.value));
            _out.endTag("CalculatedMemberProperty");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            CalculatedMemberProperty _cother = (CalculatedMemberProperty)_other;
            boolean _diff = CalculatedMemberProperty.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMemberProperty.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMemberProperty.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMemberProperty.displayAttributeDiff((String)"expression", (Object)this.expression, (Object)_cother.expression, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMemberProperty.displayAttributeDiff((String)"value", (Object)this.value, (Object)_cother.value, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class CalculatedMember
    extends ElementDef {
        public String name;
        public String formatString;
        public String caption;
        public String description;
        public String formula;
        public String dimension;
        public Boolean visible;
        public Annotations annotations;
        public Formula formulaElement;
        public CalculatedMemberProperty[] memberProperties;

        public CalculatedMember() {
        }

        public CalculatedMember(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.formatString = (String)_parser.getAttribute("formatString", "String", null, null, false);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.formula = (String)_parser.getAttribute("formula", "String", null, null, false);
                this.dimension = (String)_parser.getAttribute("dimension", "String", null, null, true);
                this.visible = (Boolean)_parser.getAttribute("visible", "Boolean", null, null, false);
                this.annotations = (Annotations)_parser.getElement(Annotations.class, false);
                this.formulaElement = (Formula)_parser.getElement(Formula.class, false);
                NodeDef[] _tempArray = _parser.getArray(CalculatedMemberProperty.class, 0, 0);
                this.memberProperties = new CalculatedMemberProperty[_tempArray.length];
                for (int _i = 0; _i < this.memberProperties.length; ++_i) {
                    this.memberProperties[_i] = (CalculatedMemberProperty)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "CalculatedMember";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"formatString", (Object)this.formatString, (int)(_indent + 1));
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"formula", (Object)this.formula, (int)(_indent + 1));
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"dimension", (Object)this.dimension, (int)(_indent + 1));
            CalculatedMember.displayAttribute((PrintWriter)_out, (String)"visible", (Object)this.visible, (int)(_indent + 1));
            CalculatedMember.displayElement((PrintWriter)_out, (String)"annotations", (ElementDef)this.annotations, (int)(_indent + 1));
            CalculatedMember.displayElement((PrintWriter)_out, (String)"formulaElement", (ElementDef)this.formulaElement, (int)(_indent + 1));
            CalculatedMember.displayElementArray((PrintWriter)_out, (String)"memberProperties", (NodeDef[])this.memberProperties, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("CalculatedMember", new XMLAttrVector().add("name", (Object)this.name).add("formatString", (Object)this.formatString).add("caption", (Object)this.caption).add("description", (Object)this.description).add("formula", (Object)this.formula).add("dimension", (Object)this.dimension).add("visible", (Object)this.visible));
            CalculatedMember.displayXMLElement((XMLOutput)_out, (ElementDef)this.annotations);
            CalculatedMember.displayXMLElement((XMLOutput)_out, (ElementDef)this.formulaElement);
            CalculatedMember.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.memberProperties);
            _out.endTag("CalculatedMember");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            CalculatedMember _cother = (CalculatedMember)_other;
            boolean _diff = CalculatedMember.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayAttributeDiff((String)"formatString", (Object)this.formatString, (Object)_cother.formatString, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayAttributeDiff((String)"formula", (Object)this.formula, (Object)_cother.formula, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayAttributeDiff((String)"dimension", (Object)this.dimension, (Object)_cother.dimension, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayAttributeDiff((String)"visible", (Object)this.visible, (Object)_cother.visible, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayElementDiff((String)"annotations", (NodeDef)this.annotations, (NodeDef)_cother.annotations, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayElementDiff((String)"formulaElement", (NodeDef)this.formulaElement, (NodeDef)_cother.formulaElement, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CalculatedMember.displayElementArrayDiff((String)"memberProperties", (NodeDef[])this.memberProperties, (NodeDef[])_cother.memberProperties, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public String getFormula() {
            if (this.formulaElement != null) {
                return this.formulaElement.cdata;
            }
            return this.formula;
        }
    }

    public static class Measure
    extends ElementDef {
        public String name;
        public String column;
        public static final String[] _datatype_values = new String[]{"String", "Numeric", "Integer", "Boolean", "Date", "Time", "Timestamp"};
        public String datatype;
        public String formatString;
        public String aggregator;
        public String formatter;
        public String caption;
        public String description;
        public Boolean visible;
        public Annotations annotations;
        public MeasureExpression measureExp;
        public CalculatedMemberProperty[] memberProperties;

        public Measure() {
        }

        public Measure(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.column = (String)_parser.getAttribute("column", "String", null, null, false);
                this.datatype = (String)_parser.getAttribute("datatype", "String", null, _datatype_values, false);
                this.formatString = (String)_parser.getAttribute("formatString", "String", null, null, false);
                this.aggregator = (String)_parser.getAttribute("aggregator", "String", null, null, true);
                this.formatter = (String)_parser.getAttribute("formatter", "String", null, null, false);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.visible = (Boolean)_parser.getAttribute("visible", "Boolean", null, null, false);
                this.annotations = (Annotations)_parser.getElement(Annotations.class, false);
                this.measureExp = (MeasureExpression)_parser.getElement(MeasureExpression.class, false);
                NodeDef[] _tempArray = _parser.getArray(CalculatedMemberProperty.class, 0, 0);
                this.memberProperties = new CalculatedMemberProperty[_tempArray.length];
                for (int _i = 0; _i < this.memberProperties.length; ++_i) {
                    this.memberProperties[_i] = (CalculatedMemberProperty)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Measure";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Measure.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"column", (Object)this.column, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"datatype", (Object)this.datatype, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"formatString", (Object)this.formatString, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"aggregator", (Object)this.aggregator, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"formatter", (Object)this.formatter, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Measure.displayAttribute((PrintWriter)_out, (String)"visible", (Object)this.visible, (int)(_indent + 1));
            Measure.displayElement((PrintWriter)_out, (String)"annotations", (ElementDef)this.annotations, (int)(_indent + 1));
            Measure.displayElement((PrintWriter)_out, (String)"measureExp", (ElementDef)this.measureExp, (int)(_indent + 1));
            Measure.displayElementArray((PrintWriter)_out, (String)"memberProperties", (NodeDef[])this.memberProperties, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Measure", new XMLAttrVector().add("name", (Object)this.name).add("column", (Object)this.column).add("datatype", (Object)this.datatype).add("formatString", (Object)this.formatString).add("aggregator", (Object)this.aggregator).add("formatter", (Object)this.formatter).add("caption", (Object)this.caption).add("description", (Object)this.description).add("visible", (Object)this.visible));
            Measure.displayXMLElement((XMLOutput)_out, (ElementDef)this.annotations);
            Measure.displayXMLElement((XMLOutput)_out, (ElementDef)this.measureExp);
            Measure.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.memberProperties);
            _out.endTag("Measure");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Measure _cother = (Measure)_other;
            boolean _diff = Measure.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"column", (Object)this.column, (Object)_cother.column, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"datatype", (Object)this.datatype, (Object)_cother.datatype, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"formatString", (Object)this.formatString, (Object)_cother.formatString, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"aggregator", (Object)this.aggregator, (Object)_cother.aggregator, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"formatter", (Object)this.formatter, (Object)_cother.formatter, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayAttributeDiff((String)"visible", (Object)this.visible, (Object)_cother.visible, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayElementDiff((String)"annotations", (NodeDef)this.annotations, (NodeDef)_cother.annotations, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayElementDiff((String)"measureExp", (NodeDef)this.measureExp, (NodeDef)_cother.measureExp, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Measure.displayElementArrayDiff((String)"memberProperties", (NodeDef[])this.memberProperties, (NodeDef[])_cother.memberProperties, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Property
    extends ElementDef {
        public String name;
        public String column;
        public static final String[] _type_values = new String[]{"String", "Numeric", "Integer", "Boolean", "Date", "Time", "Timestamp"};
        public String type;
        public String formatter;
        public String caption;
        public String description;
        public Boolean dependsOnLevelValue;

        public Property() {
        }

        public Property(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, false);
                this.column = (String)_parser.getAttribute("column", "String", null, null, false);
                this.type = (String)_parser.getAttribute("type", "String", "String", _type_values, false);
                this.formatter = (String)_parser.getAttribute("formatter", "String", null, null, false);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.dependsOnLevelValue = (Boolean)_parser.getAttribute("dependsOnLevelValue", "Boolean", null, null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Property";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Property.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Property.displayAttribute((PrintWriter)_out, (String)"column", (Object)this.column, (int)(_indent + 1));
            Property.displayAttribute((PrintWriter)_out, (String)"type", (Object)this.type, (int)(_indent + 1));
            Property.displayAttribute((PrintWriter)_out, (String)"formatter", (Object)this.formatter, (int)(_indent + 1));
            Property.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            Property.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Property.displayAttribute((PrintWriter)_out, (String)"dependsOnLevelValue", (Object)this.dependsOnLevelValue, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Property", new XMLAttrVector().add("name", (Object)this.name).add("column", (Object)this.column).add("type", (Object)this.type).add("formatter", (Object)this.formatter).add("caption", (Object)this.caption).add("description", (Object)this.description).add("dependsOnLevelValue", (Object)this.dependsOnLevelValue));
            _out.endTag("Property");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Property _cother = (Property)_other;
            boolean _diff = Property.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Property.displayAttributeDiff((String)"column", (Object)this.column, (Object)_cother.column, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Property.displayAttributeDiff((String)"type", (Object)this.type, (Object)_cother.type, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Property.displayAttributeDiff((String)"formatter", (Object)this.formatter, (Object)_cother.formatter, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Property.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Property.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Property.displayAttributeDiff((String)"dependsOnLevelValue", (Object)this.dependsOnLevelValue, (Object)_cother.dependsOnLevelValue, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Closure
    extends ElementDef {
        public String parentColumn;
        public String childColumn;
        public Table table;

        public Closure() {
        }

        public Closure(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.parentColumn = (String)_parser.getAttribute("parentColumn", "String", null, null, true);
                this.childColumn = (String)_parser.getAttribute("childColumn", "String", null, null, true);
                this.table = (Table)_parser.getElement(Table.class, true);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Closure";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Closure.displayAttribute((PrintWriter)_out, (String)"parentColumn", (Object)this.parentColumn, (int)(_indent + 1));
            Closure.displayAttribute((PrintWriter)_out, (String)"childColumn", (Object)this.childColumn, (int)(_indent + 1));
            Closure.displayElement((PrintWriter)_out, (String)"table", (ElementDef)this.table, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Closure", new XMLAttrVector().add("parentColumn", (Object)this.parentColumn).add("childColumn", (Object)this.childColumn));
            Closure.displayXMLElement((XMLOutput)_out, (ElementDef)this.table);
            _out.endTag("Closure");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Closure _cother = (Closure)_other;
            boolean _diff = Closure.displayAttributeDiff((String)"parentColumn", (Object)this.parentColumn, (Object)_cother.parentColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Closure.displayAttributeDiff((String)"childColumn", (Object)this.childColumn, (Object)_cother.childColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Closure.displayElementDiff((String)"table", (NodeDef)this.table, (NodeDef)_cother.table, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Level
    extends ElementDef {
        public String approxRowCount;
        public String name;
        public String table;
        public String column;
        public String nameColumn;
        public String ordinalColumn;
        public String parentColumn;
        public String nullParentValue;
        public static final String[] _type_values = new String[]{"String", "Numeric", "Integer", "Boolean", "Date", "Time", "Timestamp"};
        public String type;
        public Boolean uniqueMembers;
        public static final String[] _levelType_values = new String[]{"Regular", "TimeYears", "TimeHalfYear", "TimeQuarters", "TimeMonths", "TimeWeeks", "TimeDays", "TimeHours", "TimeMinutes", "TimeSeconds", "TimeUndefined"};
        public String levelType;
        public static final String[] _hideMemberIf_values = new String[]{"Never", "IfBlankName", "IfParentsName"};
        public String hideMemberIf;
        public String formatter;
        public String caption;
        public String description;
        public String captionColumn;
        public Annotations annotations;
        public KeyExpression keyExp;
        public NameExpression nameExp;
        public OrdinalExpression ordinalExp;
        public ParentExpression parentExp;
        public Closure closure;
        public Property[] properties;

        public Level() {
        }

        public Level(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.approxRowCount = (String)_parser.getAttribute("approxRowCount", "String", null, null, false);
                this.name = (String)_parser.getAttribute("name", "String", null, null, false);
                this.table = (String)_parser.getAttribute("table", "String", null, null, false);
                this.column = (String)_parser.getAttribute("column", "String", null, null, false);
                this.nameColumn = (String)_parser.getAttribute("nameColumn", "String", null, null, false);
                this.ordinalColumn = (String)_parser.getAttribute("ordinalColumn", "String", null, null, false);
                this.parentColumn = (String)_parser.getAttribute("parentColumn", "String", null, null, false);
                this.nullParentValue = (String)_parser.getAttribute("nullParentValue", "String", null, null, false);
                this.type = (String)_parser.getAttribute("type", "String", "String", _type_values, false);
                this.uniqueMembers = (Boolean)_parser.getAttribute("uniqueMembers", "Boolean", "false", null, false);
                this.levelType = (String)_parser.getAttribute("levelType", "String", "Regular", _levelType_values, false);
                this.hideMemberIf = (String)_parser.getAttribute("hideMemberIf", "String", "Never", _hideMemberIf_values, false);
                this.formatter = (String)_parser.getAttribute("formatter", "String", null, null, false);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.captionColumn = (String)_parser.getAttribute("captionColumn", "String", null, null, false);
                this.annotations = (Annotations)_parser.getElement(Annotations.class, false);
                this.keyExp = (KeyExpression)_parser.getElement(KeyExpression.class, false);
                this.nameExp = (NameExpression)_parser.getElement(NameExpression.class, false);
                this.ordinalExp = (OrdinalExpression)_parser.getElement(OrdinalExpression.class, false);
                this.parentExp = (ParentExpression)_parser.getElement(ParentExpression.class, false);
                this.closure = (Closure)_parser.getElement(Closure.class, false);
                NodeDef[] _tempArray = _parser.getArray(Property.class, 0, 0);
                this.properties = new Property[_tempArray.length];
                for (int _i = 0; _i < this.properties.length; ++_i) {
                    this.properties[_i] = (Property)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Level";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Level.displayAttribute((PrintWriter)_out, (String)"approxRowCount", (Object)this.approxRowCount, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"table", (Object)this.table, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"column", (Object)this.column, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"nameColumn", (Object)this.nameColumn, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"ordinalColumn", (Object)this.ordinalColumn, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"parentColumn", (Object)this.parentColumn, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"nullParentValue", (Object)this.nullParentValue, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"type", (Object)this.type, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"uniqueMembers", (Object)this.uniqueMembers, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"levelType", (Object)this.levelType, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"hideMemberIf", (Object)this.hideMemberIf, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"formatter", (Object)this.formatter, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Level.displayAttribute((PrintWriter)_out, (String)"captionColumn", (Object)this.captionColumn, (int)(_indent + 1));
            Level.displayElement((PrintWriter)_out, (String)"annotations", (ElementDef)this.annotations, (int)(_indent + 1));
            Level.displayElement((PrintWriter)_out, (String)"keyExp", (ElementDef)this.keyExp, (int)(_indent + 1));
            Level.displayElement((PrintWriter)_out, (String)"nameExp", (ElementDef)this.nameExp, (int)(_indent + 1));
            Level.displayElement((PrintWriter)_out, (String)"ordinalExp", (ElementDef)this.ordinalExp, (int)(_indent + 1));
            Level.displayElement((PrintWriter)_out, (String)"parentExp", (ElementDef)this.parentExp, (int)(_indent + 1));
            Level.displayElement((PrintWriter)_out, (String)"closure", (ElementDef)this.closure, (int)(_indent + 1));
            Level.displayElementArray((PrintWriter)_out, (String)"properties", (NodeDef[])this.properties, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Level", new XMLAttrVector().add("approxRowCount", (Object)this.approxRowCount).add("name", (Object)this.name).add("table", (Object)this.table).add("column", (Object)this.column).add("nameColumn", (Object)this.nameColumn).add("ordinalColumn", (Object)this.ordinalColumn).add("parentColumn", (Object)this.parentColumn).add("nullParentValue", (Object)this.nullParentValue).add("type", (Object)this.type).add("uniqueMembers", (Object)this.uniqueMembers).add("levelType", (Object)this.levelType).add("hideMemberIf", (Object)this.hideMemberIf).add("formatter", (Object)this.formatter).add("caption", (Object)this.caption).add("description", (Object)this.description).add("captionColumn", (Object)this.captionColumn));
            Level.displayXMLElement((XMLOutput)_out, (ElementDef)this.annotations);
            Level.displayXMLElement((XMLOutput)_out, (ElementDef)this.keyExp);
            Level.displayXMLElement((XMLOutput)_out, (ElementDef)this.nameExp);
            Level.displayXMLElement((XMLOutput)_out, (ElementDef)this.ordinalExp);
            Level.displayXMLElement((XMLOutput)_out, (ElementDef)this.parentExp);
            Level.displayXMLElement((XMLOutput)_out, (ElementDef)this.closure);
            Level.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.properties);
            _out.endTag("Level");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Level _cother = (Level)_other;
            boolean _diff = Level.displayAttributeDiff((String)"approxRowCount", (Object)this.approxRowCount, (Object)_cother.approxRowCount, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"table", (Object)this.table, (Object)_cother.table, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"column", (Object)this.column, (Object)_cother.column, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"nameColumn", (Object)this.nameColumn, (Object)_cother.nameColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"ordinalColumn", (Object)this.ordinalColumn, (Object)_cother.ordinalColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"parentColumn", (Object)this.parentColumn, (Object)_cother.parentColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"nullParentValue", (Object)this.nullParentValue, (Object)_cother.nullParentValue, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"type", (Object)this.type, (Object)_cother.type, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"uniqueMembers", (Object)this.uniqueMembers, (Object)_cother.uniqueMembers, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"levelType", (Object)this.levelType, (Object)_cother.levelType, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"hideMemberIf", (Object)this.hideMemberIf, (Object)_cother.hideMemberIf, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"formatter", (Object)this.formatter, (Object)_cother.formatter, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayAttributeDiff((String)"captionColumn", (Object)this.captionColumn, (Object)_cother.captionColumn, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayElementDiff((String)"annotations", (NodeDef)this.annotations, (NodeDef)_cother.annotations, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayElementDiff((String)"keyExp", (NodeDef)this.keyExp, (NodeDef)_cother.keyExp, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayElementDiff((String)"nameExp", (NodeDef)this.nameExp, (NodeDef)_cother.nameExp, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayElementDiff((String)"ordinalExp", (NodeDef)this.ordinalExp, (NodeDef)_cother.ordinalExp, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayElementDiff((String)"parentExp", (NodeDef)this.parentExp, (NodeDef)_cother.parentExp, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayElementDiff((String)"closure", (NodeDef)this.closure, (NodeDef)_cother.closure, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Level.displayElementArrayDiff((String)"properties", (NodeDef[])this.properties, (NodeDef[])_cother.properties, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public Expression getKeyExp() {
            if (this.keyExp != null) {
                return this.keyExp;
            }
            if (this.column != null) {
                return new Column(this.table, this.column);
            }
            return null;
        }

        public Expression getNameExp() {
            if (this.nameExp != null) {
                return this.nameExp;
            }
            if (this.nameColumn != null) {
                return new Column(this.table, this.nameColumn);
            }
            return null;
        }

        public Expression getCaptionExp() {
            if (this.captionColumn != null) {
                return new Column(this.table, this.captionColumn);
            }
            return null;
        }

        public Expression getOrdinalExp() {
            if (this.ordinalExp != null) {
                return this.ordinalExp;
            }
            if (this.ordinalColumn != null) {
                return new Column(this.table, this.ordinalColumn);
            }
            return null;
        }

        public Expression getParentExp() {
            if (this.parentExp != null) {
                return this.parentExp;
            }
            if (this.parentColumn != null) {
                return new Column(this.table, this.parentColumn);
            }
            return null;
        }

        public Expression getPropertyExp(int i) {
            return new Column(this.table, this.properties[i].column);
        }

        public Dialect.Datatype getDatatype() {
            return Dialect.Datatype.valueOf(this.type);
        }
    }

    public static class Hierarchy
    extends ElementDef {
        public String name;
        public Boolean hasAll;
        public String allMemberName;
        public String allMemberCaption;
        public String allLevelName;
        public String primaryKey;
        public String primaryKeyTable;
        public String defaultMember;
        public String memberReaderClass;
        public String caption;
        public String description;
        public String uniqueKeyLevelName;
        public Annotations annotations;
        public RelationOrJoin relation;
        public Level[] levels;
        public MemberReaderParameter[] memberReaderParameters;

        public Hierarchy() {
        }

        public Hierarchy(DOMWrapper _def) throws XOMException {
            try {
                int _i;
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, false);
                this.hasAll = (Boolean)_parser.getAttribute("hasAll", "Boolean", null, null, true);
                this.allMemberName = (String)_parser.getAttribute("allMemberName", "String", null, null, false);
                this.allMemberCaption = (String)_parser.getAttribute("allMemberCaption", "String", null, null, false);
                this.allLevelName = (String)_parser.getAttribute("allLevelName", "String", null, null, false);
                this.primaryKey = (String)_parser.getAttribute("primaryKey", "String", null, null, false);
                this.primaryKeyTable = (String)_parser.getAttribute("primaryKeyTable", "String", null, null, false);
                this.defaultMember = (String)_parser.getAttribute("defaultMember", "String", null, null, false);
                this.memberReaderClass = (String)_parser.getAttribute("memberReaderClass", "String", null, null, false);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.uniqueKeyLevelName = (String)_parser.getAttribute("uniqueKeyLevelName", "String", null, null, false);
                this.annotations = (Annotations)_parser.getElement(Annotations.class, false);
                this.relation = (RelationOrJoin)_parser.getElement(RelationOrJoin.class, false);
                NodeDef[] _tempArray = _parser.getArray(Level.class, 0, 0);
                this.levels = new Level[_tempArray.length];
                for (_i = 0; _i < this.levels.length; ++_i) {
                    this.levels[_i] = (Level)_tempArray[_i];
                }
                _tempArray = _parser.getArray(MemberReaderParameter.class, 0, 0);
                this.memberReaderParameters = new MemberReaderParameter[_tempArray.length];
                for (_i = 0; _i < this.memberReaderParameters.length; ++_i) {
                    this.memberReaderParameters[_i] = (MemberReaderParameter)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Hierarchy";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"hasAll", (Object)this.hasAll, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"allMemberName", (Object)this.allMemberName, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"allMemberCaption", (Object)this.allMemberCaption, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"allLevelName", (Object)this.allLevelName, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"primaryKey", (Object)this.primaryKey, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"primaryKeyTable", (Object)this.primaryKeyTable, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"defaultMember", (Object)this.defaultMember, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"memberReaderClass", (Object)this.memberReaderClass, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Hierarchy.displayAttribute((PrintWriter)_out, (String)"uniqueKeyLevelName", (Object)this.uniqueKeyLevelName, (int)(_indent + 1));
            Hierarchy.displayElement((PrintWriter)_out, (String)"annotations", (ElementDef)this.annotations, (int)(_indent + 1));
            Hierarchy.displayElement((PrintWriter)_out, (String)"relation", (ElementDef)this.relation, (int)(_indent + 1));
            Hierarchy.displayElementArray((PrintWriter)_out, (String)"levels", (NodeDef[])this.levels, (int)(_indent + 1));
            Hierarchy.displayElementArray((PrintWriter)_out, (String)"memberReaderParameters", (NodeDef[])this.memberReaderParameters, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Hierarchy", new XMLAttrVector().add("name", (Object)this.name).add("hasAll", (Object)this.hasAll).add("allMemberName", (Object)this.allMemberName).add("allMemberCaption", (Object)this.allMemberCaption).add("allLevelName", (Object)this.allLevelName).add("primaryKey", (Object)this.primaryKey).add("primaryKeyTable", (Object)this.primaryKeyTable).add("defaultMember", (Object)this.defaultMember).add("memberReaderClass", (Object)this.memberReaderClass).add("caption", (Object)this.caption).add("description", (Object)this.description).add("uniqueKeyLevelName", (Object)this.uniqueKeyLevelName));
            Hierarchy.displayXMLElement((XMLOutput)_out, (ElementDef)this.annotations);
            Hierarchy.displayXMLElement((XMLOutput)_out, (ElementDef)this.relation);
            Hierarchy.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.levels);
            Hierarchy.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.memberReaderParameters);
            _out.endTag("Hierarchy");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Hierarchy _cother = (Hierarchy)_other;
            boolean _diff = Hierarchy.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"hasAll", (Object)this.hasAll, (Object)_cother.hasAll, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"allMemberName", (Object)this.allMemberName, (Object)_cother.allMemberName, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"allMemberCaption", (Object)this.allMemberCaption, (Object)_cother.allMemberCaption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"allLevelName", (Object)this.allLevelName, (Object)_cother.allLevelName, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"primaryKey", (Object)this.primaryKey, (Object)_cother.primaryKey, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"primaryKeyTable", (Object)this.primaryKeyTable, (Object)_cother.primaryKeyTable, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"defaultMember", (Object)this.defaultMember, (Object)_cother.defaultMember, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"memberReaderClass", (Object)this.memberReaderClass, (Object)_cother.memberReaderClass, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayAttributeDiff((String)"uniqueKeyLevelName", (Object)this.uniqueKeyLevelName, (Object)_cother.uniqueKeyLevelName, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayElementDiff((String)"annotations", (NodeDef)this.annotations, (NodeDef)_cother.annotations, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayElementDiff((String)"relation", (NodeDef)this.relation, (NodeDef)_cother.relation, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayElementArrayDiff((String)"levels", (NodeDef[])this.levels, (NodeDef[])_cother.levels, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Hierarchy.displayElementArrayDiff((String)"memberReaderParameters", (NodeDef[])this.memberReaderParameters, (NodeDef[])_cother.memberReaderParameters, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class Dimension
    extends CubeDimension {
        public static final String[] _type_values = new String[]{"StandardDimension", "TimeDimension"};
        public String type;
        public String usagePrefix;
        public Hierarchy[] hierarchies;

        public Dimension() {
        }

        public Dimension(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.type = (String)_parser.getAttribute("type", "String", null, _type_values, false);
                this.usagePrefix = (String)_parser.getAttribute("usagePrefix", "String", null, null, false);
                this.foreignKey = (String)_parser.getAttribute("foreignKey", "String", null, null, false);
                this.highCardinality = (Boolean)_parser.getAttribute("highCardinality", "Boolean", "false", null, false);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.annotations = (Annotations)_parser.getElement(Annotations.class, false);
                NodeDef[] _tempArray = _parser.getArray(Hierarchy.class, 0, 0);
                this.hierarchies = new Hierarchy[_tempArray.length];
                for (int _i = 0; _i < this.hierarchies.length; ++_i) {
                    this.hierarchies[_i] = (Hierarchy)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Dimension";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Dimension.displayAttribute((PrintWriter)_out, (String)"type", (Object)this.type, (int)(_indent + 1));
            Dimension.displayAttribute((PrintWriter)_out, (String)"usagePrefix", (Object)this.usagePrefix, (int)(_indent + 1));
            Dimension.displayAttribute((PrintWriter)_out, (String)"foreignKey", (Object)this.foreignKey, (int)(_indent + 1));
            Dimension.displayAttribute((PrintWriter)_out, (String)"highCardinality", (Object)this.highCardinality, (int)(_indent + 1));
            Dimension.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Dimension.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            Dimension.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Dimension.displayElement((PrintWriter)_out, (String)"annotations", (ElementDef)this.annotations, (int)(_indent + 1));
            Dimension.displayElementArray((PrintWriter)_out, (String)"hierarchies", (NodeDef[])this.hierarchies, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Dimension", new XMLAttrVector().add("type", (Object)this.type).add("usagePrefix", (Object)this.usagePrefix).add("foreignKey", (Object)this.foreignKey).add("highCardinality", (Object)this.highCardinality).add("name", (Object)this.name).add("caption", (Object)this.caption).add("description", (Object)this.description));
            Dimension.displayXMLElement((XMLOutput)_out, (ElementDef)this.annotations);
            Dimension.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.hierarchies);
            _out.endTag("Dimension");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Dimension _cother = (Dimension)_other;
            boolean _diff = Dimension.displayAttributeDiff((String)"type", (Object)this.type, (Object)_cother.type, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Dimension.displayAttributeDiff((String)"usagePrefix", (Object)this.usagePrefix, (Object)_cother.usagePrefix, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Dimension.displayElementDiff((String)"annotations", (NodeDef)this.annotations, (NodeDef)_cother.annotations, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Dimension.displayElementArrayDiff((String)"hierarchies", (NodeDef[])this.hierarchies, (NodeDef[])_cother.hierarchies, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public Dimension getDimension(Schema schema) {
            Util.assertPrecondition(schema != null, "schema != null");
            return this;
        }

        public DimensionType getDimensionType() {
            if (this.type == null) {
                return null;
            }
            return DimensionType.valueOf(this.type);
        }
    }

    public static class DimensionUsage
    extends CubeDimension {
        public String source;
        public String level;
        public String usagePrefix;

        public DimensionUsage() {
        }

        public DimensionUsage(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.source = (String)_parser.getAttribute("source", "String", null, null, true);
                this.level = (String)_parser.getAttribute("level", "String", null, null, false);
                this.usagePrefix = (String)_parser.getAttribute("usagePrefix", "String", null, null, false);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.foreignKey = (String)_parser.getAttribute("foreignKey", "String", null, null, false);
                this.highCardinality = (Boolean)_parser.getAttribute("highCardinality", "Boolean", "false", null, false);
                this.annotations = (Annotations)_parser.getElement(Annotations.class, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "DimensionUsage";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            DimensionUsage.displayAttribute((PrintWriter)_out, (String)"source", (Object)this.source, (int)(_indent + 1));
            DimensionUsage.displayAttribute((PrintWriter)_out, (String)"level", (Object)this.level, (int)(_indent + 1));
            DimensionUsage.displayAttribute((PrintWriter)_out, (String)"usagePrefix", (Object)this.usagePrefix, (int)(_indent + 1));
            DimensionUsage.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            DimensionUsage.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            DimensionUsage.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            DimensionUsage.displayAttribute((PrintWriter)_out, (String)"foreignKey", (Object)this.foreignKey, (int)(_indent + 1));
            DimensionUsage.displayAttribute((PrintWriter)_out, (String)"highCardinality", (Object)this.highCardinality, (int)(_indent + 1));
            DimensionUsage.displayElement((PrintWriter)_out, (String)"annotations", (ElementDef)this.annotations, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("DimensionUsage", new XMLAttrVector().add("source", (Object)this.source).add("level", (Object)this.level).add("usagePrefix", (Object)this.usagePrefix).add("name", (Object)this.name).add("caption", (Object)this.caption).add("description", (Object)this.description).add("foreignKey", (Object)this.foreignKey).add("highCardinality", (Object)this.highCardinality));
            DimensionUsage.displayXMLElement((XMLOutput)_out, (ElementDef)this.annotations);
            _out.endTag("DimensionUsage");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            DimensionUsage _cother = (DimensionUsage)_other;
            boolean _diff = DimensionUsage.displayAttributeDiff((String)"source", (Object)this.source, (Object)_cother.source, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && DimensionUsage.displayAttributeDiff((String)"level", (Object)this.level, (Object)_cother.level, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && DimensionUsage.displayAttributeDiff((String)"usagePrefix", (Object)this.usagePrefix, (Object)_cother.usagePrefix, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && DimensionUsage.displayElementDiff((String)"annotations", (NodeDef)this.annotations, (NodeDef)_cother.annotations, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public Dimension getDimension(Schema schema) {
            Util.assertPrecondition(schema != null, "schema != null");
            for (int i = 0; i < schema.dimensions.length; ++i) {
                if (!schema.dimensions[i].name.equals(this.source)) continue;
                return schema.dimensions[i];
            }
            throw Util.newInternal("Cannot find shared dimension '" + this.source + "'");
        }
    }

    public static class VirtualCubeMeasure
    extends ElementDef {
        public String cubeName;
        public String name;
        public Boolean visible;
        public Annotations annotations;

        public VirtualCubeMeasure() {
        }

        public VirtualCubeMeasure(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.cubeName = (String)_parser.getAttribute("cubeName", "String", null, null, false);
                this.name = (String)_parser.getAttribute("name", "String", null, null, false);
                this.visible = (Boolean)_parser.getAttribute("visible", "Boolean", null, null, false);
                this.annotations = (Annotations)_parser.getElement(Annotations.class, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "VirtualCubeMeasure";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            VirtualCubeMeasure.displayAttribute((PrintWriter)_out, (String)"cubeName", (Object)this.cubeName, (int)(_indent + 1));
            VirtualCubeMeasure.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            VirtualCubeMeasure.displayAttribute((PrintWriter)_out, (String)"visible", (Object)this.visible, (int)(_indent + 1));
            VirtualCubeMeasure.displayElement((PrintWriter)_out, (String)"annotations", (ElementDef)this.annotations, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("VirtualCubeMeasure", new XMLAttrVector().add("cubeName", (Object)this.cubeName).add("name", (Object)this.name).add("visible", (Object)this.visible));
            VirtualCubeMeasure.displayXMLElement((XMLOutput)_out, (ElementDef)this.annotations);
            _out.endTag("VirtualCubeMeasure");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            VirtualCubeMeasure _cother = (VirtualCubeMeasure)_other;
            boolean _diff = VirtualCubeMeasure.displayAttributeDiff((String)"cubeName", (Object)this.cubeName, (Object)_cother.cubeName, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && VirtualCubeMeasure.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && VirtualCubeMeasure.displayAttributeDiff((String)"visible", (Object)this.visible, (Object)_cother.visible, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && VirtualCubeMeasure.displayElementDiff((String)"annotations", (NodeDef)this.annotations, (NodeDef)_cother.annotations, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class VirtualCubeDimension
    extends CubeDimension {
        public String cubeName;

        public VirtualCubeDimension() {
        }

        public VirtualCubeDimension(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.cubeName = (String)_parser.getAttribute("cubeName", "String", null, null, false);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.foreignKey = (String)_parser.getAttribute("foreignKey", "String", null, null, false);
                this.highCardinality = (Boolean)_parser.getAttribute("highCardinality", "Boolean", "false", null, false);
                this.name = (String)_parser.getAttribute("name", "String", null, null, false);
                this.annotations = (Annotations)_parser.getElement(Annotations.class, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "VirtualCubeDimension";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            VirtualCubeDimension.displayAttribute((PrintWriter)_out, (String)"cubeName", (Object)this.cubeName, (int)(_indent + 1));
            VirtualCubeDimension.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            VirtualCubeDimension.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            VirtualCubeDimension.displayAttribute((PrintWriter)_out, (String)"foreignKey", (Object)this.foreignKey, (int)(_indent + 1));
            VirtualCubeDimension.displayAttribute((PrintWriter)_out, (String)"highCardinality", (Object)this.highCardinality, (int)(_indent + 1));
            VirtualCubeDimension.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            VirtualCubeDimension.displayElement((PrintWriter)_out, (String)"annotations", (ElementDef)this.annotations, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("VirtualCubeDimension", new XMLAttrVector().add("cubeName", (Object)this.cubeName).add("caption", (Object)this.caption).add("description", (Object)this.description).add("foreignKey", (Object)this.foreignKey).add("highCardinality", (Object)this.highCardinality).add("name", (Object)this.name));
            VirtualCubeDimension.displayXMLElement((XMLOutput)_out, (ElementDef)this.annotations);
            _out.endTag("VirtualCubeDimension");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            VirtualCubeDimension _cother = (VirtualCubeDimension)_other;
            boolean _diff = VirtualCubeDimension.displayAttributeDiff((String)"cubeName", (Object)this.cubeName, (Object)_cother.cubeName, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && VirtualCubeDimension.displayElementDiff((String)"annotations", (NodeDef)this.annotations, (NodeDef)_cother.annotations, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public Dimension getDimension(Schema schema) {
            Util.assertPrecondition(schema != null, "schema != null");
            if (this.cubeName == null) {
                return schema.getPublicDimension(this.name);
            }
            Cube cube = schema.getCube(this.cubeName);
            return cube.getDimension(schema, this.name);
        }
    }

    public static class CubeUsage
    extends ElementDef {
        public String cubeName;
        public Boolean ignoreUnrelatedDimensions;

        public CubeUsage() {
        }

        public CubeUsage(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.cubeName = (String)_parser.getAttribute("cubeName", "String", null, null, true);
                this.ignoreUnrelatedDimensions = (Boolean)_parser.getAttribute("ignoreUnrelatedDimensions", "Boolean", "false", null, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "CubeUsage";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            CubeUsage.displayAttribute((PrintWriter)_out, (String)"cubeName", (Object)this.cubeName, (int)(_indent + 1));
            CubeUsage.displayAttribute((PrintWriter)_out, (String)"ignoreUnrelatedDimensions", (Object)this.ignoreUnrelatedDimensions, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("CubeUsage", new XMLAttrVector().add("cubeName", (Object)this.cubeName).add("ignoreUnrelatedDimensions", (Object)this.ignoreUnrelatedDimensions));
            _out.endTag("CubeUsage");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            CubeUsage _cother = (CubeUsage)_other;
            boolean _diff = CubeUsage.displayAttributeDiff((String)"cubeName", (Object)this.cubeName, (Object)_cother.cubeName, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CubeUsage.displayAttributeDiff((String)"ignoreUnrelatedDimensions", (Object)this.ignoreUnrelatedDimensions, (Object)_cother.ignoreUnrelatedDimensions, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class CubeUsages
    extends ElementDef {
        public CubeUsage[] cubeUsages;

        public CubeUsages() {
        }

        public CubeUsages(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                NodeDef[] _tempArray = _parser.getArray(CubeUsage.class, 1, 0);
                this.cubeUsages = new CubeUsage[_tempArray.length];
                for (int _i = 0; _i < this.cubeUsages.length; ++_i) {
                    this.cubeUsages[_i] = (CubeUsage)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "CubeUsages";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            CubeUsages.displayElementArray((PrintWriter)_out, (String)"cubeUsages", (NodeDef[])this.cubeUsages, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("CubeUsages", new XMLAttrVector());
            CubeUsages.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.cubeUsages);
            _out.endTag("CubeUsages");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            CubeUsages _cother = (CubeUsages)_other;
            boolean _diff = CubeUsages.displayElementArrayDiff((String)"cubeUsages", (NodeDef[])this.cubeUsages, (NodeDef[])_cother.cubeUsages, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }
    }

    public static class VirtualCube
    extends ElementDef {
        public Boolean enabled;
        public String name;
        public String defaultMeasure;
        public String caption;
        public String description;
        public Annotations annotations;
        public CubeUsages cubeUsage;
        public VirtualCubeDimension[] dimensions;
        public VirtualCubeMeasure[] measures;
        public CalculatedMember[] calculatedMembers;
        public NamedSet[] namedSets;

        public VirtualCube() {
        }

        public VirtualCube(DOMWrapper _def) throws XOMException {
            try {
                int _i;
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
                this.name = (String)_parser.getAttribute("name", "String", null, null, false);
                this.defaultMeasure = (String)_parser.getAttribute("defaultMeasure", "String", null, null, false);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.annotations = (Annotations)_parser.getElement(Annotations.class, false);
                this.cubeUsage = (CubeUsages)_parser.getElement(CubeUsages.class, false);
                NodeDef[] _tempArray = _parser.getArray(VirtualCubeDimension.class, 0, 0);
                this.dimensions = new VirtualCubeDimension[_tempArray.length];
                for (_i = 0; _i < this.dimensions.length; ++_i) {
                    this.dimensions[_i] = (VirtualCubeDimension)_tempArray[_i];
                }
                _tempArray = _parser.getArray(VirtualCubeMeasure.class, 0, 0);
                this.measures = new VirtualCubeMeasure[_tempArray.length];
                for (_i = 0; _i < this.measures.length; ++_i) {
                    this.measures[_i] = (VirtualCubeMeasure)_tempArray[_i];
                }
                _tempArray = _parser.getArray(CalculatedMember.class, 0, 0);
                this.calculatedMembers = new CalculatedMember[_tempArray.length];
                for (_i = 0; _i < this.calculatedMembers.length; ++_i) {
                    this.calculatedMembers[_i] = (CalculatedMember)_tempArray[_i];
                }
                _tempArray = _parser.getArray(NamedSet.class, 0, 0);
                this.namedSets = new NamedSet[_tempArray.length];
                for (_i = 0; _i < this.namedSets.length; ++_i) {
                    this.namedSets[_i] = (NamedSet)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "VirtualCube";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            VirtualCube.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
            VirtualCube.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            VirtualCube.displayAttribute((PrintWriter)_out, (String)"defaultMeasure", (Object)this.defaultMeasure, (int)(_indent + 1));
            VirtualCube.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            VirtualCube.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            VirtualCube.displayElement((PrintWriter)_out, (String)"annotations", (ElementDef)this.annotations, (int)(_indent + 1));
            VirtualCube.displayElement((PrintWriter)_out, (String)"cubeUsage", (ElementDef)this.cubeUsage, (int)(_indent + 1));
            VirtualCube.displayElementArray((PrintWriter)_out, (String)"dimensions", (NodeDef[])this.dimensions, (int)(_indent + 1));
            VirtualCube.displayElementArray((PrintWriter)_out, (String)"measures", (NodeDef[])this.measures, (int)(_indent + 1));
            VirtualCube.displayElementArray((PrintWriter)_out, (String)"calculatedMembers", (NodeDef[])this.calculatedMembers, (int)(_indent + 1));
            VirtualCube.displayElementArray((PrintWriter)_out, (String)"namedSets", (NodeDef[])this.namedSets, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("VirtualCube", new XMLAttrVector().add("enabled", (Object)this.enabled).add("name", (Object)this.name).add("defaultMeasure", (Object)this.defaultMeasure).add("caption", (Object)this.caption).add("description", (Object)this.description));
            VirtualCube.displayXMLElement((XMLOutput)_out, (ElementDef)this.annotations);
            VirtualCube.displayXMLElement((XMLOutput)_out, (ElementDef)this.cubeUsage);
            VirtualCube.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.dimensions);
            VirtualCube.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.measures);
            VirtualCube.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.calculatedMembers);
            VirtualCube.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.namedSets);
            _out.endTag("VirtualCube");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            VirtualCube _cother = (VirtualCube)_other;
            boolean _diff = VirtualCube.displayAttributeDiff((String)"enabled", (Object)this.enabled, (Object)_cother.enabled, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && VirtualCube.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && VirtualCube.displayAttributeDiff((String)"defaultMeasure", (Object)this.defaultMeasure, (Object)_cother.defaultMeasure, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && VirtualCube.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && VirtualCube.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && VirtualCube.displayElementDiff((String)"annotations", (NodeDef)this.annotations, (NodeDef)_cother.annotations, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && VirtualCube.displayElementDiff((String)"cubeUsage", (NodeDef)this.cubeUsage, (NodeDef)_cother.cubeUsage, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && VirtualCube.displayElementArrayDiff((String)"dimensions", (NodeDef[])this.dimensions, (NodeDef[])_cother.dimensions, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && VirtualCube.displayElementArrayDiff((String)"measures", (NodeDef[])this.measures, (NodeDef[])_cother.measures, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && VirtualCube.displayElementArrayDiff((String)"calculatedMembers", (NodeDef[])this.calculatedMembers, (NodeDef[])_cother.calculatedMembers, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && VirtualCube.displayElementArrayDiff((String)"namedSets", (NodeDef[])this.namedSets, (NodeDef[])_cother.namedSets, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class Cube
    extends ElementDef {
        public String name;
        public String caption;
        public String description;
        public String defaultMeasure;
        public Boolean cache;
        public Boolean enabled;
        public Annotations annotations;
        public Relation fact;
        public CubeDimension[] dimensions;
        public Measure[] measures;
        public CalculatedMember[] calculatedMembers;
        public NamedSet[] namedSets;

        public Cube() {
        }

        public Cube(DOMWrapper _def) throws XOMException {
            try {
                int _i;
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.defaultMeasure = (String)_parser.getAttribute("defaultMeasure", "String", null, null, false);
                this.cache = (Boolean)_parser.getAttribute("cache", "Boolean", "true", null, false);
                this.enabled = (Boolean)_parser.getAttribute("enabled", "Boolean", "true", null, false);
                this.annotations = (Annotations)_parser.getElement(Annotations.class, false);
                this.fact = (Relation)_parser.getElement(Relation.class, true);
                NodeDef[] _tempArray = _parser.getArray(CubeDimension.class, 0, 0);
                this.dimensions = new CubeDimension[_tempArray.length];
                for (_i = 0; _i < this.dimensions.length; ++_i) {
                    this.dimensions[_i] = (CubeDimension)_tempArray[_i];
                }
                _tempArray = _parser.getArray(Measure.class, 0, 0);
                this.measures = new Measure[_tempArray.length];
                for (_i = 0; _i < this.measures.length; ++_i) {
                    this.measures[_i] = (Measure)_tempArray[_i];
                }
                _tempArray = _parser.getArray(CalculatedMember.class, 0, 0);
                this.calculatedMembers = new CalculatedMember[_tempArray.length];
                for (_i = 0; _i < this.calculatedMembers.length; ++_i) {
                    this.calculatedMembers[_i] = (CalculatedMember)_tempArray[_i];
                }
                _tempArray = _parser.getArray(NamedSet.class, 0, 0);
                this.namedSets = new NamedSet[_tempArray.length];
                for (_i = 0; _i < this.namedSets.length; ++_i) {
                    this.namedSets[_i] = (NamedSet)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Cube";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Cube.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Cube.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            Cube.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Cube.displayAttribute((PrintWriter)_out, (String)"defaultMeasure", (Object)this.defaultMeasure, (int)(_indent + 1));
            Cube.displayAttribute((PrintWriter)_out, (String)"cache", (Object)this.cache, (int)(_indent + 1));
            Cube.displayAttribute((PrintWriter)_out, (String)"enabled", (Object)this.enabled, (int)(_indent + 1));
            Cube.displayElement((PrintWriter)_out, (String)"annotations", (ElementDef)this.annotations, (int)(_indent + 1));
            Cube.displayElement((PrintWriter)_out, (String)"fact", (ElementDef)this.fact, (int)(_indent + 1));
            Cube.displayElementArray((PrintWriter)_out, (String)"dimensions", (NodeDef[])this.dimensions, (int)(_indent + 1));
            Cube.displayElementArray((PrintWriter)_out, (String)"measures", (NodeDef[])this.measures, (int)(_indent + 1));
            Cube.displayElementArray((PrintWriter)_out, (String)"calculatedMembers", (NodeDef[])this.calculatedMembers, (int)(_indent + 1));
            Cube.displayElementArray((PrintWriter)_out, (String)"namedSets", (NodeDef[])this.namedSets, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Cube", new XMLAttrVector().add("name", (Object)this.name).add("caption", (Object)this.caption).add("description", (Object)this.description).add("defaultMeasure", (Object)this.defaultMeasure).add("cache", (Object)this.cache).add("enabled", (Object)this.enabled));
            Cube.displayXMLElement((XMLOutput)_out, (ElementDef)this.annotations);
            Cube.displayXMLElement((XMLOutput)_out, (ElementDef)this.fact);
            Cube.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.dimensions);
            Cube.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.measures);
            Cube.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.calculatedMembers);
            Cube.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.namedSets);
            _out.endTag("Cube");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Cube _cother = (Cube)_other;
            boolean _diff = Cube.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayAttributeDiff((String)"defaultMeasure", (Object)this.defaultMeasure, (Object)_cother.defaultMeasure, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayAttributeDiff((String)"cache", (Object)this.cache, (Object)_cother.cache, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayAttributeDiff((String)"enabled", (Object)this.enabled, (Object)_cother.enabled, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayElementDiff((String)"annotations", (NodeDef)this.annotations, (NodeDef)_cother.annotations, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayElementDiff((String)"fact", (NodeDef)this.fact, (NodeDef)_cother.fact, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayElementArrayDiff((String)"dimensions", (NodeDef[])this.dimensions, (NodeDef[])_cother.dimensions, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayElementArrayDiff((String)"measures", (NodeDef[])this.measures, (NodeDef[])_cother.measures, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayElementArrayDiff((String)"calculatedMembers", (NodeDef[])this.calculatedMembers, (NodeDef[])_cother.calculatedMembers, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Cube.displayElementArrayDiff((String)"namedSets", (NodeDef[])this.namedSets, (NodeDef[])_cother.namedSets, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        Dimension getDimension(Schema xmlSchema, String dimensionName) {
            for (int i = 0; i < this.dimensions.length; ++i) {
                if (!this.dimensions[i].name.equals(dimensionName)) continue;
                return this.dimensions[i].getDimension(xmlSchema);
            }
            throw Util.newInternal("Cannot find dimension '" + dimensionName + "' in cube '" + this.name + "'");
        }
    }

    public static abstract class CubeDimension
    extends ElementDef {
        public String name;
        public String caption;
        public String description;
        public String foreignKey;
        public Boolean highCardinality;
        public Annotations annotations;

        public CubeDimension() {
        }

        public CubeDimension(DOMWrapper _def) throws XOMException {
            try {
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.caption = (String)_parser.getAttribute("caption", "String", null, null, false);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.foreignKey = (String)_parser.getAttribute("foreignKey", "String", null, null, false);
                this.highCardinality = (Boolean)_parser.getAttribute("highCardinality", "Boolean", "false", null, false);
                this.annotations = (Annotations)_parser.getElement(Annotations.class, false);
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "CubeDimension";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            CubeDimension.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            CubeDimension.displayAttribute((PrintWriter)_out, (String)"caption", (Object)this.caption, (int)(_indent + 1));
            CubeDimension.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            CubeDimension.displayAttribute((PrintWriter)_out, (String)"foreignKey", (Object)this.foreignKey, (int)(_indent + 1));
            CubeDimension.displayAttribute((PrintWriter)_out, (String)"highCardinality", (Object)this.highCardinality, (int)(_indent + 1));
            CubeDimension.displayElement((PrintWriter)_out, (String)"annotations", (ElementDef)this.annotations, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("(%CubeDimension;)", new XMLAttrVector().add("name", (Object)this.name).add("caption", (Object)this.caption).add("description", (Object)this.description).add("foreignKey", (Object)this.foreignKey).add("highCardinality", (Object)this.highCardinality));
            CubeDimension.displayXMLElement((XMLOutput)_out, (ElementDef)this.annotations);
            _out.endTag("(%CubeDimension;)");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            CubeDimension _cother = (CubeDimension)_other;
            boolean _diff = CubeDimension.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CubeDimension.displayAttributeDiff((String)"caption", (Object)this.caption, (Object)_cother.caption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CubeDimension.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CubeDimension.displayAttributeDiff((String)"foreignKey", (Object)this.foreignKey, (Object)_cother.foreignKey, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CubeDimension.displayAttributeDiff((String)"highCardinality", (Object)this.highCardinality, (Object)_cother.highCardinality, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && CubeDimension.displayElementDiff((String)"annotations", (NodeDef)this.annotations, (NodeDef)_cother.annotations, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        public abstract Dimension getDimension(Schema var1);
    }

    public static class Schema
    extends ElementDef {
        public String name;
        public String description;
        public String measuresCaption;
        public String defaultRole;
        public Annotations annotations;
        public Parameter[] parameters;
        public Dimension[] dimensions;
        public Cube[] cubes;
        public VirtualCube[] virtualCubes;
        public NamedSet[] namedSets;
        public Role[] roles;
        public UserDefinedFunction[] userDefinedFunctions;

        public Schema() {
        }

        public Schema(DOMWrapper _def) throws XOMException {
            try {
                int _i;
                DOMElementParser _parser = new DOMElementParser(_def, "", MondrianDef.class);
                this.name = (String)_parser.getAttribute("name", "String", null, null, true);
                this.description = (String)_parser.getAttribute("description", "String", null, null, false);
                this.measuresCaption = (String)_parser.getAttribute("measuresCaption", "String", null, null, false);
                this.defaultRole = (String)_parser.getAttribute("defaultRole", "String", null, null, false);
                this.annotations = (Annotations)_parser.getElement(Annotations.class, false);
                NodeDef[] _tempArray = _parser.getArray(Parameter.class, 0, 0);
                this.parameters = new Parameter[_tempArray.length];
                for (_i = 0; _i < this.parameters.length; ++_i) {
                    this.parameters[_i] = (Parameter)_tempArray[_i];
                }
                _tempArray = _parser.getArray(Dimension.class, 0, 0);
                this.dimensions = new Dimension[_tempArray.length];
                for (_i = 0; _i < this.dimensions.length; ++_i) {
                    this.dimensions[_i] = (Dimension)_tempArray[_i];
                }
                _tempArray = _parser.getArray(Cube.class, 0, 0);
                this.cubes = new Cube[_tempArray.length];
                for (_i = 0; _i < this.cubes.length; ++_i) {
                    this.cubes[_i] = (Cube)_tempArray[_i];
                }
                _tempArray = _parser.getArray(VirtualCube.class, 0, 0);
                this.virtualCubes = new VirtualCube[_tempArray.length];
                for (_i = 0; _i < this.virtualCubes.length; ++_i) {
                    this.virtualCubes[_i] = (VirtualCube)_tempArray[_i];
                }
                _tempArray = _parser.getArray(NamedSet.class, 0, 0);
                this.namedSets = new NamedSet[_tempArray.length];
                for (_i = 0; _i < this.namedSets.length; ++_i) {
                    this.namedSets[_i] = (NamedSet)_tempArray[_i];
                }
                _tempArray = _parser.getArray(Role.class, 0, 0);
                this.roles = new Role[_tempArray.length];
                for (_i = 0; _i < this.roles.length; ++_i) {
                    this.roles[_i] = (Role)_tempArray[_i];
                }
                _tempArray = _parser.getArray(UserDefinedFunction.class, 0, 0);
                this.userDefinedFunctions = new UserDefinedFunction[_tempArray.length];
                for (_i = 0; _i < this.userDefinedFunctions.length; ++_i) {
                    this.userDefinedFunctions[_i] = (UserDefinedFunction)_tempArray[_i];
                }
            }
            catch (XOMException _ex) {
                throw new XOMException("In " + this.getName() + ": " + _ex.getMessage());
            }
        }

        public String getName() {
            return "Schema";
        }

        public void display(PrintWriter _out, int _indent) {
            _out.println(this.getName());
            Schema.displayAttribute((PrintWriter)_out, (String)"name", (Object)this.name, (int)(_indent + 1));
            Schema.displayAttribute((PrintWriter)_out, (String)"description", (Object)this.description, (int)(_indent + 1));
            Schema.displayAttribute((PrintWriter)_out, (String)"measuresCaption", (Object)this.measuresCaption, (int)(_indent + 1));
            Schema.displayAttribute((PrintWriter)_out, (String)"defaultRole", (Object)this.defaultRole, (int)(_indent + 1));
            Schema.displayElement((PrintWriter)_out, (String)"annotations", (ElementDef)this.annotations, (int)(_indent + 1));
            Schema.displayElementArray((PrintWriter)_out, (String)"parameters", (NodeDef[])this.parameters, (int)(_indent + 1));
            Schema.displayElementArray((PrintWriter)_out, (String)"dimensions", (NodeDef[])this.dimensions, (int)(_indent + 1));
            Schema.displayElementArray((PrintWriter)_out, (String)"cubes", (NodeDef[])this.cubes, (int)(_indent + 1));
            Schema.displayElementArray((PrintWriter)_out, (String)"virtualCubes", (NodeDef[])this.virtualCubes, (int)(_indent + 1));
            Schema.displayElementArray((PrintWriter)_out, (String)"namedSets", (NodeDef[])this.namedSets, (int)(_indent + 1));
            Schema.displayElementArray((PrintWriter)_out, (String)"roles", (NodeDef[])this.roles, (int)(_indent + 1));
            Schema.displayElementArray((PrintWriter)_out, (String)"userDefinedFunctions", (NodeDef[])this.userDefinedFunctions, (int)(_indent + 1));
        }

        public void displayXML(XMLOutput _out, int _indent) {
            _out.beginTag("Schema", new XMLAttrVector().add("name", (Object)this.name).add("description", (Object)this.description).add("measuresCaption", (Object)this.measuresCaption).add("defaultRole", (Object)this.defaultRole));
            Schema.displayXMLElement((XMLOutput)_out, (ElementDef)this.annotations);
            Schema.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.parameters);
            Schema.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.dimensions);
            Schema.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.cubes);
            Schema.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.virtualCubes);
            Schema.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.namedSets);
            Schema.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.roles);
            Schema.displayXMLElementArray((XMLOutput)_out, (NodeDef[])this.userDefinedFunctions);
            _out.endTag("Schema");
        }

        public boolean displayDiff(ElementDef _other, PrintWriter _out, int _indent) {
            Schema _cother = (Schema)_other;
            boolean _diff = Schema.displayAttributeDiff((String)"name", (Object)this.name, (Object)_cother.name, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayAttributeDiff((String)"description", (Object)this.description, (Object)_cother.description, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayAttributeDiff((String)"measuresCaption", (Object)this.measuresCaption, (Object)_cother.measuresCaption, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayAttributeDiff((String)"defaultRole", (Object)this.defaultRole, (Object)_cother.defaultRole, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayElementDiff((String)"annotations", (NodeDef)this.annotations, (NodeDef)_cother.annotations, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayElementArrayDiff((String)"parameters", (NodeDef[])this.parameters, (NodeDef[])_cother.parameters, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayElementArrayDiff((String)"dimensions", (NodeDef[])this.dimensions, (NodeDef[])_cother.dimensions, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayElementArrayDiff((String)"cubes", (NodeDef[])this.cubes, (NodeDef[])_cother.cubes, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayElementArrayDiff((String)"virtualCubes", (NodeDef[])this.virtualCubes, (NodeDef[])_cother.virtualCubes, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayElementArrayDiff((String)"namedSets", (NodeDef[])this.namedSets, (NodeDef[])_cother.namedSets, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayElementArrayDiff((String)"roles", (NodeDef[])this.roles, (NodeDef[])_cother.roles, (PrintWriter)_out, (int)(_indent + 1));
            _diff = _diff && Schema.displayElementArrayDiff((String)"userDefinedFunctions", (NodeDef[])this.userDefinedFunctions, (NodeDef[])_cother.userDefinedFunctions, (PrintWriter)_out, (int)(_indent + 1));
            return _diff;
        }

        Cube getCube(String cubeName) {
            for (int i = 0; i < this.cubes.length; ++i) {
                if (!this.cubes[i].name.equals(cubeName)) continue;
                return this.cubes[i];
            }
            throw Util.newInternal("Cannot find cube '" + cubeName + "'");
        }

        Dimension getPublicDimension(String dimensionName) {
            for (int i = 0; i < this.dimensions.length; ++i) {
                if (!this.dimensions[i].name.equals(dimensionName)) continue;
                return this.dimensions[i];
            }
            throw Util.newInternal("Cannot find public dimension '" + dimensionName + "'");
        }
    }
}

