/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ParameterCompilable;
import mondrian.calc.ParameterSlot;
import mondrian.calc.impl.AbstractMemberListCalc;
import mondrian.calc.impl.GenericCalc;
import mondrian.mdx.MemberExpr;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Literal;
import mondrian.olap.Member;
import mondrian.olap.Parameter;
import mondrian.olap.Util;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;

public class ParameterImpl
implements Parameter,
ParameterCompilable {
    private final String name;
    private String description;
    private Exp defaultExp;
    private Type type;
    private ParameterSlot slot = new ParameterSlot(){
        Object value;
        boolean assigned;

        public Object getCachedDefaultValue() {
            throw new UnsupportedOperationException();
        }

        public Calc getDefaultValueCalc() {
            throw new UnsupportedOperationException();
        }

        public int getIndex() {
            throw new UnsupportedOperationException();
        }

        public Parameter getParameter() {
            return ParameterImpl.this;
        }

        public Object getParameterValue() {
            return this.value;
        }

        public boolean isParameterSet() {
            return this.assigned;
        }

        public void unsetParameterValue() {
            this.assigned = false;
            this.value = null;
        }

        public void setCachedDefaultValue(Object value) {
            throw new UnsupportedOperationException();
        }

        public void setParameterValue(Object value, boolean assigned) {
            this.assigned = true;
            this.value = value;
        }
    };

    public ParameterImpl(String name, Exp defaultExp, String description, Type type) {
        this.name = name;
        this.defaultExp = defaultExp;
        this.description = description;
        this.type = type;
        assert (defaultExp != null);
        assert (type instanceof StringType || type instanceof NumericType || type instanceof MemberType);
    }

    public Parameter.Scope getScope() {
        return Parameter.Scope.Statement;
    }

    public Type getType() {
        return this.type;
    }

    public Exp getDefaultExp() {
        return this.defaultExp;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        if (this.slot == null) {
            return null;
        }
        return this.slot.getParameterValue();
    }

    public void setValue(Object value) {
        if (value instanceof MemberExpr) {
            this.slot.setParameterValue(((MemberExpr)value).getMember(), true);
        } else if (value instanceof Literal) {
            this.slot.setParameterValue(((Literal)value).getValue(), true);
        } else {
            this.slot.setParameterValue(value, true);
        }
    }

    public boolean isSet() {
        return this.slot != null && this.slot.isParameterSet();
    }

    public void unsetValue() {
        this.slot.unsetParameterValue();
    }

    public String getDescription() {
        return this.description;
    }

    public Object[] getChildren() {
        return null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof ParameterImpl)) {
            return false;
        }
        ParameterImpl that = (ParameterImpl)other;
        return that.getName().equals(this.getName()) && that.defaultExp.equals(this.defaultExp);
    }

    public int hashCode() {
        return Util.hash(this.getName().hashCode(), this.defaultExp.hashCode());
    }

    public boolean isModifiable() {
        return true;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setType(Type type) {
        assert (type instanceof StringType || type instanceof NumericType || type instanceof MemberType || type instanceof SetType && ((SetType)type).getElementType() instanceof MemberType) : type;
        this.type = type;
    }

    public void setDefaultExp(Exp defaultExp) {
        assert (defaultExp != null);
        this.defaultExp = defaultExp;
    }

    public Calc compile(ExpCompiler compiler) {
        ParameterSlot slot = compiler.registerParameter(this);
        if (this.slot != null && this.slot.isParameterSet()) {
            slot.setParameterValue(this.slot.getParameterValue(), true);
        }
        this.slot = slot;
        if (this.type instanceof SetType) {
            return new MemberListParameterCalc(slot);
        }
        return new ParameterCalc(slot);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MemberListParameterCalc
    extends AbstractMemberListCalc {
        private final ParameterSlot slot;

        public MemberListParameterCalc(ParameterSlot slot) {
            super(new DummyExp(slot.getParameter().getType()), new Calc[0]);
            this.slot = slot;
        }

        @Override
        public List<Member> evaluateMemberList(Evaluator evaluator) {
            List value = (List)evaluator.getParameterValue(this.slot);
            if (!this.slot.isParameterSet()) {
                this.slot.setParameterValue(value, false);
            }
            return value;
        }
    }

    private static class ParameterCalc
    extends GenericCalc {
        private final ParameterSlot slot;

        public ParameterCalc(ParameterSlot slot) {
            super(new DummyExp(slot.getParameter().getType()), new Calc[0]);
            this.slot = slot;
        }

        public Object evaluate(Evaluator evaluator) {
            Object value = evaluator.getParameterValue(this.slot);
            if (!this.slot.isParameterSet()) {
                this.slot.setParameterValue(value, false);
            }
            return value;
        }
    }
}

