/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mondrian.calc.BooleanCalc;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberIterCalc;
import mondrian.calc.MemberListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleIterCalc;
import mondrian.calc.TupleListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.AbstractMemberIterCalc;
import mondrian.calc.impl.AbstractTupleIterCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.ResultStyleException;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.type.SetType;

class FilterFunDef
extends FunDefBase {
    static final FilterFunDef instance = new FilterFunDef();

    private FilterFunDef() {
        super("Filter", "Returns the set resulting from filtering a set based on a search condition.", "fxxb");
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        List<ResultStyle> styles = compiler.getAcceptableResultStyles();
        if (call.getArg(0) instanceof ResolvedFunCall && ((ResolvedFunCall)call.getArg(0)).getFunName().equals("AS")) {
            styles = ResultStyle.ITERABLE_ONLY;
        }
        if (styles.contains((Object)ResultStyle.ITERABLE) || styles.contains((Object)ResultStyle.ANY)) {
            return this.compileCallIterable(call, compiler);
        }
        if (styles.contains((Object)ResultStyle.LIST) || styles.contains((Object)ResultStyle.MUTABLE_LIST)) {
            return this.compileCallList(call, compiler);
        }
        throw ResultStyleException.generate(ResultStyle.ITERABLE_LIST_MUTABLELIST_ANY, styles);
    }

    protected IterCalc compileCallIterable(ResolvedFunCall call, ExpCompiler compiler) {
        Calc imlcalc = compiler.compileAs(call.getArg(0), null, ResultStyle.ITERABLE_LIST_MUTABLELIST);
        BooleanCalc bcalc = compiler.compileBoolean(call.getArg(1));
        Calc[] calcs = new Calc[]{imlcalc, bcalc};
        FilterFunDef.checkIterListResultStyles(imlcalc);
        if (((SetType)imlcalc.getType()).getArity() == 1) {
            if (imlcalc.getResultStyle() == ResultStyle.ITERABLE) {
                return new IterMemberIterCalc(call, calcs);
            }
            if (imlcalc.getResultStyle() == ResultStyle.LIST) {
                return new ImMutableMemberIterCalc(call, calcs);
            }
            return new MutableMemberIterCalc(call, calcs);
        }
        if (imlcalc.getResultStyle() == ResultStyle.ITERABLE) {
            return new IterMemberArrayIterCalc(call, calcs);
        }
        if (imlcalc.getResultStyle() == ResultStyle.LIST) {
            return new ImMutableMemberArrayIterCalc(call, calcs);
        }
        return new MutableMemberArrayIterCalc(call, calcs);
    }

    protected ListCalc compileCallList(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc ilcalc = compiler.compileList(call.getArg(0), false);
        BooleanCalc bcalc = compiler.compileBoolean(call.getArg(1));
        Calc[] calcs = new Calc[]{ilcalc, bcalc};
        if (((SetType)ilcalc.getType()).getArity() == 1) {
            switch (ilcalc.getResultStyle()) {
                case LIST: {
                    return new ImmutableMemberListCalc(call, calcs);
                }
                case MUTABLE_LIST: {
                    return new MutableMemberListCalc(call, calcs);
                }
            }
            throw ResultStyleException.generateBadType(ResultStyle.MUTABLELIST_LIST, ilcalc.getResultStyle());
        }
        switch (ilcalc.getResultStyle()) {
            case LIST: {
                return new ImmutableTupleListCalc(call, calcs);
            }
            case MUTABLE_LIST: {
                return new MutableTupleListCalc(call, calcs);
            }
        }
        throw ResultStyleException.generateBadType(ResultStyle.MUTABLELIST_LIST, ilcalc.getResultStyle());
    }

    private static class ImmutableTupleListCalc
    extends BaseListCalc {
        ImmutableTupleListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
            assert (calcs[0] instanceof TupleListCalc);
            assert (calcs[1] instanceof BooleanCalc);
        }

        protected List makeList(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            TupleListCalc lcalc = (TupleListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push(false);
            List<Member[]> members = lcalc.evaluateTupleList(evaluator);
            ArrayList<Member[]> result = new ArrayList<Member[]>();
            int count = members.size();
            for (int i = 0; i < count; ++i) {
                Member[] member = members.get(i);
                evaluator2.setContext(member);
                if (!bcalc.evaluateBoolean(evaluator2)) continue;
                result.add(member);
            }
            return result;
        }
    }

    private static class MutableTupleListCalc
    extends BaseListCalc {
        MutableTupleListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
            assert (calcs[0] instanceof TupleListCalc);
            assert (calcs[1] instanceof BooleanCalc);
        }

        protected List makeList(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            TupleListCalc lcalc = (TupleListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push(false);
            List<Member[]> members = lcalc.evaluateTupleList(evaluator);
            members = new ArrayList<Member[]>(members);
            Iterator<Member[]> it = members.iterator();
            while (it.hasNext()) {
                Member[] member = it.next();
                evaluator2.setContext(member);
                if (bcalc.evaluateBoolean(evaluator2)) continue;
                it.remove();
            }
            return members;
        }
    }

    private static class ImmutableMemberListCalc
    extends BaseListCalc {
        ImmutableMemberListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
            assert (calcs[0] instanceof MemberListCalc);
            assert (calcs[1] instanceof BooleanCalc);
        }

        protected List makeList(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            MemberListCalc lcalc = (MemberListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push(false);
            List<Member> members = lcalc.evaluateMemberList(evaluator);
            ArrayList<Member> result = new ArrayList<Member>();
            int count = members.size();
            for (int i = 0; i < count; ++i) {
                Member member = members.get(i);
                evaluator2.setContext(member);
                if (!bcalc.evaluateBoolean(evaluator2)) continue;
                result.add(member);
            }
            return result;
        }
    }

    private static class MutableMemberListCalc
    extends BaseListCalc {
        MutableMemberListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
            assert (calcs[0] instanceof MemberListCalc);
            assert (calcs[1] instanceof BooleanCalc);
        }

        protected List makeList(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            MemberListCalc lcalc = (MemberListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push(false);
            List<Member> members = lcalc.evaluateMemberList(evaluator);
            members = new ArrayList<Member>(members);
            Iterator<Member> it = members.iterator();
            while (it.hasNext()) {
                Member member = it.next();
                evaluator2.setContext(member);
                if (bcalc.evaluateBoolean(evaluator2)) continue;
                it.remove();
            }
            return members;
        }
    }

    private static abstract class BaseListCalc
    extends AbstractListCalc {
        protected BaseListCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        public List evaluateList(Evaluator evaluator) {
            ResolvedFunCall call = (ResolvedFunCall)this.exp;
            SchemaReader schemaReader = evaluator.getSchemaReader();
            NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
            if (nativeEvaluator != null) {
                return (List)nativeEvaluator.execute(ResultStyle.ITERABLE);
            }
            return this.makeList(evaluator);
        }

        protected abstract List makeList(Evaluator var1);

        public boolean dependsOn(Hierarchy hierarchy) {
            return BaseListCalc.anyDependsButFirst(this.getCalcs(), hierarchy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IterMemberArrayIterCalc
    extends BaseTupleIterCalc {
        IterMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
            assert (calcs[0] instanceof TupleIterCalc);
            assert (calcs[1] instanceof BooleanCalc);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            TupleIterCalc icalc = (TupleIterCalc)calcs[0];
            final BooleanCalc bcalc = (BooleanCalc)calcs[1];
            final Evaluator evaluator2 = evaluator.push(false);
            final Iterable<Member[]> iter = icalc.evaluateTupleIterable(evaluator);
            return new Iterable<Member[]>(){

                @Override
                public Iterator<Member[]> iterator() {
                    return new Iterator<Member[]>(){
                        Iterator<Member[]> it;
                        Member[] m;
                        {
                            this.it = iter.iterator();
                            this.m = null;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.m != null) {
                                return true;
                            }
                            if (!this.it.hasNext()) {
                                return false;
                            }
                            this.m = this.it.next();
                            evaluator2.setContext(this.m);
                            while (!bcalc.evaluateBoolean(evaluator2)) {
                                if (!this.it.hasNext()) {
                                    return false;
                                }
                                this.m = this.it.next();
                                evaluator2.setContext(this.m);
                            }
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Member[] next() {
                            try {
                                Member[] memberArray = this.m;
                                return memberArray;
                            }
                            finally {
                                this.m = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }
                    };
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImMutableMemberArrayIterCalc
    extends BaseTupleIterCalc {
        ImMutableMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
            assert (calcs[0] instanceof TupleListCalc);
            assert (calcs[1] instanceof BooleanCalc);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            TupleListCalc lcalc = (TupleListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push(false);
            List<Member[]> members = lcalc.evaluateTupleList(evaluator);
            ArrayList<Member[]> result = new ArrayList<Member[]>();
            int count = members.size();
            for (int i = 0; i < count; ++i) {
                Member[] member = members.get(i);
                evaluator2.setContext(member);
                if (!bcalc.evaluateBoolean(evaluator2)) continue;
                result.add(member);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MutableMemberArrayIterCalc
    extends BaseTupleIterCalc {
        MutableMemberArrayIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
            assert (calcs[0] instanceof TupleListCalc);
            assert (calcs[1] instanceof BooleanCalc);
        }

        @Override
        protected Iterable<Member[]> makeIterable(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            TupleListCalc lcalc = (TupleListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push(false);
            List<Member[]> members = lcalc.evaluateTupleList(evaluator);
            members = new ArrayList<Member[]>(members);
            Iterator<Member[]> it = members.iterator();
            while (it.hasNext()) {
                Member[] member = it.next();
                evaluator2.setContext(member);
                if (bcalc.evaluateBoolean(evaluator2)) continue;
                it.remove();
            }
            return members;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IterMemberIterCalc
    extends BaseMemberIterCalc {
        IterMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
            assert (calcs[0] instanceof MemberIterCalc);
            assert (calcs[1] instanceof BooleanCalc);
        }

        @Override
        protected Iterable<Member> makeIterable(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            MemberIterCalc icalc = (MemberIterCalc)calcs[0];
            final BooleanCalc bcalc = (BooleanCalc)calcs[1];
            final Evaluator evaluator2 = evaluator.push(false);
            final Iterable<Member> iter = icalc.evaluateMemberIterable(evaluator);
            return new Iterable<Member>(){

                @Override
                public Iterator<Member> iterator() {
                    return new Iterator<Member>(){
                        Iterator<Member> it;
                        Member m;
                        {
                            this.it = iter.iterator();
                            this.m = null;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.m != null) {
                                return true;
                            }
                            if (!this.it.hasNext()) {
                                return false;
                            }
                            this.m = this.it.next();
                            evaluator2.setContext(this.m);
                            while (!bcalc.evaluateBoolean(evaluator2)) {
                                if (!this.it.hasNext()) {
                                    return false;
                                }
                                this.m = this.it.next();
                                evaluator2.setContext(this.m);
                            }
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Member next() {
                            try {
                                Member member = this.m;
                                return member;
                            }
                            finally {
                                this.m = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }
                    };
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ImMutableMemberIterCalc
    extends BaseMemberIterCalc {
        ImMutableMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
            assert (calcs[0] instanceof MemberListCalc);
            assert (calcs[1] instanceof BooleanCalc);
        }

        @Override
        protected Iterable<Member> makeIterable(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            MemberListCalc lcalc = (MemberListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push(false);
            List<Member> members = lcalc.evaluateMemberList(evaluator);
            ArrayList<Member> result = new ArrayList<Member>();
            int count = members.size();
            for (int i = 0; i < count; ++i) {
                Member member = members.get(i);
                evaluator2.setContext(member);
                if (!bcalc.evaluateBoolean(evaluator2)) continue;
                result.add(member);
            }
            return result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MutableMemberIterCalc
    extends BaseMemberIterCalc {
        MutableMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
            assert (calcs[0] instanceof MemberListCalc);
            assert (calcs[1] instanceof BooleanCalc);
        }

        @Override
        protected Iterable<Member> makeIterable(Evaluator evaluator) {
            Calc[] calcs = this.getCalcs();
            MemberListCalc lcalc = (MemberListCalc)calcs[0];
            BooleanCalc bcalc = (BooleanCalc)calcs[1];
            Evaluator evaluator2 = evaluator.push(false);
            List<Member> members = lcalc.evaluateMemberList(evaluator);
            members = new ArrayList<Member>(members);
            Iterator<Member> it = members.iterator();
            while (it.hasNext()) {
                Member member = it.next();
                evaluator2.setContext(member);
                if (bcalc.evaluateBoolean(evaluator2)) continue;
                it.remove();
            }
            return members;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BaseTupleIterCalc
    extends AbstractTupleIterCalc {
        protected BaseTupleIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        public Iterable<Member[]> evaluateTupleIterable(Evaluator evaluator) {
            ResolvedFunCall call = (ResolvedFunCall)this.exp;
            SchemaReader schemaReader = evaluator.getSchemaReader();
            NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
            if (nativeEvaluator != null) {
                return (Iterable)nativeEvaluator.execute(ResultStyle.ITERABLE);
            }
            return this.makeIterable(evaluator);
        }

        protected abstract Iterable<Member[]> makeIterable(Evaluator var1);

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return BaseTupleIterCalc.anyDependsButFirst(this.getCalcs(), hierarchy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class BaseMemberIterCalc
    extends AbstractMemberIterCalc {
        protected BaseMemberIterCalc(ResolvedFunCall call, Calc[] calcs) {
            super(call, calcs);
        }

        @Override
        public Iterable<Member> evaluateMemberIterable(Evaluator evaluator) {
            ResolvedFunCall call = (ResolvedFunCall)this.exp;
            SchemaReader schemaReader = evaluator.getSchemaReader();
            NativeEvaluator nativeEvaluator = schemaReader.getNativeSetEvaluator(call.getFunDef(), call.getArgs(), evaluator, this);
            if (nativeEvaluator != null) {
                return Util.castToIterable(nativeEvaluator.execute(ResultStyle.ITERABLE));
            }
            return this.makeIterable(evaluator);
        }

        protected abstract Iterable<Member> makeIterable(Evaluator var1);

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return BaseMemberIterCalc.anyDependsButFirst(this.getCalcs(), hierarchy);
        }
    }
}

