/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.calc.impl.ValueCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.ReflectiveMultiResolver;

class MinMaxFunDef
extends AbstractAggregateFunDef {
    static final ReflectiveMultiResolver MinResolver = new ReflectiveMultiResolver("Min", "Min(<Set>[, <Numeric Expression>])", "Returns the minimum value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}, MinMaxFunDef.class);
    static final MultiResolver MaxResolver = new ReflectiveMultiResolver("Max", "Max(<Set>[, <Numeric Expression>])", "Returns the maximum value of a numeric expression evaluated over a set.", new String[]{"fnx", "fnxn"}, MinMaxFunDef.class);
    private final boolean max;

    public MinMaxFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
        this.max = dummyFunDef.getName().equals("Max");
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        final ValueCalc calc = call.getArgCount() > 1 ? compiler.compileScalar(call.getArg(1), true) : new ValueCalc(call);
        return new AbstractDoubleCalc(call, new Calc[]{listCalc, calc}){

            public double evaluateDouble(Evaluator evaluator) {
                List memberList = AbstractAggregateFunDef.evaluateCurrentList(listCalc, evaluator);
                return (Double)(MinMaxFunDef.this.max ? FunUtil.max(evaluator.push(false), memberList, calc) : FunUtil.min(evaluator.push(false), memberList, calc));
            }

            public boolean dependsOn(Hierarchy hierarchy) {
                return 1.anyDependsButFirst(this.getCalcs(), hierarchy);
            }
        };
    }
}

