/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.olap.CacheControl;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianException;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCacheRegion;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.AggregationKey;
import mondrian.rolap.aggmatcher.AggStar;
import mondrian.rolap.sql.SqlQuery;
import mondrian.spi.DataSourceChangeListener;
import mondrian.spi.Dialect;
import org.apache.log4j.Logger;
import org.eigenbase.util.property.Property;
import org.eigenbase.util.property.Trigger;
import org.eigenbase.util.property.TriggerBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapStar {
    private static final Logger LOGGER = Logger.getLogger(RolapStar.class);
    private static boolean disableCaching = MondrianProperties.instance().DisableCaching.get();
    private final RolapSchema schema;
    private DataSource dataSource;
    private final Table factTable;
    private final Map<AggregationKey, Aggregation> sharedAggregations;
    private final ThreadLocal<Map<AggregationKey, Aggregation>> localAggregations = new ThreadLocal<Map<AggregationKey, Aggregation>>(){

        @Override
        protected Map<AggregationKey, Aggregation> initialValue() {
            return new HashMap<AggregationKey, Aggregation>();
        }
    };
    private final Map<AggregationKey, Aggregation> pendingAggregations;
    private final List<AggregationKey> aggregationRequests;
    private final ThreadLocal<List<AggregationKey>> localAggregationRequests = new ThreadLocal<List<AggregationKey>>(){

        @Override
        protected List<AggregationKey> initialValue() {
            return new ArrayList<AggregationKey>();
        }
    };
    private int columnCount;
    private final Dialect sqlQueryDialect;
    private boolean cacheAggregations = true;
    private List<AggStar> aggStars;
    private DataSourceChangeListener changeListener;
    private StarNetworkNode factNode;
    private Map<String, StarNetworkNode> nodeLookup = new HashMap<String, StarNetworkNode>();

    RolapStar(RolapSchema schema, DataSource dataSource, MondrianDef.Relation fact) {
        this.schema = schema;
        this.dataSource = dataSource;
        this.factTable = new Table(this, fact, null, null);
        this.factNode = new StarNetworkNode(null, this.factTable.alias, null, null, null);
        this.sharedAggregations = new HashMap<AggregationKey, Aggregation>();
        this.pendingAggregations = new HashMap<AggregationKey, Aggregation>();
        this.aggregationRequests = new ArrayList<AggregationKey>();
        this.clearAggStarList();
        this.sqlQueryDialect = schema.getDialect();
        this.changeListener = schema.getDataSourceChangeListener();
    }

    private MondrianDef.RelationOrJoin cloneRelation(MondrianDef.Relation rel, String possibleName) {
        if (rel instanceof MondrianDef.Table) {
            MondrianDef.Table tbl = (MondrianDef.Table)rel;
            return new MondrianDef.Table(tbl.schema, tbl.name, possibleName, tbl.tableHints);
        }
        if (rel instanceof MondrianDef.View) {
            MondrianDef.View view = (MondrianDef.View)rel;
            MondrianDef.View newView = new MondrianDef.View(view);
            newView.alias = possibleName;
            return newView;
        }
        if (rel instanceof MondrianDef.InlineTable) {
            MondrianDef.InlineTable inlineTable = (MondrianDef.InlineTable)rel;
            MondrianDef.InlineTable newInlineTable = new MondrianDef.InlineTable(inlineTable);
            newInlineTable.alias = possibleName;
            return newInlineTable;
        }
        throw new UnsupportedOperationException();
    }

    public MondrianDef.RelationOrJoin getUniqueRelation(MondrianDef.RelationOrJoin rel, String factForeignKey, String primaryKey, String primaryKeyTable) {
        return this.getUniqueRelation(this.factNode, rel, factForeignKey, primaryKey, primaryKeyTable);
    }

    private MondrianDef.RelationOrJoin getUniqueRelation(StarNetworkNode parent, MondrianDef.RelationOrJoin relOrJoin, String foreignKey, String joinKey, String joinKeyTable) {
        if (relOrJoin == null) {
            return null;
        }
        if (relOrJoin instanceof MondrianDef.Relation) {
            String newAlias;
            int val = 0;
            MondrianDef.Relation rel = (MondrianDef.Relation)relOrJoin;
            String string = newAlias = joinKeyTable != null ? joinKeyTable : rel.getAlias();
            while (true) {
                StarNetworkNode node;
                if ((node = this.nodeLookup.get(newAlias)) == null) {
                    if (val != 0) {
                        rel = (MondrianDef.Relation)this.cloneRelation(rel, newAlias);
                    }
                    node = new StarNetworkNode(parent, newAlias, rel, foreignKey, joinKey);
                    this.nodeLookup.put(newAlias, node);
                    return rel;
                }
                if (node.isCompatible(parent, rel, foreignKey, joinKey)) {
                    return node.origRel;
                }
                newAlias = rel.getAlias() + "_" + ++val;
            }
        }
        if (relOrJoin instanceof MondrianDef.Join) {
            MondrianDef.Join join = (MondrianDef.Join)relOrJoin;
            MondrianDef.RelationOrJoin left = null;
            MondrianDef.RelationOrJoin right = null;
            if (join.getLeftAlias().equals(joinKeyTable)) {
                left = this.getUniqueRelation(parent, join.left, foreignKey, joinKey, joinKeyTable);
                parent = this.nodeLookup.get(((MondrianDef.Relation)left).getAlias());
                right = this.getUniqueRelation(parent, join.right, join.leftKey, join.rightKey, join.getRightAlias());
            } else if (join.getRightAlias().equals(joinKeyTable)) {
                right = this.getUniqueRelation(parent, join.right, foreignKey, joinKey, joinKeyTable);
                parent = this.nodeLookup.get(((MondrianDef.Relation)right).getAlias());
                left = this.getUniqueRelation(parent, join.left, join.rightKey, join.leftKey, join.getLeftAlias());
            } else {
                new MondrianException("failed to match primary key table to join tables");
            }
            if (join.left != left || join.right != right) {
                join = new MondrianDef.Join(left instanceof MondrianDef.Relation ? ((MondrianDef.Relation)left).getAlias() : null, join.leftKey, left, right instanceof MondrianDef.Relation ? ((MondrianDef.Relation)right).getAlias() : null, join.rightKey, right);
            }
            return join;
        }
        return null;
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    private int nextColumnCount() {
        return this.columnCount++;
    }

    private int decrementColumnCount() {
        return this.columnCount--;
    }

    public void prepareToLoadAggregates() {
        this.aggStars = Collections.emptyList();
    }

    public void addAggStar(AggStar aggStar) {
        if (this.aggStars == Collections.EMPTY_LIST) {
            this.aggStars = new LinkedList<AggStar>();
        }
        int size = aggStar.getSize();
        ListIterator<AggStar> lit = this.aggStars.listIterator();
        while (lit.hasNext()) {
            AggStar as = lit.next();
            if (as.getSize() < size) continue;
            lit.previous();
            lit.add(aggStar);
            return;
        }
        this.aggStars.add(aggStar);
    }

    void clearAggStarList() {
        this.aggStars = Collections.emptyList();
    }

    public void reOrderAggStarList() {
        List<AggStar> l = this.aggStars;
        this.clearAggStarList();
        for (AggStar aggStar : l) {
            this.addAggStar(aggStar);
        }
    }

    public List<AggStar> getAggStars() {
        return this.aggStars;
    }

    public Table getFactTable() {
        return this.factTable;
    }

    public SqlQuery getSqlQuery() {
        return new SqlQuery(this.getSqlQueryDialect());
    }

    public Dialect getSqlQueryDialect() {
        return this.sqlQueryDialect;
    }

    void setCacheAggregations(boolean cacheAggregations) {
        this.cacheAggregations = cacheAggregations;
        this.clearCachedAggregations(false);
    }

    boolean isCacheAggregations() {
        return this.cacheAggregations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearCachedAggregations(boolean forced) {
        if (forced || !this.cacheAggregations || disableCaching) {
            if (LOGGER.isDebugEnabled()) {
                StringBuilder buf = new StringBuilder(100);
                buf.append("RolapStar.clearCachedAggregations: schema=");
                buf.append(this.schema.getName());
                buf.append(", star=");
                buf.append(this.getFactTable().getAlias());
                LOGGER.debug((Object)buf.toString());
            }
            if (forced) {
                Map<AggregationKey, Aggregation> map = this.sharedAggregations;
                synchronized (map) {
                    this.sharedAggregations.clear();
                }
                this.localAggregations.get().clear();
            } else {
                this.localAggregations.get().clear();
            }
        }
    }

    public Aggregation lookupOrCreateAggregation(AggregationKey aggregationKey) {
        Aggregation aggregation = this.lookupAggregation(aggregationKey);
        if (aggregation == null) {
            aggregation = new Aggregation(aggregationKey);
            this.localAggregations.get().put(aggregationKey, aggregation);
            if (this.cacheAggregations && !disableCaching && this.changeListener != null) {
                Util.discard((boolean)this.changeListener.isAggregationChanged(aggregation));
            }
        }
        return aggregation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Aggregation lookupAggregation(AggregationKey aggregationKey) {
        Aggregation aggregation = this.localAggregations.get().get(aggregationKey);
        if (aggregation != null) {
            return aggregation;
        }
        if (this.cacheAggregations && !disableCaching) {
            Map<AggregationKey, Aggregation> map = this.sharedAggregations;
            synchronized (map) {
                aggregation = this.sharedAggregations.get(aggregationKey);
                if (aggregation != null) {
                    this.recordAggregationRequest(aggregationKey);
                }
            }
        }
        return aggregation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkAggregateModifications() {
        this.clearAggregationRequests();
        if (this.changeListener != null && this.cacheAggregations && !disableCaching) {
            Map<AggregationKey, Aggregation> map = this.sharedAggregations;
            synchronized (map) {
                for (Map.Entry<AggregationKey, Aggregation> e : this.sharedAggregations.entrySet()) {
                    AggregationKey aggregationKey = e.getKey();
                    Aggregation aggregation = e.getValue();
                    if (!this.changeListener.isAggregationChanged(aggregation)) continue;
                    aggregation = new Aggregation(aggregationKey);
                    this.localAggregations.get().put(aggregationKey, aggregation);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushAggregateModificationsToGlobalCache() {
        RolapStar rolapStar = this;
        synchronized (rolapStar) {
            if (this.cacheAggregations && !disableCaching) {
                Aggregation aggregation;
                AggregationKey aggregationKey;
                Iterator<Map.Entry<AggregationKey, Aggregation>> it = this.pendingAggregations.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<AggregationKey, Aggregation> e = it.next();
                    aggregationKey = e.getKey();
                    aggregation = e.getValue();
                    if (this.isAggregationRequested(aggregationKey)) continue;
                    this.pushAggregateModification(aggregationKey, aggregation, this.sharedAggregations);
                    it.remove();
                }
                for (Map.Entry<AggregationKey, Aggregation> e : this.localAggregations.get().entrySet()) {
                    aggregationKey = e.getKey();
                    aggregation = e.getValue();
                    Map<AggregationKey, Aggregation> targetMap = this.isAggregationRequested(aggregationKey) ? this.pendingAggregations : this.sharedAggregations;
                    this.pushAggregateModification(aggregationKey, aggregation, targetMap);
                }
                this.localAggregations.get().clear();
            }
            this.clearAggregationRequests();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushAggregateModification(AggregationKey localAggregationKey, Aggregation localAggregation, Map<AggregationKey, Aggregation> destAggregations) {
        if (this.cacheAggregations && !disableCaching) {
            Map<AggregationKey, Aggregation> map = destAggregations;
            synchronized (map) {
                boolean found = false;
                Iterator<Map.Entry<AggregationKey, Aggregation>> it = destAggregations.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<AggregationKey, Aggregation> e = it.next();
                    AggregationKey aggregationKey = e.getKey();
                    Aggregation aggregation = e.getValue();
                    if (!localAggregationKey.equals(aggregationKey)) continue;
                    if (localAggregation.getCreationTimestamp().after(aggregation.getCreationTimestamp())) {
                        it.remove();
                        break;
                    }
                    found = true;
                    break;
                }
                if (!found) {
                    destAggregations.put(localAggregationKey, localAggregation);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordAggregationRequest(AggregationKey aggregationKey) {
        if (!this.localAggregationRequests.get().contains(aggregationKey)) {
            List<AggregationKey> list = this.aggregationRequests;
            synchronized (list) {
                this.aggregationRequests.add(aggregationKey);
            }
            this.localAggregationRequests.get().add(aggregationKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAggregationRequested(AggregationKey aggregationKey) {
        List<AggregationKey> list = this.aggregationRequests;
        synchronized (list) {
            return this.aggregationRequests.contains(aggregationKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearAggregationRequests() {
        List<AggregationKey> list = this.aggregationRequests;
        synchronized (list) {
            if (this.localAggregationRequests.get().isEmpty()) {
                return;
            }
            HashSet localAggregationRequestSet = new HashSet(this.localAggregationRequests.get());
            Iterator<AggregationKey> iter = this.aggregationRequests.iterator();
            while (iter.hasNext()) {
                AggregationKey aggregationKey = iter.next();
                if (!localAggregationRequestSet.contains(aggregationKey)) continue;
                iter.remove();
                localAggregationRequestSet.remove(aggregationKey);
                if (!localAggregationRequestSet.isEmpty()) continue;
                break;
            }
            this.localAggregationRequests.get().clear();
        }
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public static Measure getStarMeasure(Member member) {
        return (Measure)((RolapStoredMeasure)member).getStarMeasure();
    }

    public Column[] lookupColumns(String tableAlias, String columnName) {
        Table table = this.factTable.findDescendant(tableAlias);
        return table == null ? null : table.lookupColumns(columnName);
    }

    public Column lookupColumn(String tableAlias, String columnName) {
        Table table = this.factTable.findDescendant(tableAlias);
        return table == null ? null : table.lookupColumn(columnName);
    }

    public BitKey getBitKey(String[] tableAlias, String[] columnName) {
        BitKey bitKey = BitKey.Factory.makeBitKey(this.getColumnCount());
        for (int i = 0; i < tableAlias.length; ++i) {
            Column starColumn = this.lookupColumn(tableAlias[i], columnName[i]);
            if (starColumn == null) continue;
            bitKey.set(starColumn.getBitPosition());
        }
        return bitKey;
    }

    public List<String> getAliasList() {
        ArrayList<String> aliasList = new ArrayList<String>();
        if (this.factTable != null) {
            RolapStar.collectAliases(aliasList, this.factTable);
        }
        return aliasList;
    }

    private static void collectAliases(List<String> aliasList, Table table) {
        aliasList.add(table.getAlias());
        for (Table child : table.children) {
            RolapStar.collectAliases(aliasList, child);
        }
    }

    public static void collectColumns(Collection<Column> columnList, Table table, MondrianDef.Column joinColumn) {
        if (joinColumn == null) {
            columnList.addAll(table.columnList);
        }
        for (Table child : table.children) {
            if (joinColumn != null && !child.getJoinCondition().left.equals((Object)joinColumn)) continue;
            RolapStar.collectColumns(columnList, child, null);
        }
    }

    private boolean containsColumn(String tableName, String columnName) {
        Connection jdbcConnection;
        try {
            jdbcConnection = this.dataSource.getConnection();
        }
        catch (SQLException e1) {
            throw Util.newInternal(e1, "Error while creating connection from data source");
        }
        try {
            DatabaseMetaData metaData = jdbcConnection.getMetaData();
            ResultSet columns = metaData.getColumns(null, null, tableName, columnName);
            boolean bl = columns.next();
            return bl;
        }
        catch (SQLException e) {
            throw Util.newInternal("Error while retrieving metadata for table '" + tableName + "', column '" + columnName + "'");
        }
        finally {
            try {
                jdbcConnection.close();
            }
            catch (SQLException e) {}
        }
    }

    public RolapSchema getSchema() {
        return this.schema;
    }

    public String generateSql(List<Column> columnList, List<String> columnNameList) {
        SqlQuery query = new SqlQuery(this.sqlQueryDialect, true);
        query.addFrom(this.factTable.relation, this.factTable.relation.getAlias(), false);
        int k = -1;
        for (Column column : columnList) {
            ++k;
            column.table.addToFrom(query, false, true);
            String columnExpr = column.generateExprString(query);
            if (column instanceof Measure) {
                Measure measure = (Measure)column;
                columnExpr = measure.getAggregator().getExpression(columnExpr);
            }
            String columnName = columnNameList.get(k);
            String alias = query.addSelect(columnExpr, columnName);
            if (column instanceof Measure) continue;
            query.addGroupBy(columnExpr, alias);
        }
        return query.toString().trim();
    }

    public String toString() {
        StringWriter sw = new StringWriter(256);
        PrintWriter pw = new PrintWriter(sw);
        this.print(pw, "", true);
        pw.flush();
        return sw.toString();
    }

    public void print(PrintWriter pw, String prefix, boolean structure) {
        if (structure) {
            pw.print(prefix);
            pw.println("RolapStar:");
            String subprefix = prefix + "  ";
            this.factTable.print(pw, subprefix);
            for (AggStar aggStar : this.getAggStars()) {
                aggStar.print(pw, subprefix);
            }
        }
        ArrayList<Aggregation> aggregationList = new ArrayList<Aggregation>(this.sharedAggregations.values());
        Collections.sort(aggregationList, new Comparator<Aggregation>(){

            @Override
            public int compare(Aggregation o1, Aggregation o2) {
                return o1.getConstrainedColumnsBitKey().compareTo(o2.getConstrainedColumnsBitKey());
            }
        });
        for (Aggregation aggregation : aggregationList) {
            aggregation.print(pw);
        }
    }

    public void flush(CacheControl cacheControl, CacheControl.CellRegion region) {
        RolapCacheRegion cacheRegion = RolapAggregationManager.makeCacheRegion(this, region);
        for (Aggregation aggregation : this.sharedAggregations.values()) {
            aggregation.flush(cacheControl, cacheRegion);
        }
    }

    public DataSourceChangeListener getChangeListener() {
        return this.changeListener;
    }

    public void setChangeListener(DataSourceChangeListener changeListener) {
        this.changeListener = changeListener;
    }

    static {
        MondrianProperties.instance().DisableCaching.addTrigger((Trigger)new TriggerBase(true){

            public void execute(Property property, String value) {
                disableCaching = property.booleanValue();
                if (disableCaching) {
                    Iterator<RolapSchema> itSchemas = RolapSchema.getRolapSchemas();
                    while (itSchemas.hasNext()) {
                        RolapSchema schema1 = itSchemas.next();
                        for (RolapStar star : schema1.getStars()) {
                            star.clearCachedAggregations(true);
                        }
                    }
                }
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ColumnComparator
    implements Comparator<Column> {
        public static ColumnComparator instance = new ColumnComparator();

        private ColumnComparator() {
        }

        @Override
        public int compare(Column o1, Column o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    public static class AliasReplacer {
        private final String oldAlias;
        private final String newAlias;

        public AliasReplacer(String oldAlias, String newAlias) {
            this.oldAlias = oldAlias;
            this.newAlias = newAlias;
        }

        private Condition visit(Condition condition) {
            if (condition == null) {
                return null;
            }
            if (this.newAlias.equals(this.oldAlias)) {
                return condition;
            }
            return new Condition(this.visit(condition.left), this.visit(condition.right));
        }

        public MondrianDef.Expression visit(MondrianDef.Expression expression) {
            if (expression == null) {
                return null;
            }
            if (this.newAlias.equals(this.oldAlias)) {
                return expression;
            }
            if (expression instanceof MondrianDef.Column) {
                MondrianDef.Column column = (MondrianDef.Column)expression;
                return new MondrianDef.Column(this.visit(column.table), column.name);
            }
            throw Util.newInternal("need to implement " + (Object)((Object)expression));
        }

        private String visit(String table) {
            return table.equals(this.oldAlias) ? this.newAlias : table;
        }
    }

    public static class Condition {
        private static final Logger LOGGER = Logger.getLogger(Condition.class);
        private final MondrianDef.Expression left;
        private final MondrianDef.Expression right;
        Table table;

        Condition(MondrianDef.Expression left, MondrianDef.Expression right) {
            assert (left != null);
            assert (right != null);
            if (!(left instanceof MondrianDef.Column)) {
                LOGGER.debug((Object)("Condition.left NOT Column: " + ((Object)((Object)left)).getClass().getName()));
            }
            this.left = left;
            this.right = right;
        }

        public MondrianDef.Expression getLeft() {
            return this.left;
        }

        public String getLeft(SqlQuery query) {
            return this.left.getExpression(query);
        }

        public MondrianDef.Expression getRight() {
            return this.right;
        }

        public String getRight(SqlQuery query) {
            return this.right.getExpression(query);
        }

        public String toString(SqlQuery query) {
            return this.left.getExpression(query) + " = " + this.right.getExpression(query);
        }

        public int hashCode() {
            return this.left.hashCode() ^ this.right.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Condition)) {
                return false;
            }
            Condition that = (Condition)obj;
            return this.left.equals((Object)that.left) && this.right.equals((Object)that.right);
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            SqlQuery sqlQueuy = this.table.getSqlQuery();
            pw.print(prefix);
            pw.println("Condition:");
            String subprefix = prefix + "  ";
            pw.print(subprefix);
            pw.print("left=");
            if (this.left instanceof MondrianDef.Column) {
                MondrianDef.Column c = (MondrianDef.Column)this.left;
                Column col = this.table.star.getFactTable().lookupColumn(c.name);
                if (col != null) {
                    pw.print(" (");
                    pw.print(col.getBitPosition());
                    pw.print(") ");
                }
            }
            pw.println(this.left.getExpression(sqlQueuy));
            pw.print(subprefix);
            pw.print("right=");
            pw.println(this.right.getExpression(sqlQueuy));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Table {
        private final RolapStar star;
        private final MondrianDef.Relation relation;
        private final List<Column> columnList;
        private final Table parent;
        private List<Table> children;
        private final Condition joinCondition;
        private final String alias;

        private Table(RolapStar star, MondrianDef.Relation relation, Table parent, Condition joinCondition) {
            this.star = star;
            this.relation = relation;
            this.alias = this.chooseAlias();
            this.parent = parent;
            AliasReplacer aliasReplacer = new AliasReplacer(relation.getAlias(), this.alias);
            this.joinCondition = aliasReplacer.visit(joinCondition);
            if (this.joinCondition != null) {
                this.joinCondition.table = this;
            }
            this.columnList = new ArrayList<Column>();
            this.children = Collections.emptyList();
            Util.assertTrue(parent == null == (joinCondition == null));
        }

        public Condition getJoinCondition() {
            return this.joinCondition;
        }

        public Table getParentTable() {
            return this.parent;
        }

        private void addColumn(Column column) {
            this.columnList.add(column);
        }

        private void collectColumns(BitKey bitKey, List<Column> list) {
            for (Column column : this.getColumns()) {
                if (!bitKey.get(column.getBitPosition())) continue;
                list.add(column);
            }
            for (Table table : this.getChildren()) {
                table.collectColumns(bitKey, list);
            }
        }

        public Column[] lookupColumns(String columnName) {
            ArrayList<Column> l = new ArrayList<Column>();
            for (Column column : this.getColumns()) {
                if (!(column.getExpression() instanceof MondrianDef.Column)) continue;
                MondrianDef.Column columnExpr = (MondrianDef.Column)column.getExpression();
                if (!columnExpr.name.equals(columnName)) continue;
                l.add(column);
            }
            return l.toArray(new Column[l.size()]);
        }

        public Column lookupColumn(String columnName) {
            for (Column column : this.getColumns()) {
                if (column.getExpression() instanceof MondrianDef.Column) {
                    MondrianDef.Column columnExpr = (MondrianDef.Column)column.getExpression();
                    if (!columnExpr.name.equals(columnName)) continue;
                    return column;
                }
                if (!column.getName().equals(columnName)) continue;
                return column;
            }
            return null;
        }

        public Column lookupColumnByExpression(MondrianDef.Expression xmlExpr) {
            for (Column column : this.getColumns()) {
                if (column instanceof Measure || !column.getExpression().equals((Object)xmlExpr)) continue;
                return column;
            }
            return null;
        }

        public boolean containsColumn(Column column) {
            return this.getColumns().contains(column);
        }

        public Measure lookupMeasureByName(String cubeName, String name) {
            for (Column column : this.getColumns()) {
                Measure measure;
                if (!(column instanceof Measure) || !(measure = (Measure)column).getName().equals(name) || !measure.getCubeName().equals(cubeName)) continue;
                return measure;
            }
            return null;
        }

        RolapStar getStar() {
            return this.star;
        }

        private SqlQuery getSqlQuery() {
            return this.getStar().getSqlQuery();
        }

        public MondrianDef.Relation getRelation() {
            return this.relation;
        }

        private String chooseAlias() {
            List<String> aliasList = this.star.getAliasList();
            int i = 0;
            while (true) {
                String candidateAlias = this.relation.getAlias();
                if (i > 0) {
                    candidateAlias = candidateAlias + "_" + i;
                }
                if (!aliasList.contains(candidateAlias)) {
                    return candidateAlias;
                }
                ++i;
            }
        }

        public String getAlias() {
            return this.alias;
        }

        public String getTableName() {
            if (this.relation instanceof MondrianDef.Table) {
                MondrianDef.Table t = (MondrianDef.Table)this.relation;
                return t.name;
            }
            return null;
        }

        synchronized void makeMeasure(RolapBaseCubeMeasure measure) {
            Measure starMeasure = new Measure(measure.getName(), measure.getCube().getName(), measure.getAggregator(), this, measure.getMondrianDefExpression(), measure.getDatatype());
            measure.setStarMeasure(starMeasure);
            if (this.containsColumn(starMeasure)) {
                this.star.decrementColumnCount();
            } else {
                this.addColumn(starMeasure);
            }
        }

        synchronized Column makeColumns(RolapCube cube, RolapCubeLevel level, Column parentColumn, String usagePrefix) {
            String name;
            Column column;
            Column nameColumn = null;
            if (level.getNameExp() != null) {
                nameColumn = this.makeColumnForLevelExpr(cube, level, level.getName(), level.getNameExp(), Dialect.Datatype.String, null, null, null);
            }
            if ((column = this.makeColumnForLevelExpr(cube, level, name = level.getNameExp() == null ? level.getName() : level.getName() + " (Key)", level.getKeyExp(), level.getDatatype(), nameColumn, parentColumn, usagePrefix)) != null) {
                level.setStarKeyColumn(column);
            }
            return column;
        }

        private Column makeColumnForLevelExpr(RolapCube cube, RolapLevel level, String name, MondrianDef.Expression xmlExpr, Dialect.Datatype datatype, Column nameColumn, Column parentColumn, String usagePrefix) {
            Table table = this;
            if (xmlExpr instanceof MondrianDef.Column) {
                MondrianDef.Column xmlColumn = (MondrianDef.Column)xmlExpr;
                String tableName = xmlColumn.table;
                table = this.findAncestor(tableName);
                if (table == null) {
                    throw Util.newError("Level '" + level.getUniqueName() + "' of cube '" + this + "' is invalid: table '" + tableName + "' is not found in current scope" + Util.nl + ", star:" + Util.nl + this.getStar());
                }
                AliasReplacer aliasReplacer = new AliasReplacer(tableName, table.getAlias());
                xmlExpr = aliasReplacer.visit(xmlExpr);
            }
            Column c = this.lookupColumnByExpression(xmlExpr);
            Column column = null;
            if (c != null && !c.equals(nameColumn)) {
                column = c;
            } else {
                column = new Column(name, table, xmlExpr, datatype, nameColumn, parentColumn, usagePrefix);
                this.addColumn(column);
            }
            return column;
        }

        synchronized Table addJoin(RolapCube cube, MondrianDef.RelationOrJoin relationOrJoin, Condition joinCondition) {
            if (relationOrJoin instanceof MondrianDef.Relation) {
                MondrianDef.Relation relation = (MondrianDef.Relation)relationOrJoin;
                Table starTable = this.findChild(relation, joinCondition);
                if (starTable == null) {
                    starTable = new Table(this.star, relation, this, joinCondition);
                    if (this.children.isEmpty()) {
                        this.children = new ArrayList<Table>();
                    }
                    this.children.add(starTable);
                }
                return starTable;
            }
            if (relationOrJoin instanceof MondrianDef.Join) {
                MondrianDef.Join join = (MondrianDef.Join)relationOrJoin;
                Table leftTable = this.addJoin(cube, join.left, joinCondition);
                String leftAlias = join.leftAlias;
                if (leftAlias == null && (leftAlias = ((MondrianDef.Relation)join.left).getAlias()) == null) {
                    throw Util.newError("missing leftKeyAlias in " + (Object)((Object)relationOrJoin));
                }
                assert (leftTable.findAncestor(leftAlias) == leftTable);
                leftAlias = leftTable.getAlias();
                String rightAlias = join.rightAlias;
                if (rightAlias == null) {
                    if (join.right instanceof MondrianDef.Join) {
                        MondrianDef.Join joinright = (MondrianDef.Join)join.right;
                        rightAlias = ((MondrianDef.Relation)joinright.left).getAlias();
                    } else {
                        rightAlias = ((MondrianDef.Relation)join.right).getAlias();
                    }
                    if (rightAlias == null) {
                        throw Util.newError("missing rightKeyAlias in " + (Object)((Object)relationOrJoin));
                    }
                }
                joinCondition = new Condition(new MondrianDef.Column(leftAlias, join.leftKey), new MondrianDef.Column(rightAlias, join.rightKey));
                Table rightTable = leftTable.addJoin(cube, join.right, joinCondition);
                return rightTable;
            }
            throw Util.newInternal("bad relation type " + (Object)((Object)relationOrJoin));
        }

        public Table findChild(MondrianDef.Relation relation, Condition joinCondition) {
            for (Table child : this.getChildren()) {
                if (!child.relation.equals((Object)relation)) continue;
                Condition condition = joinCondition;
                if (!Util.equalName(relation.getAlias(), child.alias)) {
                    AliasReplacer aliasReplacer = new AliasReplacer(relation.getAlias(), child.alias);
                    condition = aliasReplacer.visit(joinCondition);
                }
                if (!child.joinCondition.equals(condition)) continue;
                return child;
            }
            return null;
        }

        public Table findDescendant(String seekAlias) {
            if (this.getAlias().equals(seekAlias)) {
                return this;
            }
            for (Table child : this.getChildren()) {
                Table found = child.findDescendant(seekAlias);
                if (found == null) continue;
                return found;
            }
            return null;
        }

        public Table findAncestor(String tableName) {
            Table t = this;
            while (t != null) {
                if (t.relation.getAlias().equals(tableName)) {
                    return t;
                }
                t = t.parent;
            }
            return null;
        }

        public boolean equalsTableName(String tableName) {
            if (this.relation instanceof MondrianDef.Table) {
                MondrianDef.Table mt = (MondrianDef.Table)this.relation;
                if (mt.name.equals(tableName)) {
                    return true;
                }
            }
            return false;
        }

        public void addToFrom(SqlQuery query, boolean failIfExists, boolean joinToParent) {
            query.addFrom(this.relation, this.alias, failIfExists);
            Util.assertTrue(this.parent == null == (this.joinCondition == null));
            if (joinToParent) {
                if (this.parent != null) {
                    this.parent.addToFrom(query, failIfExists, joinToParent);
                }
                if (this.joinCondition != null) {
                    query.addWhere(this.joinCondition.toString(query));
                }
            }
        }

        public List<Table> getChildren() {
            return this.children;
        }

        public List<Column> getColumns() {
            return this.columnList;
        }

        public Table findTableWithLeftJoinCondition(String columnName) {
            for (Table child : this.getChildren()) {
                Condition condition = child.joinCondition;
                if (condition == null || !(condition.left instanceof MondrianDef.Column)) continue;
                MondrianDef.Column mcolumn = (MondrianDef.Column)condition.left;
                if (!mcolumn.name.equals(columnName)) continue;
                return child;
            }
            return null;
        }

        public Table findTableWithLeftCondition(MondrianDef.Expression left) {
            for (Table child : this.getChildren()) {
                MondrianDef.Column mcolumn;
                Condition condition = child.joinCondition;
                if (condition == null || !(condition.left instanceof MondrianDef.Column) || !(mcolumn = (MondrianDef.Column)condition.left).equals((Object)left)) continue;
                return child;
            }
            return null;
        }

        public boolean isFunky() {
            return this.relation == null;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Table)) {
                return false;
            }
            Table other = (Table)obj;
            return this.getAlias().equals(other.getAlias());
        }

        public int hashCode() {
            return this.getAlias().hashCode();
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            pw.print(prefix);
            pw.println("Table:");
            String subprefix = prefix + "  ";
            pw.print(subprefix);
            pw.print("alias=");
            pw.println(this.getAlias());
            if (this.relation != null) {
                pw.print(subprefix);
                pw.print("relation=");
                pw.println((Object)this.relation);
            }
            pw.print(subprefix);
            pw.println("Columns:");
            String subsubprefix = subprefix + "  ";
            for (Column column : this.getColumns()) {
                column.print(pw, subsubprefix);
                pw.println();
            }
            if (this.joinCondition != null) {
                this.joinCondition.print(pw, subprefix);
            }
            for (Table child : this.getChildren()) {
                child.print(pw, subprefix);
            }
        }

        public boolean containsColumn(String columnName) {
            if (this.relation instanceof MondrianDef.Relation) {
                return this.star.containsColumn(this.relation.getAlias(), columnName);
            }
            return false;
        }
    }

    public static class Measure
    extends Column {
        private final String cubeName;
        private final RolapAggregator aggregator;

        public Measure(String name, String cubeName, RolapAggregator aggregator, Table table, MondrianDef.Expression expression, Dialect.Datatype datatype) {
            super(name, table, expression, datatype);
            this.cubeName = cubeName;
            this.aggregator = aggregator;
        }

        public RolapAggregator getAggregator() {
            return this.aggregator;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Measure)) {
                return false;
            }
            Measure that = (Measure)o;
            if (!super.equals(that)) {
                return false;
            }
            if (!this.cubeName.equals(that.cubeName)) {
                return false;
            }
            return that.aggregator == this.aggregator;
        }

        public int hashCode() {
            int h = super.hashCode();
            h = Util.hash(h, this.aggregator);
            return h;
        }

        public void print(PrintWriter pw, String prefix) {
            SqlQuery sqlQuery = this.getSqlQuery();
            pw.print(prefix);
            pw.print(this.getName());
            pw.print(" (");
            pw.print(this.getBitPosition());
            pw.print("): ");
            pw.print(this.aggregator.getExpression(this.getExpression() == null ? null : this.generateExprString(sqlQuery)));
        }

        public String getCubeName() {
            return this.cubeName;
        }
    }

    public static class Column {
        private final Table table;
        private final MondrianDef.Expression expression;
        private final Dialect.Datatype datatype;
        private final String name;
        private final Column parentColumn;
        private final String usagePrefix;
        private final Column nameColumn;
        private boolean isNameColumn;
        private final int bitPosition;
        private int cardinality = -1;

        private Column(String name, Table table, MondrianDef.Expression expression, Dialect.Datatype datatype) {
            this(name, table, expression, datatype, null, null, null);
        }

        private Column(String name, Table table, MondrianDef.Expression expression, Dialect.Datatype datatype, Column nameColumn, Column parentColumn, String usagePrefix) {
            this.name = name;
            this.table = table;
            this.expression = expression;
            this.datatype = datatype;
            this.bitPosition = table.star.nextColumnCount();
            this.nameColumn = nameColumn;
            this.parentColumn = parentColumn;
            this.usagePrefix = usagePrefix;
            if (nameColumn != null) {
                nameColumn.isNameColumn = true;
            }
        }

        protected Column(Dialect.Datatype datatype) {
            this.table = null;
            this.expression = null;
            this.datatype = datatype;
            this.name = null;
            this.parentColumn = null;
            this.nameColumn = null;
            this.usagePrefix = null;
            this.bitPosition = 0;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Column)) {
                return false;
            }
            Column other = (Column)obj;
            return other.table == this.table && Util.equals((Object)other.expression, (Object)this.expression) && other.datatype == this.datatype && other.name.equals(this.name);
        }

        public int hashCode() {
            int h = this.name.hashCode();
            h = Util.hash(h, this.table);
            return h;
        }

        public String getName() {
            return this.name;
        }

        public int getBitPosition() {
            return this.bitPosition;
        }

        public RolapStar getStar() {
            return this.table.star;
        }

        public Table getTable() {
            return this.table;
        }

        public SqlQuery getSqlQuery() {
            return this.getTable().getStar().getSqlQuery();
        }

        public Column getNameColumn() {
            return this.nameColumn;
        }

        public Column getParentColumn() {
            return this.parentColumn;
        }

        public String getUsagePrefix() {
            return this.usagePrefix;
        }

        public boolean isNameColumn() {
            return this.isNameColumn;
        }

        public MondrianDef.Expression getExpression() {
            return this.expression;
        }

        public String generateExprString(SqlQuery query) {
            return this.getExpression().getExpression(query);
        }

        public int getCardinality() {
            if (this.cardinality == -1) {
                RolapStar star = this.getStar();
                RolapSchema schema = star.getSchema();
                Integer card = schema.getCachedRelationExprCardinality(this.table.getRelation(), this.expression);
                if (card != null) {
                    this.cardinality = card;
                } else {
                    this.cardinality = this.getCardinality(star.getDataSource());
                    schema.putCachedRelationExprCardinality(this.table.getRelation(), this.expression, this.cardinality);
                }
            }
            return this.cardinality;
        }

        private int getCardinality(DataSource dataSource) {
            SqlQuery sqlQuery = this.getSqlQuery();
            if (sqlQuery.getDialect().allowsCountDistinct()) {
                sqlQuery.addSelect("count(distinct " + this.generateExprString(sqlQuery) + ")");
                this.table.addToFrom(sqlQuery, true, false);
            } else if (sqlQuery.getDialect().allowsFromQuery()) {
                SqlQuery inner = sqlQuery.cloneEmpty();
                inner.setDistinct(true);
                inner.addSelect(this.generateExprString(inner));
                boolean failIfExists = true;
                boolean joinToParent = false;
                this.table.addToFrom(inner, failIfExists, joinToParent);
                sqlQuery.addSelect("count(*)");
                sqlQuery.addFrom(inner, "init", failIfExists);
            } else {
                throw Util.newInternal("Cannot compute cardinality: this database neither supports COUNT DISTINCT nor SELECT in the FROM clause.");
            }
            String sql = sqlQuery.toString();
            SqlStatement stmt = RolapUtil.executeQuery(dataSource, sql, "RolapStar.Column.getCardinality", "while counting distinct values of column '" + this.expression.getGenericExpression());
            try {
                ResultSet resultSet = stmt.getResultSet();
                Util.assertTrue(resultSet.next());
                ++stmt.rowCount;
                int n = resultSet.getInt(1);
                return n;
            }
            catch (SQLException e) {
                throw stmt.handle(e);
            }
            finally {
                stmt.close();
            }
        }

        public static String createInExpr(final String expr, StarColumnPredicate predicate, Dialect.Datatype datatype, SqlQuery sqlQuery) {
            Column column = new Column(datatype){

                public String generateExprString(SqlQuery query) {
                    return expr;
                }
            };
            predicate = predicate.cloneWithColumn(column);
            StringBuilder buf = new StringBuilder(64);
            predicate.toSql(sqlQuery, buf);
            return buf.toString();
        }

        public String toString() {
            StringWriter sw = new StringWriter(256);
            PrintWriter pw = new PrintWriter(sw);
            this.print(pw, "");
            pw.flush();
            return sw.toString();
        }

        public void print(PrintWriter pw, String prefix) {
            SqlQuery sqlQuery = this.getSqlQuery();
            pw.print(prefix);
            pw.print(this.getName());
            pw.print(" (");
            pw.print(this.getBitPosition());
            pw.print("): ");
            pw.print(this.generateExprString(sqlQuery));
        }

        public Dialect.Datatype getDatatype() {
            return this.datatype;
        }

        public String getDatatypeString(Dialect dialect) {
            SqlQuery query = new SqlQuery(dialect);
            query.addFrom(this.table.star.factTable.relation, this.table.star.factTable.alias, false);
            query.addFrom(this.table.relation, this.table.alias, false);
            query.addSelect(this.expression.getExpression(query));
            String sql = query.toString();
            Connection jdbcConnection = null;
            try {
                jdbcConnection = this.table.star.dataSource.getConnection();
                PreparedStatement pstmt = jdbcConnection.prepareStatement(sql);
                ResultSetMetaData resultSetMetaData = pstmt.getMetaData();
                assert (resultSetMetaData.getColumnCount() == 1);
                String type = resultSetMetaData.getColumnTypeName(1);
                int precision = resultSetMetaData.getPrecision(1);
                int scale = resultSetMetaData.getScale(1);
                if (type.equals("DOUBLE")) {
                    precision = 0;
                }
                String typeString = precision == 0 ? type : (scale == 0 ? type + "(" + precision + ")" : type + "(" + precision + ", " + scale + ")");
                pstmt.close();
                jdbcConnection.close();
                jdbcConnection = null;
                String string = typeString;
                return string;
            }
            catch (SQLException e) {
                throw Util.newError(e, "Error while deriving type of column " + this.toString());
            }
            finally {
                if (jdbcConnection != null) {
                    try {
                        jdbcConnection.close();
                    }
                    catch (SQLException e) {}
                }
            }
        }
    }

    private static class StarNetworkNode {
        private StarNetworkNode parent;
        private MondrianDef.Relation origRel;
        private String foreignKey;
        private String joinKey;

        private StarNetworkNode(StarNetworkNode parent, String alias, MondrianDef.Relation origRel, String foreignKey, String joinKey) {
            this.parent = parent;
            this.origRel = origRel;
            this.foreignKey = foreignKey;
            this.joinKey = joinKey;
        }

        private boolean isCompatible(StarNetworkNode compatibleParent, MondrianDef.Relation rel, String compatibleForeignKey, String compatibleJoinKey) {
            return this.parent == compatibleParent && ((Object)((Object)this.origRel)).getClass().equals(((Object)((Object)rel)).getClass()) && this.foreignKey.equals(compatibleForeignKey) && this.joinKey.equals(compatibleJoinKey);
        }
    }
}

