/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import mondrian.olap.Util;
import mondrian.rolap.RolapUtil;
import mondrian.util.DelegatingInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlStatement {
    private final DataSource dataSource;
    private Connection jdbcConnection;
    private ResultSet resultSet;
    private final String sql;
    private final int maxRows;
    private final int firstRowOrdinal;
    private final String component;
    private final int resultSetType;
    private final int resultSetConcurrency;
    private final RolapUtil.Semaphore querySemaphore = RolapUtil.getQuerySemaphore();
    private final String message;
    private boolean haveSemaphore;
    public int rowCount;
    private long startTime;
    private final List<Accessor> accessors = new ArrayList<Accessor>();
    private static long executeCount = -1L;
    private boolean done;

    SqlStatement(DataSource dataSource, String sql, int maxRows, int firstRowOrdinal, String component, String message, int resultSetType, int resultSetConcurrency) {
        this.dataSource = dataSource;
        this.sql = sql;
        this.maxRows = maxRows;
        this.firstRowOrdinal = firstRowOrdinal;
        this.component = component;
        this.message = message;
        this.resultSetType = resultSetType;
        this.resultSetConcurrency = resultSetConcurrency;
    }

    public void execute() {
        long currId = 0L;
        String status = "failed";
        Statement statement = null;
        try {
            RolapUtil.ExecuteQueryHook hook;
            this.jdbcConnection = this.dataSource.getConnection();
            this.querySemaphore.enter();
            this.haveSemaphore = true;
            if (RolapUtil.SQL_LOGGER.isDebugEnabled()) {
                currId = ++executeCount;
                StringBuilder sqllog = new StringBuilder();
                sqllog.append(currId).append(": ").append(this.component).append(": executing sql [");
                if (this.sql.indexOf(10) >= 0) {
                    sqllog.append("\n");
                }
                sqllog.append(this.sql);
                sqllog.append(']');
                RolapUtil.SQL_LOGGER.debug((Object)sqllog.toString());
            }
            if ((hook = RolapUtil.threadHooks.get()) != null) {
                hook.onExecuteQuery(this.sql);
            }
            this.startTime = System.currentTimeMillis();
            statement = this.resultSetType < 0 || this.resultSetConcurrency < 0 ? this.jdbcConnection.createStatement() : this.jdbcConnection.createStatement(this.resultSetType, this.resultSetConcurrency);
            if (this.maxRows > 0) {
                statement.setMaxRows(this.maxRows);
            }
            this.resultSet = statement.executeQuery(this.sql);
            this.done = false;
            if (this.firstRowOrdinal > 0) {
                if (this.resultSetType == 1003) {
                    for (int i = 0; i < this.firstRowOrdinal; ++i) {
                        if (this.resultSet.next()) continue;
                        this.done = true;
                        break;
                    }
                } else {
                    this.done = !this.resultSet.absolute(this.firstRowOrdinal);
                }
            }
            long time = System.currentTimeMillis();
            long execMs = time - this.startTime;
            Util.addDatabaseTime(execMs);
            status = ", exec " + execMs + " ms";
            this.accessors.clear();
            for (Type type : this.guessTypes()) {
                this.accessors.add(this.createAccessor(this.accessors.size(), type));
            }
        }
        catch (Exception e) {
            status = ", failed (" + e + ")";
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (SQLException e2) {
                // empty catch block
            }
            throw this.handle(e);
        }
        finally {
            RolapUtil.SQL_LOGGER.debug((Object)(currId + ": " + status));
            if (RolapUtil.LOGGER.isDebugEnabled()) {
                RolapUtil.LOGGER.debug((Object)(this.component + ": executing sql [" + this.sql + "]" + status));
            }
        }
    }

    public void close() {
        if (this.haveSemaphore) {
            this.haveSemaphore = false;
            this.querySemaphore.leave();
        }
        Statement statement = null;
        if (this.resultSet != null) {
            try {
                statement = this.resultSet.getStatement();
                this.resultSet.close();
            }
            catch (SQLException e) {
                throw Util.newError(this.message + "; sql=[" + this.sql + "]");
            }
            finally {
                this.resultSet = null;
            }
        }
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                throw Util.newError(this.message + "; sql=[" + this.sql + "]");
            }
        }
        if (this.jdbcConnection != null) {
            try {
                this.jdbcConnection.close();
            }
            catch (SQLException e) {
                throw Util.newError(this.message + "; sql=[" + this.sql + "]");
            }
            finally {
                this.jdbcConnection = null;
            }
        }
        long time = System.currentTimeMillis();
        long totalMs = time - this.startTime;
        String status = ", exec+fetch " + totalMs + " ms, " + this.rowCount + " rows";
        RolapUtil.SQL_LOGGER.debug((Object)(executeCount + ": " + status));
        if (RolapUtil.LOGGER.isDebugEnabled()) {
            RolapUtil.LOGGER.debug((Object)(this.component + ": done executing sql [" + this.sql + "]" + status));
        }
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public RuntimeException handle(Exception e) {
        RuntimeException runtimeException = Util.newError(e, this.message + "; sql=[" + this.sql + "]");
        try {
            this.close();
        }
        catch (RuntimeException runtimeException2) {
            // empty catch block
        }
        return runtimeException;
    }

    public static Type guessType(ResultSetMetaData metaData, int i) throws SQLException {
        int columnType = metaData.getColumnType(i + 1);
        int precision = metaData.getPrecision(i + 1);
        int scale = metaData.getScale(i + 1);
        String columnName = metaData.getColumnName(i + 1);
        String columnLabel = metaData.getColumnLabel(i + 1);
        switch (columnType) {
            case 4: 
            case 5: 
            case 16: {
                return Type.INT;
            }
            case 2: {
                if (precision == 0 && scale == 0) {
                    return Type.DOUBLE;
                }
            }
            case 3: {
                if (!(scale != 0 && scale != -127 || precision > 9 && precision != 38)) {
                    return Type.INT;
                }
                return Type.DOUBLE;
            }
            case 6: 
            case 8: {
                return Type.DOUBLE;
            }
        }
        return Type.OBJECT;
    }

    private Accessor createAccessor(int column, Type type) {
        final int columnPlusOne = column + 1;
        switch (type) {
            case OBJECT: {
                return new Accessor(){

                    public Object get() throws SQLException {
                        return SqlStatement.this.resultSet.getObject(columnPlusOne);
                    }
                };
            }
            case INT: {
                return new Accessor(){

                    public Object get() throws SQLException {
                        int intVal = SqlStatement.this.resultSet.getInt(columnPlusOne);
                        if (intVal == 0 && SqlStatement.this.resultSet.wasNull()) {
                            return null;
                        }
                        return intVal;
                    }
                };
            }
            case DOUBLE: {
                return new Accessor(){

                    public Object get() throws SQLException {
                        double doubleVal = SqlStatement.this.resultSet.getDouble(columnPlusOne);
                        if (doubleVal == 0.0 && SqlStatement.this.resultSet.wasNull()) {
                            return null;
                        }
                        return doubleVal;
                    }
                };
            }
        }
        throw Util.unexpected(type);
    }

    public List<Type> guessTypes() throws SQLException {
        ResultSetMetaData metaData = this.resultSet.getMetaData();
        ArrayList<Type> types = new ArrayList<Type>();
        for (int i = 0; i < metaData.getColumnCount(); ++i) {
            types.add(SqlStatement.guessType(metaData, i));
        }
        return types;
    }

    public List<Accessor> getAccessors() throws SQLException {
        return this.accessors;
    }

    public boolean isDone() {
        return this.done;
    }

    public ResultSet getWrappedResultSet() {
        return (ResultSet)Proxy.newProxyInstance(null, new Class[]{ResultSet.class}, (InvocationHandler)new MyDelegatingInvocationHandler(this));
    }

    public static class MyDelegatingInvocationHandler
    extends DelegatingInvocationHandler {
        private final SqlStatement sqlStatement;

        MyDelegatingInvocationHandler(SqlStatement sqlStatement) {
            this.sqlStatement = sqlStatement;
        }

        protected Object getTarget() {
            return this.sqlStatement.getResultSet();
        }

        public void close() throws SQLException {
            this.sqlStatement.close();
        }
    }

    public static interface Accessor {
        public Object get() throws SQLException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        OBJECT,
        DOUBLE,
        INT;


        public Object get(ResultSet resultSet, int column) throws SQLException {
            switch (this) {
                case OBJECT: {
                    return resultSet.getObject(column + 1);
                }
                case INT: {
                    return resultSet.getInt(column + 1);
                }
                case DOUBLE: {
                    return resultSet.getDouble(column + 1);
                }
            }
            throw Util.unexpected(this);
        }
    }
}

