/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.agg.AggregationManager;
import mondrian.rolap.agg.CellRequest;

public class CountingAggregationManager
extends AggregationManager {
    private SynchronizedCounter requestCount = new SynchronizedCounter();
    private SynchronizedCounter missCount = new SynchronizedCounter();

    CountingAggregationManager() {
    }

    public Object getCellFromCache(CellRequest request) {
        this.requestCount.increment();
        Object obj = super.getCellFromCache(request);
        if (obj == null) {
            this.missCount.increment();
        }
        return obj;
    }

    public Object getCellFromCache(CellRequest request, RolapAggregationManager.PinSet pinSet) {
        this.requestCount.increment();
        Object obj = super.getCellFromCache(request, pinSet);
        if (obj == null) {
            this.missCount.increment();
        }
        return obj;
    }

    public int getRequestCount() {
        return this.requestCount.value();
    }

    public int getMissCount() {
        return this.missCount.value();
    }

    public double getHitRatio() {
        return ((double)this.requestCount.value() - (double)this.missCount.value()) / (double)this.requestCount.value();
    }

    public void resetCounters() {
        this.requestCount.reset();
        this.missCount.reset();
    }

    private class SynchronizedCounter {
        private int c = 0;

        private SynchronizedCounter() {
        }

        public synchronized void increment() {
            ++this.c;
        }

        public synchronized void reset() {
            this.c = 0;
        }

        public synchronized int value() {
            return this.c;
        }
    }
}

