/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.Collection;
import java.util.List;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AbstractColumnPredicate;
import mondrian.rolap.agg.MinusStarPredicate;
import mondrian.rolap.sql.SqlQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LiteralStarPredicate
extends AbstractColumnPredicate {
    private final boolean value;
    public static final LiteralStarPredicate TRUE = new LiteralStarPredicate(null, true);
    public static final LiteralStarPredicate FALSE = new LiteralStarPredicate(null, false);

    public LiteralStarPredicate(RolapStar.Column column, boolean value) {
        super(column);
        this.value = value;
    }

    public int hashCode() {
        return this.value ? 2 : 1;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LiteralStarPredicate) {
            LiteralStarPredicate that = (LiteralStarPredicate)obj;
            return this.value == that.value;
        }
        return false;
    }

    @Override
    public boolean evaluate(List<Object> valueList) {
        assert (valueList.isEmpty());
        return this.value;
    }

    @Override
    public boolean equalConstraint(StarPredicate that) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return Boolean.toString(this.value);
    }

    @Override
    public void values(Collection<Object> collection) {
    }

    @Override
    public boolean evaluate(Object value) {
        return this.value;
    }

    @Override
    public void describe(StringBuilder buf) {
        buf.append("=any");
    }

    @Override
    public StarColumnPredicate.Overlap intersect(StarColumnPredicate predicate) {
        return new StarColumnPredicate.Overlap(this.value, null, 0.0f);
    }

    @Override
    public boolean mightIntersect(StarPredicate other) {
        if (!this.value) {
            return false;
        }
        if (other instanceof LiteralStarPredicate) {
            return ((LiteralStarPredicate)other).value;
        }
        return true;
    }

    @Override
    public StarColumnPredicate minus(StarPredicate predicate) {
        assert (predicate != null);
        if (this.value) {
            return new MinusStarPredicate(this, (StarColumnPredicate)predicate);
        }
        return this;
    }

    @Override
    public StarColumnPredicate cloneWithColumn(RolapStar.Column column) {
        return this;
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public void toSql(SqlQuery sqlQuery, StringBuilder buf) {
        buf.append(this.value);
    }
}

