/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import mondrian.olap.Util;
import mondrian.rolap.CellKey;
import mondrian.rolap.RolapAggregationManager;
import mondrian.rolap.RolapStar;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.Aggregation;
import mondrian.rolap.agg.DenseDoubleSegmentDataset;
import mondrian.rolap.agg.DenseIntSegmentDataset;
import mondrian.rolap.agg.DenseObjectSegmentDataset;
import mondrian.rolap.agg.LiteralStarPredicate;
import mondrian.rolap.agg.SegmentDataset;
import mondrian.rolap.agg.SparseSegmentDataset;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Segment {
    private static int nextId = 0;
    final int id;
    private String desc;
    final Aggregation aggregation;
    final RolapStar.Measure measure;
    final Aggregation.Axis[] axes;
    private SegmentDataset data;
    private final CountDownLatch dataGate = new CountDownLatch(1);
    private State state = State.Loading;
    private final ReentrantReadWriteLock stateLock = new ReentrantReadWriteLock();
    private final List<Region> excludedRegions;
    private static final Logger LOGGER = Logger.getLogger(Segment.class);

    Segment(Aggregation aggregation, RolapStar.Measure measure, Aggregation.Axis[] axes, List<Region> excludedRegions) {
        this.id = nextId++;
        this.aggregation = aggregation;
        this.measure = measure;
        this.axes = axes;
        this.excludedRegions = excludedRegions;
        for (Region region : excludedRegions) {
            assert (region.getPredicates().size() == axes.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setData(SegmentDataset data, RolapAggregationManager.PinSet pinnedSegments) {
        this.stateLock.writeLock().lock();
        try {
            Util.assertTrue(this.data == null);
            Util.assertTrue(this.state == State.Loading);
            this.data = data;
            this.state = State.Ready;
        }
        finally {
            this.stateLock.writeLock().unlock();
        }
        this.dataGate.countDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setFailIfStillLoading() {
        this.stateLock.writeLock().lock();
        try {
            switch (this.state) {
                case Loading: {
                    Util.assertTrue(this.data == null);
                    this.state = State.Failed;
                    return;
                }
                case Ready: {
                    return;
                }
                default: {
                    throw Util.badValue(this.state);
                }
            }
        }
        finally {
            this.stateLock.writeLock().unlock();
            if (this.state == State.Failed) {
                this.dataGate.countDown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareState(State value) {
        boolean retval = false;
        this.stateLock.readLock().lock();
        try {
            retval = this.state == value;
        }
        finally {
            this.stateLock.readLock().unlock();
        }
        return retval;
    }

    public boolean isReady() {
        return this.compareState(State.Ready);
    }

    boolean isFailed() {
        return this.compareState(State.Failed);
    }

    private void makeDescription(StringBuilder buf, boolean values) {
        String sep = Util.nl + "    ";
        buf.append(this.printSegmentHeaderInfo(sep));
        RolapStar.Column[] columns = this.aggregation.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            buf.append(sep);
            buf.append(columns[i].getExpression().getGenericExpression());
            Aggregation.Axis axis = this.axes[i];
            axis.getPredicate().describe(buf);
            if (!values || !this.isReady()) continue;
            Comparable<?>[] keys = axis.getKeys();
            buf.append(", values={");
            for (int j = 0; j < keys.length; ++j) {
                if (j > 0) {
                    buf.append(", ");
                }
                Comparable<?> key = keys[j];
                buf.append(key);
            }
            buf.append("}");
        }
        if (!this.excludedRegions.isEmpty()) {
            buf.append(sep);
            buf.append("excluded={");
            int k = 0;
            for (Region excludedRegion : this.excludedRegions) {
                if (k++ > 0) {
                    buf.append(", ");
                }
                excludedRegion.describe(buf);
            }
            buf.append('}');
        }
        buf.append('}');
    }

    private String printSegmentHeaderInfo(String sep) {
        StringBuilder buf = new StringBuilder();
        buf.append("Segment #");
        buf.append(this.id);
        buf.append(" {");
        buf.append(sep);
        buf.append("measure=");
        buf.append(this.measure.getAggregator().getExpression(this.measure.getExpression().getGenericExpression()));
        return buf.toString();
    }

    public String toString() {
        if (this.desc == null) {
            StringBuilder buf = new StringBuilder(64);
            this.makeDescription(buf, false);
            this.desc = buf.toString();
        }
        return this.desc;
    }

    Object getCellValue(Object[] keys) {
        assert (keys.length == this.axes.length);
        int missed = 0;
        CellKey cellKey = CellKey.Generator.newCellKey(this.axes.length);
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            int offset = this.axes[i].getOffset(key);
            if (offset < 0) {
                if (this.axes[i].getPredicate().evaluate(key)) {
                    ++missed;
                    continue;
                }
                return null;
            }
            cellKey.setAxis(i, offset);
        }
        if (this.isExcluded(keys)) {
            return null;
        }
        if (missed > 0) {
            return Util.nullValue;
        }
        this.waitUntilLoaded();
        Object o = this.data.getObject(cellKey);
        if (o == null) {
            o = Util.nullValue;
        }
        return o;
    }

    boolean wouldContain(Object[] keys) {
        Util.assertTrue(keys.length == this.axes.length);
        for (int i = 0; i < keys.length; ++i) {
            Object key = keys[i];
            if (this.axes[i].getPredicate().evaluate(key)) continue;
            return false;
        }
        return !this.isExcluded(keys);
    }

    private boolean isExcluded(Object[] keys) {
        int n = this.excludedRegions.size();
        for (int i = 0; i < n; ++i) {
            Region excludedRegion = this.excludedRegions.get(i);
            if (!excludedRegion.wouldContain(keys)) continue;
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public void waitUntilLoaded() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[SWITCH], 5[CASE]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isLoading() {
        return this.compareState(State.Loading);
    }

    public void print(PrintWriter pw) {
        this.waitUntilLoaded();
        StringBuilder buf = new StringBuilder();
        this.makeDescription(buf, true);
        pw.print(buf.toString());
        pw.println();
    }

    public List<Region> getExcludedRegions() {
        return this.excludedRegions;
    }

    public int getCellCount() {
        int cellCount = 1;
        for (Aggregation.Axis axis : this.axes) {
            cellCount *= axis.getKeys().length;
        }
        for (Region excludedRegion : this.excludedRegions) {
            cellCount -= excludedRegion.cellCount;
        }
        return cellCount;
    }

    Segment createSubSegment(BitSet[] axisKeepBitSets, int bestColumn, StarColumnPredicate bestPredicate, List<Region> excludedRegions) {
        assert (axisKeepBitSets.length == this.axes.length);
        Aggregation.Axis[] newAxes = (Aggregation.Axis[])this.axes.clone();
        Map[] axisPosMaps = new Map[this.axes.length];
        int valueCount = 1;
        for (int j = 0; j < this.axes.length; ++j) {
            Aggregation.Axis newAxis;
            Comparable[] newAxisKeys;
            Aggregation.Axis axis = this.axes[j];
            StarColumnPredicate newPredicate = axis.getPredicate();
            if (j == bestColumn) {
                newPredicate = bestPredicate;
            }
            Comparable[] axisKeys = axis.getKeys();
            BitSet keepBitSet = axisKeepBitSets[j];
            int firstClearBit = keepBitSet.nextClearBit(0);
            if (firstClearBit >= axisKeys.length) {
                newAxisKeys = axisKeys;
                axisPosMaps[j] = null;
            } else {
                ArrayList<Comparable> newAxisKeyList = new ArrayList<Comparable>();
                HashMap<Integer, Integer> map = axisPosMaps[j] = new HashMap<Integer, Integer>();
                int bit = keepBitSet.nextSetBit(0);
                while (bit >= 0) {
                    map.put(bit, newAxisKeyList.size());
                    newAxisKeyList.add(axisKeys[bit]);
                    bit = keepBitSet.nextSetBit(bit + 1);
                }
                newAxisKeys = newAxisKeyList.toArray(new Comparable[newAxisKeyList.size()]);
                assert (newAxisKeys.length > 0);
            }
            newAxes[j] = newAxis = new Aggregation.Axis(newPredicate, newAxisKeys);
            valueCount *= newAxisKeys.length;
        }
        Segment newSegment = new Segment(this.aggregation, this.measure, newAxes, excludedRegions);
        Util.assertTrue(this.isReady());
        SegmentDataset newData = this.createDataset(this.data instanceof SparseSegmentDataset, this.data.getType(), valueCount);
        int[] pos = new int[this.axes.length];
        block2: for (Map.Entry entry : this.data) {
            CellKey key = (CellKey)entry.getKey();
            for (int i = 0; i < pos.length; ++i) {
                int ordinal = key.getAxis(i);
                Map axisPosMap = axisPosMaps[i];
                if (axisPosMap == null) {
                    pos[i] = ordinal;
                    continue;
                }
                Integer integer = (Integer)axisPosMap.get(ordinal);
                if (integer == null) continue block2;
                pos[i] = integer;
            }
            newData.populateFrom(pos, this.data, key);
        }
        newSegment.setData(newData, null);
        return newSegment;
    }

    SegmentDataset createDataset(boolean sparse, SqlStatement.Type type, int size) {
        if (sparse) {
            return new SparseSegmentDataset(this);
        }
        switch (type) {
            case OBJECT: {
                return new DenseObjectSegmentDataset(this, size);
            }
            case INT: {
                return new DenseIntSegmentDataset(this, size);
            }
            case DOUBLE: {
                return new DenseDoubleSegmentDataset(this, size);
            }
        }
        throw Util.unexpected(type);
    }

    SegmentDataset getData() {
        if (this.isReady()) {
            return this.data;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Region {
        private final StarColumnPredicate[] predicates;
        private final StarPredicate[] multiColumnPredicates;
        private final int cellCount;

        Region(List<StarColumnPredicate> predicateList, List<StarPredicate> multiColumnPredicateList, int cellCount) {
            this.predicates = predicateList.toArray(new StarColumnPredicate[predicateList.size()]);
            this.multiColumnPredicates = multiColumnPredicateList.toArray(new StarPredicate[multiColumnPredicateList.size()]);
            this.cellCount = cellCount;
        }

        public List<StarColumnPredicate> getPredicates() {
            return Collections.unmodifiableList(Arrays.asList(this.predicates));
        }

        public List<StarPredicate> getMultiColumnPredicates() {
            return Collections.unmodifiableList(Arrays.asList(this.multiColumnPredicates));
        }

        public int getCellCount() {
            return this.cellCount;
        }

        public boolean wouldContain(Object[] keys) {
            assert (keys.length == this.predicates.length);
            for (int i = 0; i < keys.length; ++i) {
                StarColumnPredicate predicate = this.predicates[i];
                Object key = keys[i];
                if (predicate.evaluate(key)) continue;
                return false;
            }
            return true;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Region) {
                Region that = (Region)obj;
                return Arrays.equals(this.predicates, that.predicates) && Arrays.equals(this.multiColumnPredicates, that.multiColumnPredicates);
            }
            return false;
        }

        public int hashCode() {
            return Arrays.hashCode(this.multiColumnPredicates) ^ Arrays.hashCode(this.predicates);
        }

        public void describe(StringBuilder buf) {
            int k = 0;
            for (StarColumnPredicate starColumnPredicate : this.predicates) {
                if (starColumnPredicate instanceof LiteralStarPredicate && ((LiteralStarPredicate)starColumnPredicate).getValue()) continue;
                if (k++ > 0) {
                    buf.append(" AND ");
                }
                starColumnPredicate.describe(buf);
            }
            for (StarPredicate starPredicate : this.multiColumnPredicates) {
                if (starPredicate instanceof LiteralStarPredicate && ((LiteralStarPredicate)starPredicate).getValue()) continue;
                if (k++ > 0) {
                    buf.append(" AND ");
                }
                starPredicate.describe(buf);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        Initial,
        Loading,
        Ready,
        Failed;

    }
}

