/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tiles.Attribute;
import org.apache.tiles.AttributeContext;
import org.apache.tiles.BasicAttributeContext;
import org.apache.tiles.Definition;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.context.TilesContextFactory;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.DefinitionsFactoryException;
import org.apache.tiles.definition.NoSuchDefinitionException;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.impl.CannotRenderException;
import org.apache.tiles.preparer.NoSuchPreparerException;
import org.apache.tiles.preparer.PreparerFactory;
import org.apache.tiles.preparer.ViewPreparer;
import org.apache.tiles.renderer.AttributeRenderer;
import org.apache.tiles.renderer.RendererFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicTilesContainer
implements TilesContainer {
    public static final String DEFINITIONS_CONFIG = "org.apache.tiles.impl.BasicTilesContainer.DEFINITIONS_CONFIG";
    private static final String LEGACY_DEFINITIONS_CONFIG = "definitions-config";
    private static final String ATTRIBUTE_CONTEXT_STACK = "org.apache.tiles.AttributeContext.STACK";
    private final Log log = LogFactory.getLog(BasicTilesContainer.class);
    private TilesApplicationContext context;
    private DefinitionsFactory definitionsFactory;
    private PreparerFactory preparerFactory;
    private RendererFactory rendererFactory;
    private AttributeEvaluator evaluator;
    private TilesRequestContextFactory contextFactory;
    private boolean initialized = false;

    public void init(Map<String, String> initParameters) {
        this.checkInit();
        this.initialized = true;
        if (this.rendererFactory == null) {
            throw new IllegalStateException("RendererFactory not specified");
        }
        if (this.preparerFactory == null) {
            throw new IllegalStateException("PreparerFactory not specified");
        }
        if (this.definitionsFactory == null) {
            throw new IllegalStateException("DefinitionsFactory not specified");
        }
        if (this.evaluator == null) {
            throw new IllegalStateException("AttributeEvaluator not specified");
        }
        if (this.contextFactory == null) {
            throw new IllegalStateException("TilesContextFactory not specified");
        }
        if (this.context == null) {
            throw new IllegalStateException("TilesApplicationContext not specified");
        }
    }

    public AttributeContext startContext(Object ... requestItems) {
        TilesRequestContext tilesContext = this.getRequestContext(requestItems);
        return this.startContext(tilesContext);
    }

    public void endContext(Object ... requestItems) {
        TilesRequestContext tilesContext = this.getRequestContext(requestItems);
        this.endContext(tilesContext);
    }

    public void renderContext(Object ... requestItems) {
        TilesRequestContext request = this.getRequestContext(requestItems);
        AttributeContext attributeContext = this.getAttributeContext(request);
        this.render(request, attributeContext);
    }

    public TilesApplicationContext getApplicationContext() {
        return this.context;
    }

    public void setApplicationContext(TilesApplicationContext context) {
        this.context = context;
    }

    public AttributeContext getAttributeContext(Object ... requestItems) {
        TilesRequestContext tilesContext = this.getRequestContext(requestItems);
        return this.getAttributeContext(tilesContext);
    }

    @Deprecated
    public TilesContextFactory getContextFactory() {
        return null;
    }

    protected TilesRequestContextFactory getRequestContextFactory() {
        return this.contextFactory;
    }

    public void setContextFactory(TilesContextFactory contextFactory) {
    }

    public void setRequestContextFactory(TilesRequestContextFactory contextFactory) {
        this.checkInit();
        this.contextFactory = contextFactory;
    }

    public DefinitionsFactory getDefinitionsFactory() {
        return this.definitionsFactory;
    }

    public void setDefinitionsFactory(DefinitionsFactory definitionsFactory) {
        this.checkInit();
        this.definitionsFactory = definitionsFactory;
    }

    public PreparerFactory getPreparerFactory() {
        return this.preparerFactory;
    }

    public void setPreparerFactory(PreparerFactory preparerFactory) {
        this.preparerFactory = preparerFactory;
    }

    public void setRendererFactory(RendererFactory rendererFactory) {
        this.rendererFactory = rendererFactory;
    }

    public void setEvaluator(AttributeEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    public void prepare(String preparer, Object ... requestItems) {
        TilesRequestContext requestContext = this.getRequestContextFactory().createRequestContext(this.getApplicationContext(), requestItems);
        this.prepare(requestContext, preparer, false);
    }

    public void render(String definitionName, Object ... requestItems) {
        TilesRequestContext requestContext = this.getRequestContextFactory().createRequestContext(this.getApplicationContext(), requestItems);
        this.render(requestContext, definitionName);
    }

    @Deprecated
    public void render(Attribute attr, Writer writer, Object ... requestItems) throws IOException {
        this.render(attr, requestItems);
    }

    public void render(Attribute attr, Object ... requestItems) throws IOException {
        TilesRequestContext requestContext = this.getRequestContextFactory().createRequestContext(this.getApplicationContext(), requestItems);
        this.render(attr, requestContext);
    }

    public Object evaluate(Attribute attribute, Object ... requestItems) {
        TilesRequestContext request = this.getRequestContextFactory().createRequestContext(this.context, requestItems);
        return this.evaluator.evaluate(attribute, request);
    }

    public boolean isValidDefinition(String definitionName, Object ... requestItems) {
        return this.isValidDefinition(this.getRequestContext(requestItems), definitionName);
    }

    protected Definition getDefinition(String definitionName, TilesRequestContext request) {
        Definition definition = this.definitionsFactory.getDefinition(definitionName, request);
        return definition;
    }

    protected String getResourceString() {
        return this.getResourceString(this.context.getInitParams());
    }

    protected String getResourceString(Map<String, String> parms) {
        String resourceStr = parms.get(DEFINITIONS_CONFIG);
        if (resourceStr == null) {
            resourceStr = parms.get(LEGACY_DEFINITIONS_CONFIG);
        }
        if (resourceStr == null) {
            resourceStr = "/WEB-INF/tiles.xml";
        }
        return resourceStr;
    }

    protected List<String> getResourceNames(String resourceString) {
        StringTokenizer tokenizer = new StringTokenizer(resourceString, ",");
        ArrayList<String> filenames = new ArrayList<String>(tokenizer.countTokens());
        while (tokenizer.hasMoreTokens()) {
            filenames.add(tokenizer.nextToken().trim());
        }
        return filenames;
    }

    protected void checkInit() {
        if (this.initialized) {
            throw new IllegalStateException("Container allready initialized");
        }
    }

    @Deprecated
    protected void initializeDefinitionsFactory(DefinitionsFactory definitionsFactory, String resourceString, Map<String, String> initParameters) {
        if (this.rendererFactory == null) {
            throw new IllegalStateException("No RendererFactory found");
        }
        definitionsFactory.init(initParameters);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"Tiles2 container initialization complete.");
        }
    }

    protected Stack<AttributeContext> getContextStack(TilesRequestContext tilesContext) {
        Stack contextStack = (Stack)tilesContext.getRequestScope().get(ATTRIBUTE_CONTEXT_STACK);
        if (contextStack == null) {
            contextStack = new Stack();
            tilesContext.getRequestScope().put(ATTRIBUTE_CONTEXT_STACK, contextStack);
        }
        return contextStack;
    }

    protected void pushContext(AttributeContext context, TilesRequestContext tilesContext) {
        Stack<AttributeContext> contextStack = this.getContextStack(tilesContext);
        contextStack.push(context);
    }

    protected AttributeContext popContext(TilesRequestContext tilesContext) {
        Stack<AttributeContext> contextStack = this.getContextStack(tilesContext);
        return contextStack.pop();
    }

    protected AttributeContext getContext(TilesRequestContext tilesContext) {
        Stack<AttributeContext> contextStack = this.getContextStack(tilesContext);
        if (!contextStack.isEmpty()) {
            return contextStack.peek();
        }
        return null;
    }

    private AttributeContext getAttributeContext(TilesRequestContext tilesContext) {
        AttributeContext context = this.getContext(tilesContext);
        if (context == null) {
            context = new BasicAttributeContext();
            this.pushContext(context, tilesContext);
        }
        return context;
    }

    private TilesRequestContext getRequestContext(Object ... requestItems) {
        return this.getRequestContextFactory().createRequestContext(this.getApplicationContext(), requestItems);
    }

    private AttributeContext startContext(TilesRequestContext tilesContext) {
        BasicAttributeContext context = new BasicAttributeContext();
        Stack<AttributeContext> stack = this.getContextStack(tilesContext);
        if (!stack.isEmpty()) {
            AttributeContext parent = stack.peek();
            context.inheritCascadedAttributes(parent);
        }
        stack.push((AttributeContext)context);
        return context;
    }

    private void endContext(TilesRequestContext tilesContext) {
        this.popContext(tilesContext);
    }

    private void prepare(TilesRequestContext context, String preparerName, boolean ignoreMissing) {
        ViewPreparer preparer;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Prepare request received for '" + preparerName));
        }
        if ((preparer = this.preparerFactory.getPreparer(preparerName, context)) == null && ignoreMissing) {
            return;
        }
        if (preparer == null) {
            throw new NoSuchPreparerException("Preparer '" + preparerName + " not found");
        }
        AttributeContext attributeContext = this.getContext(context);
        preparer.execute(context, attributeContext);
    }

    protected void render(TilesRequestContext request, String definitionName) {
        Definition definition;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Render request recieved for definition '" + definitionName + "'"));
        }
        if ((definition = this.getDefinition(definitionName, request)) == null) {
            if (this.log.isWarnEnabled()) {
                String message = "Unable to find the definition '" + definitionName + "'";
                this.log.warn((Object)message);
            }
            throw new NoSuchDefinitionException(definitionName);
        }
        this.render(request, definition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void render(TilesRequestContext request, Definition definition) {
        AttributeContext originalContext = this.getAttributeContext(request);
        BasicAttributeContext subContext = new BasicAttributeContext(originalContext);
        subContext.inherit((BasicAttributeContext)definition);
        this.pushContext((AttributeContext)subContext, request);
        try {
            this.render(request, (AttributeContext)subContext);
        }
        finally {
            this.popContext(request);
        }
    }

    private void render(Attribute attr, TilesRequestContext requestContext) throws IOException {
        if (attr == null) {
            throw new CannotRenderException("Cannot render a null attribute");
        }
        AttributeRenderer renderer = this.rendererFactory.getRenderer(attr.getRenderer());
        if (renderer == null) {
            throw new CannotRenderException("Cannot render an attribute with renderer name " + attr.getRenderer());
        }
        renderer.render(attr, requestContext);
    }

    protected void render(TilesRequestContext request, AttributeContext attributeContext) {
        try {
            if (attributeContext.getPreparer() != null) {
                this.prepare(request, attributeContext.getPreparer(), true);
            }
            this.render(attributeContext.getTemplateAttribute(), request);
        }
        catch (IOException e) {
            throw new CannotRenderException(e.getMessage(), e);
        }
    }

    private boolean isValidDefinition(TilesRequestContext context, String definitionName) {
        try {
            Definition definition = this.getDefinition(definitionName, context);
            return definition != null;
        }
        catch (NoSuchDefinitionException nsde) {
            return false;
        }
        catch (DefinitionsFactoryException e) {
            return false;
        }
    }
}

