/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.language.Argument;
import org.teiid.language.Command;
import org.teiid.logging.LogManager;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.JDBCExecutionException;
import org.teiid.translator.jdbc.JDBCExecutionFactory;
import org.teiid.translator.jdbc.JDBCPlugin;
import org.teiid.translator.jdbc.JDBCQueryExecution;

public class JDBCDirectQueryExecution
extends JDBCQueryExecution
implements ProcedureExecution {
    protected int columnCount;
    private List<Argument> arguments;
    protected int updateCount = -1;

    public JDBCDirectQueryExecution(List<Argument> arguments, Command command, Connection connection, ExecutionContext context, JDBCExecutionFactory env) {
        super(command, connection, context, env);
        this.arguments = arguments;
    }

    @Override
    public void execute() throws TranslatorException {
        String sourceSQL = (String)this.arguments.get(0).getArgumentValue().getValue();
        List<Argument> parameters = this.arguments.subList(1, this.arguments.size());
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Source sql", sourceSQL});
        int paramCount = parameters.size();
        try {
            Statement stmt;
            boolean hasResults = false;
            if (paramCount > 0) {
                PreparedStatement pstatement = this.getPreparedStatement(sourceSQL);
                for (int i = 0; i < paramCount; ++i) {
                    Argument arg = parameters.get(i);
                    this.executionFactory.bindValue(pstatement, arg.getArgumentValue(), arg.getArgumentValue().getType(), i);
                }
                stmt = pstatement;
                hasResults = pstatement.execute();
            } else {
                stmt = this.getStatement();
                hasResults = stmt.execute(sourceSQL);
            }
            if (hasResults) {
                this.results = stmt.getResultSet();
                this.columnCount = this.results.getMetaData().getColumnCount();
            } else {
                this.updateCount = stmt.getUpdateCount();
            }
            this.addStatementWarnings();
        }
        catch (SQLException e) {
            throw new JDBCExecutionException((BundleUtil.Event)JDBCPlugin.Event.TEIID11008, e, sourceSQL);
        }
    }

    @Override
    public List<?> next() throws TranslatorException, DataNotAvailableException {
        try {
            ArrayList<Object[]> row = new ArrayList<Object[]>(1);
            if (this.results != null) {
                if (this.results.next()) {
                    ArrayList<Object> vals = new ArrayList<Object>(this.columnCount);
                    for (int i = 0; i < this.columnCount; ++i) {
                        Object value = this.executionFactory.retrieveValue(this.results, i + 1, TypeFacility.RUNTIME_TYPES.OBJECT);
                        vals.add(value);
                    }
                    row.add(vals.toArray(new Object[vals.size()]));
                    return row;
                }
            } else if (this.updateCount != -1) {
                ArrayList<Integer> vals = new ArrayList<Integer>(1);
                vals.add(new Integer(this.updateCount));
                this.updateCount = -1;
                row.add(vals.toArray(new Object[vals.size()]));
                return row;
            }
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e, JDBCPlugin.Util.getString("JDBCTranslator.Unexpected_exception_translating_results___8", new Object[]{e.getMessage()}));
        }
        return null;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        return null;
    }
}

