/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.ingres;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Limit;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.jdbc.AliasModifier;
import org.teiid.translator.jdbc.ConvertModifier;
import org.teiid.translator.jdbc.JDBCExecutionFactory;

@Translator(name="ingres", description="A translator for Ingres Databases")
public class IngresExecutionFactory
extends JDBCExecutionFactory {
    private static final String INGRES = "ingres";
    protected ConvertModifier convert = new ConvertModifier();

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.convert.addTypeMapping("tinyint", 2, 3);
        this.convert.addTypeMapping("smallint", 4);
        this.convert.addTypeMapping("integer", 5);
        this.convert.addTypeMapping("bigint", 6);
        this.convert.addTypeMapping("real", 8);
        this.convert.addTypeMapping("float", 9);
        this.convert.addTypeMapping("decimal(38,19)", 10);
        this.convert.addTypeMapping("decimal(15,0)", 7);
        this.convert.addTypeMapping("date", 11);
        this.convert.addTypeMapping("time", 12);
        this.convert.addTypeMapping("timestamp", 13);
        this.convert.addTypeMapping("char(1)", 1);
        this.convert.addTypeMapping("varchar(4000)", 0);
        this.convert.addTypeMapping("blob", 15);
        this.convert.addTypeMapping("clob", 16);
        this.convert.addNumericBooleanConversions();
        this.convert.setWideningNumericImplicit(true);
        this.registerFunctionModifier("convert", this.convert);
        this.registerFunctionModifier("bitand", new AliasModifier("bit_and"));
        this.registerFunctionModifier("bitnot", new AliasModifier("bit_not"));
        this.registerFunctionModifier("bitor", new AliasModifier("bit_or"));
        this.registerFunctionModifier("bitxor", new AliasModifier("bit_xor"));
        this.registerFunctionModifier("curtime", new AliasModifier("current_time"));
        this.registerFunctionModifier("curdate", new AliasModifier("current_date"));
        this.registerFunctionModifier("lcase", new AliasModifier("lowercase"));
        this.registerFunctionModifier("ucase", new AliasModifier("uppercase"));
        this.registerFunctionModifier("dayofmonth", new AliasModifier("day"));
        this.addPushDownFunction(INGRES, "bit_add", "integer", new String[]{"integer", "integer"});
        this.addPushDownFunction(INGRES, "bit_length", "integer", new String[]{"integer"});
        this.addPushDownFunction(INGRES, "character_length", "string", new String[]{"integer"});
        this.addPushDownFunction(INGRES, "charextract", "char", new String[]{"string", "integer"});
        this.addPushDownFunction(INGRES, "gmt_timestamp", "string", new String[]{"integer"});
        this.addPushDownFunction(INGRES, "hash", "integer", new String[]{"string"});
        this.addPushDownFunction(INGRES, "hex", "string", new String[]{"string"});
        this.addPushDownFunction(INGRES, "ln", "double", new String[]{"double"});
        this.addPushDownFunction(INGRES, "octet_length", "integer", new String[]{"string"});
        this.addPushDownFunction(INGRES, "randomf", "float", new String[0]);
        this.addPushDownFunction(INGRES, "session_user", "string", new String[0]);
        this.addPushDownFunction(INGRES, "size", "integer", new String[]{"string"});
        this.addPushDownFunction(INGRES, "squeeze", "string", new String[]{"string"});
        this.addPushDownFunction(INGRES, "soundex", "string", new String[]{"string"});
        this.addPushDownFunction(INGRES, "unhex", "string", new String[]{"string"});
        this.addPushDownFunction(INGRES, "usercode", "string", new String[0]);
        this.addPushDownFunction(INGRES, "username", "string", new String[0]);
    }

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("abs");
        supportedFunctions.add("atan");
        supportedFunctions.add("bitand");
        supportedFunctions.add("bitnot");
        supportedFunctions.add("bitor");
        supportedFunctions.add("bitxor");
        supportedFunctions.add("concat");
        supportedFunctions.add("cos");
        supportedFunctions.add("convert");
        supportedFunctions.add("curtime");
        supportedFunctions.add("curdate");
        supportedFunctions.add("dayofmonth");
        supportedFunctions.add("exp");
        supportedFunctions.add("hour");
        supportedFunctions.add("lcase");
        supportedFunctions.add("left");
        supportedFunctions.add("lpad");
        supportedFunctions.add("length");
        supportedFunctions.add("log");
        supportedFunctions.add("minute");
        supportedFunctions.add("month");
        supportedFunctions.add("power");
        supportedFunctions.add("right");
        supportedFunctions.add("rpad");
        supportedFunctions.add("second");
        supportedFunctions.add("sin");
        supportedFunctions.add("sqrt");
        supportedFunctions.add("substring");
        supportedFunctions.add("year");
        supportedFunctions.add("ucase");
        return supportedFunctions;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    @Override
    public List<?> translateLimit(Limit limit, ExecutionContext context) {
        return Arrays.asList("FETCH FIRST ", limit.getRowLimit(), " ROWS ONLY");
    }

    @Override
    public String translateLiteralDate(Date dateValue) {
        return "DATE '" + this.formatDateValue(dateValue) + "'";
    }

    @Override
    public String translateLiteralTime(Time timeValue) {
        return "TIME '" + this.formatDateValue(timeValue) + "'";
    }

    @Override
    public String translateLiteralTimestamp(Timestamp timestampValue) {
        return "TIMESTAMP '" + this.formatDateValue(timestampValue) + "'";
    }

    @Override
    public ExecutionFactory.NullOrder getDefaultNullOrder() {
        return ExecutionFactory.NullOrder.LAST;
    }

    @Override
    public boolean supportsInlineViews() {
        return true;
    }
}

