/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.AndOr;
import org.teiid.language.Condition;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.IsNull;
import org.teiid.language.LanguageFactory;
import org.teiid.language.Literal;
import org.teiid.language.SearchedWhenClause;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.FunctionModifier;

public class ConcatFunctionModifier
extends FunctionModifier {
    private LanguageFactory langFactory;

    public ConcatFunctionModifier(LanguageFactory langFactory) {
        this.langFactory = langFactory;
    }

    @Override
    public List<?> translate(Function function) {
        Expression a = (Expression)function.getParameters().get(0);
        Expression b = (Expression)function.getParameters().get(1);
        ArrayList<IsNull> crits = new ArrayList<IsNull>();
        Literal nullValue = this.langFactory.createLiteral(null, TypeFacility.RUNTIME_TYPES.STRING);
        if (this.isNull(a)) {
            return Arrays.asList(nullValue);
        }
        if (!ConcatFunctionModifier.isNotNull(a)) {
            crits.add(this.langFactory.createIsNullCriteria(a, false));
        }
        if (this.isNull(b)) {
            return Arrays.asList(nullValue);
        }
        if (!ConcatFunctionModifier.isNotNull(b)) {
            crits.add(this.langFactory.createIsNullCriteria(b, false));
        }
        Object crit = null;
        if (crits.isEmpty()) {
            return null;
        }
        crit = crits.size() == 1 ? (Condition)crits.get(0) : this.langFactory.createAndOr(AndOr.Operator.OR, (Condition)crits.get(0), (Condition)crits.get(1));
        List<SearchedWhenClause> cases = Arrays.asList(this.langFactory.createSearchedWhenCondition(crit, (Expression)nullValue));
        return Arrays.asList(this.langFactory.createSearchedCaseExpression(cases, (Expression)function, TypeFacility.RUNTIME_TYPES.STRING));
    }

    public static boolean isNotNull(Expression expr) {
        Function function;
        if (expr instanceof Literal) {
            Literal literal = (Literal)expr;
            return literal.getValue() != null;
        }
        if (expr instanceof Function && ((function = (Function)expr).getName().equalsIgnoreCase("NVL") || function.getName().equalsIgnoreCase("ifnull"))) {
            return ConcatFunctionModifier.isNotNull((Expression)function.getParameters().get(1));
        }
        return false;
    }

    private boolean isNull(Expression expr) {
        if (expr instanceof Literal) {
            Literal literal = (Literal)expr;
            return literal.getValue() == null;
        }
        return false;
    }
}

