/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.PhysicalAddress;
import org.jgroups.protocols.TP;

public class SHARED_LOOPBACK
extends TP {
    private PhysicalAddress physical_addr = null;
    private static final ConcurrentMap<String, Map<Address, SHARED_LOOPBACK>> routing_table = new ConcurrentHashMap<String, Map<Address, SHARED_LOOPBACK>>();

    @Override
    public boolean supportsMulticasting() {
        return false;
    }

    @Override
    public String toString() {
        return "SHARED_LOOPBACK(local address: " + this.local_addr + ')';
    }

    @Override
    public void sendMulticast(byte[] data, int offset, int length) throws Exception {
        Map dests = (Map)routing_table.get(this.channel_name);
        if (dests == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("no destination found for " + this.channel_name);
            }
            return;
        }
        for (Map.Entry entry : dests.entrySet()) {
            Address dest = (Address)entry.getKey();
            SHARED_LOOPBACK target = (SHARED_LOOPBACK)entry.getValue();
            try {
                target.receive(this.local_addr, data, offset, length);
            }
            catch (Throwable t) {
                this.log.error("failed sending message to " + dest, t);
            }
        }
    }

    @Override
    public void sendUnicast(PhysicalAddress dest, byte[] data, int offset, int length) throws Exception {
        Map dests = (Map)routing_table.get(this.channel_name);
        if (dests == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("no destination found for " + this.channel_name);
            }
            return;
        }
        SHARED_LOOPBACK target = (SHARED_LOOPBACK)dests.get(dest);
        if (target == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("destination address " + dest + " not found");
            }
            return;
        }
        target.receive(this.local_addr, data, offset, length);
    }

    @Override
    protected void sendToSingleMember(Address dest, byte[] buf, int offset, int length) throws Exception {
        Map dests = (Map)routing_table.get(this.channel_name);
        if (dests == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("no destination found for " + this.channel_name);
            }
            return;
        }
        SHARED_LOOPBACK target = (SHARED_LOOPBACK)dests.get(dest);
        if (target == null) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("destination address " + dest + " not found");
            }
            return;
        }
        target.receive(this.local_addr, buf, offset, length);
    }

    @Override
    public String getInfo() {
        return this.toString();
    }

    @Override
    protected PhysicalAddress getPhysicalAddress() {
        return this.physical_addr;
    }

    @Override
    public Object down(Event evt) {
        Object retval = super.down(evt);
        switch (evt.getType()) {
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                SHARED_LOOPBACK.register(this.channel_name, this.local_addr, this);
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return retval;
    }

    @Override
    public void stop() {
        super.stop();
    }

    protected static void register(String channel_name, Address local_addr, SHARED_LOOPBACK shared_loopback) {
        Map tmp;
        Map<Address, SHARED_LOOPBACK> map = (ConcurrentHashMap<Address, SHARED_LOOPBACK>)routing_table.get(channel_name);
        if (map == null && (tmp = (Map)routing_table.putIfAbsent(channel_name, map = new ConcurrentHashMap<Address, SHARED_LOOPBACK>())) != null) {
            map = tmp;
        }
        map.put(local_addr, shared_loopback);
    }

    protected static void unregister(String channel_name, Address local_addr) {
        Map map = (Map)routing_table.get(channel_name);
        if (map != null) {
            map.remove(local_addr);
            if (map.isEmpty()) {
                routing_table.remove(channel_name);
            }
        }
    }
}

