/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jgroups.Address;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.conf.PropertyConverters;
import org.jgroups.stack.AckSenderWindow;
import org.jgroups.stack.ExponentialInterval;
import org.jgroups.stack.NakReceiverWindow;
import org.jgroups.stack.Protocol;
import org.jgroups.stack.Retransmitter;
import org.jgroups.stack.StaticInterval;
import org.jgroups.util.AgeOutCache;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Reliable unicast layer")
public class UNICAST2
extends Protocol
implements Retransmitter.RetransmitCommand,
AgeOutCache.Handler<Address> {
    public static final long DEFAULT_FIRST_SEQNO = 1L;
    private int[] timeout = new int[]{400, 800, 1600, 3200};
    @Property(description="The first value (in milliseconds) to use in the exponential backoff. Enabled if greater than 0")
    private int exponential_backoff = 300;
    @Property(description="Max number of messages to be removed from a NakReceiverWindow. This property might get removed anytime, so don't use it !")
    private int max_msg_batch_size = 50000;
    @Property(description="Max number of bytes before a stability message is sent to the sender")
    protected long max_bytes = 10000000L;
    @Property(description="Max number of milliseconds before a stability message is sent to the sender(s)")
    protected long stable_interval = 60000L;
    @Property(description="Max number of STABLE messages sent for the same highest_received seqno. A value < 1 is invalid")
    protected int max_stable_msgs = 5;
    @Property(description="Number of rows of the matrix in the retransmission table (only for experts)", writable=false)
    int xmit_table_num_rows = 5;
    @Property(description="Number of elements of a row of the matrix in the retransmission table (only for experts). The capacity of the matrix is xmit_table_num_rows * xmit_table_msgs_per_row", writable=false)
    int xmit_table_msgs_per_row = 10000;
    @Property(description="Resize factor of the matrix in the retransmission table (only for experts)", writable=false)
    double xmit_table_resize_factor = 1.2;
    @Property(description="Number of milliseconds after which the matrix in the retransmission table is compacted (only for experts)", writable=false)
    long xmit_table_max_compaction_time = 600000L;
    @Property(description="If enabled, the removal of a message from the retransmission table causes an automatic purge (only for experts)", writable=false)
    boolean xmit_table_automatic_purging = true;
    @Property(description="Whether to use the old retransmitter which retransmits individual messages or the new one which uses ranges of retransmitted messages. Default is true. Note that this property will be removed in 3.0; it is only used to switch back to the old (and proven) retransmitter mechanism if issues occur")
    private boolean use_range_based_retransmitter = true;
    @Property(description="Time (in milliseconds) after which an idle incoming or outgoing connection is closed. The connection will get re-established when used again. 0 disables connection reaping")
    protected long conn_expiry_timeout = 60000L;
    private long num_msgs_sent = 0L;
    private long num_msgs_received = 0L;
    private long num_bytes_sent = 0L;
    private long num_bytes_received = 0L;
    private long num_xmits = 0L;
    private final ConcurrentMap<Address, SenderEntry> send_table = Util.createConcurrentMap();
    private final ConcurrentMap<Address, ReceiverEntry> recv_table = Util.createConcurrentMap();
    protected final ReentrantLock recv_table_lock = new ReentrantLock();
    private final List<Address> members = new ArrayList<Address>(11);
    private Address local_addr = null;
    private TimeScheduler timer = null;
    private boolean started = false;
    private short last_conn_id = 0;
    protected long max_retransmit_time = 60000L;
    private AgeOutCache<Address> cache = null;
    private Future<?> stable_task_future = null;
    protected Future<?> connection_reaper;

    public int[] getTimeout() {
        return this.timeout;
    }

    @Property(name="timeout", converter=PropertyConverters.IntegerArray.class, description="list of timeouts")
    public void setTimeout(int[] val) {
        if (val != null) {
            this.timeout = val;
        }
    }

    public void setMaxMessageBatchSize(int size) {
        if (size >= 1) {
            this.max_msg_batch_size = size;
        }
    }

    @ManagedAttribute
    public String getLocalAddress() {
        return this.local_addr != null ? this.local_addr.toString() : "null";
    }

    @ManagedAttribute
    public String getMembers() {
        return this.members != null ? this.members.toString() : "[]";
    }

    @ManagedAttribute(description="Returns the number of outgoing (send) connections")
    public int getNumSendConnections() {
        return this.send_table.size();
    }

    @ManagedAttribute(description="Returns the number of incoming (receive) connections")
    public int getNumReceiveConnections() {
        return this.recv_table.size();
    }

    @ManagedAttribute(description="Returns the total number of outgoing (send) and incoming (receive) connections")
    public int getNumConnections() {
        return this.getNumReceiveConnections() + this.getNumSendConnections();
    }

    @ManagedOperation
    public String printConnections() {
        StringBuilder sb = new StringBuilder();
        if (!this.send_table.isEmpty()) {
            sb.append("send connections:\n");
            for (Map.Entry entry : this.send_table.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        if (!this.recv_table.isEmpty()) {
            sb.append("\nreceive connections:\n");
            for (Map.Entry entry : this.recv_table.entrySet()) {
                sb.append(entry.getKey()).append(": ").append(entry.getValue()).append("\n");
            }
        }
        return sb.toString();
    }

    @ManagedAttribute(description="Whether the ConnectionReaper task is running")
    public boolean isConnectionReaperRunning() {
        return this.connection_reaper != null && !this.connection_reaper.isDone();
    }

    @ManagedAttribute
    public long getNumMessagesSent() {
        return this.num_msgs_sent;
    }

    @ManagedAttribute
    public long getNumMessagesReceived() {
        return this.num_msgs_received;
    }

    @ManagedAttribute
    public long getNumBytesSent() {
        return this.num_bytes_sent;
    }

    @ManagedAttribute
    public long getNumBytesReceived() {
        return this.num_bytes_received;
    }

    @ManagedAttribute
    public long getNumberOfRetransmissions() {
        return this.num_xmits;
    }

    @ManagedAttribute
    public long getPendingXmitRequests() {
        long retval = 0L;
        Collection values = this.recv_table.values();
        for (ReceiverEntry entry : values) {
            if (entry.received_msgs == null) continue;
            retval += (long)entry.received_msgs.getPendingXmits();
        }
        return retval;
    }

    public long getMaxRetransmitTime() {
        return this.max_retransmit_time;
    }

    @Property(description="Max number of milliseconds we try to retransmit a message to any given member. After that, the connection is removed. Any new connection to that member will start with seqno #1 again. 0 disables this")
    public void setMaxRetransmitTime(long max_retransmit_time) {
        this.max_retransmit_time = max_retransmit_time;
        if (this.cache != null && max_retransmit_time > 0L) {
            this.cache.setTimeout(max_retransmit_time);
        }
    }

    @ManagedAttribute
    public int getAgeOutCacheSize() {
        return this.cache != null ? this.cache.size() : 0;
    }

    @ManagedOperation
    public String printAgeOutCache() {
        return this.cache != null ? this.cache.toString() : "n/a";
    }

    public AgeOutCache<Address> getAgeOutCache() {
        return this.cache;
    }

    @ManagedAttribute
    public int getNumberOfMessagesInReceiveWindows() {
        int num = 0;
        for (ReceiverEntry entry : this.recv_table.values()) {
            if (entry.received_msgs == null) continue;
            num += entry.received_msgs.size();
        }
        return num;
    }

    @ManagedOperation(description="Returns the sizes of all NakReceiverWindow.RetransmitTables")
    public String printRetransmitTableSizes() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry entry : this.recv_table.entrySet()) {
            NakReceiverWindow win = ((ReceiverEntry)entry.getValue()).received_msgs;
            sb.append(entry.getKey() + ": ").append(win.getRetransmitTableSize()).append(" (capacity=" + win.getRetransmitTableCapacity()).append(", fill factor=" + win.getRetransmitTableFillFactor() + "%)\n");
        }
        return sb.toString();
    }

    @ManagedOperation(description="Compacts the retransmission tables")
    public void compact() {
        for (Map.Entry entry : this.recv_table.entrySet()) {
            NakReceiverWindow win = ((ReceiverEntry)entry.getValue()).received_msgs;
            win.compact();
        }
    }

    @ManagedOperation(description="Purges highes delivered messages and compacts the retransmission tables")
    public void purgeAndCompact() {
        for (Map.Entry entry : this.recv_table.entrySet()) {
            NakReceiverWindow win = ((ReceiverEntry)entry.getValue()).received_msgs;
            win.stable(win.getHighestDelivered());
            win.compact();
        }
    }

    @Override
    public void resetStats() {
        this.num_xmits = 0L;
        this.num_bytes_received = 0L;
        this.num_bytes_sent = 0L;
        this.num_msgs_received = 0L;
        this.num_msgs_sent = 0L;
    }

    @Override
    public Map<String, Object> dumpStats() {
        Map<String, Object> m = super.dumpStats();
        m.put("num_msgs_sent", this.num_msgs_sent);
        m.put("num_msgs_received", this.num_msgs_received);
        m.put("num_bytes_sent", this.num_bytes_sent);
        m.put("num_bytes_received", this.num_bytes_received);
        m.put("num_xmits", this.num_xmits);
        m.put("num_msgs_in_recv_windows", this.getNumberOfMessagesInReceiveWindows());
        return m;
    }

    public TimeScheduler getTimer() {
        return this.timer;
    }

    public void setTimer(TimeScheduler timer) {
        this.timer = timer;
    }

    @Override
    public void init() throws Exception {
        super.init();
        if (this.max_stable_msgs < 1) {
            throw new IllegalArgumentException("max_stable_msgs ( " + this.max_stable_msgs + ") must be > 0");
        }
        if (this.max_bytes <= 0L) {
            throw new IllegalArgumentException("max_bytes has to be > 0");
        }
    }

    @Override
    public void start() throws Exception {
        this.timer = this.getTransport().getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        if (this.max_retransmit_time > 0L) {
            this.cache = new AgeOutCache(this.timer, this.max_retransmit_time, this);
        }
        this.started = true;
        if (this.stable_interval > 0L) {
            this.startStableTask();
        }
        if (this.conn_expiry_timeout > 0L) {
            this.startConnectionReaper();
        }
    }

    @Override
    public void stop() {
        this.started = false;
        this.stopStableTask();
        this.stopConnectionReaper();
        this.removeAllConnections();
    }

    @Override
    public Object up(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Unicast2Header hdr;
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || msg.isFlagSet(Message.NO_RELIABILITY) || (hdr = (Unicast2Header)msg.getHeader(this.id)) == null) break;
                Address src = msg.getSrc();
                switch (hdr.type) {
                    case 0: {
                        this.handleDataReceived(src, hdr.seqno, hdr.conn_id, hdr.first, msg, evt);
                        return null;
                    }
                    case 1: {
                        this.handleXmitRequest(src, hdr.seqno, hdr.high_seqno);
                        break;
                    }
                    case 2: {
                        this.handleResendingOfFirstMessage(src, hdr.seqno);
                        break;
                    }
                    case 3: {
                        this.stable(msg.getSrc(), hdr.conn_id, hdr.seqno, hdr.high_seqno);
                        break;
                    }
                    default: {
                        this.log.error("UnicastHeader type " + hdr.type + " not known !");
                    }
                }
                return null;
            }
        }
        return this.up_prot.up(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 1: {
                Unicast2Header hdr;
                Message msg = (Message)evt.getArg();
                Address dst = msg.getDest();
                if (dst == null || msg.isFlagSet(Message.NO_RELIABILITY)) break;
                if (!this.started) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("discarded message as start() has not yet been called, message: " + msg);
                    }
                    return null;
                }
                SenderEntry entry = (SenderEntry)this.send_table.get(dst);
                if (entry == null) {
                    entry = new SenderEntry(this.getNewConnectionId());
                    SenderEntry existing = this.send_table.putIfAbsent(dst, entry);
                    if (existing != null) {
                        entry = existing;
                    } else {
                        if (this.log.isTraceEnabled()) {
                            this.log.trace(this.local_addr + ": created connection to " + dst + " (conn_id=" + entry.send_conn_id + ")");
                        }
                        if (this.cache != null && !this.members.contains(dst)) {
                            this.cache.add(dst);
                        }
                    }
                }
                long seqno = -2L;
                short send_conn_id = -1;
                entry.lock();
                try {
                    seqno = entry.sent_msgs_seqno;
                    send_conn_id = entry.send_conn_id;
                    hdr = Unicast2Header.createDataHeader(seqno, send_conn_id, seqno == 1L);
                    msg.putHeader(this.id, hdr);
                    entry.sent_msgs.addToMessages(seqno, msg);
                    ++entry.sent_msgs_seqno;
                    entry.update();
                }
                finally {
                    entry.unlock();
                }
                if (this.log.isTraceEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(this.local_addr).append(" --> DATA(").append(dst).append(": #").append(seqno).append(", conn_id=").append(send_conn_id);
                    if (hdr.first) {
                        sb.append(", first");
                    }
                    sb.append(')');
                    this.log.trace(sb);
                }
                try {
                    this.down_prot.down(evt);
                    ++this.num_msgs_sent;
                    this.num_bytes_sent += (long)msg.getLength();
                }
                catch (Throwable t) {
                    this.log.warn("failed sending the message", t);
                }
                return null;
            }
            case 6: {
                View view = (View)evt.getArg();
                List<Address> new_members = view.getMembers();
                HashSet non_members = new HashSet(this.send_table.keySet());
                non_members.addAll(this.recv_table.keySet());
                List<Address> list = this.members;
                synchronized (list) {
                    this.members.clear();
                    if (new_members != null) {
                        this.members.addAll(new_members);
                    }
                    non_members.removeAll(this.members);
                    if (this.cache != null) {
                        this.cache.removeAll(this.members);
                    }
                }
                if (non_members.isEmpty()) break;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("removing non members " + non_members);
                }
                for (Address non_mbr : non_members) {
                    this.removeConnection(non_mbr);
                }
                break;
            }
            case 8: {
                this.local_addr = (Address)evt.getArg();
            }
        }
        return this.down_prot.down(evt);
    }

    protected void stable(Address sender, short conn_id, long highest_delivered, long highest_seen) {
        AckSenderWindow win;
        SenderEntry entry = (SenderEntry)this.send_table.get(sender);
        AckSenderWindow ackSenderWindow = win = entry != null ? entry.sent_msgs : null;
        if (win == null) {
            return;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder().append(this.local_addr).append(" <-- STABLE(").append(sender).append(": ").append(highest_delivered).append("-").append(highest_seen).append(", conn_id=" + conn_id) + ")");
        }
        if (entry.send_conn_id != conn_id) {
            this.log.warn(this.local_addr + ": my conn_id (" + entry.send_conn_id + ") != received conn_id (" + conn_id + "); discarding STABLE message !");
            return;
        }
        win.ack(highest_delivered);
        long win_high = win.getHighest();
        if (win_high > highest_seen) {
            for (long seqno = highest_seen; seqno <= win_high; ++seqno) {
                Message msg = win.get(seqno);
                if (msg == null) continue;
                this.down_prot.down(new Event(1, msg));
            }
        }
    }

    @ManagedOperation(description="Sends a STABLE message to all senders. This causes message purging and potential retransmissions from senders")
    public void sendStableMessages() {
        for (Map.Entry entry : this.recv_table.entrySet()) {
            Address dest = (Address)entry.getKey();
            ReceiverEntry val = (ReceiverEntry)entry.getValue();
            NakReceiverWindow win = val != null ? val.received_msgs : null;
            if (win == null) continue;
            long[] tmp = win.getDigest();
            long low = tmp[0];
            long high = tmp[1];
            if (val.last_highest == high) {
                if (val.num_stable_msgs >= val.max_stable_msgs) continue;
                val.num_stable_msgs++;
            } else {
                val.last_highest = high;
                val.num_stable_msgs = 1;
            }
            this.sendStableMessage(dest, val.recv_conn_id, low, high);
        }
    }

    protected void sendStableMessage(Address dest, short conn_id, long low, long high) {
        NakReceiverWindow win;
        Message stable_msg = new Message(dest, null, null);
        Unicast2Header hdr = Unicast2Header.createStableHeader(conn_id, low, high);
        stable_msg.putHeader(this.id, hdr);
        stable_msg.setFlag(Message.OOB);
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.local_addr).append(" --> STABLE(").append(dest).append(": ").append(low).append("-").append(high).append(", conn_id=").append(conn_id).append(")");
            this.log.trace(sb.toString());
        }
        this.down_prot.down(new Event(1, stable_msg));
        ReceiverEntry entry = (ReceiverEntry)this.recv_table.get(dest);
        NakReceiverWindow nakReceiverWindow = win = entry != null ? entry.received_msgs : null;
        if (win != null) {
            win.stable(win.getHighestDelivered());
        }
    }

    private void startStableTask() {
        if (this.stable_task_future == null || this.stable_task_future.isDone()) {
            Runnable stable_task = new Runnable(){

                @Override
                public void run() {
                    try {
                        UNICAST2.this.sendStableMessages();
                    }
                    catch (Throwable t) {
                        UNICAST2.this.log.error("sending of STABLE messages failed", t);
                    }
                }
            };
            this.stable_task_future = this.timer.scheduleWithFixedDelay(stable_task, this.stable_interval, this.stable_interval, TimeUnit.MILLISECONDS);
            if (this.log.isTraceEnabled()) {
                this.log.trace("stable task started");
            }
        }
    }

    private void stopStableTask() {
        if (this.stable_task_future != null) {
            this.stable_task_future.cancel(false);
            this.stable_task_future = null;
        }
    }

    protected synchronized void startConnectionReaper() {
        if (this.connection_reaper == null || this.connection_reaper.isDone()) {
            this.connection_reaper = this.timer.scheduleWithFixedDelay(new ConnectionReaper(), this.conn_expiry_timeout, this.conn_expiry_timeout, TimeUnit.MILLISECONDS);
        }
    }

    protected synchronized void stopConnectionReaper() {
        if (this.connection_reaper != null) {
            this.connection_reaper.cancel(false);
        }
    }

    public void removeConnection(Address mbr) {
        this.removeSendConnection(mbr);
        this.removeReceiveConnection(mbr);
    }

    public void removeSendConnection(Address mbr) {
        SenderEntry entry = (SenderEntry)this.send_table.remove(mbr);
        if (entry != null) {
            entry.reset();
        }
    }

    public void removeReceiveConnection(Address mbr) {
        ReceiverEntry entry2 = (ReceiverEntry)this.recv_table.remove(mbr);
        if (entry2 != null) {
            NakReceiverWindow win = entry2.received_msgs;
            if (win != null) {
                this.sendStableMessage(mbr, entry2.recv_conn_id, win.getHighestDelivered(), win.getHighestReceived());
            }
            entry2.reset();
        }
    }

    @ManagedOperation(description="Trashes all connections to other nodes. This is only used for testing")
    public void removeAllConnections() {
        for (SenderEntry entry : this.send_table.values()) {
            entry.reset();
        }
        this.send_table.clear();
        this.sendStableMessages();
        for (ReceiverEntry entry2 : this.recv_table.values()) {
            entry2.reset();
        }
        this.recv_table.clear();
    }

    @Override
    public void retransmit(long first_seqno, long last_seqno, Address sender) {
        if (last_seqno < first_seqno) {
            return;
        }
        Unicast2Header hdr = Unicast2Header.createXmitReqHeader(first_seqno, last_seqno);
        Message xmit_req = new Message(sender, null, null);
        xmit_req.putHeader(this.id, hdr);
        this.down_prot.down(new Event(1, xmit_req));
    }

    @Override
    public void expired(Address key) {
        if (key != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("removing connection to " + key + " because it expired");
            }
            this.removeConnection(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDataReceived(Address sender, long seqno, short conn_id, boolean first, Message msg, Event evt) {
        AtomicBoolean processing;
        int len;
        NakReceiverWindow win;
        ReceiverEntry entry;
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.local_addr).append(" <-- DATA(").append(sender).append(": #").append(seqno);
            if (conn_id != 0) {
                sb.append(", conn_id=").append(conn_id);
            }
            if (first) {
                sb.append(", first");
            }
            sb.append(')');
            this.log.trace(sb);
        }
        this.recv_table_lock.lock();
        try {
            entry = (ReceiverEntry)this.recv_table.get(sender);
            NakReceiverWindow nakReceiverWindow = win = entry != null ? entry.received_msgs : null;
            if (first) {
                if (entry == null) {
                    entry = this.getOrCreateReceiverEntry(sender, seqno, conn_id);
                    win = entry.received_msgs;
                } else if (conn_id != entry.recv_conn_id) {
                    ReceiverEntry entry2;
                    if (this.log.isTraceEnabled()) {
                        this.log.trace(this.local_addr + ": conn_id=" + conn_id + " != " + entry.recv_conn_id + "; resetting receiver window");
                    }
                    if ((entry2 = (ReceiverEntry)this.recv_table.remove(sender)) != null) {
                        entry2.received_msgs.destroy();
                    }
                    entry = this.getOrCreateReceiverEntry(sender, seqno, conn_id);
                    win = entry.received_msgs;
                }
            } else if (win == null || entry.recv_conn_id != conn_id) {
                this.recv_table_lock.unlock();
                this.sendRequestForFirstSeqno(sender, seqno);
                return;
            }
        }
        finally {
            if (this.recv_table_lock.isHeldByCurrentThread()) {
                this.recv_table_lock.unlock();
            }
        }
        entry.update();
        boolean added = win.add(seqno, msg);
        ++this.num_msgs_received;
        this.num_bytes_received += (long)msg.getLength();
        if (added && (len = msg.getLength()) > 0) {
            boolean send_stable_msg = false;
            entry.lock();
            try {
                entry.received_bytes += len;
                if ((long)entry.received_bytes >= this.max_bytes) {
                    entry.received_bytes = 0;
                    send_stable_msg = true;
                }
            }
            finally {
                entry.unlock();
            }
            if (send_stable_msg) {
                this.sendStableMessage(sender, entry.recv_conn_id, win.getHighestDelivered(), win.getHighestReceived());
            }
        }
        if (msg.isFlagSet(Message.OOB) && added) {
            try {
                this.up_prot.up(evt);
            }
            catch (Throwable t) {
                this.log.error("couldn't deliver OOB message " + msg, t);
            }
        }
        if (!(processing = win.getProcessing()).compareAndSet(false, true)) {
            return;
        }
        boolean released_processing = false;
        try {
            block14: while (true) {
                List<Message> msgs;
                if ((msgs = win.removeMany(processing, true, this.max_msg_batch_size)) == null || msgs.isEmpty()) {
                    released_processing = true;
                    return;
                }
                Iterator<Message> i$ = msgs.iterator();
                while (true) {
                    if (!i$.hasNext()) continue block14;
                    Message m = i$.next();
                    if (m.isFlagSet(Message.OOB)) continue;
                    try {
                        this.up_prot.up(new Event(1, m));
                    }
                    catch (Throwable t) {
                        this.log.error("couldn't deliver message " + m, t);
                    }
                }
                break;
            }
        }
        finally {
            if (!released_processing) {
                processing.set(false);
            }
        }
    }

    private ReceiverEntry getOrCreateReceiverEntry(Address sender, long seqno, short conn_id) {
        NakReceiverWindow win = new NakReceiverWindow(sender, this, seqno - 1L, this.timer, this.use_range_based_retransmitter, this.xmit_table_num_rows, this.xmit_table_msgs_per_row, this.xmit_table_resize_factor, this.xmit_table_max_compaction_time, this.xmit_table_automatic_purging);
        if (this.exponential_backoff > 0) {
            win.setRetransmitTimeouts(new ExponentialInterval(this.exponential_backoff));
        } else {
            win.setRetransmitTimeouts(new StaticInterval(this.timeout));
        }
        ReceiverEntry entry = new ReceiverEntry(win, conn_id, this.max_stable_msgs);
        ReceiverEntry entry2 = this.recv_table.putIfAbsent(sender, entry);
        if (entry2 != null) {
            return entry2;
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + ": created receiver window for " + sender + " at seqno=#" + seqno + " for conn-id=" + conn_id);
        }
        return entry;
    }

    private void handleXmitRequest(Address sender, long low, long high) {
        SenderEntry entry;
        AckSenderWindow win;
        if (this.log.isTraceEnabled()) {
            this.log.trace(new StringBuilder().append(this.local_addr).append(" <-- XMIT(").append(sender).append(": #").append(low).append("-").append(high).append(')'));
        }
        AckSenderWindow ackSenderWindow = win = (entry = (SenderEntry)this.send_table.get(sender)) != null ? entry.sent_msgs : null;
        if (win != null) {
            for (long i = low; i <= high; ++i) {
                Message msg = win.get(i);
                if (msg == null) {
                    if (!this.log.isWarnEnabled() || this.local_addr.equals(sender)) continue;
                    StringBuilder sb = new StringBuilder();
                    sb.append("(requester=").append(sender).append(", local_addr=").append(this.local_addr);
                    sb.append(") message ").append(sender).append("::").append(i);
                    sb.append(" not found in retransmission table of ").append(sender).append(":\n").append(win);
                    this.log.warn(sb.toString());
                    continue;
                }
                this.down_prot.down(new Event(1, msg));
                ++this.num_xmits;
            }
        }
    }

    private void handleResendingOfFirstMessage(Address sender, long seqno) {
        SenderEntry entry;
        AckSenderWindow win;
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + " <-- SEND_FIRST_SEQNO(" + sender + "," + seqno + ")");
        }
        AckSenderWindow ackSenderWindow = win = (entry = (SenderEntry)this.send_table.get(sender)) != null ? entry.sent_msgs : null;
        if (win == null) {
            if (this.log.isErrorEnabled()) {
                this.log.error(this.local_addr + ": sender window for " + sender + " not found");
            }
            return;
        }
        long lowest = win.getLowest();
        Message rsp = win.get(lowest);
        if (rsp == null) {
            return;
        }
        Message copy = rsp.copy();
        Unicast2Header hdr = (Unicast2Header)copy.getHeader(this.id);
        Unicast2Header newhdr = hdr.copy();
        newhdr.first = true;
        copy.putHeader(this.id, newhdr);
        if (this.log.isTraceEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.local_addr).append(" --> DATA(").append(copy.getDest()).append(": #").append(newhdr.seqno).append(", conn_id=").append(newhdr.conn_id);
            if (newhdr.first) {
                sb.append(", first");
            }
            sb.append(')');
            this.log.trace(sb);
        }
        this.down_prot.down(new Event(1, copy));
        if (++lowest > seqno) {
            return;
        }
        for (long i = lowest; i <= seqno; ++i) {
            rsp = win.get(i);
            if (rsp == null) continue;
            this.down_prot.down(new Event(1, rsp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short getNewConnectionId() {
        UNICAST2 uNICAST2 = this;
        synchronized (uNICAST2) {
            short retval = this.last_conn_id;
            this.last_conn_id = this.last_conn_id >= Short.MAX_VALUE || this.last_conn_id < 0 ? (short)0 : (short)(this.last_conn_id + 1);
            return retval;
        }
    }

    private void sendRequestForFirstSeqno(Address dest, long seqno_received) {
        Message msg = new Message(dest);
        msg.setFlag(Message.OOB);
        Unicast2Header hdr = Unicast2Header.createSendFirstSeqnoHeader(seqno_received);
        msg.putHeader(this.id, hdr);
        if (this.log.isTraceEnabled()) {
            this.log.trace(this.local_addr + " --> SEND_FIRST_SEQNO(" + dest + "," + seqno_received + ")");
        }
        this.down_prot.down(new Event(1, msg));
    }

    @ManagedOperation(description="Closes connections that have been idle for more than conn_expiry_timeout ms")
    public void reapIdleConnections() {
        long age;
        Object val;
        for (Map.Entry entry : this.send_table.entrySet()) {
            val = (SenderEntry)entry.getValue();
            age = ((SenderEntry)val).age();
            if (age < this.conn_expiry_timeout) continue;
            this.removeSendConnection((Address)entry.getKey());
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug(this.local_addr + ": removed expired connection for " + entry.getKey() + " (" + age + " ms old) from send_table");
        }
        for (Map.Entry entry : this.recv_table.entrySet()) {
            val = (ReceiverEntry)entry.getValue();
            age = ((ReceiverEntry)val).age();
            if (age < this.conn_expiry_timeout) continue;
            this.removeReceiveConnection((Address)entry.getKey());
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug(this.local_addr + ": removed expired connection for " + entry.getKey() + " (" + age + " ms old) from recv_table");
        }
    }

    protected class ConnectionReaper
    implements Runnable {
        protected ConnectionReaper() {
        }

        @Override
        public void run() {
            UNICAST2.this.reapIdleConnections();
        }
    }

    private static final class ReceiverEntry {
        private final NakReceiverWindow received_msgs;
        private final short recv_conn_id;
        private int received_bytes = 0;
        private long timestamp;
        private final Lock lock = new ReentrantLock();
        private long last_highest = -1L;
        private int num_stable_msgs = 0;
        public final int max_stable_msgs;

        public ReceiverEntry(NakReceiverWindow received_msgs, short recv_conn_id, int max_stable_msgs) {
            this.received_msgs = received_msgs;
            this.recv_conn_id = recv_conn_id;
            this.max_stable_msgs = max_stable_msgs;
            this.update();
        }

        void lock() {
            this.lock.lock();
        }

        void unlock() {
            this.lock.unlock();
        }

        void reset() {
            if (this.received_msgs != null) {
                this.received_msgs.destroy();
            }
            this.received_bytes = 0;
            this.last_highest = -1L;
            this.num_stable_msgs = 0;
        }

        void update() {
            this.timestamp = System.currentTimeMillis();
        }

        long age() {
            return System.currentTimeMillis() - this.timestamp;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.received_msgs != null) {
                sb.append(this.received_msgs).append(", ");
            }
            sb.append("recv_conn_id=" + this.recv_conn_id);
            sb.append(" (" + this.age() + " ms old)");
            return sb.toString();
        }
    }

    private static final class SenderEntry {
        final AckSenderWindow sent_msgs;
        long sent_msgs_seqno = 1L;
        final short send_conn_id;
        private long timestamp;
        final Lock lock = new ReentrantLock();

        public SenderEntry(short send_conn_id) {
            this.send_conn_id = send_conn_id;
            this.sent_msgs = new AckSenderWindow();
            this.update();
        }

        void lock() {
            this.lock.lock();
        }

        void unlock() {
            this.lock.unlock();
        }

        void reset() {
            if (this.sent_msgs != null) {
                this.sent_msgs.reset();
            }
            this.sent_msgs_seqno = 1L;
        }

        void update() {
            this.timestamp = System.currentTimeMillis();
        }

        long age() {
            return System.currentTimeMillis() - this.timestamp;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.sent_msgs != null) {
                sb.append(this.sent_msgs).append(", ");
            }
            sb.append("send_conn_id=" + this.send_conn_id);
            sb.append(" (" + this.age() + " ms old)");
            return sb.toString();
        }
    }

    public static class Unicast2Header
    extends Header {
        public static final byte DATA = 0;
        public static final byte XMIT_REQ = 1;
        public static final byte SEND_FIRST_SEQNO = 2;
        public static final byte STABLE = 3;
        byte type;
        long seqno;
        long high_seqno;
        short conn_id;
        boolean first;

        public Unicast2Header() {
        }

        public static Unicast2Header createDataHeader(long seqno, short conn_id, boolean first) {
            return new Unicast2Header(0, seqno, 0L, conn_id, first);
        }

        public static Unicast2Header createXmitReqHeader(long low, long high) {
            if (low > high) {
                throw new IllegalArgumentException("low (" + low + " needs to be <= high (" + high + ")");
            }
            Unicast2Header retval = new Unicast2Header(1, low);
            retval.high_seqno = high;
            return retval;
        }

        public static Unicast2Header createStableHeader(short conn_id, long low, long high) {
            if (low > high) {
                throw new IllegalArgumentException("low (" + low + ") needs to be <= high (" + high + ")");
            }
            Unicast2Header retval = new Unicast2Header(3, low);
            retval.high_seqno = high;
            retval.conn_id = conn_id;
            return retval;
        }

        public static Unicast2Header createSendFirstSeqnoHeader(long seqno_received) {
            return new Unicast2Header(2, seqno_received);
        }

        private Unicast2Header(byte type, long seqno) {
            this.type = type;
            this.seqno = seqno;
        }

        private Unicast2Header(byte type, long seqno, long high, short conn_id, boolean first) {
            this.type = type;
            this.seqno = seqno;
            this.high_seqno = high;
            this.conn_id = conn_id;
            this.first = first;
        }

        public byte getType() {
            return this.type;
        }

        public long getSeqno() {
            return this.seqno;
        }

        public long getHighSeqno() {
            return this.high_seqno;
        }

        public short getConnId() {
            return this.conn_id;
        }

        public boolean isFirst() {
            return this.first;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(Unicast2Header.type2Str(this.type)).append(", seqno=").append(this.seqno);
            if (this.conn_id != 0) {
                sb.append(", conn_id=").append(this.conn_id);
            }
            if (this.first) {
                sb.append(", first");
            }
            return sb.toString();
        }

        public static String type2Str(byte t) {
            switch (t) {
                case 0: {
                    return "DATA";
                }
                case 1: {
                    return "XMIT_REQ";
                }
                case 2: {
                    return "SEND_FIRST_SEQNO";
                }
                case 3: {
                    return "STABLE";
                }
            }
            return "<unknown>";
        }

        @Override
        public final int size() {
            int retval = 1;
            switch (this.type) {
                case 0: {
                    retval += Util.size(this.seqno) + 2 + 1;
                    break;
                }
                case 1: {
                    retval += Util.size(this.seqno, this.high_seqno);
                    break;
                }
                case 3: {
                    retval += Util.size(this.seqno, this.high_seqno) + 2;
                    break;
                }
                case 2: {
                    retval += Util.size(this.seqno);
                }
            }
            return retval;
        }

        public Unicast2Header copy() {
            return new Unicast2Header(this.type, this.seqno, this.high_seqno, this.conn_id, this.first);
        }

        @Override
        public void writeTo(DataOutput out) throws Exception {
            out.writeByte(this.type);
            switch (this.type) {
                case 0: {
                    Util.writeLong(this.seqno, out);
                    out.writeShort(this.conn_id);
                    out.writeBoolean(this.first);
                    break;
                }
                case 1: {
                    Util.writeLongSequence(this.seqno, this.high_seqno, out);
                    break;
                }
                case 3: {
                    Util.writeLongSequence(this.seqno, this.high_seqno, out);
                    out.writeShort(this.conn_id);
                    break;
                }
                case 2: {
                    Util.writeLong(this.seqno, out);
                }
            }
        }

        @Override
        public void readFrom(DataInput in) throws Exception {
            this.type = in.readByte();
            switch (this.type) {
                case 0: {
                    this.seqno = Util.readLong(in);
                    this.conn_id = in.readShort();
                    this.first = in.readBoolean();
                    break;
                }
                case 1: {
                    long[] seqnos = Util.readLongSequence(in);
                    this.seqno = seqnos[0];
                    this.high_seqno = seqnos[1];
                    break;
                }
                case 3: {
                    long[] seqnos = Util.readLongSequence(in);
                    this.seqno = seqnos[0];
                    this.high_seqno = seqnos[1];
                    this.conn_id = in.readShort();
                    break;
                }
                case 2: {
                    this.seqno = Util.readLong(in);
                }
            }
        }
    }
}

