/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.properties;

import com.jaspersoft.jasperserver.crypto.EncryptionEngine;
import com.jaspersoft.jasperserver.crypto.KeystoreManager;
import java.security.Key;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class DecryptingPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer {
    private static final Map<String, String> springImportedProperties = new Hashtable<String, String>();

    protected void convertProperties(Properties properties) {
        super.convertProperties(properties);
        for (Object propKey : properties.keySet()) {
            springImportedProperties.put(propKey.toString(), properties.getProperty(propKey.toString()));
        }
    }

    protected String convertPropertyValue(String originalValue) {
        if (EncryptionEngine.isEncrypted((String)(originalValue = originalValue.trim()))) {
            KeystoreManager ksManager = KeystoreManager.getInstance();
            originalValue = EncryptionEngine.decrypt((Key)ksManager.getBuildKey(), (String)originalValue);
        }
        return originalValue;
    }

    public static Map<String, String> getSpringImportedProperties() {
        return Collections.unmodifiableMap(springImportedProperties);
    }
}

