/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.properties;

import com.jaspersoft.jasperserver.api.common.properties.PropertiesManagementService;
import com.jaspersoft.jasperserver.api.common.properties.PropertyChanger;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValues;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ListOfValuesItem;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FolderImpl;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.ListOfValuesItemImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;

public class PropertiesManagementServiceImpl
implements PropertiesManagementService,
ApplicationContextAware,
ApplicationListener<ContextRefreshedEvent> {
    protected static final Log log = LogFactory.getLog(PropertiesManagementServiceImpl.class);
    public static final String CONTENT_FOLDER = "properties";
    public static final String CONTENT_FOLDER_DESC = "System Properties";
    public static final String RESOURCE_NAME = "GlobalPropertiesList";
    public static final String RESOURCE_FULL_NAME = "/properties/GlobalPropertiesList";
    protected ApplicationContext context;
    protected Map<String, String> changers;
    protected Map<String, PropertyChanger> changerObjects;
    protected Map<String, String> mov;
    protected Map<String, String> previousMov;
    protected RepositoryService mRepository;

    public void initialize() {
        log.info((Object)"Initializing porperty management service");
        this.parseChangers();
        this.loadProperties();
        this.applyProperties();
    }

    public void setProperty(String key, String val) {
        log.debug((Object)("property " + key + " is going to be set to " + val));
        this.mov.put(key, val);
        this.saveProperties();
    }

    protected PropertyChanger getChanger(String key) {
        if (key.isEmpty()) {
            return null;
        }
        int semicolonPos = key.indexOf(":") > 0 ? key.indexOf(":") : Integer.MAX_VALUE;
        int pointPos = key.indexOf(".") > 0 ? key.indexOf(".") : Integer.MAX_VALUE;
        int changerKeyLength = Math.min(key.length(), Math.min(semicolonPos, pointPos));
        String changerKey = key.substring(0, changerKeyLength);
        return this.changerObjects.get(changerKey);
    }

    protected void applyProperty(String key, String val) {
        log.debug((Object)("Applying configuration property " + key + " = " + val));
        PropertyChanger changer = null;
        try {
            changer = this.getChanger(key);
            if (changer == null) {
                log.error((Object)("PropertyChanger not found for property " + key));
            } else {
                changer.setProperty(key, val);
            }
        }
        catch (Exception e) {
            log.error((Object)("PropertyChanger " + changer + " failed to apply configuration property " + key + " = " + val), (Throwable)e);
        }
    }

    protected void removeProperty(String key, String val) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Removing configuration property " + key + " = " + val));
        }
        try {
            this.getChanger(key).removeProperty(key, val);
        }
        catch (Exception e) {
            log.error((Object)("PropertyChanger " + this.getChanger(key) + "failed to remove configuration property " + key + " = " + val), (Throwable)e);
        }
    }

    public String getProperty(String key) {
        try {
            String val = this.getChanger(key).getProperty(key);
            log.debug((Object)("Read configuration property " + key + " = " + val));
            return val;
        }
        catch (Exception e) {
            log.error((Object)("PropertyChanger " + this.getChanger(key) + "failed to read configuration property " + key));
            return null;
        }
    }

    protected void loadProperties() {
        log.info((Object)"Loading configuration properties from /properties/GlobalPropertiesList");
        RepositoryService rep = this.getRepository();
        ListOfValues lov = (ListOfValues)rep.getResource(null, RESOURCE_FULL_NAME);
        if (lov == null) {
            log.debug((Object)"/properties/GlobalPropertiesList not found, creating it");
            lov = (ListOfValues)rep.newResource(null, ListOfValues.class);
            lov.setName(RESOURCE_NAME);
            lov.setLabel(RESOURCE_NAME);
            lov.setDescription(RESOURCE_NAME);
            Folder folder = rep.getFolder(null, "/properties");
            if (folder == null) {
                log.debug((Object)"/properties not found, creating it");
                folder = new FolderImpl();
                folder.setName(CONTENT_FOLDER);
                folder.setLabel(CONTENT_FOLDER_DESC);
                folder.setDescription(CONTENT_FOLDER_DESC);
                folder.setParentFolder(rep.getFolder(null, "/"));
                rep.saveFolder(null, folder);
            }
            lov.setParentFolder(folder);
            rep.saveResource(null, (Resource)lov);
        }
        if (this.mov != null) {
            this.previousMov = Collections.unmodifiableMap(new HashMap<String, String>(this.mov));
        }
        this.mov = new HashMap<String, String>();
        for (ListOfValuesItem i : lov.getValues()) {
            this.mov.put(i.getLabel(), (String)i.getValue());
        }
    }

    public void saveProperties() {
        log.info((Object)"Saving configuration properties to /properties/GlobalPropertiesList");
        RepositoryService rep = this.getRepository();
        ListOfValues lov = (ListOfValues)rep.getResource(null, RESOURCE_FULL_NAME);
        ListOfValuesItem[] oldItems = lov.getValues();
        for (int i = 0; i < oldItems.length; ++i) {
            lov.removeValue(oldItems[i]);
        }
        for (Map.Entry<String, String> e : this.mov.entrySet()) {
            ListOfValuesItemImpl i = new ListOfValuesItemImpl();
            i.setLabel(e.getKey());
            i.setValue((Object)e.getValue());
            lov.addValue((ListOfValuesItem)i);
        }
        rep.saveResource(null, (Resource)lov);
    }

    public void applyProperties() {
        log.info((Object)"Appling all configuration properties");
        for (Map.Entry<String, String> e : this.mov.entrySet()) {
            this.applyProperty(e.getKey(), e.getValue());
        }
    }

    public void removeProperties() {
        log.debug((Object)"Removing deleted configuration properties");
        if (this.previousMov != null) {
            for (Map.Entry<String, String> e : this.previousMov.entrySet()) {
                if (this.mov.containsKey(e.getKey())) continue;
                this.removeProperty(e.getKey(), e.getValue());
            }
            this.previousMov = null;
        }
    }

    public int size() {
        return this.mov.size();
    }

    public Set entrySet() {
        return this.mov.entrySet();
    }

    public String remove(String key) {
        return this.mov.remove(key);
    }

    public Map<String, String> removeByValue(String val) {
        HashMap<String, String> removedKeys = new HashMap<String, String>();
        if (this.mov != null) {
            Iterator<Map.Entry<String, String>> it = this.mov.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, String> entry = it.next();
                if (!entry.getValue().equals(val)) continue;
                removedKeys.put(entry.getKey(), entry.getValue());
                it.remove();
            }
            if (removedKeys.size() > 0) {
                this.saveProperties();
                for (Map.Entry entry : removedKeys.entrySet()) {
                    this.getChanger((String)entry.getKey()).removeProperty((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        return removedKeys;
    }

    private RepositoryService getRepository() {
        return this.mRepository;
    }

    public void setRepository(RepositoryService repository) {
        this.mRepository = repository;
    }

    public Map<String, String> getChangers() {
        return this.changers;
    }

    public void setChangers(Map<String, String> changers) {
        this.changers = changers;
        if (this.changerObjects != null) {
            this.parseChangers();
        }
    }

    private void parseChangers() {
        log.debug((Object)"Collecting all changers from Spring context");
        this.changerObjects = new HashMap<String, PropertyChanger>();
        for (Map.Entry<String, String> e : this.changers.entrySet()) {
            this.changerObjects.put(e.getKey(), (PropertyChanger)this.context.getBean(e.getValue()));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public void reloadProperties() {
        this.loadProperties();
        this.removeProperties();
        this.applyProperties();
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        log.debug((Object)("Service got a ContextRefreshedEvent " + event));
        if (this.changerObjects == null) {
            this.fixFolderParentBug();
            this.initialize();
        }
    }

    private void fixFolderParentBug() {
        RepositoryService rep = this.getRepository();
        Folder folder = rep.getFolder(null, "/properties");
        if (folder != null && folder.getParentFolder() == null) {
            Folder parent = rep.getFolder(null, "/");
            if (parent != null) {
                folder.setParentFolder(parent);
                rep.saveFolder(null, folder);
                log.info((Object)"Property folder has been assigned as a child of the root folder");
            } else {
                log.error((Object)"Root folder does not exist");
            }
        }
    }
}

