/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.service.impl;

import com.jaspersoft.jasperserver.api.common.domain.ExecutionContext;
import com.jaspersoft.jasperserver.api.common.domain.impl.ExecutionContextImpl;
import com.jaspersoft.jasperserver.api.common.properties.PropertiesManagementService;
import com.jaspersoft.jasperserver.api.common.properties.PropertiesManagementServiceImpl;
import com.jaspersoft.jasperserver.api.common.service.JdbcDriverService;
import com.jaspersoft.jasperserver.api.common.util.JdbcDriverShim;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.FileResourceData;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Folder;
import com.jaspersoft.jasperserver.api.metadata.common.domain.Resource;
import com.jaspersoft.jasperserver.api.metadata.common.domain.ResourceLookup;
import com.jaspersoft.jasperserver.api.metadata.common.domain.client.FileResourceImpl;
import com.jaspersoft.jasperserver.api.metadata.common.service.RepositoryService;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterCriteria;
import com.jaspersoft.jasperserver.api.metadata.view.domain.FilterElement;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public class JdbcDriverServiceImpl
implements JdbcDriverService,
ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    public static final String DEFAULT_JDBC_REPO_FOLDER = "/jdbc";
    public static final String DEFAULT_JDBC_TEMP_FOLDER = System.getProperty("java.io.tmpdir");
    public static final String URL_CLASSLOADER_FORMAT = "jar:file:%s!/";
    public static final String TEMP_FILE_PATH_FORMAT = "%s/jdbc-%s-%s.jar";
    public static final String SYSTEM_PROPERTIES_LIST_KEY_PREFIX = "jdbc:";
    public static final String SYSTEM_PROPERTIES_LIST_KEY_FORMAT = "jdbc:%s";
    public static final String SYSTEM_PROPERTIES_PRESERVED_KEY_SUFFIX = "_backup";
    public static final String SYSTEM_CLASSLOADER_PATH = "[SYSTEM]";
    private Map<String, Driver> driverClassToDriverMap = new HashMap<String, Driver>();
    private Map<Driver, ClassLoader> driverToClassLoaderMap = new HashMap<Driver, ClassLoader>();
    private Map<ClassLoader, String> classLoaderToUrlMap = new HashMap<ClassLoader, String>();
    private Map<String, String> driverClassToUrlMap = new HashMap<String, String>();
    private RepositoryService repository;
    private PropertiesManagementService propertiesManagementService;
    private ApplicationContext applicationContext;
    private String jdbcDriversFolder = "/jdbc";
    private Boolean systemClassLoaderFirst = false;

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public void setSystemClassLoaderFirst(Boolean systemClassLoaderFirst) {
        this.systemClassLoaderFirst = systemClassLoaderFirst;
    }

    public void setJdbcDriversFolder(String jdbcDriversFolder) {
        this.jdbcDriversFolder = jdbcDriversFolder;
    }

    @Override
    public String getJdbcDriversFolder() {
        return this.jdbcDriversFolder;
    }

    @Override
    public synchronized void register(String driverClass) throws Exception {
        if (this.driverClassToDriverMap.containsKey(driverClass)) {
            return;
        }
        this.loadDriverFromExistingClassLoaders(driverClass);
    }

    @Override
    public synchronized boolean isRegistered(String driverClass) {
        boolean registered = true;
        try {
            this.register(driverClass);
        }
        catch (Exception e) {
            registered = false;
        }
        return registered;
    }

    @Override
    public synchronized void setDriverMappings(Map<String, String> driverMappings) throws Exception {
        for (Map.Entry<String, String> entry : driverMappings.entrySet()) {
            this.setDriverMapping(entry.getKey(), entry.getValue());
        }
        HashSet<String> values = new HashSet<String>(this.classLoaderToUrlMap.values());
        for (String path : values) {
            if (driverMappings.values().contains(path)) continue;
            this.unRegisterByUrl(path);
        }
    }

    @Override
    public synchronized void setDriverMapping(String driverClass, String path) throws Exception {
        if (driverClass == null) {
            throw new IllegalArgumentException("Driver class could not be null");
        }
        if (driverClass.endsWith(SYSTEM_PROPERTIES_PRESERVED_KEY_SUFFIX)) {
            return;
        }
        String registeredUrl = this.getUrlByDriverClassName(driverClass);
        if (!path.equals(registeredUrl)) {
            this.unRegisterByUrl(registeredUrl);
            this.driverClassToUrlMap.put(driverClass, path);
            this.loadJdbcDriverFromRepository(path);
        }
    }

    @Override
    public synchronized void removeDriverMapping(String driverClass) throws Exception {
        if (driverClass == null) {
            throw new IllegalArgumentException("Driver class could not be null");
        }
        if (driverClass.endsWith(SYSTEM_PROPERTIES_PRESERVED_KEY_SUFFIX)) {
            return;
        }
        String registeredUrl = this.getUrlByDriverClassName(driverClass);
        if (registeredUrl != null) {
            if (SYSTEM_CLASSLOADER_PATH.equals(registeredUrl)) {
                this.unRegisterByClassName(driverClass);
            } else {
                this.unRegisterByUrl(registeredUrl);
                this.driverClassToUrlMap.remove(driverClass);
            }
        }
    }

    @Override
    public Map<String, String> getDriverMappings() {
        return Collections.unmodifiableMap(this.driverClassToUrlMap);
    }

    @Override
    public Set<String> getRegisteredDriverClassNames() {
        HashSet<String> driverNames = new HashSet<String>(this.driverClassToUrlMap.size());
        for (String className : this.driverClassToUrlMap.keySet()) {
            if (!this.isRegistered(className)) continue;
            driverNames.add(className);
        }
        return driverNames;
    }

    private ClassLoader getClassLoaderAndVerifyDriverClassName(String driverClassName, String path) throws Exception {
        List<FileResource> driverResources = this.findJdbcDriversInRepo(path);
        if (driverResources.isEmpty()) {
            throw new IllegalStateException("No drivers found in folder");
        }
        ArrayList<String> pathToDriverFile = new ArrayList<String>(driverResources.size());
        for (FileResource driverResource : driverResources) {
            pathToDriverFile.add(this.copyJdbcDriverToTempFolder(driverResource));
        }
        ClassLoader classLoader = this.getClassLoader(pathToDriverFile.toArray(new String[pathToDriverFile.size()]));
        Class.forName(driverClassName, true, classLoader);
        return classLoader;
    }

    @Override
    public synchronized void setDriverMappingAndRegister(String driverClass, String path) throws Exception {
        ClassLoader classLoader = this.getClassLoaderAndVerifyDriverClassName(driverClass, path);
        String registeredUrl = this.getUrlByDriverClassName(driverClass);
        if (SYSTEM_CLASSLOADER_PATH.equals(registeredUrl)) {
            this.unRegisterByClassName(driverClass);
        } else {
            this.unRegisterByUrl(registeredUrl);
        }
        this.driverClassToUrlMap.put(driverClass, path);
        this.classLoaderToUrlMap.put(classLoader, path);
        this.register(driverClass);
        if (this.getPropertiesManagementService() != null) {
            String driverNameKey = String.format(SYSTEM_PROPERTIES_LIST_KEY_FORMAT, driverClass);
            this.getPropertiesManagementService().setProperty(driverNameKey, path);
        }
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRED)
    public void setDriver(String driverClassName, Map<String, byte[]> driverFiles) throws Exception {
        ClassLoader classLoader = this.getClassLoader(driverFiles);
        this.verifyDriverClass(driverClassName, classLoader);
        String concreteDriverFolderUri = this.saveDriverFiles(driverClassName, driverFiles);
        String registeredUrl = this.getUrlByDriverClassName(driverClassName);
        if (SYSTEM_CLASSLOADER_PATH.equals(registeredUrl)) {
            this.unRegisterByClassName(driverClassName);
        } else {
            this.unRegisterByUrl(registeredUrl);
        }
        this.driverClassToUrlMap.put(driverClassName, concreteDriverFolderUri);
        this.classLoaderToUrlMap.put(classLoader, concreteDriverFolderUri);
        try {
            this.register(driverClassName);
        }
        catch (NoClassDefFoundError e) {
            this.driverClassToUrlMap.remove(driverClassName);
            this.classLoaderToUrlMap.remove(classLoader);
            throw e;
        }
        if (this.getPropertiesManagementService() != null) {
            String driverNameKey = String.format(SYSTEM_PROPERTIES_LIST_KEY_FORMAT, driverClassName);
            this.getPropertiesManagementService().setProperty(driverNameKey, concreteDriverFolderUri);
        }
    }

    private ClassLoader getClassLoader(Map<String, byte[]> driverFilesData) throws Exception {
        HashSet<String> tempFilesPathName = new HashSet<String>();
        for (byte[] driverFileData : driverFilesData.values()) {
            tempFilesPathName.add(this.createTempFile(driverFileData));
        }
        ClassLoader classLoader = this.getClassLoader(tempFilesPathName.toArray(new String[tempFilesPathName.size()]));
        return classLoader;
    }

    void verifyDriverClass(String driverClassName, ClassLoader classLoader) throws ClassNotFoundException {
        Class.forName(driverClassName, true, classLoader);
    }

    private String saveDriverFiles(String driverClassName, Map<String, byte[]> driverFilesData) {
        ExecutionContext exContext = ExecutionContextImpl.getRuntimeExecutionContext();
        String concreteDriverFolderUri = this.checkFoldersForDriver(exContext, driverClassName);
        Set<FileResource> jarFileResources = this.createJarFileResources(concreteDriverFolderUri, driverFilesData);
        this.saveResourceList(exContext, jarFileResources);
        return concreteDriverFolderUri.substring(this.jdbcDriversFolder.length() + 1);
    }

    private void saveResourceList(ExecutionContext exContext, Set<FileResource> fileResources) {
        for (FileResource fileResource : fileResources) {
            this.repository.saveResource(exContext, (Resource)fileResource);
        }
    }

    private Set<FileResource> createJarFileResources(String parentUri, Map<String, byte[]> driverFilesData) {
        HashSet<FileResource> fileResources = new HashSet<FileResource>();
        for (Map.Entry<String, byte[]> entry : driverFilesData.entrySet()) {
            fileResources.add(this.createJarFileResource(parentUri, entry.getKey(), entry.getValue()));
        }
        return fileResources;
    }

    private FileResource createJarFileResource(String parentUri, String originalFileName, byte[] fileData) {
        FileResourceImpl result = new FileResourceImpl();
        result.setFileType("jar");
        result.setData(fileData);
        result.setName(originalFileName);
        result.setLabel(originalFileName);
        result.setParentFolder(parentUri);
        return result;
    }

    private String checkFoldersForDriver(ExecutionContext exContext, String driverClassName) {
        this.checkJdbcFolder(exContext);
        return this.checkConcreteDriverFolder(exContext, driverClassName);
    }

    private void checkJdbcFolder(ExecutionContext exContext) {
        if (!this.repository.folderExists(exContext, this.jdbcDriversFolder)) {
            Folder folder = (Folder)this.repository.newResource(exContext, Folder.class);
            String[] pathAndName = this.getNameFromPath(this.jdbcDriversFolder);
            folder.setName(pathAndName[1]);
            folder.setLabel(pathAndName[1]);
            folder.setParentFolder(pathAndName[0]);
            this.repository.saveFolder(exContext, folder);
        }
    }

    private String checkConcreteDriverFolder(ExecutionContext exContext, String driverClassName) {
        String concreteDriverFolderResourceName = driverClassName.replaceAll("\\W", "_");
        String concreteDriverFolderUri = this.jdbcDriversFolder + "/" + concreteDriverFolderResourceName;
        if (!this.repository.folderExists(exContext, concreteDriverFolderUri)) {
            Folder folder = (Folder)this.repository.newResource(exContext, Folder.class);
            folder.setName(concreteDriverFolderResourceName);
            folder.setLabel(driverClassName);
            folder.setParentFolder(this.jdbcDriversFolder);
            this.repository.saveFolder(exContext, folder);
        } else {
            Folder bakFolder = (Folder)this.repository.newResource(exContext, Folder.class);
            long currentTimeMillis = System.currentTimeMillis();
            String resourceNameSuffix = "_" + String.valueOf(currentTimeMillis);
            String labelSuffix = " " + new SimpleDateFormat().format(currentTimeMillis);
            String bakResourceName = concreteDriverFolderResourceName + resourceNameSuffix;
            bakFolder.setName(bakResourceName);
            bakFolder.setLabel(driverClassName + labelSuffix);
            bakFolder.setParentFolder(this.jdbcDriversFolder);
            this.repository.saveFolder(exContext, bakFolder);
            FilterCriteria criteria = FilterCriteria.createFilter(Resource.class);
            criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)concreteDriverFolderUri));
            String bakConcreteDriverFolderUri = this.jdbcDriversFolder + "/" + bakResourceName;
            List resources = this.repository.loadResourcesList(exContext, criteria);
            for (ResourceLookup resourceLookup : resources) {
                this.repository.moveResource(exContext, resourceLookup.getURIString(), bakConcreteDriverFolderUri);
            }
        }
        return concreteDriverFolderUri;
    }

    private String[] getNameFromPath(String path) {
        Matcher m = Pattern.compile("(.*/)(.+)").matcher(path);
        String[] pathAndName = null;
        if (m.matches()) {
            pathAndName = new String[]{m.group(1), m.group(2)};
        }
        return pathAndName;
    }

    private String getUrlByDriverClassName(String driverClassName) {
        return this.driverClassToUrlMap.get(driverClassName);
    }

    private ClassLoader getClassLoaderByClassName(String driverClassName) {
        String url = this.driverClassToUrlMap.get(driverClassName);
        if (url != null && !SYSTEM_CLASSLOADER_PATH.equals(url)) {
            for (Map.Entry<ClassLoader, String> entry : this.classLoaderToUrlMap.entrySet()) {
                if (!entry.getValue().equals(url)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private List<ClassLoader> getAllNonSystemClassLoaders() {
        ArrayList<ClassLoader> classLoaders = new ArrayList<ClassLoader>(this.classLoaderToUrlMap.size());
        for (Map.Entry<ClassLoader, String> entry : this.classLoaderToUrlMap.entrySet()) {
            if (entry.getValue().equals(SYSTEM_CLASSLOADER_PATH)) continue;
            classLoaders.add(entry.getKey());
        }
        return classLoaders;
    }

    private void unRegisterByClassName(String className) throws Exception {
        if (className == null) {
            return;
        }
        Driver driver = this.driverClassToDriverMap.get(className);
        if (driver != null) {
            this.unRegisterDriver(driver);
        }
    }

    private void unRegisterByUrl(String url) throws Exception {
        if (url == null) {
            return;
        }
        Iterator<Map.Entry<ClassLoader, String>> classLoaderToUrlMapIterator = this.classLoaderToUrlMap.entrySet().iterator();
        while (classLoaderToUrlMapIterator.hasNext()) {
            Map.Entry<ClassLoader, String> entry = classLoaderToUrlMapIterator.next();
            if (!entry.getValue().equals(url)) continue;
            ClassLoader classLoader = entry.getKey();
            this.unRegisterDriversByClassLoader(classLoader);
            classLoaderToUrlMapIterator.remove();
            break;
        }
        Iterator<Map.Entry<String, String>> driverClassToUrlMapIterator = this.driverClassToUrlMap.entrySet().iterator();
        while (driverClassToUrlMapIterator.hasNext()) {
            Map.Entry<String, String> entry = driverClassToUrlMapIterator.next();
            if (!entry.getValue().equals(url)) continue;
            driverClassToUrlMapIterator.remove();
        }
    }

    private void unRegisterDriversByClassLoader(ClassLoader classLoader) throws Exception {
        Iterator<Map.Entry<Driver, ClassLoader>> driverToClassLoaderMapIterator = this.driverToClassLoaderMap.entrySet().iterator();
        while (driverToClassLoaderMapIterator.hasNext()) {
            Map.Entry<Driver, ClassLoader> driverToClassLoaderMapEntry = driverToClassLoaderMapIterator.next();
            if (!driverToClassLoaderMapEntry.getValue().equals(classLoader)) continue;
            this.unRegisterDriver(driverToClassLoaderMapEntry.getKey());
            driverToClassLoaderMapIterator.remove();
        }
    }

    private void unRegisterDriver(Driver driver) throws Exception {
        this.unRegisterDriverFromJVM(driver);
        Iterator<Map.Entry<String, Driver>> driverClassToDriverMapIterator = this.driverClassToDriverMap.entrySet().iterator();
        while (driverClassToDriverMapIterator.hasNext()) {
            Map.Entry<String, Driver> driverClassToDriverMapEntry = driverClassToDriverMapIterator.next();
            if (!driverClassToDriverMapEntry.getValue().equals(driver)) continue;
            driverClassToDriverMapIterator.remove();
            this.driverClassToUrlMap.remove(driverClassToDriverMapEntry.getKey());
            break;
        }
    }

    private void loadDriverFromExistingClassLoaders(String driverClassName) throws Exception {
        boolean driverLoaded = false;
        ClassNotFoundException classLoadingException = null;
        for (ClassLoader classLoader : this.getAvailableClassLoaders(driverClassName)) {
            try {
                Class<?> driverClass = Class.forName(driverClassName, true, classLoader);
                this.registerDriver(driverClassName, driverClass, classLoader);
                driverLoaded = true;
                break;
            }
            catch (ClassNotFoundException e) {
                if (classLoadingException != null) continue;
                classLoadingException = e;
            }
        }
        if (!driverLoaded) {
            throw classLoadingException;
        }
    }

    private void loadJdbcDriverFromRepository(String path) throws Exception {
        if (path == null || SYSTEM_CLASSLOADER_PATH.equals(path)) {
            return;
        }
        if (this.classLoaderToUrlMap.containsValue(path)) {
            return;
        }
        List<FileResource> driverResources = this.findJdbcDriversInRepo(path);
        ArrayList<String> pathToDriverFile = new ArrayList<String>(driverResources.size());
        for (FileResource driverResource : driverResources) {
            pathToDriverFile.add(this.copyJdbcDriverToTempFolder(driverResource));
        }
        if (pathToDriverFile.size() > 0) {
            ClassLoader classLoader = this.getClassLoader(pathToDriverFile.toArray(new String[pathToDriverFile.size()]));
            this.classLoaderToUrlMap.put(classLoader, path);
        }
    }

    private void registerDriver(String driverClassName, Class driverClass, ClassLoader driverClassLoader) throws Exception {
        Driver driver = null;
        String oldUrl = this.driverClassToUrlMap.get(driverClassName);
        if (driverClassLoader != this.getSystemClassLoader()) {
            Driver driverFromRepository = (Driver)driverClass.newInstance();
            driver = new JdbcDriverShim(driverFromRepository);
            this.registerDriverInJVM(driver);
            if (this.getUrlByDriverClassName(driverClassName) == null) {
                String url = this.classLoaderToUrlMap.get(driverClassLoader);
                this.driverClassToUrlMap.put(driverClassName, url);
                this.mapDriverToClassLoaderInGlobalPropertiesList(driverClassName, url, oldUrl);
            }
        } else {
            Enumeration<Driver> driverEnumeration = this.getDriversRegisteredInJVM();
            while (driverEnumeration.hasMoreElements()) {
                Driver nextDriver = driverEnumeration.nextElement();
                if (!nextDriver.getClass().equals(driverClass)) continue;
                driver = nextDriver;
                break;
            }
            if (driver == null) {
                driver = (Driver)driverClass.newInstance();
                this.registerDriverInJVM(driver);
            }
            this.driverClassToUrlMap.put(driverClassName, SYSTEM_CLASSLOADER_PATH);
            this.classLoaderToUrlMap.put(driverClassLoader, SYSTEM_CLASSLOADER_PATH);
            this.mapDriverToClassLoaderInGlobalPropertiesList(driverClassName, SYSTEM_CLASSLOADER_PATH, oldUrl);
        }
        if (driver == null) {
            throw new IllegalStateException(String.format("Driver was loaded by System class loader but not registered in DriverManager: [%s]", driverClassName));
        }
        this.driverClassToDriverMap.put(driverClassName, driver);
        this.driverToClassLoaderMap.put(driver, driverClassLoader);
    }

    private void mapDriverToClassLoaderInGlobalPropertiesList(String driverClassName, String url, String oldUrl) {
        if (this.getPropertiesManagementService() != null) {
            try {
                this.getPropertiesManagementService().size();
            }
            catch (Exception e) {
                this.getPropertiesManagementService().reloadProperties();
            }
            String driverNameKey = String.format(SYSTEM_PROPERTIES_LIST_KEY_FORMAT, driverClassName);
            if (!url.equals(oldUrl)) {
                if (oldUrl != null) {
                    String preservedDriverNameKey = String.format("%s%s", driverNameKey, SYSTEM_PROPERTIES_PRESERVED_KEY_SUFFIX);
                    this.logger.info((Object)String.format("Existing mapping for [%s] will be saved as [%s]", driverClassName, preservedDriverNameKey));
                    this.getPropertiesManagementService().setProperty(preservedDriverNameKey, oldUrl);
                }
                this.getPropertiesManagementService().setProperty(driverNameKey, url);
            }
        }
    }

    private ClassLoader getSystemClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    private List<ClassLoader> getAvailableClassLoaders(String driverClass) {
        LinkedList<ClassLoader> classLoaders = new LinkedList<ClassLoader>();
        ClassLoader repositoryClassLoader = this.getClassLoaderByClassName(driverClass);
        if (repositoryClassLoader != null) {
            classLoaders.add(repositoryClassLoader);
        }
        if (this.systemClassLoaderFirst.booleanValue()) {
            classLoaders.addFirst(this.getSystemClassLoader());
        } else {
            classLoaders.addLast(this.getSystemClassLoader());
        }
        return classLoaders;
    }

    private List<FileResource> findJdbcDriversInRepo(String path) {
        String uri = String.format("%s/%s", this.jdbcDriversFolder, path);
        ArrayList<FileResource> driverResources = new ArrayList<FileResource>();
        ExecutionContext runtimeExecutionContext = ExecutionContextImpl.getRuntimeExecutionContext();
        Folder driversFolder = this.repository.getFolder(runtimeExecutionContext, uri);
        if (driversFolder == null) {
            return driverResources;
        }
        FilterCriteria criteria = FilterCriteria.createFilter(FileResource.class);
        criteria.addFilterElement((FilterElement)FilterCriteria.createParentFolderFilter((String)uri));
        List resources = this.repository.loadResourcesList(runtimeExecutionContext, criteria);
        for (ResourceLookup lookup : resources) {
            FileResource fileResource = (FileResource)this.repository.getResource(runtimeExecutionContext, lookup.getURIString());
            if (!"jar".equals(fileResource.getFileType())) continue;
            driverResources.add(fileResource);
        }
        return driverResources;
    }

    private ClassLoader getClassLoader(String[] pathToDriverFile) throws Exception {
        URL[] urls = new URL[pathToDriverFile.length];
        for (int i = 0; i < pathToDriverFile.length; ++i) {
            urls[i] = new URL(String.format(URL_CLASSLOADER_FORMAT, pathToDriverFile[i]));
        }
        return new URLClassLoader(urls, null);
    }

    private String copyJdbcDriverToTempFolder(FileResource driverResource) throws IOException {
        String pathToJdbcDriverFile = this.getUniqueFilePath();
        File file = new File(pathToJdbcDriverFile);
        FileUtils.writeByteArrayToFile((File)file, (byte[])this.getFileResourceData(ExecutionContextImpl.getRuntimeExecutionContext(), driverResource));
        file.deleteOnExit();
        return pathToJdbcDriverFile;
    }

    private String createTempFile(byte[] fileData) throws IOException {
        String tempFilePath = this.getUniqueFilePath();
        File file = new File(tempFilePath);
        FileUtils.writeByteArrayToFile((File)file, (byte[])fileData);
        file.deleteOnExit();
        return tempFilePath;
    }

    private String getUniqueFilePath() {
        return String.format(TEMP_FILE_PATH_FORMAT, DEFAULT_JDBC_TEMP_FOLDER, System.currentTimeMillis(), (long)(Math.random() * 1000000.0));
    }

    private byte[] getFileResourceData(ExecutionContext context, FileResource fileResource) {
        byte[] data;
        if (fileResource.hasData()) {
            data = fileResource.getData();
        } else {
            FileResourceData resourceData = this.repository.getResourceData(context, fileResource.getURIString());
            data = resourceData.getData();
        }
        return data;
    }

    protected void registerDriverInJVM(Driver driver) throws SQLException {
        DriverManager.registerDriver(driver);
    }

    protected void unRegisterDriverFromJVM(Driver driver) throws SQLException {
        DriverManager.deregisterDriver(driver);
    }

    protected Enumeration<Driver> getDriversRegisteredInJVM() throws SQLException {
        return DriverManager.getDrivers();
    }

    private PropertiesManagementService getPropertiesManagementService() {
        if (this.propertiesManagementService == null) {
            try {
                this.propertiesManagementService = (PropertiesManagementService)this.applicationContext.getBean("propertiesManagementService", PropertiesManagementServiceImpl.class);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
        }
        return this.propertiesManagementService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

