/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.util;

import com.jaspersoft.jasperserver.api.common.properties.PropertyChanger;
import com.jaspersoft.jasperserver.api.common.service.JdbcDriverService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcDriverServicePropertyChanger
implements PropertyChanger {
    public static final String PROPERTY_PREFIX = "jdbc:";
    public static final Log log = LogFactory.getLog(JdbcDriverServicePropertyChanger.class);
    private JdbcDriverService jdbcDriverService;

    public void setJdbcDriverService(JdbcDriverService jdbcDriverService) {
        this.jdbcDriverService = jdbcDriverService;
    }

    public void setProperty(String key, String val) {
        this.checkKey(key);
        try {
            this.jdbcDriverService.setDriverMapping(this.getDriverClassName(key), val);
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    public String getProperty(String key) {
        this.checkKey(key);
        return this.jdbcDriverService.getDriverMappings().get(this.getDriverClassName(key));
    }

    public void removeProperty(String key, String val) {
        this.checkKey(key);
        try {
            this.jdbcDriverService.removeDriverMapping(this.getDriverClassName(key));
        }
        catch (Exception e) {
            log.warn((Object)e);
        }
    }

    private void checkKey(String key) {
        if (!key.startsWith(PROPERTY_PREFIX)) {
            throw new IllegalArgumentException(String.format("Key should starts with %s", PROPERTY_PREFIX));
        }
    }

    private String getDriverClassName(String key) {
        return key.substring(PROPERTY_PREFIX.length(), key.length());
    }
}

