/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.util.rd;

import com.jaspersoft.jasperserver.api.common.util.TimeZoneContextHolder;
import java.sql.Timestamp;
import java.util.Date;
import java.util.TimeZone;
import net.sf.jasperreports.types.date.DateRange;
import net.sf.jasperreports.types.date.DateRangeBuilder;
import net.sf.jasperreports.types.date.DateRangeExpression;
import net.sf.jasperreports.types.date.InvalidDateRangeExpressionException;

public class DateRangeFactory {
    public static DateRange getInstance(String expression) throws InvalidDateRangeExpressionException {
        return DateRangeFactory.getInstance(expression, null);
    }

    public static DateRange getInstance(Date date) {
        return new DateRangeBuilder(date).toDateRange();
    }

    public static DateRange getInstance(Date date, Class<? extends Date> valueClass) {
        return new DateRangeBuilder(date).set(valueClass).toDateRange();
    }

    public static DateRange getInstance(String expression, Class<? extends Date> valueClass) throws InvalidDateRangeExpressionException {
        TimeZone tz = valueClass != null && valueClass.equals(Timestamp.class) ? TimeZoneContextHolder.getTimeZone() : null;
        return DateRangeFactory.getInstance(expression, tz, valueClass);
    }

    public static DateRange getInstance(String expression, Class<? extends Date> valueClass, String datePattern) throws InvalidDateRangeExpressionException {
        DateRangeBuilder builder = new DateRangeBuilder(expression).set(valueClass).set(datePattern);
        if (valueClass != null && valueClass.equals(Timestamp.class)) {
            builder.set(TimeZoneContextHolder.getTimeZone());
        }
        return builder.toDateRange();
    }

    public static DateRange getInstance(String expression, TimeZone timeZone, Class<? extends Date> valueClass) throws InvalidDateRangeExpressionException {
        return new DateRangeBuilder(expression).set(valueClass).set(timeZone).toDateRange();
    }

    public static DateRange getInstanceForExpression(String expression, Class<? extends Date> valueClass) throws InvalidDateRangeExpressionException {
        if (expression == null || "null".equals(expression)) {
            return null;
        }
        DateRange testDateRange = DateRangeFactory.getInstance(expression);
        TimeZone tz = TimeZone.getDefault();
        if (testDateRange instanceof DateRangeExpression) {
            tz = valueClass != null && valueClass.equals(Timestamp.class) ? TimeZoneContextHolder.getTimeZone() : null;
        }
        return DateRangeFactory.getInstance(expression, tz, valueClass);
    }
}

