/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.api.common.util.spring;

import com.jaspersoft.jasperserver.api.JSException;
import com.jaspersoft.jasperserver.api.common.util.spring.AbstractBeanPropertyProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.TypedStringValue;

public class BeanPropertyTextAppender
extends AbstractBeanPropertyProcessor {
    private static final Log log = LogFactory.getLog(BeanPropertyTextAppender.class);
    private String appended;

    @Override
    protected Object getProcessedPropertyValue(Object originalValue) {
        String appendedValue;
        if (originalValue == null) {
            appendedValue = this.getAppended();
        } else if (originalValue instanceof String) {
            appendedValue = originalValue + this.getAppended();
        } else if (originalValue instanceof TypedStringValue) {
            TypedStringValue newValue = (TypedStringValue)originalValue;
            newValue.setValue(newValue.getValue() + this.getAppended());
            appendedValue = newValue;
        } else {
            throw new JSException("jsexception.property.not.a.text", new Object[]{this.getPropertyName(), this.getBeanName()});
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Appending " + this.getBeanName() + "." + this.getPropertyName() + " with " + this.getAppended()));
        }
        return appendedValue;
    }

    public String getAppended() {
        return this.appended;
    }

    public void setAppended(String appendedText) {
        this.appended = appendedText;
    }
}

