/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elastictranscoder.model.PresetWatermark;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoParameters
implements Serializable {
    private String codec;
    private Map<String, String> codecOptions;
    private String keyframesMaxDist;
    private String fixedGOP;
    private String bitRate;
    private String frameRate;
    private String maxFrameRate;
    private String resolution;
    private String aspectRatio;
    private String maxWidth;
    private String maxHeight;
    private String displayAspectRatio;
    private String sizingPolicy;
    private String paddingPolicy;
    private ListWithAutoConstructFlag<PresetWatermark> watermarks;

    public String getCodec() {
        return this.codec;
    }

    public void setCodec(String codec) {
        this.codec = codec;
    }

    public VideoParameters withCodec(String codec) {
        this.codec = codec;
        return this;
    }

    public Map<String, String> getCodecOptions() {
        if (this.codecOptions == null) {
            this.codecOptions = new HashMap<String, String>();
        }
        return this.codecOptions;
    }

    public void setCodecOptions(Map<String, String> codecOptions) {
        this.codecOptions = codecOptions;
    }

    public VideoParameters withCodecOptions(Map<String, String> codecOptions) {
        this.setCodecOptions(codecOptions);
        return this;
    }

    public VideoParameters addCodecOptionsEntry(String key, String value) {
        if (null == this.codecOptions) {
            this.codecOptions = new HashMap<String, String>();
        }
        if (this.codecOptions.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.codecOptions.put(key, value);
        return this;
    }

    public VideoParameters clearCodecOptionsEntries() {
        this.codecOptions = null;
        return this;
    }

    public String getKeyframesMaxDist() {
        return this.keyframesMaxDist;
    }

    public void setKeyframesMaxDist(String keyframesMaxDist) {
        this.keyframesMaxDist = keyframesMaxDist;
    }

    public VideoParameters withKeyframesMaxDist(String keyframesMaxDist) {
        this.keyframesMaxDist = keyframesMaxDist;
        return this;
    }

    public String getFixedGOP() {
        return this.fixedGOP;
    }

    public void setFixedGOP(String fixedGOP) {
        this.fixedGOP = fixedGOP;
    }

    public VideoParameters withFixedGOP(String fixedGOP) {
        this.fixedGOP = fixedGOP;
        return this;
    }

    public String getBitRate() {
        return this.bitRate;
    }

    public void setBitRate(String bitRate) {
        this.bitRate = bitRate;
    }

    public VideoParameters withBitRate(String bitRate) {
        this.bitRate = bitRate;
        return this;
    }

    public String getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(String frameRate) {
        this.frameRate = frameRate;
    }

    public VideoParameters withFrameRate(String frameRate) {
        this.frameRate = frameRate;
        return this;
    }

    public String getMaxFrameRate() {
        return this.maxFrameRate;
    }

    public void setMaxFrameRate(String maxFrameRate) {
        this.maxFrameRate = maxFrameRate;
    }

    public VideoParameters withMaxFrameRate(String maxFrameRate) {
        this.maxFrameRate = maxFrameRate;
        return this;
    }

    public String getResolution() {
        return this.resolution;
    }

    public void setResolution(String resolution) {
        this.resolution = resolution;
    }

    public VideoParameters withResolution(String resolution) {
        this.resolution = resolution;
        return this;
    }

    public String getAspectRatio() {
        return this.aspectRatio;
    }

    public void setAspectRatio(String aspectRatio) {
        this.aspectRatio = aspectRatio;
    }

    public VideoParameters withAspectRatio(String aspectRatio) {
        this.aspectRatio = aspectRatio;
        return this;
    }

    public String getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxWidth(String maxWidth) {
        this.maxWidth = maxWidth;
    }

    public VideoParameters withMaxWidth(String maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public String getMaxHeight() {
        return this.maxHeight;
    }

    public void setMaxHeight(String maxHeight) {
        this.maxHeight = maxHeight;
    }

    public VideoParameters withMaxHeight(String maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    public String getDisplayAspectRatio() {
        return this.displayAspectRatio;
    }

    public void setDisplayAspectRatio(String displayAspectRatio) {
        this.displayAspectRatio = displayAspectRatio;
    }

    public VideoParameters withDisplayAspectRatio(String displayAspectRatio) {
        this.displayAspectRatio = displayAspectRatio;
        return this;
    }

    public String getSizingPolicy() {
        return this.sizingPolicy;
    }

    public void setSizingPolicy(String sizingPolicy) {
        this.sizingPolicy = sizingPolicy;
    }

    public VideoParameters withSizingPolicy(String sizingPolicy) {
        this.sizingPolicy = sizingPolicy;
        return this;
    }

    public String getPaddingPolicy() {
        return this.paddingPolicy;
    }

    public void setPaddingPolicy(String paddingPolicy) {
        this.paddingPolicy = paddingPolicy;
    }

    public VideoParameters withPaddingPolicy(String paddingPolicy) {
        this.paddingPolicy = paddingPolicy;
        return this;
    }

    public List<PresetWatermark> getWatermarks() {
        if (this.watermarks == null) {
            this.watermarks = new ListWithAutoConstructFlag();
            this.watermarks.setAutoConstruct(true);
        }
        return this.watermarks;
    }

    public void setWatermarks(Collection<PresetWatermark> watermarks) {
        if (watermarks == null) {
            this.watermarks = null;
            return;
        }
        ListWithAutoConstructFlag watermarksCopy = new ListWithAutoConstructFlag(watermarks.size());
        watermarksCopy.addAll(watermarks);
        this.watermarks = watermarksCopy;
    }

    public VideoParameters withWatermarks(PresetWatermark ... watermarks) {
        if (this.getWatermarks() == null) {
            this.setWatermarks(new ArrayList<PresetWatermark>(watermarks.length));
        }
        for (PresetWatermark value : watermarks) {
            this.getWatermarks().add(value);
        }
        return this;
    }

    public VideoParameters withWatermarks(Collection<PresetWatermark> watermarks) {
        if (watermarks == null) {
            this.watermarks = null;
        } else {
            ListWithAutoConstructFlag watermarksCopy = new ListWithAutoConstructFlag(watermarks.size());
            watermarksCopy.addAll(watermarks);
            this.watermarks = watermarksCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCodec() != null) {
            sb.append("Codec: " + this.getCodec() + ",");
        }
        if (this.getCodecOptions() != null) {
            sb.append("CodecOptions: " + this.getCodecOptions() + ",");
        }
        if (this.getKeyframesMaxDist() != null) {
            sb.append("KeyframesMaxDist: " + this.getKeyframesMaxDist() + ",");
        }
        if (this.getFixedGOP() != null) {
            sb.append("FixedGOP: " + this.getFixedGOP() + ",");
        }
        if (this.getBitRate() != null) {
            sb.append("BitRate: " + this.getBitRate() + ",");
        }
        if (this.getFrameRate() != null) {
            sb.append("FrameRate: " + this.getFrameRate() + ",");
        }
        if (this.getMaxFrameRate() != null) {
            sb.append("MaxFrameRate: " + this.getMaxFrameRate() + ",");
        }
        if (this.getResolution() != null) {
            sb.append("Resolution: " + this.getResolution() + ",");
        }
        if (this.getAspectRatio() != null) {
            sb.append("AspectRatio: " + this.getAspectRatio() + ",");
        }
        if (this.getMaxWidth() != null) {
            sb.append("MaxWidth: " + this.getMaxWidth() + ",");
        }
        if (this.getMaxHeight() != null) {
            sb.append("MaxHeight: " + this.getMaxHeight() + ",");
        }
        if (this.getDisplayAspectRatio() != null) {
            sb.append("DisplayAspectRatio: " + this.getDisplayAspectRatio() + ",");
        }
        if (this.getSizingPolicy() != null) {
            sb.append("SizingPolicy: " + this.getSizingPolicy() + ",");
        }
        if (this.getPaddingPolicy() != null) {
            sb.append("PaddingPolicy: " + this.getPaddingPolicy() + ",");
        }
        if (this.getWatermarks() != null) {
            sb.append("Watermarks: " + this.getWatermarks());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCodec() == null ? 0 : this.getCodec().hashCode());
        hashCode = 31 * hashCode + (this.getCodecOptions() == null ? 0 : this.getCodecOptions().hashCode());
        hashCode = 31 * hashCode + (this.getKeyframesMaxDist() == null ? 0 : this.getKeyframesMaxDist().hashCode());
        hashCode = 31 * hashCode + (this.getFixedGOP() == null ? 0 : this.getFixedGOP().hashCode());
        hashCode = 31 * hashCode + (this.getBitRate() == null ? 0 : this.getBitRate().hashCode());
        hashCode = 31 * hashCode + (this.getFrameRate() == null ? 0 : this.getFrameRate().hashCode());
        hashCode = 31 * hashCode + (this.getMaxFrameRate() == null ? 0 : this.getMaxFrameRate().hashCode());
        hashCode = 31 * hashCode + (this.getResolution() == null ? 0 : this.getResolution().hashCode());
        hashCode = 31 * hashCode + (this.getAspectRatio() == null ? 0 : this.getAspectRatio().hashCode());
        hashCode = 31 * hashCode + (this.getMaxWidth() == null ? 0 : this.getMaxWidth().hashCode());
        hashCode = 31 * hashCode + (this.getMaxHeight() == null ? 0 : this.getMaxHeight().hashCode());
        hashCode = 31 * hashCode + (this.getDisplayAspectRatio() == null ? 0 : this.getDisplayAspectRatio().hashCode());
        hashCode = 31 * hashCode + (this.getSizingPolicy() == null ? 0 : this.getSizingPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getPaddingPolicy() == null ? 0 : this.getPaddingPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getWatermarks() == null ? 0 : this.getWatermarks().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VideoParameters)) {
            return false;
        }
        VideoParameters other = (VideoParameters)obj;
        if (other.getCodec() == null ^ this.getCodec() == null) {
            return false;
        }
        if (other.getCodec() != null && !other.getCodec().equals(this.getCodec())) {
            return false;
        }
        if (other.getCodecOptions() == null ^ this.getCodecOptions() == null) {
            return false;
        }
        if (other.getCodecOptions() != null && !other.getCodecOptions().equals(this.getCodecOptions())) {
            return false;
        }
        if (other.getKeyframesMaxDist() == null ^ this.getKeyframesMaxDist() == null) {
            return false;
        }
        if (other.getKeyframesMaxDist() != null && !other.getKeyframesMaxDist().equals(this.getKeyframesMaxDist())) {
            return false;
        }
        if (other.getFixedGOP() == null ^ this.getFixedGOP() == null) {
            return false;
        }
        if (other.getFixedGOP() != null && !other.getFixedGOP().equals(this.getFixedGOP())) {
            return false;
        }
        if (other.getBitRate() == null ^ this.getBitRate() == null) {
            return false;
        }
        if (other.getBitRate() != null && !other.getBitRate().equals(this.getBitRate())) {
            return false;
        }
        if (other.getFrameRate() == null ^ this.getFrameRate() == null) {
            return false;
        }
        if (other.getFrameRate() != null && !other.getFrameRate().equals(this.getFrameRate())) {
            return false;
        }
        if (other.getMaxFrameRate() == null ^ this.getMaxFrameRate() == null) {
            return false;
        }
        if (other.getMaxFrameRate() != null && !other.getMaxFrameRate().equals(this.getMaxFrameRate())) {
            return false;
        }
        if (other.getResolution() == null ^ this.getResolution() == null) {
            return false;
        }
        if (other.getResolution() != null && !other.getResolution().equals(this.getResolution())) {
            return false;
        }
        if (other.getAspectRatio() == null ^ this.getAspectRatio() == null) {
            return false;
        }
        if (other.getAspectRatio() != null && !other.getAspectRatio().equals(this.getAspectRatio())) {
            return false;
        }
        if (other.getMaxWidth() == null ^ this.getMaxWidth() == null) {
            return false;
        }
        if (other.getMaxWidth() != null && !other.getMaxWidth().equals(this.getMaxWidth())) {
            return false;
        }
        if (other.getMaxHeight() == null ^ this.getMaxHeight() == null) {
            return false;
        }
        if (other.getMaxHeight() != null && !other.getMaxHeight().equals(this.getMaxHeight())) {
            return false;
        }
        if (other.getDisplayAspectRatio() == null ^ this.getDisplayAspectRatio() == null) {
            return false;
        }
        if (other.getDisplayAspectRatio() != null && !other.getDisplayAspectRatio().equals(this.getDisplayAspectRatio())) {
            return false;
        }
        if (other.getSizingPolicy() == null ^ this.getSizingPolicy() == null) {
            return false;
        }
        if (other.getSizingPolicy() != null && !other.getSizingPolicy().equals(this.getSizingPolicy())) {
            return false;
        }
        if (other.getPaddingPolicy() == null ^ this.getPaddingPolicy() == null) {
            return false;
        }
        if (other.getPaddingPolicy() != null && !other.getPaddingPolicy().equals(this.getPaddingPolicy())) {
            return false;
        }
        if (other.getWatermarks() == null ^ this.getWatermarks() == null) {
            return false;
        }
        return other.getWatermarks() == null || other.getWatermarks().equals(this.getWatermarks());
    }
}

