/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sqs;

import com.amazonaws.AmazonClientException;
import com.amazonaws.Request;
import com.amazonaws.handlers.AbstractRequestHandler;
import com.amazonaws.services.sqs.model.Message;
import com.amazonaws.services.sqs.model.ReceiveMessageRequest;
import com.amazonaws.services.sqs.model.ReceiveMessageResult;
import com.amazonaws.services.sqs.model.SendMessageBatchRequest;
import com.amazonaws.services.sqs.model.SendMessageBatchRequestEntry;
import com.amazonaws.services.sqs.model.SendMessageBatchResult;
import com.amazonaws.services.sqs.model.SendMessageBatchResultEntry;
import com.amazonaws.services.sqs.model.SendMessageRequest;
import com.amazonaws.services.sqs.model.SendMessageResult;
import com.amazonaws.util.BinaryUtils;
import com.amazonaws.util.Md5Utils;
import com.amazonaws.util.TimingInfo;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageMD5ChecksumHandler
extends AbstractRequestHandler {
    private static final Log log = LogFactory.getLog(MessageMD5ChecksumHandler.class);

    @Override
    public void afterResponse(Request<?> request, Object response, TimingInfo timingInfo) {
        block10: {
            block12: {
                ReceiveMessageResult receiveMessageResult;
                block11: {
                    String md5Returned;
                    if (null == request || null == response) break block10;
                    if (!(request.getOriginalRequest() instanceof SendMessageRequest) || !(response instanceof SendMessageResult)) break block11;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"Checking the MD5 digest returned in SendMessageResult.");
                    }
                    SendMessageRequest sendMessageRequest = (SendMessageRequest)request.getOriginalRequest();
                    SendMessageResult sendMessageResult = (SendMessageResult)response;
                    String messageSent = sendMessageRequest.getMessageBody();
                    if (!this.checkMessageMd5(messageSent, md5Returned = sendMessageResult.getMD5OfMessageBody())) {
                        throw new AmazonClientException("MD5 returned by SQS does not match the calculation on the original request.(Message body: \"" + messageSent + "\", MD5 returned: \"" + md5Returned + "\")");
                    }
                    break block10;
                }
                if (!(request.getOriginalRequest() instanceof ReceiveMessageRequest) || !(response instanceof ReceiveMessageResult)) break block12;
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Checking the MD5 digest returned in ReceiveMessageResult.");
                }
                if (null == (receiveMessageResult = (ReceiveMessageResult)response).getMessages()) break block10;
                for (Message messageReceived : receiveMessageResult.getMessages()) {
                    String string;
                    String messageBody = messageReceived.getBody();
                    if (this.checkMessageMd5(messageBody, string = messageReceived.getMD5OfBody())) continue;
                    throw new AmazonClientException("MD5 returned by SQS does not match the calculation on the original request.(Message body: \"" + messageBody + "\", MD5 returned: \"" + string + "\")");
                }
                break block10;
            }
            if (request.getOriginalRequest() instanceof SendMessageBatchRequest && response instanceof SendMessageBatchResult) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Checking the MD5 digest returned in SendMessageBatchResult.");
                }
                SendMessageBatchRequest sendMessageBatchRequest = (SendMessageBatchRequest)request.getOriginalRequest();
                SendMessageBatchResult sendMessageBatchResult = (SendMessageBatchResult)response;
                HashMap<String, String> idToMessageBodyMap = new HashMap<String, String>();
                if (null != sendMessageBatchRequest.getEntries()) {
                    for (SendMessageBatchRequestEntry sendMessageBatchRequestEntry : sendMessageBatchRequest.getEntries()) {
                        idToMessageBodyMap.put(sendMessageBatchRequestEntry.getId(), sendMessageBatchRequestEntry.getMessageBody());
                    }
                }
                if (null != sendMessageBatchResult.getSuccessful()) {
                    for (SendMessageBatchResultEntry sendMessageBatchResultEntry : sendMessageBatchResult.getSuccessful()) {
                        if (this.checkMessageMd5((String)idToMessageBodyMap.get(sendMessageBatchResultEntry.getId()), sendMessageBatchResultEntry.getMD5OfMessageBody())) continue;
                        throw new AmazonClientException("MD5 returned by SQS does not match the calculation on the original request.(Message body: \"" + (String)idToMessageBodyMap.get(sendMessageBatchResultEntry.getId()) + "\", MD5 returned: \"" + sendMessageBatchResultEntry.getMD5OfMessageBody() + "\")");
                    }
                }
            }
        }
    }

    private boolean checkMessageMd5(String messageBody, String md5) {
        byte[] expectedMd5;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Raw Message: " + messageBody));
        }
        try {
            expectedMd5 = Md5Utils.computeMD5Hash(messageBody.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to calculate MD5 hash: " + e.getMessage(), e);
        }
        String expectedMd5Hex = BinaryUtils.toHex(expectedMd5);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Expected  MD5: " + expectedMd5Hex));
            log.debug((Object)("From Response: " + md5));
        }
        return expectedMd5Hex.equals(md5);
    }
}

