/*
 * Decompiled with CFR 0.152.
 */
package com.tonbeller.jpivot.navigator.member;

import com.tonbeller.jpivot.olap.model.Hierarchy;
import com.tonbeller.jpivot.olap.model.Level;
import com.tonbeller.jpivot.olap.model.Member;
import com.tonbeller.jpivot.olap.navi.MemberTree;
import com.tonbeller.wcf.tree.AbstractTreeModel;
import com.tonbeller.wcf.tree.TreeModel;
import java.util.Locale;
import org.apache.log4j.Logger;

public class TreeModelAdapter
extends AbstractTreeModel
implements TreeModel {
    Hierarchy[] hiers;
    MemberTree tree;
    Level noChildrenLevel = null;
    Locale locale;
    boolean showSingleHierarchyNode = false;
    OverflowListener overflowListener;
    private static Logger logger = Logger.getLogger(TreeModelAdapter.class);

    public TreeModelAdapter(Hierarchy hier, MemberTree tree, Locale locale) {
        this.hiers = new Hierarchy[]{hier};
        this.tree = tree;
        this.locale = locale;
    }

    public TreeModelAdapter(Hierarchy[] hiers, MemberTree tree, Locale locale) {
        this.hiers = hiers;
        this.tree = tree;
        this.locale = locale;
    }

    public Object[] getRoots() {
        logger.debug((Object)("getRoots: " + this.hiers));
        try {
            if (this.showSingleHierarchyNode || this.hiers.length > 1) {
                logger.debug((Object)("getRoots: showSingleHierarchyNode - " + this.showSingleHierarchyNode));
                return this.hiers;
            }
            logger.debug((Object)("getRoots tree: " + this.hiers[0]));
            return this.tree.getRootMembers(this.hiers[0]);
        }
        catch (MemberTree.TooManyMembersException e) {
            this.overflowOccured(e);
            return new Member[0];
        }
    }

    public boolean hasChildren(Object node) {
        logger.debug((Object)("hasChildren : " + node));
        if (node instanceof Hierarchy) {
            logger.debug((Object)"  Hierarchy");
            return true;
        }
        if (this.noChildrenLevel != null) {
            Member m = (Member)node;
            if (this.noChildrenLevel.equals(m.getLevel())) {
                logger.debug((Object)("  noChildrenLevel != null, member.level: " + m.getLevel()));
            }
            return false;
        }
        return this.tree.hasChildren((Member)node);
    }

    public Object[] getChildren(Object node) {
        logger.debug((Object)("getChildren : " + node));
        try {
            if (node instanceof Hierarchy) {
                logger.debug((Object)"  Hierarchy");
                return this.tree.getRootMembers((Hierarchy)node);
            }
            Object[] children = this.tree.getChildren((Member)node);
            if (children == null) {
                logger.debug((Object)"  null children");
                return new Member[0];
            }
            logger.debug((Object)("  " + children.length + " children"));
            return children;
        }
        catch (MemberTree.TooManyMembersException e) {
            this.overflowOccured(e);
            return new Member[0];
        }
    }

    public Object getParent(Object node) {
        logger.debug((Object)("getParent : " + node));
        if (this.showSingleHierarchyNode || this.hiers.length > 1) {
            logger.debug((Object)("  showSingleHierarchyNode - " + this.showSingleHierarchyNode + ", " + this.hiers));
            if (node instanceof Hierarchy) {
                logger.debug((Object)"  Hierarchy: null");
                return null;
            }
            Member parent = this.tree.getParent((Member)node);
            if (parent == null) {
                logger.debug((Object)("  parent null: " + ((Member)node).getLevel().getHierarchy()));
                return ((Member)node).getLevel().getHierarchy();
            }
            logger.debug((Object)("  parent: " + parent));
            return parent;
        }
        return this.tree.getParent((Member)node);
    }

    public void fireModelChanged() {
        super.fireModelChanged();
    }

    public Level getNoChildrenLevel() {
        return this.noChildrenLevel;
    }

    public void setNoChildrenLevel(Level level) {
        logger.debug((Object)("setNoChildrenLevel: " + level));
        this.noChildrenLevel = level;
    }

    public void modelChanged() {
        super.fireModelChanged();
    }

    private void overflowOccured(Exception e) {
        logger.error(null, (Throwable)e);
        if (this.overflowListener != null) {
            this.overflowListener.overflowOccured();
        }
    }

    public OverflowListener getOverflowListener() {
        return this.overflowListener;
    }

    public void setOverflowListener(OverflowListener overflowListener) {
        this.overflowListener = overflowListener;
    }

    public boolean isShowSingleHierarchyNode() {
        return this.showSingleHierarchyNode;
    }

    public void setShowSingleHierarchyNode(boolean showSingleHierarchyNode) {
        this.showSingleHierarchyNode = showSingleHierarchyNode;
    }

    static interface OverflowListener {
        public void overflowOccured();
    }
}

